/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.reports.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.utils.DatabaseUtils;

public class Report
extends GenericBean {
    private int id = -1;
    private int categoryId = -1;
    private int permissionId = -1;
    private String filename = null;
    private int type = -1;
    private String title = null;
    private String description = null;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;
    private boolean enabled = true;
    private boolean custom = false;
    private String permissionName = null;

    public Report() {
    }

    public Report(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public Report(Connection db, int reportId) throws SQLException {
        this.queryRecord(db, reportId);
    }

    public void queryRecord(Connection db, int reportId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT r.*, p.permission FROM report r LEFT JOIN permission p ON (r.permission_id = p.permission_id) WHERE report_id = ? ");
        pst.setInt(1, reportId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Report record not found.");
        }
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("report_id");
        this.categoryId = rs.getInt("category_id");
        this.permissionId = DatabaseUtils.getInt(rs, "permission_id");
        this.filename = rs.getString("filename");
        this.type = rs.getInt("type");
        this.title = rs.getString("title");
        this.description = rs.getString("description");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.enabled = rs.getBoolean("enabled");
        this.custom = rs.getBoolean("custom");
        this.permissionName = rs.getString("permission");
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public void setCategoryId(String tmp) {
        this.categoryId = Integer.parseInt(tmp);
    }

    public void setPermissionId(int tmp) {
        this.permissionId = tmp;
    }

    public void setPermissionId(String tmp) {
        this.permissionId = Integer.parseInt(tmp);
    }

    public void setFilename(String tmp) {
        this.filename = tmp;
    }

    public void setType(int tmp) {
        this.type = tmp;
    }

    public void setType(String tmp) {
        this.type = Integer.parseInt(tmp);
    }

    public void setTitle(String tmp) {
        this.title = tmp;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setCustom(boolean tmp) {
        this.custom = tmp;
    }

    public void setCustom(String tmp) {
        this.custom = DatabaseUtils.parseBoolean(tmp);
    }

    public void setPermissionName(String tmp) {
        this.permissionName = tmp;
    }

    public int getId() {
        return this.id;
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public int getPermissionId() {
        return this.permissionId;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public boolean getCustom() {
        return this.custom;
    }

    public String getPermissionName() {
        return this.permissionName;
    }

    public static int lookupId(Connection db, String filename) throws SQLException {
        int reportId = -1;
        PreparedStatement pst = db.prepareStatement("SELECT report_id FROM report WHERE filename = ? ");
        pst.setString(1, filename);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            reportId = rs.getInt("report_id");
        }
        rs.close();
        pst.close();
        return reportId;
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "report_report_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO report (" + (this.id > -1 ? "report_id, " : "") + "category_id, permission_id, filename, " + DatabaseUtils.addQuotes(db, "type") + ", title, description, enteredby, modifiedby) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?, ?, ?) ");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.categoryId);
        DatabaseUtils.setInt(pst, ++i, this.permissionId);
        pst.setString(++i, this.filename);
        pst.setInt(++i, this.type);
        pst.setString(++i, this.title);
        pst.setString(++i, this.description);
        pst.setInt(++i, this.enteredBy);
        pst.setInt(++i, this.modifiedBy);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "report_report_id_seq", this.id);
        return true;
    }
}

