/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.reports.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Iterator;
import org.aspcfs.modules.reports.base.Criteria;
import org.aspcfs.modules.reports.base.Parameter;
import org.aspcfs.modules.reports.base.Report;
import org.aspcfs.utils.DatabaseUtils;

public class ReportQueue
extends GenericBean {
    public static final int STATUS_UNDEFINED = -1;
    public static final int STATUS_QUEUED = 0;
    public static final int STATUS_PROCESSING = 1;
    public static final int STATUS_PROCESSED = 2;
    public static final int STATUS_ERROR = 3;
    public static final int REPORT_TYPE_PDF = 1;
    public static final int REPORT_TYPE_CSV = 2;
    public static final int REPORT_TYPE_HTML = 3;
    public static final int REPORT_TYPE_EXCEL = 4;
    private int id = -1;
    private int reportId = -1;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private int status = -1;
    private Timestamp processed = null;
    private String filename = null;
    private long size = -1L;
    private boolean enabled = true;
    private int outputType = -1;
    private int outputTypeConstant = -1;
    private String outputTypeDescription = null;
    private boolean email = false;
    private int position = -1;
    private Report report = null;
    private boolean throwNotFoundException = true;

    public ReportQueue() {
    }

    public ReportQueue(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public ReportQueue(Connection db, int queueId) throws SQLException {
        this.queryRecord(db, queueId);
    }

    public ReportQueue(Connection db, int queueId, boolean throwException) throws SQLException {
        this.throwNotFoundException = throwException;
        this.queryRecord(db, queueId);
    }

    public void queryRecord(Connection db, int queueId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT q.*, rt.description as type_description, rt.constant as type_constant FROM report_queue q LEFT JOIN lookup_report_type rt ON (q.output_type = rt.code) WHERE queue_id = ? ");
        pst.setInt(1, queueId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1 && this.throwNotFoundException) {
            throw new SQLException("Queue record not found.");
        }
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setReportId(int tmp) {
        this.reportId = tmp;
    }

    public void setReportId(String tmp) {
        this.reportId = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setStatus(int tmp) {
        this.status = tmp;
    }

    public void setStatus(String tmp) {
        this.status = Integer.parseInt(tmp);
    }

    public void setProcessed(Timestamp tmp) {
        this.processed = tmp;
    }

    public void setProcessed(String tmp) {
        this.processed = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setFilename(String tmp) {
        this.filename = tmp;
    }

    public void setSize(long tmp) {
        this.size = tmp;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setOutputType(int tmp) {
        this.outputType = tmp;
    }

    public void setOutputType(String tmp) {
        this.outputType = Integer.parseInt(tmp);
    }

    public void setEmail(boolean tmp) {
        this.email = tmp;
    }

    public void setEmail(String tmp) {
        this.email = DatabaseUtils.parseBoolean(tmp);
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setPosition(int tmp) {
        this.position = tmp;
    }

    public void setPosition(String tmp) {
        this.position = Integer.parseInt(tmp);
    }

    public void setReport(Report tmp) {
        this.report = tmp;
    }

    public void setThrowNotFoundException(boolean tmp) {
        this.throwNotFoundException = tmp;
    }

    public void setThrowNotFoundException(String tmp) {
        this.throwNotFoundException = DatabaseUtils.parseBoolean(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getReportId() {
        return this.reportId;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getStatus() {
        return this.status;
    }

    public Timestamp getProcessed() {
        return this.processed;
    }

    public String getFilename() {
        return this.filename;
    }

    public long getSize() {
        return this.size;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public int getOutputType() {
        return this.outputType;
    }

    public int getOutputTypeConstant() {
        return this.outputTypeConstant;
    }

    public String getOutputTypeDescription() {
        return this.outputTypeDescription;
    }

    public boolean getEmail() {
        return this.email;
    }

    public int getPosition() {
        return this.position;
    }

    public Report getReport() {
        return this.report;
    }

    public boolean getThrowNotFoundException() {
        return this.throwNotFoundException;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("queue_id");
        this.reportId = rs.getInt("report_id");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.processed = rs.getTimestamp("processed");
        this.status = rs.getInt("status");
        this.filename = rs.getString("filename");
        this.size = DatabaseUtils.getLong(rs, "filesize");
        this.enabled = rs.getBoolean("enabled");
        this.outputType = rs.getInt("output_type");
        this.email = rs.getBoolean("email");
        this.outputTypeDescription = rs.getString("type_description");
        this.outputTypeConstant = rs.getInt("type_constant");
    }

    public void insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "report_queue_queue_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO report_queue (" + (this.id > -1 ? "queue_id, " : "") + "report_id, entered, enteredby, processed, " + "status, filename, filesize, enabled, output_type, email) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.reportId);
        pst.setTimestamp(++i, this.entered);
        pst.setInt(++i, this.enteredBy);
        pst.setTimestamp(++i, this.processed);
        DatabaseUtils.setInt(pst, ++i, this.status);
        pst.setString(++i, this.filename);
        DatabaseUtils.setLong(pst, ++i, this.size);
        pst.setBoolean(++i, this.enabled);
        DatabaseUtils.setInt(pst, ++i, this.outputType);
        pst.setBoolean(++i, this.email);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "report_queue_queue_id_seq", this.id);
    }

    public static int insert(Connection db, Criteria criteria, int reportType, boolean sendEmail) throws SQLException {
        int position = -1;
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            int id = DatabaseUtils.getNextSeq(db, "report_queue_queue_id_seq");
            PreparedStatement pst = db.prepareStatement("INSERT INTO report_queue (" + (id > -1 ? "queue_id, " : "") + "report_id, enteredby, output_type, email) " + "VALUES (" + (id > -1 ? "?, " : "") + "?, ?, ?, ?) ");
            int i = 0;
            if (id > -1) {
                pst.setInt(++i, id);
            }
            pst.setInt(++i, criteria.getReportId());
            pst.setInt(++i, criteria.getOwner());
            pst.setInt(++i, reportType);
            pst.setBoolean(++i, sendEmail);
            pst.execute();
            pst.close();
            id = DatabaseUtils.getCurrVal(db, "report_queue_queue_id_seq", id);
            int rqcId = DatabaseUtils.getNextSeq(db, "report_queue_criteria_criteria_id_seq");
            pst = db.prepareStatement("INSERT INTO report_queue_criteria (" + (rqcId > -1 ? "criteria_id, " : "") + "queue_id, " + DatabaseUtils.addQuotes(db, "parameter") + ", " + DatabaseUtils.addQuotes(db, "value") + ") " + "VALUES (" + (rqcId > -1 ? "?, " : "") + "?, ?, ?) ");
            Iterator params = criteria.getParameters().iterator();
            while (params.hasNext()) {
                Parameter param = (Parameter)((Object)params.next());
                int ip = 0;
                if (rqcId > -1) {
                    pst.setInt(++ip, rqcId);
                }
                pst.setInt(++ip, id);
                pst.setString(++ip, param.getName());
                pst.setString(++ip, param.getValue());
                pst.execute();
                if (rqcId <= -1 || !params.hasNext()) continue;
                rqcId = DatabaseUtils.getNextSeq(db, "report_queue_criteria_criteria_id_seq");
            }
            pst.close();
            pst = db.prepareStatement("SELECT count(*) AS " + DatabaseUtils.addQuotes(db, "position") + " " + "FROM report_queue " + "WHERE processed IS NULL ");
            ResultSet rs = pst.executeQuery();
            rs.next();
            position = rs.getInt("position");
            rs.close();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (Exception e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return position;
    }

    public void buildReport(Connection db) throws SQLException {
        this.report = new Report(db, this.reportId);
    }

    public boolean updateStatus(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE report_queue SET status = ?, " + (this.filename != null ? "filename = ?, " : "") + "filesize = ?, " + "processed = " + DatabaseUtils.getCurrentTimestamp(db) + ", " + "output_type = ?, " + "email = ? " + "WHERE queue_id = ? ");
        int i = 0;
        pst.setInt(++i, this.status);
        if (this.filename != null) {
            pst.setString(++i, this.filename);
        }
        DatabaseUtils.setLong(pst, ++i, this.size);
        DatabaseUtils.setInt(pst, ++i, this.outputType);
        pst.setBoolean(++i, this.email);
        pst.setInt(++i, this.id);
        int count = pst.executeUpdate();
        pst.close();
        return count == 1;
    }

    public boolean delete(Connection db, String localFilename) throws SQLException, IOException {
        File file;
        if (this.id == -1) {
            return false;
        }
        if (this.report == null && this.reportId > -1) {
            this.buildReport(db);
        }
        if (this.filename != null && (file = new File(localFilename)).exists()) {
            file.delete();
        }
        try {
            db.setAutoCommit(false);
            PreparedStatement pst = db.prepareStatement("DELETE FROM report_queue_criteria WHERE queue_id = ? ");
            pst.setInt(1, this.id);
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE FROM report_queue WHERE queue_id = ? ");
            pst.setInt(1, this.id);
            pst.execute();
            pst.close();
            db.commit();
        }
        catch (Exception e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }
}

