/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.reports.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.reports.base.ReportQueue;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class ReportQueueList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int enteredBy = -1;
    private boolean buildResources = false;
    private boolean processedOnly = false;
    private boolean unprocessedOnly = false;
    private boolean inQueueOnly = false;
    private boolean sortAscending = false;
    private Timestamp rangeStart = null;
    private Timestamp rangeEnd = null;

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public void setBuildResources(boolean tmp) {
        this.buildResources = tmp;
    }

    public void setBuildResources(String tmp) {
        this.buildResources = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildResources() {
        return this.buildResources;
    }

    public void setProcessedOnly(boolean tmp) {
        this.processedOnly = tmp;
    }

    public void setProcessedOnly(String tmp) {
        this.processedOnly = DatabaseUtils.parseBoolean(tmp);
    }

    public void setUnprocessedOnly(boolean tmp) {
        this.unprocessedOnly = tmp;
    }

    public void setUnprocessedOnly(String tmp) {
        this.unprocessedOnly = DatabaseUtils.parseBoolean(tmp);
    }

    public void setInQueueOnly(boolean tmp) {
        this.inQueueOnly = tmp;
    }

    public void setInQueueOnly(String tmp) {
        this.inQueueOnly = DatabaseUtils.parseBoolean(tmp);
    }

    public void setSortAscending(boolean tmp) {
        this.sortAscending = tmp;
    }

    public void setSortAscending(String tmp) {
        this.sortAscending = DatabaseUtils.parseBoolean(tmp);
    }

    public void setRangeStart(Timestamp tmp) {
        this.rangeStart = tmp;
    }

    public void setRangeStart(String tmp) {
        this.rangeStart = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setRangeEnd(Timestamp tmp) {
        this.rangeEnd = tmp;
    }

    public void setRangeEnd(String tmp) {
        this.rangeEnd = DatabaseUtils.parseTimestamp(tmp);
    }

    public boolean getProcessedOnly() {
        return this.processedOnly;
    }

    public boolean getUnprocessedOnly() {
        return this.unprocessedOnly;
    }

    public boolean getInQueueOnly() {
        return this.inQueueOnly;
    }

    public boolean getSortAscending() {
        return this.sortAscending;
    }

    public Timestamp getRangeStart() {
        return this.rangeStart;
    }

    public Timestamp getRangeEnd() {
        return this.rangeEnd;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) as recordcount FROM report_queue q WHERE queue_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("q.entered", "DESC");
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY q.entered " + (this.sortAscending ? "" : "DESC") + " ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("q.*, rt.description as type_description, rt.constant as type_constant FROM report_queue q LEFT JOIN lookup_report_type rt ON (q.output_type = rt.code) WHERE queue_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            ReportQueue thisQueue = new ReportQueue(rs);
            this.add(thisQueue);
        }
        rs.close();
        pst.close();
        if (this.buildResources) {
            for (ReportQueue thisQueue : this) {
                thisQueue.buildReport(db);
            }
        }
    }

    protected void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.enteredBy != -1) {
            sqlFilter.append("AND q.enteredby = ? ");
        }
        if (this.processedOnly) {
            sqlFilter.append("AND q.processed IS NOT NULL ");
        }
        if (this.unprocessedOnly) {
            sqlFilter.append("AND q.processed IS NULL AND q.status = 0 ");
        }
        if (this.inQueueOnly) {
            sqlFilter.append("AND q.processed IS NULL ");
        }
        if (this.rangeStart != null) {
            sqlFilter.append("AND q.processed >= ? ");
        }
        if (this.rangeEnd != null) {
            sqlFilter.append("AND q.processed < ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.enteredBy != -1) {
            pst.setInt(++i, this.enteredBy);
        }
        if (this.rangeStart != null) {
            pst.setTimestamp(++i, this.rangeStart);
        }
        if (this.rangeEnd != null) {
            pst.setTimestamp(++i, this.rangeEnd);
        }
        return i;
    }

    public static boolean lockReport(ReportQueue thisReport, Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE report_queue SET status = ? WHERE queue_id = ? AND status = ? ");
        pst.setInt(1, 1);
        pst.setInt(2, thisReport.getId());
        pst.setInt(3, 0);
        int count = pst.executeUpdate();
        pst.close();
        return count == 1;
    }
}

