/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.reports.jobs;

import com.darkhorseventures.database.ConnectionPool;
import java.sql.Connection;
import org.aspcfs.apps.reportRunner.task.ProcessJasperReports;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.modules.system.base.Site;
import org.aspcfs.modules.system.base.SiteList;
import org.aspcfs.utils.SiteUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerContext;
import org.quartz.StatefulJob;

public class ReportRunnerJob
implements StatefulJob {
    public void execute(JobExecutionContext context) throws JobExecutionException {
        SchedulerContext schedulerContext = null;
        ConnectionPool cp = null;
        Connection db = null;
        Connection scriptdb = null;
        try {
            schedulerContext = context.getScheduler().getContext();
            ApplicationPrefs prefs = (ApplicationPrefs)schedulerContext.get((Object)"ApplicationPrefs");
            cp = (ConnectionPool)schedulerContext.get((Object)"ConnectionPool");
            if (System.getProperty("DEBUG") != null) {
                System.out.println("ReportRunnerJob-> Checking for new reports...");
            }
            SiteList siteList = SiteUtils.getSiteList(prefs, cp);
            for (Site thisSite : siteList) {
                db = cp.getConnection(thisSite.getConnectionElement());
                scriptdb = cp.getConnection(thisSite.getConnectionElement());
                ProcessJasperReports reportRunner = new ProcessJasperReports(db, scriptdb, thisSite, prefs.getPrefs(), prefs.getLocalizationPrefs(thisSite.getLanguage()));
                reportRunner = null;
                cp.free(db);
                cp.free(scriptdb);
                db = null;
                scriptdb = null;
            }
        }
        catch (Exception e) {
            throw new JobExecutionException(e.getMessage());
        }
        finally {
            if (cp != null) {
                if (db != null) {
                    cp.free(db);
                }
                if (scriptdb != null) {
                    cp.free(scriptdb);
                }
            }
        }
    }
}

