/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.search.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import org.aspcfs.modules.accounts.base.OrganizationList;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.modules.pipeline.base.OpportunityList;
import org.aspcfs.modules.troubletickets.base.TicketList;
import org.aspcfs.utils.UserUtils;
import org.aspcfs.utils.web.PagedListInfo;

public final class Search
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSiteSearch(ActionContext context) {
        int ITEMS_PER_PAGE = 15;
        Exception errorMessage = null;
        Connection db = null;
        String sectionId = null;
        if (context.getRequest().getParameter("pagedListSectionId") != null) {
            sectionId = context.getRequest().getParameter("pagedListSectionId");
        }
        PagedListInfo contactSearchInfo = this.getPagedListInfo(context, "SearchSiteContactInfo");
        PagedListInfo employeeSearchInfo = this.getPagedListInfo(context, "SearchSiteEmployeeInfo");
        PagedListInfo leadsSearchInfo = this.getPagedListInfo(context, "SearchSiteLeadInfo");
        PagedListInfo accountSearchInfo = this.getPagedListInfo(context, "SearchSiteAccountInfo");
        PagedListInfo opportuntySearchInfo = this.getPagedListInfo(context, "SearchSiteOppInfo");
        PagedListInfo ticSearchInfo = this.getPagedListInfo(context, "SearchSiteTicketInfo");
        if (context.getRequest().getParameter("resetList") != null && context.getRequest().getParameter("resetList").equals("true")) {
            opportuntySearchInfo.setExpandedSelection(false);
            ticSearchInfo.setExpandedSelection(false);
            accountSearchInfo.setExpandedSelection(false);
            leadsSearchInfo.setExpandedSelection(false);
            employeeSearchInfo.setExpandedSelection(false);
            contactSearchInfo.setExpandedSelection(false);
        }
        try {
            db = this.getConnection(context);
            if (this.hasPermission(context, "contacts-external_contacts-view") || this.hasPermission(context, "accounts-accounts-contacts-view")) {
                contactSearchInfo.setLink("Search.do?command=SiteSearch");
                if (sectionId == null) {
                    if (!contactSearchInfo.getExpandedSelection() && contactSearchInfo.getItemsPerPage() != ITEMS_PER_PAGE) {
                        contactSearchInfo.setItemsPerPage(ITEMS_PER_PAGE);
                    }
                } else if (sectionId.equals(contactSearchInfo.getId()) && !contactSearchInfo.getExpandedSelection()) {
                    contactSearchInfo.setExpandedSelection(true);
                }
                ContactList contactList = new ContactList();
                contactList.setPagedListInfo(contactSearchInfo);
                contactSearchInfo.setSearchCriteria(contactList, context);
                contactList.addIgnoreTypeId(1);
                contactList.addIgnoreTypeId(2);
                contactList.setAllContacts(true, this.getUserId(context), this.getUserRange(context));
                contactList.setBuildDetails(true);
                contactList.setBuildTypes(false);
                contactList.setSiteId(UserUtils.getUserSiteId(context.getRequest()));
                contactList.setExclusiveToSite(true);
                if (UserUtils.getUserSiteId(context.getRequest()) == -1) {
                    contactList.setIncludeAllSites(true);
                }
                if (sectionId == null || contactSearchInfo.getExpandedSelection()) {
                    contactList.buildList(db);
                }
                context.getRequest().setAttribute("ContactList", (Object)contactList);
            }
            if (this.hasPermission(context, "contacts-internal_contacts-view")) {
                employeeSearchInfo.setLink("Search.do?command=SiteSearch");
                if (sectionId == null) {
                    if (!employeeSearchInfo.getExpandedSelection() && employeeSearchInfo.getItemsPerPage() != ITEMS_PER_PAGE) {
                        employeeSearchInfo.setItemsPerPage(ITEMS_PER_PAGE);
                    }
                } else if (sectionId.equals(employeeSearchInfo.getId()) && !employeeSearchInfo.getExpandedSelection()) {
                    employeeSearchInfo.setExpandedSelection(true);
                }
                ContactList employeeList = new ContactList();
                employeeList.setPagedListInfo(employeeSearchInfo);
                employeeSearchInfo.setSearchCriteria(employeeList, context);
                employeeList.setEmployeesOnly(1);
                employeeList.setPersonalId(-2);
                employeeList.setBuildDetails(true);
                employeeList.setBuildTypes(false);
                employeeList.setSiteId(UserUtils.getUserSiteId(context.getRequest()));
                employeeList.setExclusiveToSite(true);
                if (UserUtils.getUserSiteId(context.getRequest()) == -1) {
                    employeeList.setIncludeAllSites(true);
                }
                if (sectionId == null || employeeSearchInfo.getExpandedSelection()) {
                    employeeList.buildList(db);
                }
                context.getRequest().setAttribute("EmployeeList", (Object)employeeList);
            }
            if (this.hasPermission(context, "sales-view")) {
                leadsSearchInfo.setLink("Search.do?command=SiteSearch");
                if (sectionId == null) {
                    if (!leadsSearchInfo.getExpandedSelection() && leadsSearchInfo.getItemsPerPage() != ITEMS_PER_PAGE) {
                        leadsSearchInfo.setItemsPerPage(ITEMS_PER_PAGE);
                    }
                } else if (sectionId.equals(leadsSearchInfo.getId()) && !leadsSearchInfo.getExpandedSelection()) {
                    leadsSearchInfo.setExpandedSelection(true);
                }
                ContactList leadsList = new ContactList();
                leadsList.setPagedListInfo(leadsSearchInfo);
                leadsSearchInfo.setSearchCriteria(leadsList, context);
                leadsList.setLeadsOnly(1);
                leadsList.setBuildDetails(true);
                leadsList.setBuildTypes(false);
                leadsList.setControlledHierarchyOnly(true, this.getUserRange(context));
                leadsList.setSiteId(UserUtils.getUserSiteId(context.getRequest()));
                leadsList.setExclusiveToSite(true);
                if (UserUtils.getUserSiteId(context.getRequest()) == -1) {
                    leadsList.setIncludeAllSites(true);
                }
                if (sectionId == null || leadsSearchInfo.getExpandedSelection()) {
                    leadsList.buildList(db);
                }
                context.getRequest().setAttribute("leadsList", (Object)leadsList);
            }
            if (this.hasPermission(context, "accounts-accounts-view")) {
                accountSearchInfo.setLink("Search.do?command=SiteSearch");
                if (sectionId == null) {
                    if (!accountSearchInfo.getExpandedSelection() && accountSearchInfo.getItemsPerPage() != ITEMS_PER_PAGE) {
                        accountSearchInfo.setItemsPerPage(ITEMS_PER_PAGE);
                    }
                } else if (sectionId.equals(accountSearchInfo.getId()) && !accountSearchInfo.getExpandedSelection()) {
                    accountSearchInfo.setExpandedSelection(true);
                }
                OrganizationList organizationList = new OrganizationList();
                organizationList.setMinerOnly(false);
                organizationList.setPagedListInfo(accountSearchInfo);
                accountSearchInfo.setSearchCriteria(organizationList, context);
                organizationList.setOrgSiteId(UserUtils.getUserSiteId(context.getRequest()));
                if (sectionId == null || accountSearchInfo.getExpandedSelection()) {
                    organizationList.buildList(db);
                }
                context.getRequest().setAttribute("OrganizationList", (Object)organizationList);
            }
            if (this.hasPermission(context, "pipeline-opportunities-view")) {
                opportuntySearchInfo.setLink("Search.do?command=SiteSearch");
                if (sectionId == null) {
                    if (!opportuntySearchInfo.getExpandedSelection() && opportuntySearchInfo.getItemsPerPage() != ITEMS_PER_PAGE) {
                        opportuntySearchInfo.setItemsPerPage(ITEMS_PER_PAGE);
                    }
                } else if (sectionId.equals(opportuntySearchInfo.getId()) && !opportuntySearchInfo.getExpandedSelection()) {
                    opportuntySearchInfo.setExpandedSelection(true);
                }
                OpportunityList oppList = new OpportunityList();
                if (UserUtils.getUserSiteId(context.getRequest()) > -1) {
                    oppList.setIncludeAllSites(false);
                } else {
                    oppList.setIncludeAllSites(true);
                    oppList.setSiteId(-1);
                }
                oppList.setPagedListInfo(opportuntySearchInfo);
                opportuntySearchInfo.setSearchCriteria(oppList, context);
                oppList.setOwnerIdRange(this.getUserRange(context));
                if (sectionId == null || opportuntySearchInfo.getExpandedSelection()) {
                    oppList.buildList(db);
                }
                context.getRequest().setAttribute("OpportunityList", (Object)oppList);
            }
            if (this.hasPermission(context, "tickets-tickets-view")) {
                ticSearchInfo.setLink("Search.do?command=SiteSearch");
                if (sectionId == null) {
                    if (!ticSearchInfo.getExpandedSelection() && ticSearchInfo.getItemsPerPage() != ITEMS_PER_PAGE) {
                        ticSearchInfo.setItemsPerPage(ITEMS_PER_PAGE);
                    }
                } else if (sectionId.equals(ticSearchInfo.getId()) && !ticSearchInfo.getExpandedSelection()) {
                    ticSearchInfo.setExpandedSelection(true);
                }
                TicketList ticketList = new TicketList();
                ticketList.setPagedListInfo(ticSearchInfo);
                ticSearchInfo.setSearchCriteria(ticketList, context);
                if (UserUtils.getUserSiteId(context.getRequest()) != -1) {
                    ticketList.setIncludeAllSites(false);
                }
                ticketList.setExclusiveToSite(true);
                ticketList.setSiteId(UserUtils.getUserSiteId(context.getRequest()));
                if (sectionId == null || ticSearchInfo.getExpandedSelection()) {
                    ticketList.buildList(db);
                }
                context.getRequest().setAttribute("TicketList", (Object)ticketList);
            }
            context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            this.addModuleBean(context, "Search", "Search Results");
            return "SearchOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }
}

