/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.service.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.isavvix.tools.FileInfo;
import com.isavvix.tools.HttpMultiPartParser;
import com.zeroio.iteam.base.FileItem;
import java.io.File;
import java.sql.Connection;
import java.util.HashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.login.base.AuthenticationItem;

public final class ProcessDocument
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDefault(ActionContext context) {
        Object errorMessage = null;
        Connection db = null;
        HashMap<String, String> errors = new HashMap<String, String>();
        boolean isValid = false;
        boolean recordInserted = false;
        try {
            String enteredBy;
            String filePath = this.getPath(context, "tmp");
            HttpMultiPartParser multiPart = new HttpMultiPartParser();
            multiPart.setUsePathParam(false);
            multiPart.setUseUniqueName(true);
            multiPart.setUseDateForFolder(false);
            HashMap parts = multiPart.parseData(context.getRequest(), filePath);
            AuthenticationItem auth = new AuthenticationItem();
            auth.setId((String)parts.get("id"));
            auth.setCode((String)parts.get("code"));
            auth.setSystemId((String)parts.get("systemId"));
            db = auth.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            if (db == null) {
                errors.put("authError", systemStatus.getLabel("object.validation.noAuthorization"));
            } else {
                context.getSession().setAttribute("ConnectionElement", (Object)auth.getConnectionElement(context));
            }
            String type = (String)parts.get("type");
            if (type == null) {
                errors.put("typeError", systemStatus.getLabel("object.validation.objectTypeRequired"));
            }
            String id = null;
            String newFilePath = null;
            int linkModuleId = -1;
            if ("ticket".equals(type)) {
                id = (String)parts.get("tid");
                newFilePath = this.getPath(context, "tickets");
                linkModuleId = 6;
            }
            if (id == null) {
                errors.put("idError", systemStatus.getLabel("object.validation.objectIdNotSpecified"));
            }
            if ((enteredBy = (String)parts.get("enteredBy")) == null) {
                errors.put("enteredByError", systemStatus.getLabel("object.validation.required"));
            }
            String subject = (String)parts.get("subject");
            String folderId = (String)parts.get("folderId");
            if (folderId != null) {
                context.getRequest().setAttribute("folderId", (Object)folderId);
            }
            if (subject != null) {
                context.getRequest().setAttribute("subject", (Object)subject);
            }
            if (parts.get("file1") instanceof FileInfo) {
                FileInfo newFileInfo = (FileInfo)parts.get("file1");
                File uploadedFile = new File(filePath + newFileInfo.getRealFilename());
                if (errors.size() > 0) {
                    uploadedFile.delete();
                } else {
                    String finalFilePath = newFilePath + ProcessDocument.getDatePath(newFileInfo.getRealFilename());
                    File renamedPath = new File(finalFilePath);
                    renamedPath.mkdirs();
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("ProcessDocument-> Final path: " + finalFilePath);
                    }
                    File renamedFile = new File(finalFilePath + newFileInfo.getRealFilename());
                    uploadedFile.renameTo(renamedFile);
                    FileItem thisItem = new FileItem();
                    thisItem.setLinkModuleId(linkModuleId);
                    thisItem.setLinkItemId(id);
                    thisItem.setEnteredBy(enteredBy);
                    thisItem.setModifiedBy(enteredBy);
                    thisItem.setSubject(subject);
                    thisItem.setClientFilename(newFileInfo.getClientFileName());
                    thisItem.setFilename(newFileInfo.getRealFilename());
                    thisItem.setVersion(1.0);
                    thisItem.setSize(newFileInfo.getSize());
                    isValid = this.validateObject(context, db, thisItem);
                    if (isValid) {
                        recordInserted = thisItem.insert(db);
                    }
                }
            } else {
                recordInserted = false;
                errors.put("actionError", systemStatus.getLabel("object.validation.incorrectFileName"));
            }
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
            context.getSession().removeAttribute("ConnectionElement");
        }
        context.getSession().removeAttribute("ConnectionElement");
        if (recordInserted) {
            return "UploadOK";
        }
        this.processErrors(context, errors);
        return "UserError";
    }
}

