/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.service.actions;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.database.ConnectionPool;
import com.darkhorseventures.framework.actions.ActionContext;
import java.io.BufferedReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.controller.SecurityHook;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.controller.objectHookManager.ObjectHookManager;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.login.base.AuthenticationItem;
import org.aspcfs.modules.login.beans.UserBean;
import org.aspcfs.modules.service.base.PacketContext;
import org.aspcfs.modules.service.base.SyncClient;
import org.aspcfs.modules.service.base.SyncClientManager;
import org.aspcfs.modules.service.base.SyncTable;
import org.aspcfs.modules.service.base.SyncTableList;
import org.aspcfs.modules.service.base.Transaction;
import org.aspcfs.modules.service.base.TransactionStatus;
import org.aspcfs.modules.service.base.TransactionStatusList;
import org.aspcfs.modules.system.base.Site;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.LoginUtils;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ProcessPacket
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDefault(ActionContext context) {
        String encoding;
        TransactionStatusList statusMessages;
        block39: {
            Connection dbLookup;
            block38: {
                ApplicationPrefs applicationPrefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
                statusMessages = new TransactionStatusList();
                Connection db = null;
                dbLookup = null;
                encoding = "UTF-8";
                String commitLevel = "packet";
                boolean validateObject = true;
                try {
                    String validator;
                    String commit = context.getRequest().getHeader("commit-level");
                    if (commit != null && "transaction".equals(commit)) {
                        commitLevel = "transaction";
                    }
                    if ((validator = context.getRequest().getHeader("object-validation")) != null) {
                        validateObject = DatabaseUtils.parseBoolean(validator);
                    }
                    HttpServletRequest request = context.getRequest();
                    StringBuffer data = new StringBuffer();
                    BufferedReader br = request.getReader();
                    String line = null;
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("XMLUtils->Reading XML from request");
                    }
                    while ((line = br.readLine()) != null) {
                        data.append(line.trim() + System.getProperty("line.separator"));
                    }
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("  XML: " + data.toString());
                    }
                    XMLUtils xml = new XMLUtils(data.toString());
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("ProcessPacket-> Parsing data");
                    }
                    AuthenticationItem auth = new AuthenticationItem();
                    XMLUtils.populateObject(auth, xml.getFirstChild("authentication"));
                    encoding = auth.getEncoding();
                    ConnectionElement ce = auth.getConnectionElement(context);
                    context.getSession().setMaxInactiveInterval(300);
                    context.getSession().setAttribute("ConnectionElement", (Object)ce);
                    UserBean thisUser = null;
                    db = this.getConnection(context);
                    boolean proceed = false;
                    if (auth.getType() == 3) {
                        thisUser = this.isUserValid(context, db, auth, applicationPrefs);
                        proceed = thisUser != null;
                    } else if (auth.getType() == 2) {
                        proceed = this.isClientValid(context, db, auth);
                    }
                    if (proceed) {
                        PacketContext packetContext = new PacketContext();
                        packetContext.setActionContext(context);
                        packetContext.setAuthenticationItem(auth);
                        packetContext.setUserBean(thisUser);
                        SyncClientManager clientManager = new SyncClientManager();
                        clientManager.addClient(db, auth.getClientId());
                        packetContext.setClientManager(clientManager);
                        HashMap objectMap = this.getObjectMap(context, db, auth);
                        packetContext.setObjectMap(objectMap);
                        ConnectionPool sqlDriver = (ConnectionPool)context.getServletContext().getAttribute("ConnectionPool");
                        packetContext.setConnectionPool(sqlDriver);
                        packetContext.setConnectionElement(ce);
                        Site thisSite = SecurityHook.retrieveSite(context.getServletContext(), context.getRequest());
                        SystemStatus systemStatus = SecurityHook.retrieveSystemStatus(context.getServletContext(), db, ce, thisSite.getLanguage());
                        packetContext.setSystemStatus(systemStatus);
                        ObjectHookManager hookManager = systemStatus.getHookManager();
                        packetContext.setObjectHookManager(hookManager);
                        dbLookup = this.getConnection(context);
                        LinkedList transactionList = new LinkedList();
                        XMLUtils.getAllChildren(xml.getDocumentElement(), "transaction", transactionList);
                        Iterator trans = transactionList.iterator();
                        try {
                            if ("packet".equals(commitLevel)) {
                                dbLookup.setAutoCommit(false);
                            }
                            while (trans.hasNext()) {
                                Element thisElement = (Element)trans.next();
                                Transaction thisTransaction = new Transaction();
                                thisTransaction.setPacketContext(packetContext);
                                thisTransaction.setValidateObject(validateObject);
                                SyncTable metaMapping = new SyncTable();
                                metaMapping.setName("meta");
                                metaMapping.setMappedClassName("org.aspcfs.modules.service.base.TransactionMeta");
                                thisTransaction.addMapping("meta", metaMapping);
                                thisTransaction.build(thisElement);
                                if (auth.getType() == 3) {
                                    proceed = true;
                                } else if (auth.getType() == 2) {
                                    proceed = true;
                                }
                                if (!proceed) continue;
                                int statusCode = thisTransaction.execute(db, dbLookup);
                                TransactionStatus thisStatus = new TransactionStatus();
                                thisStatus.setStatusCode(statusCode);
                                thisStatus.setId(thisTransaction.getId());
                                thisStatus.setMessage(thisTransaction.getErrorMessage());
                                thisStatus.setRecordList(thisTransaction.getRecordList());
                                statusMessages.add(thisStatus);
                            }
                            if ("packet".equals(commitLevel) && !dbLookup.getAutoCommit()) {
                                dbLookup.commit();
                            }
                        }
                        catch (SQLException e) {
                            if ("packet".equals(commitLevel) && !dbLookup.getAutoCommit()) {
                                dbLookup.rollback();
                            }
                            throw new SQLException(e.getMessage());
                        }
                        finally {
                            if ("packet".equals(commitLevel) && !dbLookup.getAutoCommit()) {
                                dbLookup.setAutoCommit(true);
                            }
                        }
                        if (statusMessages.size() == 0 && transactionList.size() == 0) {
                            TransactionStatus thisStatus = new TransactionStatus();
                            thisStatus.setStatusCode(1);
                            thisStatus.setMessage("No transactions found");
                            statusMessages.add(thisStatus);
                        }
                    } else {
                        TransactionStatus thisStatus = new TransactionStatus();
                        thisStatus.setStatusCode(1);
                        thisStatus.setMessage("Not authorized");
                        statusMessages.add(thisStatus);
                    }
                    if (db == null) break block38;
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                    TransactionStatus thisStatus = new TransactionStatus();
                    thisStatus.setStatusCode(1);
                    thisStatus.setMessage("Error: " + e.getMessage());
                    statusMessages.add(thisStatus);
                    break block39;
                }
                finally {
                    if (db != null) {
                        this.freeConnection(context, db);
                    }
                    if (dbLookup != null) {
                        this.freeConnection(context, dbLookup);
                    }
                }
                this.freeConnection(context, db);
            }
            if (dbLookup != null) {
                this.freeConnection(context, dbLookup);
            }
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document document = builder.newDocument();
            Element app = document.createElement("aspcfs");
            document.appendChild(app);
            int returnedRecordCount = 0;
            if (System.getProperty("DEBUG") != null) {
                System.out.println("ProcessPacket-> Processing StatusMessages for output: " + statusMessages.size());
            }
            returnedRecordCount = statusMessages.appendResponse(document, app);
            if (System.getProperty("DEBUG") != null) {
                System.out.println("ProcessPacket-> Total Records: " + returnedRecordCount);
            }
            context.getRequest().setAttribute("statusXML", (Object)XMLUtils.toString(document, encoding));
        }
        catch (Exception pce) {
            pce.printStackTrace(System.out);
        }
        return "PacketOK";
    }

    private UserBean isUserValid(ActionContext context, Connection db, AuthenticationItem auth, ApplicationPrefs applicationPrefs) throws Exception {
        LoginUtils loginUtils = new LoginUtils(db, auth.getUsername(), auth.getCode());
        loginUtils.setApplicationPrefs(applicationPrefs);
        if (loginUtils.isUserValid(context, db) && loginUtils.hasHttpApiAccess(db)) {
            return loginUtils.getUserBean();
        }
        return null;
    }

    private boolean isClientValid(ActionContext context, Connection db, AuthenticationItem auth) throws Exception {
        SyncClient client = new SyncClient(db, auth.getClientId());
        if (!client.getEnabled()) {
            return false;
        }
        if ((client.getCode() == null || "".equals(client.getCode())) && "true".equals(ProcessPacket.getPref(context, "WEBSERVER.ASPMODE"))) {
            return auth.isAuthenticated(context);
        }
        auth.setAuthCode(client.getCode());
        return auth.isAuthenticated(context);
    }

    public String executeCommandReloadSyncMap(ActionContext context) {
        context.getServletContext().removeAttribute("SyncObjectMap");
        return "PacketOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap getObjectMap(ActionContext context, Connection db, AuthenticationItem auth) {
        SyncTableList systemObjectMap = (SyncTableList)context.getServletContext().getAttribute("SyncObjectMap" + auth.getId());
        if (systemObjectMap == null) {
            ProcessPacket processPacket = this;
            synchronized (processPacket) {
                systemObjectMap = (SyncTableList)context.getServletContext().getAttribute("SyncObjectMap" + auth.getId());
                if (systemObjectMap == null) {
                    systemObjectMap = new SyncTableList();
                    systemObjectMap.setBuildTextFields(false);
                    try {
                        systemObjectMap.buildList(db);
                    }
                    catch (SQLException e) {
                        e.printStackTrace(System.out);
                    }
                    context.getServletContext().setAttribute("SyncObjectMap" + auth.getId(), (Object)systemObjectMap);
                }
            }
        }
        return systemObjectMap.getObjectMapping(auth.getSystemId());
    }
}

