/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.service.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import org.aspcfs.modules.service.base.DemoData;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.PasswordHash;

public class DemoAccount {
    public static final String fs = System.getProperty("file.separator");
    public static final int STATUS_DEFAULT = -1;
    public static final int STATUS_INITIALIZED = 1;
    public static final int STATUS_EMAIL_SENT = 2;
    public static final int STATUS_EMAIL_ERROR = 3;
    private int id = -1;
    private String nameFirst = null;
    private String nameLast = null;
    private String organization = null;
    private String title = null;
    private String phone = null;
    private String extension = null;
    private String email = null;
    private String ipAddress = null;
    private String browser = null;
    private String language = null;
    private String referer = null;
    private int status = -1;
    private String password = null;
    private Timestamp processed = null;
    private int failedCount = 0;
    private int roleId = -1;

    public DemoAccount() {
    }

    public DemoAccount(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setNameFirst(String tmp) {
        this.nameFirst = tmp;
    }

    public void setNameLast(String tmp) {
        this.nameLast = tmp;
    }

    public void setOrganization(String tmp) {
        this.organization = tmp;
    }

    public void setTitle(String tmp) {
        this.title = tmp;
    }

    public void setPhone(String tmp) {
        this.phone = tmp;
    }

    public void setExtension(String tmp) {
        this.extension = tmp;
    }

    public void setEmail(String tmp) {
        this.email = tmp;
    }

    public void setIpAddress(String tmp) {
        this.ipAddress = tmp;
    }

    public void setBrowser(String tmp) {
        this.browser = tmp;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    public void setStatus(int tmp) {
        this.status = tmp;
    }

    public void setStatus(String tmp) {
        this.status = Integer.parseInt(tmp);
    }

    public void setProcessed(Timestamp processed) {
        this.processed = processed;
    }

    public int getId() {
        return this.id;
    }

    public String getNameFirst() {
        return this.nameFirst;
    }

    public String getNameLast() {
        return this.nameLast;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getTitle() {
        return this.title;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getEmail() {
        return this.email;
    }

    public String getEmailSubstring() {
        if (this.email != null && this.email.indexOf("@") > 0) {
            return this.email.substring(this.email.lastIndexOf("@") + 1);
        }
        return this.email;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getBrowser() {
        return this.browser;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getReferer() {
        return this.referer;
    }

    public int getStatus() {
        return this.status;
    }

    public Timestamp getProcessed() {
        return this.processed;
    }

    public int getFailedCount() {
        return this.failedCount;
    }

    public void setFailedCount(int failedCount) {
        this.failedCount = failedCount;
    }

    public synchronized void addFailed() {
        this.failedCount += this.failedCount;
    }

    public int getRoleId() {
        return this.roleId;
    }

    public void setRoleId(int roleId) {
        this.roleId = roleId;
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "demo_account_demo_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO demo_account (" + (this.id > -1 ? "demo_id, " : "") + "name_first, name_last, organization, title, " + "phone, extension, email, ip_address, browser, language, referer, status) VALUES " + "(" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setString(++i, this.nameFirst);
        pst.setString(++i, this.nameLast);
        pst.setString(++i, this.organization);
        pst.setString(++i, this.title);
        pst.setString(++i, this.phone);
        pst.setString(++i, this.extension);
        pst.setString(++i, this.email);
        pst.setString(++i, this.ipAddress);
        pst.setString(++i, this.browser);
        pst.setString(++i, this.language);
        pst.setString(++i, this.referer);
        pst.setInt(++i, this.status);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "demo_account_demo_id_seq", this.id);
        if (System.getProperty("DEBUG") != null) {
            System.out.println("DemoAccount-> Inserted new demo account: " + this.id);
        }
        return true;
    }

    public boolean updateStatus(Connection db, int newStatus) throws SQLException {
        this.status = newStatus;
        PreparedStatement pst = db.prepareStatement("UPDATE demo_account SET status = ? WHERE demo_id = ?");
        int i = 0;
        pst.setInt(++i, this.status);
        pst.setInt(++i, this.id);
        pst.executeUpdate();
        pst.close();
        return true;
    }

    public boolean updateProcessed(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE demo_account SET processed = CURRENT_TIMESTAMP WHERE demo_id = ?");
        int i = 0;
        pst.setInt(++i, this.id);
        pst.executeUpdate();
        pst.close();
        return true;
    }

    public String getDatabaseName() {
        return "demo_" + this.id;
    }

    public void setPassword(String tmp) {
        this.password = tmp;
    }

    public String getGeneratedPassword() {
        if (this.password == null) {
            this.password = PasswordHash.getRandomString(6, 8);
        }
        return this.password;
    }

    public String getLoginName() {
        return this.email.trim();
    }

    public boolean createDatabase(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("CREATE DATABASE " + this.getDatabaseName() + " " + "WITH ENCODING = 'UNICODE'");
        pst.execute();
        pst.close();
        return true;
    }

    public boolean addToSites(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("INSERT INTO sites (sitecode, vhost, dbhost, dbname, dbport, dbuser, dbpw, driver, enabled, language) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        int i = 0;
        pst.setString(++i, "cfs");
        pst.setString(++i, "account" + this.id + ".demo.centriccrm.com");
        pst.setString(++i, "jdbc:postgresql://127.0.0.1:5432/demo_" + this.id);
        pst.setString(++i, this.getDatabaseName());
        pst.setInt(++i, 5432);
        pst.setString(++i, "postgres");
        pst.setString(++i, "");
        pst.setString(++i, "org.postgresql.Driver");
        pst.setBoolean(++i, true);
        pst.setString(++i, this.language);
        pst.execute();
        pst.close();
        return true;
    }

    public boolean dropDatabase(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("DROP DATABASE " + this.getDatabaseName() + " ");
        pst.execute();
        pst.close();
        pst = db.prepareStatement("DELETE FROM sites WHERE dbname = ? ");
        int i = 0;
        pst.setString(++i, this.getDatabaseName());
        pst.execute();
        pst.close();
        return true;
    }

    public boolean insertSampleData(Connection db) throws SQLException, InterruptedException {
        if (!this.isDatabaseInstalled(db)) {
            return false;
        }
        return DemoData.install(db, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testAndFinalize(Connection db) throws SQLException, InterruptedException {
        if (!this.isDatabaseInstalled(db)) {
            return false;
        }
        PreparedStatement pst = null;
        try {
            pst = db.prepareStatement("UPDATE access SET username = ?, password = ? WHERE user_id = 2");
            pst.setString(1, this.getLoginName());
            pst.setString(2, PasswordHash.encrypt(this.getGeneratedPassword()));
            pst.execute();
            pst.close();
            pst = db.prepareStatement("UPDATE contact SET namefirst = ?, namelast = ? WHERE user_id = 2");
            pst.setString(1, this.nameFirst);
            pst.setString(2, this.nameLast);
            pst.execute();
            pst.close();
            pst = db.prepareStatement("UPDATE contact_emailaddress SET email = ? WHERE contact_id IN (SELECT contact_id FROM contact WHERE user_id = 2)");
            pst.setString(1, this.email);
            pst.execute();
            pst.close();
            pst = db.prepareStatement("UPDATE organization SET name = ? WHERE org_id = 0");
            pst.setString(1, this.organization);
            pst.execute();
            pst.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (pst != null) {
                pst.close();
            }
        }
        return true;
    }

    private boolean isDatabaseInstalled(Connection db) {
        boolean databaseExists = false;
        try {
            Statement st = db.createStatement();
            ResultSet rs = st.executeQuery("SELECT count(*) AS test FROM access ");
            if (rs.next()) {
                databaseExists = true;
            }
            rs.close();
            st.close();
        }
        catch (SQLException sqe) {
            System.out.println("DemoAccount-> " + sqe.getMessage());
        }
        return databaseExists;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("demo_id");
        this.nameFirst = rs.getString("name_first");
        this.nameLast = rs.getString("name_last");
        this.organization = rs.getString("organization");
        this.title = rs.getString("title");
        this.phone = rs.getString("phone");
        this.extension = rs.getString("extension");
        this.email = rs.getString("email");
        this.ipAddress = rs.getString("ip_address");
        this.browser = rs.getString("browser");
        this.status = DatabaseUtils.getInt(rs, "status");
        this.processed = rs.getTimestamp("processed");
        this.language = rs.getString("language");
        this.referer = rs.getString("referer");
    }
}

