/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.service.base;

import com.darkhorseventures.framework.beans.GenericBean;
import com.zeroio.iteam.base.Assignment;
import com.zeroio.iteam.base.AssignmentFolder;
import com.zeroio.iteam.base.FileFolder;
import com.zeroio.iteam.base.IssueCategory;
import com.zeroio.iteam.base.NewsArticle;
import com.zeroio.iteam.base.Project;
import com.zeroio.iteam.base.Requirement;
import com.zeroio.iteam.base.TeamMember;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Locale;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.accounts.base.OrganizationAddress;
import org.aspcfs.modules.accounts.base.OrganizationEmailAddress;
import org.aspcfs.modules.accounts.base.OrganizationPhoneNumber;
import org.aspcfs.modules.actionlist.base.ActionItem;
import org.aspcfs.modules.actionlist.base.ActionList;
import org.aspcfs.modules.admin.base.AccessTypeList;
import org.aspcfs.modules.admin.base.Permission;
import org.aspcfs.modules.admin.base.Role;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.base.CustomField;
import org.aspcfs.modules.base.CustomFieldCategory;
import org.aspcfs.modules.base.CustomFieldGroup;
import org.aspcfs.modules.communications.base.ActiveSurvey;
import org.aspcfs.modules.communications.base.ActiveSurveyQuestion;
import org.aspcfs.modules.communications.base.Campaign;
import org.aspcfs.modules.communications.base.CampaignRun;
import org.aspcfs.modules.communications.base.Item;
import org.aspcfs.modules.communications.base.ItemList;
import org.aspcfs.modules.communications.base.Message;
import org.aspcfs.modules.communications.base.ScheduledRecipient;
import org.aspcfs.modules.communications.base.SearchCriteriaElement;
import org.aspcfs.modules.communications.base.SearchCriteriaList;
import org.aspcfs.modules.communications.base.SearchCriteriaListList;
import org.aspcfs.modules.communications.base.Survey;
import org.aspcfs.modules.communications.base.SurveyAnswer;
import org.aspcfs.modules.communications.base.SurveyQuestion;
import org.aspcfs.modules.communications.base.SurveyResponse;
import org.aspcfs.modules.contacts.base.Call;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactAddress;
import org.aspcfs.modules.contacts.base.ContactEmailAddress;
import org.aspcfs.modules.contacts.base.ContactPhoneNumber;
import org.aspcfs.modules.pipeline.base.OpportunityComponent;
import org.aspcfs.modules.pipeline.base.OpportunityHeader;
import org.aspcfs.modules.service.base.DemoAccount;
import org.aspcfs.modules.tasks.base.Task;
import org.aspcfs.modules.troubletickets.base.Ticket;
import org.aspcfs.modules.troubletickets.base.TicketLog;
import org.aspcfs.utils.formatter.AddressFormatter;
import org.aspcfs.utils.formatter.EmailAddressFormatter;
import org.aspcfs.utils.formatter.PhoneNumberFormatter;
import org.aspcfs.utils.web.LookupList;

public class DemoData {
    public static Timestamp addCurrentTimestamp(int days) {
        if (days != 0) {
            return new Timestamp(System.currentTimeMillis() + (long)(days * 1000 * 60 * 60 * 24));
        }
        return new Timestamp(System.currentTimeMillis());
    }

    public static void checkIfInserted(boolean value, Object object) throws SQLException {
        if (!value) {
            String warningMsg;
            for (String warningKey : ((GenericBean)object).getErrors().keySet()) {
                warningMsg = (String)((GenericBean)object).getErrors().get(warningKey);
                if (System.getProperty("DEBUG") == null) continue;
                System.out.println("Object Validation Error-> " + warningKey + "=" + warningMsg);
            }
            for (String warningKey : ((GenericBean)object).getWarnings().keySet()) {
                warningMsg = (String)((GenericBean)object).getWarnings().get(warningKey);
                if (System.getProperty("DEBUG") == null) continue;
                System.out.println("Object Validation Warning-> " + warningKey + "=" + warningMsg);
            }
            throw new SQLException("Record not inserted for: " + object.getClass().getName());
        }
    }

    public static boolean install(Connection db, DemoAccount demoAccount) throws SQLException {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("DemoData-> Installing data");
        }
        EmailAddressFormatter emailFormatter = new EmailAddressFormatter();
        PhoneNumberFormatter phoneFormatter = new PhoneNumberFormatter();
        AddressFormatter addressFormatter = new AddressFormatter();
        Locale thisLocale = Locale.US;
        String timeZone = "America/New_York";
        Organization.renameMyCompany(db, demoAccount.getOrganization());
        Role role = new Role();
        role.setRole("Demo User (Non-administrative)");
        role.setDescription("Non-administrative demo user");
        role.setRoleType(0);
        role.setEnteredBy(0);
        role.setModifiedBy(0);
        DemoData.checkIfInserted(role.insert(db), (Object)role);
        role.addPermission(db, Permission.lookupId(db, "myhomepage"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "myhomepage-dashboard"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "myhomepage-inbox"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "myhomepage-tasks"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "myhomepage-profile"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "myhomepage-profile-personal"), false, true, true, false);
        role.addPermission(db, Permission.lookupId(db, "myhomepage-profile-settings"), false, true, true, false);
        role.addPermission(db, Permission.lookupId(db, "myhomepage-profile-password"), false, false, true, false);
        role.addPermission(db, Permission.lookupId(db, "myhomepage-action-lists"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "myhomepage-action-plans"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "myhomepage-reassign"), false, true, true, false);
        role.addPermission(db, Permission.lookupId(db, "sales"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "sales-dashboard"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "sales-leads"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "sales-import"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "sales-reports"), false, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "contacts"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "contacts-external_contacts"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "contacts-external_contacts-reports"), true, true, false, true);
        role.addPermission(db, Permission.lookupId(db, "contacts-external_contacts-folders"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "contacts-external_contacts-calls"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "contacts-external_contacts-messages"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "contacts-external_contacts-opportunities"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "contacts-external_contacts-history"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "pipeline"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "pipeline-opportunities"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "pipeline-dashboard"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "pipeline-reports"), true, true, false, true);
        role.addPermission(db, Permission.lookupId(db, "pipeline-opportunities-calls"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "pipeline-opportunities-documents"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "pipeline-folders"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "pipeline-quotes"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "accounts"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "accounts-accounts"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "accounts-accounts-folders"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "accounts-accounts-contacts"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "accounts-accounts-contacts-opportunities"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "accounts-accounts-contacts-calls"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "accounts-accounts-contacts-completed-calls"), false, false, true, false);
        role.addPermission(db, Permission.lookupId(db, "accounts-accounts-contacts-messages"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "accounts-accounts-contacts-move"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "accounts-accounts-opportunities"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "accounts-accounts-tickets"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "accounts-accounts-tickets-tasks"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "accounts-accounts-tickets-folders"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "accounts-accounts-tickets-documents"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "accounts-accounts-documents"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "accounts-accounts-reports"), true, true, false, true);
        role.addPermission(db, Permission.lookupId(db, "accounts-accounts-history"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "accounts-service-contracts"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "accounts-assets"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "accounts-accounts-tickets-maintenance-report"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "accounts-accounts-tickets-activity-log"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "accounts-accounts-relationships"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "accounts-projects"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "portal-user"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "accounts-quotes"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "accounts-action-plans"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "accounts-accounts-contacts-opportunities-quotes"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "accounts-accounts-contacts-folders"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "accounts-accounts-contacts-opps-folders"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "quotes"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "quotes-quotes"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "product-catalog-product"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "campaign"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "campaign-dashboard"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "campaign-campaigns"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "campaign-campaigns-groups"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "campaign-campaigns-messages"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "campaign-campaigns-surveys"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "campaign-campaign-contact-updater"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "projects"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "projects-personal"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "projects-enterprise"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "projects-projects"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "tickets"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "tickets-tickets"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "tickets-reports"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "tickets-tickets-tasks"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "tickets-maintenance-report"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "tickets-activity-log"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "tickets-knowledge-base"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "tickets-defects"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "tickets-action-plans"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "employees"), true, true, true, false);
        role.addPermission(db, Permission.lookupId(db, "contacts-internal_contacts"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "contacts-internal_contacts-projects"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "contacts-internal_contacts-folders"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "reports"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "admin"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "admin-users"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "admin-roles"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "admin-sysconfig"), false, true, true, false);
        role.addPermission(db, Permission.lookupId(db, "admin-usage"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "admin-sysconfig-lists"), false, true, true, false);
        role.addPermission(db, Permission.lookupId(db, "admin-sysconfig-folders"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "admin-object-workflow"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "admin-sysconfig-categories"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "product-catalog"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "product-catalog-product"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "product-catalog-product-imports"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "admin-sysconfig-logos"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "admin-actionplans"), true, true, true, true);
        role.addPermission(db, Permission.lookupId(db, "help"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "globalitems-search"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "globalitems-myitems"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "globalitems-recentitems"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "documents"), false, true, false, false);
        role.addPermission(db, Permission.lookupId(db, "documents_documentstore"), true, true, true, true);
        AccessTypeList employeeAccessTypes = new AccessTypeList(db, 626030332);
        AccessTypeList accountContactAccessTypes = new AccessTypeList(db, 626030331);
        AccessTypeList messageAccessTypes = new AccessTypeList(db, 707031028);
        AccessTypeList contactAccessTypes = new AccessTypeList(db, 626030330);
        AccessTypeList oppAccessTypes = new AccessTypeList(db, 804051057);
        int departmentList_SALES = 12;
        int departmentList_ENGINEERING = 5;
        int departmentList_LEGAL = 8;
        int ticketPriorityList_URGENT = 3;
        int ticketPriorityList_AS_SCHEDULED = 2;
        int ticketPriorityList_CRITICAL = 4;
        int ticketSeverityList_NORMAL = 1;
        int ticketSeverityList_IMPORTANT = 2;
        int ticketSeverityList_CRITICAL = 3;
        int ticketSourceList_PHONE = 1;
        int ticketSourceList_EMAIL = 2;
        int callTypeList_OUTGOING_CALL = 2;
        int callTypeList_OUTSIDE_APPT = 5;
        int callResultList_YES_BUS_PROGRESSING = 1;
        int callPriorityList_HIGH = 3;
        int callReminderList_HOURS = 2;
        int stageList_PROSPECTING = 1;
        int stageList_PROPOSAL = 6;
        int stageList_NEGOTIATION = 7;
        int stageList_NEEDS_ANALYSIS = 3;
        int stageList_VALUE_PROP = 4;
        int industryList_REAL_ESTATE = 18;
        int industryList_AUTOMOTIVE = 1;
        int industryList_CONSULTING = 5;
        int industryList_FINANCIAL_SERVICES = 9;
        int industryList_FOOD = 10;
        int industryList_COMPUTER = 4;
        int industryList_RETAIL = 19;
        int accountTypeList_CONTRACT = 4;
        int accountTypeList_NON_CONTRACT = 5;
        int accountTypeList_TERRITORY1 = 6;
        int accountTypeList_TERRITORY3 = 8;
        int accountTypeList_TERRITORY5 = 9;
        int accountTypeList_LARGE = 3;
        LookupList contactTypeList = new LookupList(db, "lookup_contact_types");
        int contactTypeList_ACQUAINTANCE = 1;
        int contactTypeList_CUSTOMER = 3;
        int contactTypeList_FRIEND = 4;
        int contactTypeList_PROSPECT = 5;
        int contactTypeList_VENDOR = 7;
        int contactTypeList_EXECUTIVE = 13;
        int contactTypeList_ACCOUNTING = 8;
        int contactTypeList_SALES = 18;
        int contactTypeList_ADMINISTRATIVE = 9;
        int contactTypeList_BUSINESS_DEV = 10;
        int opportunityTypeList_MAINTENANCE = 4;
        int opportunityTypeList_SERVICES = 6;
        int opportunityTypeList_PRODUCT_SALES = 5;
        int opportunityTypeList_CONSULTATION = 2;
        int opportunityTypeList_DEVELOPMENT = 3;
        int projectRoleList_LEAD = 1;
        int projectRoleList_CONTRIBUTOR = 2;
        int projectRoleList_OBSERVER = 3;
        int contact1Id = -1;
        int user1Id = -1;
        Contact contact = new Contact();
        contact.setAccessType(employeeAccessTypes.getDefaultItem());
        contact.setEmployee(true);
        contact.setEnteredBy(0);
        contact.setModifiedBy(0);
        contact.setNameFirst(demoAccount.getNameFirst());
        contact.setNameLast(demoAccount.getNameLast());
        contact.setTitle("VP / Sales");
        contact.setDepartment(departmentList_SALES);
        contact.setOrgId(0);
        ContactPhoneNumber businessPhone = new ContactPhoneNumber();
        businessPhone.setType(1);
        businessPhone.setEnteredBy(0);
        businessPhone.setModifiedBy(0);
        businessPhone.setNumber(demoAccount.getPhone());
        businessPhone.setExtension(demoAccount.getExtension());
        if (businessPhone.isValid()) {
            PhoneNumberFormatter.format(businessPhone, thisLocale);
            contact.getPhoneNumberList().add(businessPhone);
        } else {
            System.err.println("Business1 phone is invalid: " + businessPhone.toString());
        }
        ContactEmailAddress businessEmail = new ContactEmailAddress();
        businessEmail.setType(1);
        businessEmail.setEnteredBy(0);
        businessEmail.setModifiedBy(0);
        businessEmail.setEmail(demoAccount.getEmail());
        if (businessEmail.isValid()) {
            emailFormatter.format(businessEmail);
            contact.getEmailAddressList().add(businessEmail);
        } else {
            System.err.println("Business1 email is invalid: " + businessEmail.toString());
        }
        DemoData.checkIfInserted(contact.insert(db), (Object)contact);
        contact1Id = contact.getId();
        User user = new User();
        user.setContact(contact);
        user.setUsername(demoAccount.getLoginName());
        user.setPassword1(demoAccount.getGeneratedPassword());
        user.setContactId(contact1Id);
        if (demoAccount.getRoleId() > -1) {
            user.setRoleId(demoAccount.getRoleId());
        } else {
            user.setRoleId(role.getId());
        }
        user.setExpires(DemoData.addCurrentTimestamp(5));
        DemoData.checkIfInserted(user.insert(db), (Object)user);
        user1Id = user.getId();
        Task task = new Task();
        task.setEnteredBy(user1Id);
        task.setModifiedBy(user1Id);
        task.setPriority(1);
        task.setDescription("Meeting prep for next week with Newco");
        task.setNotes("Use existing powerpoint");
        task.setSharing(-1);
        task.setOwner(user1Id);
        task.setDueDate(DemoData.addCurrentTimestamp(0));
        task.setDueDateTimeZone(timeZone);
        task.setEstimatedLOE(1.0);
        task.setEstimatedLOEType(2);
        task.setType(1);
        DemoData.checkIfInserted(task.insert(db), (Object)task);
        int contact2Id = -1;
        int user2Id = -1;
        Contact contact2 = new Contact();
        contact2.setAccessType(employeeAccessTypes.getDefaultItem());
        contact2.setEmployee(true);
        contact2.setEnteredBy(user1Id);
        contact2.setModifiedBy(user1Id);
        contact2.setNameFirst("Matt");
        contact2.setNameLast("Rajkowski");
        contact2.setTitle("Chief Architect");
        contact2.setOrgId(0);
        contact2.setDepartment(departmentList_ENGINEERING);
        ContactAddress businessAddress = new ContactAddress();
        businessAddress.setType(1);
        businessAddress.setEnteredBy(user1Id);
        businessAddress.setModifiedBy(user1Id);
        businessAddress.setStreetAddressLine1("200 Main Street");
        businessAddress.setStreetAddressLine2("");
        businessAddress.setStreetAddressLine3("");
        businessAddress.setCity("Iowa City");
        businessAddress.setState("HI");
        businessAddress.setZip("");
        businessAddress.setCountry("UNITED STATES");
        if (businessAddress.isValid()) {
            addressFormatter.format(businessAddress);
            contact2.getAddressList().add(businessAddress);
        } else {
            System.err.println("Business2 address is invalid: " + businessAddress.toString());
        }
        ContactPhoneNumber businessPhone2 = new ContactPhoneNumber();
        businessPhone2.setType(1);
        businessPhone2.setEnteredBy(user1Id);
        businessPhone2.setModifiedBy(user1Id);
        businessPhone2.setNumber("(800) 555-1212");
        businessPhone2.setExtension("");
        if (businessPhone2.isValid()) {
            PhoneNumberFormatter.format(businessPhone2, thisLocale);
            contact2.getPhoneNumberList().add(businessPhone2);
        } else {
            System.err.println("Business2 phone is invalid: " + businessPhone2.toString());
        }
        ContactEmailAddress businessEmail2 = new ContactEmailAddress();
        businessEmail2.setType(1);
        businessEmail2.setEnteredBy(user1Id);
        businessEmail2.setModifiedBy(user1Id);
        businessEmail2.setEmail("matt@company.com");
        if (businessEmail2.isValid()) {
            emailFormatter.format(businessEmail2);
            contact2.getEmailAddressList().add(businessEmail2);
        } else {
            System.err.println("Business2 email is invalid: " + businessEmail2.toString());
        }
        DemoData.checkIfInserted(contact2.insert(db), (Object)contact2);
        contact2Id = contact2.getId();
        User user2 = new User();
        user2.setContact(contact2);
        user2.setUsername("matt-unused");
        user2.setPassword1("--none--");
        user2.setContactId(contact2Id);
        user2.setRoleId(role.getId());
        user2.setExpires(DemoData.addCurrentTimestamp(2));
        DemoData.checkIfInserted(user2.insert(db), (Object)user2);
        user2Id = user2.getId();
        int contact3Id = -1;
        int user3Id = -1;
        Contact contact3 = new Contact();
        contact3.setAccessType(employeeAccessTypes.getDefaultItem());
        contact3.setEmployee(true);
        contact3.setEnteredBy(user1Id);
        contact3.setModifiedBy(user1Id);
        contact3.setNameFirst("Tom");
        contact3.setNameLast("Manos");
        contact3.setTitle("CTO");
        contact3.setDepartment(departmentList_ENGINEERING);
        contact3.setOrgId(0);
        ContactAddress businessAddress2 = new ContactAddress();
        businessAddress2.setType(1);
        businessAddress2.setEnteredBy(user1Id);
        businessAddress2.setModifiedBy(user1Id);
        businessAddress2.setStreetAddressLine1("200 Main Street");
        businessAddress2.setStreetAddressLine2("");
        businessAddress2.setStreetAddressLine3("");
        businessAddress2.setCity("Iowa City");
        businessAddress2.setState("HI");
        businessAddress2.setZip("");
        businessAddress2.setCountry("UNITED STATES");
        if (businessAddress2.isValid()) {
            addressFormatter.format(businessAddress2);
            contact3.getAddressList().add(businessAddress2);
        } else {
            System.err.println("Business3 address is invalid: " + businessAddress2.toString());
        }
        ContactPhoneNumber businessPhone3 = new ContactPhoneNumber();
        businessPhone3.setType(1);
        businessPhone3.setEnteredBy(user1Id);
        businessPhone3.setModifiedBy(user1Id);
        businessPhone3.setNumber("(800) 555-1212");
        businessPhone3.setExtension("");
        if (businessPhone3.isValid()) {
            PhoneNumberFormatter.format(businessPhone3, thisLocale);
            contact3.getPhoneNumberList().add(businessPhone3);
        } else {
            System.err.println("Business3 phone is invalid: " + businessPhone3.toString());
        }
        ContactEmailAddress businessEmail3 = new ContactEmailAddress();
        businessEmail3.setType(1);
        businessEmail3.setEnteredBy(user1Id);
        businessEmail3.setModifiedBy(user1Id);
        businessEmail3.setEmail("tom@company.com");
        if (businessEmail3.isValid()) {
            emailFormatter.format(businessEmail3);
            contact3.getEmailAddressList().add(businessEmail3);
        } else {
            System.err.println("Business3 email is invalid: " + businessEmail3.toString());
        }
        DemoData.checkIfInserted(contact3.insert(db), (Object)contact3);
        contact3Id = contact3.getId();
        User user3 = new User();
        user3.setContact(contact3);
        user3.setUsername("tom-unused");
        user3.setPassword1("--none--");
        user3.setManagerId(user1Id);
        user3.setContactId(contact3Id);
        user3.setRoleId(role.getId());
        user3.setExpires(DemoData.addCurrentTimestamp(2));
        DemoData.checkIfInserted(user3.insert(db), (Object)user3);
        user3Id = user3.getId();
        int contact4Id = -1;
        int user4Id = -1;
        Contact contact4 = new Contact();
        contact4.setAccessType(employeeAccessTypes.getDefaultItem());
        contact4.setEmployee(true);
        contact4.setEnteredBy(user1Id);
        contact4.setModifiedBy(user1Id);
        contact4.setNameFirst("Larry");
        contact4.setNameLast("Stanford");
        contact4.setTitle("Partner");
        contact4.setDepartment(departmentList_LEGAL);
        contact4.setOrgId(0);
        ContactPhoneNumber businessPhone4 = new ContactPhoneNumber();
        businessPhone4.setType(1);
        businessPhone4.setEnteredBy(user1Id);
        businessPhone4.setModifiedBy(user1Id);
        businessPhone4.setNumber("(334) 331-9898");
        businessPhone4.setExtension("");
        if (businessPhone4.isValid()) {
            PhoneNumberFormatter.format(businessPhone4, thisLocale);
            contact4.getPhoneNumberList().add(businessPhone4);
        } else {
            System.err.println("Business4 phone is invalid: " + businessPhone4.toString());
        }
        ContactEmailAddress businessEmail4 = new ContactEmailAddress();
        businessEmail4.setType(1);
        businessEmail4.setEnteredBy(user1Id);
        businessEmail4.setModifiedBy(user1Id);
        businessEmail4.setEmail("larry@stanfordco.com");
        if (businessEmail4.isValid()) {
            emailFormatter.format(businessEmail4);
            contact4.getEmailAddressList().add(businessEmail4);
        } else {
            System.err.println("Business4 email is invalid: " + businessEmail4.toString());
        }
        DemoData.checkIfInserted(contact4.insert(db), (Object)contact4);
        contact4Id = contact4.getId();
        User user4 = new User();
        user4.setContact(contact4);
        user4.setUsername("larry-unused");
        user4.setPassword1("--none--");
        user4.setContactId(contact4Id);
        user4.setRoleId(role.getId());
        user4.setExpires(DemoData.addCurrentTimestamp(2));
        DemoData.checkIfInserted(user4.insert(db), (Object)user4);
        user4Id = user4.getId();
        CustomFieldCategory category = new CustomFieldCategory();
        category.setModuleId(2);
        category.setName("Personal Background");
        category.setEnabled(true);
        category.setAllowMultipleRecords(false);
        category.insertCategory(db);
        CustomFieldGroup group = new CustomFieldGroup();
        group.setCategoryId(category.getId());
        group.setName("Education");
        group.setLevel(1);
        group.setEnabled(true);
        group.insertGroup(db);
        CustomField field = new CustomField();
        field.setGroupId(group.getId());
        field.setName("Highest level attained");
        field.setType(2);
        field.setRequired(false);
        field.setLookupListText("K-12\r\nJunior College\r\nCollege\r\nPost Graduate - Masters\r\nPost Graduate - Doctorate");
        field.insertField(db);
        field = new CustomField();
        field.setGroupId(group.getId());
        field.setName("Institutions Attended");
        field.setType(1);
        field.setMaxLength("250");
        field.setRequired(false);
        field.insertField(db);
        field = new CustomField();
        field.setGroupId(group.getId());
        field.setName("Degree");
        field.setType(2);
        field.setRequired(false);
        field.setLookupListText("AB\r\nBA\r\nBS\r\nMBA\r\nJD");
        field.insertField(db);
        field = new CustomField();
        field.setGroupId(group.getId());
        field.setName("Grade Point");
        field.setType(1);
        field.setMaxLength("4");
        field.setRequired(false);
        field.insertField(db);
        field = new CustomField();
        field.setGroupId(group.getId());
        field.setName("Field of Study");
        field.setType(1);
        field.setMaxLength("50");
        field.setRequired(false);
        field.insertField(db);
        group = new CustomFieldGroup();
        group.setCategoryId(category.getId());
        group.setName("Personal");
        group.setLevel(1);
        group.setEnabled(true);
        group.insertGroup(db);
        field = new CustomField();
        field.setGroupId(group.getId());
        field.setName("Sex");
        field.setType(2);
        field.setRequired(false);
        field.setLookupListText("Female\r\nMale");
        field.insertField(db);
        field = new CustomField();
        field.setGroupId(group.getId());
        field.setName("Age");
        field.setType(9);
        field.setMaxLength("3");
        field.setRequired(false);
        field.insertField(db);
        field = new CustomField();
        field.setGroupId(group.getId());
        field.setName("Marital Status");
        field.setType(2);
        field.setRequired(false);
        field.setLookupListText("Single\r\nMarried\r\nDivorced");
        field.insertField(db);
        field = new CustomField();
        field.setGroupId(group.getId());
        field.setName("Hobbies");
        field.setType(1);
        field.setMaxLength("250");
        field.setRequired(false);
        field.insertField(db);
        field = new CustomField();
        field.setGroupId(group.getId());
        field.setName("Member of...");
        field.setType(2);
        field.setRequired(false);
        field.setLookupListText("American Society of Pediatrics\r\nAmerican Society of Oncolologists\r\nAmerican Medical Association\r\nAmerican Juvenile Diabetes Federation");
        field.insertField(db);
        ActionList actionList1 = new ActionList();
        actionList1.setDescription("Weekly call list for early in week");
        actionList1.setOwner(user1Id);
        actionList1.setLinkModuleId(2);
        actionList1.setEnteredBy(user1Id);
        actionList1.setModifiedBy(user1Id);
        actionList1.setEnabled(true);
        DemoData.checkIfInserted(actionList1.insert(db), (Object)actionList1);
        ActionList actionList2 = new ActionList();
        actionList2.setDescription("Weekly call list for late in week");
        actionList2.setOwner(user1Id);
        actionList2.setLinkModuleId(2);
        actionList2.setEnteredBy(user1Id);
        actionList2.setModifiedBy(user1Id);
        actionList2.setEnabled(true);
        DemoData.checkIfInserted(actionList2.insert(db), (Object)actionList2);
        int message1Id = -1;
        Message message = new Message();
        message.setName("Large Account Newsletter Update - 1 January");
        message.setDescription("January newsletter to biggest customers");
        message.setReplyTo("boballen@fictitiousco.com");
        message.setMessageSubject("January happenings at Shoe World");
        message.setMessageText("<img src=\"images/demo/master_logo_sdcwinter.gif\" width=\"300\" height=\"65\" alt=\"Shoes.com\" border=\"0\" /><br /><br />Dear ${firstname},<br /><br />    Below are a few of the new things we thought you might want to know about as a member of our Gold Shoe Club.<br /><br /><ul><li>New store ours on Friday:  Now from 8:00 AM to 7 PM</li><li>The cocktail bar will even be open on Sundays</li><li>Our new price list will be out on the 12th</li><li>Sign-up for pre-ordering can be done by clicking on the survey link below</li></ul>Sincerely,<br /><br />Frank Jones<br />VP/Key Accounts<br />");
        message.setEnteredBy(user1Id);
        message.setModifiedBy(user1Id);
        message.setAccessType(messageAccessTypes.getDefaultItem());
        DemoData.checkIfInserted(message.insert(db), (Object)message);
        message1Id = message.getId();
        int group1Id = -1;
        SearchCriteriaList campaignGroup = new SearchCriteriaList();
        campaignGroup.setGroupName("\"Executives\" in Accounts in Zipcode 23510 and 06006");
        campaignGroup.setContactSource(2);
        campaignGroup.setEnteredBy(user1Id);
        campaignGroup.setModifiedBy(user1Id);
        campaignGroup.setOwner(user1Id);
        DemoData.checkIfInserted(campaignGroup.insert(db), campaignGroup);
        group1Id = campaignGroup.getId();
        SearchCriteriaElement element = new SearchCriteriaElement();
        element.setFieldId(8);
        element.setOperator("=");
        element.setOperatorId(1);
        element.setText(contactTypeList.getValueFromId(contactTypeList_EXECUTIVE));
        element.setSourceId(3);
        DemoData.checkIfInserted(element.insert(campaignGroup.getId(), db), element);
        element = new SearchCriteriaElement();
        element.setFieldId(5);
        element.setOperator("=");
        element.setOperatorId(1);
        element.setText("23510");
        element.setSourceId(3);
        DemoData.checkIfInserted(element.insert(campaignGroup.getId(), db), element);
        element = new SearchCriteriaElement();
        element.setFieldId(5);
        element.setOperator("=");
        element.setOperatorId(1);
        element.setText("06006");
        element.setSourceId(3);
        DemoData.checkIfInserted(element.insert(campaignGroup.getId(), db), element);
        Survey survey = new Survey();
        survey.setEnteredBy(user1Id);
        survey.setModifiedBy(user1Id);
        survey.setStatus(2);
        survey.setName("Gold Shoe Club - Pre-Season Survey");
        survey.setDescription("Sent to large accounts for them to do a pre-season order");
        survey.setIntro("Thank you for giving us your \"Pre-Season\" order.  As you know, this order entitles you to a 10% discount because it allows us to better manage our production output over the coming year.<br><br>Just click next to any of the packages your interested in and a key account rep will call you back in the next few days and additional marketing information will be automatically e-mailed to you.");
        survey.setOutro("Thanks for giving us your \"Pre-Season\" order and your key account rep will be back to your shortly");
        survey.setType(1);
        DemoData.checkIfInserted(survey.insert(db), (Object)survey);
        SurveyQuestion question = new SurveyQuestion();
        question.setSurveyId(survey.getId());
        question.setType(4);
        question.setDescription("Put a check box next to any of the packages you're interested in");
        question.setPosition(1);
        survey.getQuestions().add(question);
        ItemList itemList = new ItemList();
        question.setItemList(itemList);
        Item item = new Item();
        item.setDescription("Package 1:  10,000 Units - Mixed Allotment");
        itemList.add(item);
        item = new Item();
        item.setDescription("Package 2: 50,000 Units - Mixed Allotment");
        itemList.add(item);
        item = new Item();
        item.setDescription("Package 3: 100,000 Units - Mixed Allotment");
        itemList.add(item);
        item = new Item();
        item.setDescription("Package 4: Bergdorf Line - Mixed");
        itemList.add(item);
        item = new Item();
        item.setDescription("Package 5:  Bergdorf Line - Premium");
        itemList.add(item);
        item = new Item();
        item.setDescription("Package 6: Charlie Brown Line - Mixed");
        itemList.add(item);
        item = new Item();
        item.setDescription("Package 7: Charlie Brown Line - Premium");
        itemList.add(item);
        item = new Item();
        item.setDescription("Package 8: Nike Line - Mixed");
        itemList.add(item);
        item = new Item();
        item.setDescription("Package 9: Nike Line - Sports");
        itemList.add(item);
        DemoData.checkIfInserted(question.insert(db, survey.getId()), question);
        Campaign campaign = new Campaign();
        campaign.setName("Gold Shoe Club Pre-Order Survey to Executives in Zips-23510/06006");
        campaign.setDescription("Sent to all executives in target zipcodes 23510 and 06006 who are in the gold club to get a feel for this year's \"pre-order\"");
        campaign.setMessageId(message1Id);
        campaign.setReplyTo("boballen@fictitiousco.com");
        campaign.setSubject("This month's happenings at Shoe World");
        campaign.setMessage("<img src=\"images/demo/master_logo_sdcwinter.gif\" width=\"300\" height=\"65\" alt=\"Shoes.com\" border=\"0\" /><br /><br />Dear ${firstname},<br /><br />    Below are a few of the new things we thought you might want to know about as a member of our Gold Shoe Club.<br /><br /><ul><li>New store ours on Friday:  Now from 8:00 AM to 7 PM</li><li>The cocktail bar will even be open on Sundays</li><li>Our new price list will be out on the 12'th</li><li>Sign-up for pre-ordering can be done by clicking on the survey link below</li></ul>Sincerely,<br /><br />Frank Jones<br />VP/Key Accounts<br /><br><br>You can take the survey at the following web-site: <a href=\"ProcessSurvey.do?id=${surveyId=1}\">http://demo.centriccrm.com/ProcessSurvey.do?id=${surveyId=1}</a>");
        campaign.setStatusId(4);
        campaign.setStatus("Messages Sent");
        campaign.setActive(true);
        campaign.setActiveDate(DemoData.addCurrentTimestamp(-2));
        campaign.setActiveDateTimeZone(timeZone);
        campaign.setSendMethodId(1);
        campaign.setEnteredBy(user1Id);
        campaign.setModifiedBy(user1Id);
        campaign.setType(1);
        DemoData.checkIfInserted(campaign.insert(db), (Object)campaign);
        CampaignRun campaignRun = new CampaignRun();
        campaignRun.setCampaignId(campaign.getId());
        campaignRun.setStatus(0);
        campaignRun.setTotalContacts(2);
        campaignRun.setTotalSent(2);
        campaignRun.setTotalReplied(2);
        campaignRun.setRunDate(DemoData.addCurrentTimestamp(-3));
        DemoData.checkIfInserted(campaignRun.insert(db), campaignRun);
        ActiveSurvey activeSurvey = new ActiveSurvey(survey);
        activeSurvey.setCampaignId(campaign.getId());
        activeSurvey.setEnteredBy(user1Id);
        activeSurvey.setModifiedBy(user1Id);
        DemoData.checkIfInserted(activeSurvey.insert(db), (Object)activeSurvey);
        ActiveSurveyQuestion activeQuestion = (ActiveSurveyQuestion)activeSurvey.getQuestions().get(0);
        SearchCriteriaListList thisList = new SearchCriteriaListList();
        thisList.setBuildCriteria(true);
        thisList.buildList(db);
        campaign.lockGroupCriteria(thisList, db);
        Organization organization = new Organization();
        organization.setName("Southside Realty");
        organization.setOwner(user2Id);
        organization.setIndustry(industryList_REAL_ESTATE);
        organization.setEnteredBy(user2Id);
        organization.setModifiedBy(user2Id);
        OrganizationPhoneNumber mainPhone = new OrganizationPhoneNumber();
        mainPhone.setOrgId(organization.getOrgId());
        mainPhone.setType(1);
        mainPhone.setEnteredBy(user1Id);
        mainPhone.setModifiedBy(user1Id);
        mainPhone.setNumber("(777) 888-9898");
        if (mainPhone.isValid()) {
            PhoneNumberFormatter.format(mainPhone, thisLocale);
            organization.getPhoneNumberList().add(mainPhone);
        }
        DemoData.checkIfInserted(organization.insert(db), (Object)organization);
        organization.insertType(db, accountTypeList_NON_CONTRACT, 1);
        organization.insertType(db, accountTypeList_TERRITORY3, 2);
        organization = new Organization();
        organization.setName("AAA Automotive Repair");
        organization.setOwner(user4Id);
        organization.setIndustry(industryList_AUTOMOTIVE);
        organization.setAccountNumber("10001");
        organization.setAlertText("Contract renewal alert");
        organization.setAlertDate(DemoData.addCurrentTimestamp(7));
        organization.setAlertDateTimeZone(timeZone);
        organization.setContractEndDate(DemoData.addCurrentTimestamp(14));
        organization.setContractEndDateTimeZone(timeZone);
        organization.setEnteredBy(user4Id);
        organization.setModifiedBy(user4Id);
        mainPhone = new OrganizationPhoneNumber();
        mainPhone.setType(1);
        mainPhone.setEnteredBy(user4Id);
        mainPhone.setModifiedBy(user4Id);
        mainPhone.setNumber("(555) 555-1212");
        if (mainPhone.isValid()) {
            PhoneNumberFormatter.format(mainPhone, thisLocale);
            organization.getPhoneNumberList().add(mainPhone);
        }
        mainPhone = new OrganizationPhoneNumber();
        mainPhone.setType(2);
        mainPhone.setEnteredBy(user4Id);
        mainPhone.setModifiedBy(user4Id);
        mainPhone.setNumber("(555) 555-1213");
        if (mainPhone.isValid()) {
            PhoneNumberFormatter.format(mainPhone, thisLocale);
            organization.getPhoneNumberList().add(mainPhone);
        }
        OrganizationAddress organizationAddress = new OrganizationAddress();
        organizationAddress.setType(1);
        organizationAddress.setEnteredBy(user4Id);
        organizationAddress.setModifiedBy(user4Id);
        organizationAddress.setStreetAddressLine1("100 Main Street");
        organizationAddress.setStreetAddressLine2("");
        organizationAddress.setStreetAddressLine3("");
        organizationAddress.setCity("Ocean City");
        organizationAddress.setState("FL");
        organizationAddress.setZip("");
        organizationAddress.setCountry("UNITED STATES");
        if (organizationAddress.isValid()) {
            addressFormatter.format(organizationAddress);
            organization.getAddressList().add(organizationAddress);
        }
        OrganizationEmailAddress primaryEmail = new OrganizationEmailAddress();
        primaryEmail.setType(1);
        primaryEmail.setEnteredBy(user4Id);
        primaryEmail.setModifiedBy(user4Id);
        primaryEmail.setEmail("support@automotiveA1.com");
        if (primaryEmail.isValid()) {
            emailFormatter.format(primaryEmail);
            organization.getEmailAddressList().add(primaryEmail);
        }
        DemoData.checkIfInserted(organization.insert(db), (Object)organization);
        organization.insertType(db, accountTypeList_LARGE, 1);
        organization.insertType(db, accountTypeList_NON_CONTRACT, 2);
        Contact contact5 = new Contact();
        contact5.setAccessType(accountContactAccessTypes.getDefaultItem());
        contact5.setEnteredBy(user4Id);
        contact5.setModifiedBy(user4Id);
        contact5.setOwner(user1Id);
        contact5.setNameFirst("Bobby");
        contact5.setNameLast("Allison");
        contact5.setTitle("President");
        contact5.setOrgId(organization.getId());
        ContactPhoneNumber businessPhone5 = new ContactPhoneNumber();
        businessPhone5.setType(1);
        businessPhone5.setEnteredBy(user4Id);
        businessPhone5.setModifiedBy(user4Id);
        businessPhone5.setNumber("(414) 667-0906");
        businessPhone5.setExtension("");
        if (businessPhone5.isValid()) {
            PhoneNumberFormatter.format(businessPhone5, thisLocale);
            contact5.getPhoneNumberList().add(businessPhone5);
        } else {
            System.err.println("Business4 phone is invalid: " + businessPhone5.toString());
        }
        businessPhone5 = new ContactPhoneNumber();
        businessPhone5.setType(7);
        businessPhone5.setEnteredBy(user4Id);
        businessPhone5.setModifiedBy(user4Id);
        businessPhone5.setNumber("(414) 556-2312");
        businessPhone5.setExtension("");
        if (businessPhone5.isValid()) {
            PhoneNumberFormatter.format(businessPhone5, thisLocale);
            contact5.getPhoneNumberList().add(businessPhone5);
        } else {
            System.err.println("Business4 phone is invalid: " + businessPhone5.toString());
        }
        ContactEmailAddress businessEmail5 = new ContactEmailAddress();
        businessEmail5.setType(1);
        businessEmail5.setEnteredBy(user4Id);
        businessEmail5.setModifiedBy(user4Id);
        businessEmail5.setEmail("test3@anothercompany.com");
        if (businessEmail5.isValid()) {
            emailFormatter.format(businessEmail5);
            contact5.getEmailAddressList().add(businessEmail5);
        } else {
            System.err.println("Business4 email is invalid: " + businessEmail5.toString());
        }
        DemoData.checkIfInserted(contact5.insert(db), (Object)contact5);
        contact5.insertType(db, contactTypeList_EXECUTIVE, 1);
        OpportunityHeader opportunity = new OpportunityHeader();
        opportunity.setDescription("2006 Contract for Services");
        opportunity.setContactLink(contact5.getId());
        opportunity.setEnteredBy(user3Id);
        opportunity.setModifiedBy(user3Id);
        opportunity.setManager(user3Id);
        opportunity.setAccessType(oppAccessTypes.getDefaultItem());
        DemoData.checkIfInserted(opportunity.insert(db), (Object)opportunity);
        OpportunityComponent component = new OpportunityComponent();
        component.setHeaderId(opportunity.getId());
        component.setOwner(user3Id);
        component.setDescription("Annual Maintenance");
        component.setCloseProb("33");
        component.setCloseDate(DemoData.addCurrentTimestamp(13));
        component.setCloseDateTimeZone(timeZone);
        component.setGuess("240000");
        component.setTerms(12.0);
        component.setUnits("M");
        component.setType("N");
        component.setStage(stageList_PROPOSAL);
        component.setStageDate(DemoData.addCurrentTimestamp(-1));
        component.setAlertText("Check to see if service commenced");
        component.setAlertDate(DemoData.addCurrentTimestamp(10));
        component.setAlertDateTimeZone(timeZone);
        component.setEnteredBy(user4Id);
        component.setModifiedBy(user4Id);
        DemoData.checkIfInserted(component.insert(db), (Object)component);
        component.insertType(db, opportunityTypeList_MAINTENANCE, 1);
        component = new OpportunityComponent();
        component.setHeaderId(opportunity.getId());
        component.setOwner(user1Id);
        component.setDescription("One-time setup");
        component.setCloseProb("50");
        component.setCloseDate(DemoData.addCurrentTimestamp(9));
        component.setCloseDateTimeZone(timeZone);
        component.setGuess("50000");
        component.setTerms(2.0);
        component.setUnits("M");
        component.setType("N");
        component.setStage(stageList_NEGOTIATION);
        component.setStageDate(DemoData.addCurrentTimestamp(0));
        component.setAlertText("Send final contract revision");
        component.setAlertDate(DemoData.addCurrentTimestamp(0));
        component.setAlertDateTimeZone(timeZone);
        component.setOnlyWarnings(true);
        component.setEnteredBy(user4Id);
        component.setModifiedBy(user4Id);
        DemoData.checkIfInserted(component.insert(db), (Object)component);
        component.insertType(db, opportunityTypeList_SERVICES, 1);
        int parentCallId = -1;
        Call call = new Call();
        call.setContactId(contact5.getId());
        call.setOrgId(organization.getId());
        call.setCallTypeId(callTypeList_OUTGOING_CALL);
        call.setLength(0);
        call.setSubject("Left message w/Secretary to set up Lunch");
        call.setNotes("Want to talk about next years products and services early");
        call.setAlertDate(DemoData.addCurrentTimestamp(8));
        call.setAlertDateTimeZone(timeZone);
        call.setFollowupNotes("Sandy is her name.  If she doens't get back to me I'll call");
        call.setEntered(DemoData.addCurrentTimestamp(0));
        call.setEnteredBy(user1Id);
        call.setModified(DemoData.addCurrentTimestamp(0));
        call.setModifiedBy(user1Id);
        call.setAlertText("Follow up w/Secretary to set up Lunch");
        call.setAlertCallTypeId(callTypeList_OUTSIDE_APPT);
        call.setOwner(user1Id);
        call.setAssignDate(DemoData.addCurrentTimestamp(0));
        call.setCompletedBy(user1Id);
        call.setCompleteDate(DemoData.addCurrentTimestamp(0));
        call.setResultId(callResultList_YES_BUS_PROGRESSING);
        call.setPriorityId(callPriorityList_HIGH);
        call.setStatusId(3);
        call.setReminderId(1);
        call.setReminderTypeId(callReminderList_HOURS);
        call.setAlertDateTimeZone(timeZone);
        DemoData.checkIfInserted(call.insert(db), (Object)call);
        parentCallId = call.getId();
        call = new Call();
        call.setContactId(contact5.getId());
        call.setOrgId(organization.getId());
        call.setCallTypeId(callTypeList_OUTGOING_CALL);
        call.setLength(0);
        call.setSubject("Spoke w/Secretary");
        call.setNotes("Lunch is on for the 12'th at Harry's Bar & Grill");
        call.setAlertDate(DemoData.addCurrentTimestamp(8));
        call.setAlertDateTimeZone(timeZone);
        call.setFollowupNotes("- To meet just before noon");
        call.setEntered(DemoData.addCurrentTimestamp(0));
        call.setEnteredBy(user1Id);
        call.setModified(DemoData.addCurrentTimestamp(0));
        call.setModifiedBy(user1Id);
        call.setAlertText("Lunch w/the President");
        call.setAlertCallTypeId(callTypeList_OUTSIDE_APPT);
        call.setParentId(parentCallId);
        call.setOwner(user1Id);
        call.setAssignDate(DemoData.addCurrentTimestamp(0));
        call.setCompletedBy(user1Id);
        call.setCompleteDate(DemoData.addCurrentTimestamp(0));
        call.setResultId(callResultList_YES_BUS_PROGRESSING);
        call.setPriorityId(callPriorityList_HIGH);
        call.setStatusId(3);
        call.setReminderId(3);
        call.setReminderTypeId(callReminderList_HOURS);
        DemoData.checkIfInserted(call.insert(db), (Object)call);
        contact5 = new Contact();
        contact5.setAccessType(accountContactAccessTypes.getDefaultItem());
        contact5.setEnteredBy(user4Id);
        contact5.setModifiedBy(user4Id);
        contact5.setOwner(user1Id);
        contact5.setNameFirst("Colin");
        contact5.setNameLast("Morgan");
        contact5.setTitle("Operations Manager");
        contact5.setOrgId(organization.getId());
        businessPhone5 = new ContactPhoneNumber();
        businessPhone5.setType(1);
        businessPhone5.setEnteredBy(user1Id);
        businessPhone5.setModifiedBy(user1Id);
        businessPhone5.setNumber("(414) 331-9898");
        businessPhone5.setExtension("");
        if (businessPhone5.isValid()) {
            PhoneNumberFormatter.format(businessPhone5, thisLocale);
            contact5.getPhoneNumberList().add(businessPhone5);
        } else {
            System.err.println("Business4 phone is invalid: " + businessPhone5.toString());
        }
        businessPhone5 = new ContactPhoneNumber();
        businessPhone5.setType(7);
        businessPhone5.setEnteredBy(user1Id);
        businessPhone5.setModifiedBy(user1Id);
        businessPhone5.setNumber("(414) 908-8909");
        businessPhone5.setExtension("");
        if (businessPhone5.isValid()) {
            PhoneNumberFormatter.format(businessPhone5, thisLocale);
            contact5.getPhoneNumberList().add(businessPhone5);
        } else {
            System.err.println("Business4 phone is invalid: " + businessPhone5.toString());
        }
        businessEmail5 = new ContactEmailAddress();
        businessEmail5.setType(1);
        businessEmail5.setEnteredBy(user4Id);
        businessEmail5.setModifiedBy(user4Id);
        businessEmail5.setEmail("test7@anothercompany.com");
        if (businessEmail5.isValid()) {
            emailFormatter.format(businessEmail5);
            contact5.getEmailAddressList().add(businessEmail5);
        } else {
            System.err.println("Business4 email is invalid: " + businessEmail5.toString());
        }
        DemoData.checkIfInserted(contact5.insert(db), (Object)contact5);
        contact5.insertType(db, contactTypeList_ACCOUNTING, 1);
        contact5 = new Contact();
        contact5.setAccessType(accountContactAccessTypes.getDefaultItem());
        contact5.setEnteredBy(user4Id);
        contact5.setModifiedBy(user4Id);
        contact5.setOwner(user1Id);
        contact5.setNameFirst("Mary");
        contact5.setNameLast("Smith");
        contact5.setTitle("Administrative Assistant");
        contact5.setOrgId(organization.getId());
        businessPhone5 = new ContactPhoneNumber();
        businessPhone5.setType(1);
        businessPhone5.setEnteredBy(user1Id);
        businessPhone5.setModifiedBy(user1Id);
        businessPhone5.setNumber("(414) 998-9999");
        businessPhone5.setExtension("");
        if (businessPhone5.isValid()) {
            PhoneNumberFormatter.format(businessPhone5, thisLocale);
            contact5.getPhoneNumberList().add(businessPhone5);
        } else {
            System.err.println("Business4 phone is invalid: " + businessPhone5.toString());
        }
        businessPhone5 = new ContactPhoneNumber();
        businessPhone5.setType(7);
        businessPhone5.setEnteredBy(user4Id);
        businessPhone5.setModifiedBy(user4Id);
        businessPhone5.setNumber("(414) 888-8888");
        businessPhone5.setExtension("");
        if (businessPhone5.isValid()) {
            PhoneNumberFormatter.format(businessPhone5, thisLocale);
            contact5.getPhoneNumberList().add(businessPhone5);
        } else {
            System.err.println("Business4 phone is invalid: " + businessPhone5.toString());
        }
        businessPhone5 = new ContactPhoneNumber();
        businessPhone5.setType(4);
        businessPhone5.setEnteredBy(user1Id);
        businessPhone5.setModifiedBy(user1Id);
        businessPhone5.setNumber("(414) 555-9999");
        businessPhone5.setExtension("");
        if (businessPhone5.isValid()) {
            PhoneNumberFormatter.format(businessPhone5, thisLocale);
            contact5.getPhoneNumberList().add(businessPhone5);
        } else {
            System.err.println("Business4 phone is invalid: " + businessPhone5.toString());
        }
        businessEmail5 = new ContactEmailAddress();
        businessEmail5.setType(1);
        businessEmail5.setEnteredBy(user4Id);
        businessEmail5.setModifiedBy(user4Id);
        businessEmail5.setEmail("test2@anothercompany.com");
        if (businessEmail5.isValid()) {
            emailFormatter.format(businessEmail5);
            contact5.getEmailAddressList().add(businessEmail5);
        } else {
            System.err.println("Business4 email is invalid: " + businessEmail5.toString());
        }
        DemoData.checkIfInserted(contact5.insert(db), (Object)contact5);
        contact5 = new Contact();
        contact5.setAccessType(accountContactAccessTypes.getDefaultItem());
        contact5.setEnteredBy(user4Id);
        contact5.setModifiedBy(user4Id);
        contact5.setOwner(user1Id);
        contact5.setNameFirst("Willie");
        contact5.setNameLast("Wilborn");
        contact5.setTitle("SVP / Sales");
        contact5.setOrgId(organization.getId());
        contact5.setNotes("Decision maker");
        businessPhone5 = new ContactPhoneNumber();
        businessPhone5.setType(1);
        businessPhone5.setEnteredBy(user1Id);
        businessPhone5.setModifiedBy(user1Id);
        businessPhone5.setNumber("(414) 777-8765");
        businessPhone5.setExtension("");
        if (businessPhone5.isValid()) {
            PhoneNumberFormatter.format(businessPhone5, thisLocale);
            contact5.getPhoneNumberList().add(businessPhone5);
        } else {
            System.err.println("Business4 phone is invalid: " + businessPhone5.toString());
        }
        ContactEmailAddress businessEmail6 = new ContactEmailAddress();
        businessEmail6.setType(1);
        businessEmail6.setEnteredBy(user4Id);
        businessEmail6.setModifiedBy(user4Id);
        businessEmail6.setEmail("test5@anothercompany.com");
        if (businessEmail6.isValid()) {
            emailFormatter.format(businessEmail6);
            contact5.getEmailAddressList().add(businessEmail6);
        } else {
            System.err.println("Business4 email is invalid: " + businessEmail6.toString());
        }
        ContactAddress businessAddress3 = new ContactAddress();
        businessAddress3.setType(1);
        businessAddress3.setEnteredBy(user1Id);
        businessAddress3.setModifiedBy(user1Id);
        businessAddress3.setStreetAddressLine1("220 W. Main Street");
        businessAddress3.setStreetAddressLine2("");
        businessAddress3.setStreetAddressLine3("");
        businessAddress3.setCity("Hampton");
        businessAddress3.setState("VA");
        businessAddress3.setZip("23510");
        businessAddress3.setCountry("UNITED STATES");
        if (businessAddress3.isValid()) {
            addressFormatter.format(businessAddress3);
            contact5.getAddressList().add(businessAddress3);
        } else {
            System.err.println("Business2 address is invalid: " + businessAddress3.toString());
        }
        DemoData.checkIfInserted(contact5.insert(db), (Object)contact5);
        contact5.insertType(db, contactTypeList_EXECUTIVE, 1);
        Ticket ticket = new Ticket();
        ticket.setSourceCode(ticketSourceList_PHONE);
        ticket.setProblem("Please take care of his laptop. It doesn't seem to work as well when there is full moon. He thinks it may have to do with the power in his office...or a prank");
        ticket.setComment("Can you give him a call back ASAP. He wasn't happy and he's going out of town tomorrow");
        ticket.setSeverityCode(ticketSeverityList_IMPORTANT);
        ticket.setOrgId(organization.getId());
        ticket.setContactId(contact5.getId());
        ticket.setPriorityCode(ticketPriorityList_URGENT);
        ticket.setDepartmentCode(departmentList_ENGINEERING);
        ticket.setAssignedTo(user2Id);
        ticket.setAssignedDate(DemoData.addCurrentTimestamp(-3));
        ticket.setEntered(DemoData.addCurrentTimestamp(-3));
        ticket.setEnteredBy(user1Id);
        ticket.setModified(DemoData.addCurrentTimestamp(-3));
        ticket.setModifiedBy(user1Id);
        DemoData.checkIfInserted(ticket.insert(db), (Object)ticket);
        ticket = new Ticket();
        ticket.setSourceCode(ticketSourceList_PHONE);
        ticket.setProblem("Need to coordinate with engineering the project to get started");
        ticket.setSeverityCode(ticketSeverityList_NORMAL);
        ticket.setOrgId(organization.getId());
        ticket.setContactId(contact5.getId());
        ticket.setPriorityCode(ticketPriorityList_AS_SCHEDULED);
        ticket.setDepartmentCode(departmentList_ENGINEERING);
        ticket.setAssignedTo(user3Id);
        ticket.setAssignedDate(DemoData.addCurrentTimestamp(0));
        ticket.setEntered(DemoData.addCurrentTimestamp(0));
        ticket.setEnteredBy(user1Id);
        ticket.setModified(DemoData.addCurrentTimestamp(0));
        ticket.setModifiedBy(user1Id);
        DemoData.checkIfInserted(ticket.insert(db), (Object)ticket);
        ScheduledRecipient recipient = new ScheduledRecipient();
        recipient.setCampaignId(campaign.getId());
        recipient.setContactId(contact5.getId());
        recipient.setRunId(campaignRun.getId());
        recipient.setStatusId(1);
        recipient.setStatus("Email Sent");
        recipient.setStatusDate(DemoData.addCurrentTimestamp(-1));
        recipient.setScheduledDate(DemoData.addCurrentTimestamp(-1));
        recipient.setSentDate(DemoData.addCurrentTimestamp(-1));
        DemoData.checkIfInserted(recipient.insert(db), recipient);
        SurveyResponse response = new SurveyResponse();
        response.setActiveSurveyId(activeSurvey.getId());
        response.setContactId(contact5.getId());
        response.setUniqueCode("-- not needed --");
        response.setIpAddress("127.0.0.1");
        DemoData.checkIfInserted(response.insert(db), response);
        SurveyAnswer surveyAnswer = new SurveyAnswer();
        surveyAnswer.setResponseId(response.getId());
        surveyAnswer.setQuestionId(activeQuestion.getId());
        surveyAnswer.setComments("");
        DemoData.checkIfInserted(surveyAnswer.insert(db, response.getId()), surveyAnswer);
        organization = new Organization();
        organization.setName("Ad Department");
        organization.setOwner(user3Id);
        organization.setIndustry(industryList_CONSULTING);
        organization.setAlertText("New contact signing");
        organization.setAlertDate(DemoData.addCurrentTimestamp(50));
        organization.setAlertDateTimeZone(timeZone);
        organization.setContractEndDate(DemoData.addCurrentTimestamp(55));
        organization.setContractEndDateTimeZone(timeZone);
        organization.setEnteredBy(user3Id);
        organization.setModifiedBy(user3Id);
        mainPhone = new OrganizationPhoneNumber();
        mainPhone.setType(1);
        mainPhone.setEnteredBy(user4Id);
        mainPhone.setModifiedBy(user4Id);
        mainPhone.setNumber("(757) 555-1812");
        if (mainPhone.isValid()) {
            PhoneNumberFormatter.format(mainPhone, thisLocale);
            organization.getPhoneNumberList().add(mainPhone);
        }
        organizationAddress = new OrganizationAddress();
        organizationAddress.setType(1);
        organizationAddress.setEnteredBy(user3Id);
        organizationAddress.setModifiedBy(user3Id);
        organizationAddress.setStreetAddressLine1("150 W. Rambleton Street");
        organizationAddress.setStreetAddressLine2("");
        organizationAddress.setStreetAddressLine3("");
        organizationAddress.setCity("Norwalk");
        organizationAddress.setState("CT");
        organizationAddress.setZip("06006");
        organizationAddress.setCountry("UNITED STATES");
        if (organizationAddress.isValid()) {
            addressFormatter.format(organizationAddress);
            organization.getAddressList().add(organizationAddress);
        }
        DemoData.checkIfInserted(organization.insert(db), (Object)organization);
        contact5 = new Contact();
        contact5.setAccessType(accountContactAccessTypes.getDefaultItem());
        contact5.setEnteredBy(user1Id);
        contact5.setModifiedBy(user1Id);
        contact5.setOwner(user1Id);
        contact5.setNameFirst("Ken");
        contact5.setNameLast("Bees");
        contact5.setTitle("Sales Rep");
        contact5.setOrgId(organization.getId());
        businessPhone5 = new ContactPhoneNumber();
        businessPhone5.setType(1);
        businessPhone5.setEnteredBy(user1Id);
        businessPhone5.setModifiedBy(user1Id);
        businessPhone5.setNumber("(767) 889-4521");
        businessPhone5.setExtension("");
        if (businessPhone5.isValid()) {
            PhoneNumberFormatter.format(businessPhone5, thisLocale);
            contact5.getPhoneNumberList().add(businessPhone5);
        } else {
            System.err.println("Business4 phone is invalid: " + businessPhone5.toString());
        }
        businessPhone5 = new ContactPhoneNumber();
        businessPhone5.setType(7);
        businessPhone5.setEnteredBy(user4Id);
        businessPhone5.setModifiedBy(user4Id);
        businessPhone5.setNumber("(767) 990-9765");
        businessPhone5.setExtension("");
        if (businessPhone5.isValid()) {
            PhoneNumberFormatter.format(businessPhone5, thisLocale);
            contact5.getPhoneNumberList().add(businessPhone5);
        } else {
            System.err.println("Business4 phone is invalid: " + businessPhone5.toString());
        }
        businessEmail5 = new ContactEmailAddress();
        businessEmail5.setType(1);
        businessEmail5.setEnteredBy(user4Id);
        businessEmail5.setModifiedBy(user4Id);
        businessEmail5.setEmail("test8@andanothercompany.com");
        if (businessEmail5.isValid()) {
            emailFormatter.format(businessEmail5);
            contact5.getEmailAddressList().add(businessEmail5);
        } else {
            System.err.println("Business4 email is invalid: " + businessEmail5.toString());
        }
        DemoData.checkIfInserted(contact5.insert(db), (Object)contact5);
        contact5.insertType(db, contactTypeList_SALES, 1);
        Ticket ticket2 = new Ticket();
        ticket2.setSourceCode(ticketSourceList_PHONE);
        ticket2.setProblem("Would like some training on how to use the new Tork converter reciprocator");
        ticket2.setComment("He needs help quickly or else his trip to a key account is worthless");
        ticket2.setSeverityCode(ticketSeverityList_NORMAL);
        ticket2.setOrgId(organization.getId());
        ticket2.setContactId(contact5.getId());
        ticket2.setPriorityCode(ticketPriorityList_CRITICAL);
        ticket2.setDepartmentCode(departmentList_ENGINEERING);
        ticket2.setAssignedTo(user2Id);
        ticket2.setAssignedDate(DemoData.addCurrentTimestamp(-1));
        ticket2.setEntered(DemoData.addCurrentTimestamp(-1));
        ticket2.setEnteredBy(user1Id);
        ticket2.setModified(DemoData.addCurrentTimestamp(-1));
        ticket2.setModifiedBy(user1Id);
        DemoData.checkIfInserted(ticket2.insert(db), (Object)ticket2);
        TicketLog log = new TicketLog();
        log.setTicketId(ticket2.getId());
        log.setEntryText("His questions were too much for me, Tom, can you handle");
        log.setAssignedTo(user3Id);
        log.setEnteredBy(user2Id);
        log.setModifiedBy(user2Id);
        log.setPriorityCode(ticketPriorityList_CRITICAL);
        log.setDepartmentCode(departmentList_ENGINEERING);
        log.setSeverityCode(ticketSeverityList_IMPORTANT);
        DemoData.checkIfInserted(log.insert(db), (Object)log);
        log = new TicketLog();
        log.setTicketId(ticket2.getId());
        log.setEntryText("This contract needs to be resolved");
        log.setAssignedTo(user4Id);
        log.setEnteredBy(user3Id);
        log.setModifiedBy(user3Id);
        log.setPriorityCode(ticketPriorityList_CRITICAL);
        log.setDepartmentCode(departmentList_LEGAL);
        log.setSeverityCode(ticketSeverityList_IMPORTANT);
        DemoData.checkIfInserted(log.insert(db), (Object)log);
        contact5 = new Contact();
        contact5.setAccessType(accountContactAccessTypes.getDefaultItem());
        contact5.setEnteredBy(user1Id);
        contact5.setModifiedBy(user1Id);
        contact5.setOwner(user1Id);
        contact5.setNameFirst("Kimberly");
        contact5.setNameLast("Clarkson");
        contact5.setTitle("Account Manager");
        contact5.setOrgId(organization.getId());
        businessPhone5 = new ContactPhoneNumber();
        businessPhone5.setType(1);
        businessPhone5.setEnteredBy(user1Id);
        businessPhone5.setModifiedBy(user1Id);
        businessPhone5.setNumber("(767) 888-9999");
        businessPhone5.setExtension("");
        if (businessPhone5.isValid()) {
            PhoneNumberFormatter.format(businessPhone5, thisLocale);
            contact5.getPhoneNumberList().add(businessPhone5);
        } else {
            System.err.println("Business4 phone is invalid: " + businessPhone5.toString());
        }
        businessEmail5 = new ContactEmailAddress();
        businessEmail5.setType(1);
        businessEmail5.setEnteredBy(user4Id);
        businessEmail5.setModifiedBy(user4Id);
        businessEmail5.setEmail("test4@andanothercompany.com");
        if (businessEmail5.isValid()) {
            emailFormatter.format(businessEmail5);
            contact5.getEmailAddressList().add(businessEmail5);
        } else {
            System.err.println("Business4 email is invalid: " + businessEmail5.toString());
        }
        ContactAddress businessAddress4 = new ContactAddress();
        businessAddress4.setType(1);
        businessAddress4.setEnteredBy(user1Id);
        businessAddress4.setModifiedBy(user1Id);
        businessAddress4.setStreetAddressLine1("180 Richmond Street");
        businessAddress4.setStreetAddressLine2("");
        businessAddress4.setStreetAddressLine3("");
        businessAddress4.setCity("Hampton");
        businessAddress4.setState("VA");
        businessAddress4.setZip("23510");
        businessAddress4.setCountry("UNITED STATES");
        if (businessAddress4.isValid()) {
            addressFormatter.format(businessAddress4);
            contact5.getAddressList().add(businessAddress4);
        } else {
            System.err.println("Business2 address is invalid: " + businessAddress4.toString());
        }
        DemoData.checkIfInserted(contact5.insert(db), (Object)contact5);
        contact5.insertType(db, contactTypeList_EXECUTIVE, 1);
        opportunity = new OpportunityHeader();
        opportunity.setDescription("Software training for Kim and her team");
        opportunity.setContactLink(contact5.getId());
        opportunity.setEnteredBy(user1Id);
        opportunity.setModifiedBy(user1Id);
        opportunity.setManager(user1Id);
        opportunity.setAccessType(oppAccessTypes.getDefaultItem());
        DemoData.checkIfInserted(opportunity.insert(db), (Object)opportunity);
        component = new OpportunityComponent();
        component.setHeaderId(opportunity.getId());
        component.setOwner(user1Id);
        component.setDescription("One-time training on CRM for Ad team");
        component.setCloseProb("80");
        component.setCloseDate(DemoData.addCurrentTimestamp(39));
        component.setCloseDateTimeZone(timeZone);
        component.setGuess("25000");
        component.setTerms(2.0);
        component.setUnits("M");
        component.setType("N");
        component.setStage(stageList_NEGOTIATION);
        component.setStageDate(DemoData.addCurrentTimestamp(0));
        component.setAlertText("Send Kim flowers for her Birthday");
        component.setAlertDate(DemoData.addCurrentTimestamp(0));
        component.setAlertDateTimeZone(timeZone);
        component.setOnlyWarnings(true);
        component.setEnteredBy(user1Id);
        component.setModifiedBy(user1Id);
        DemoData.checkIfInserted(component.insert(db), (Object)component);
        component.insertType(db, opportunityTypeList_SERVICES, 1);
        recipient = new ScheduledRecipient();
        recipient.setCampaignId(campaign.getId());
        recipient.setContactId(contact5.getId());
        recipient.setRunId(campaignRun.getId());
        recipient.setStatusId(1);
        recipient.setStatus("Email Sent");
        recipient.setStatusDate(DemoData.addCurrentTimestamp(-1));
        recipient.setScheduledDate(DemoData.addCurrentTimestamp(-1));
        recipient.setSentDate(DemoData.addCurrentTimestamp(-1));
        DemoData.checkIfInserted(recipient.insert(db), recipient);
        response = new SurveyResponse();
        response.setActiveSurveyId(activeSurvey.getId());
        response.setContactId(contact5.getId());
        response.setUniqueCode("-- not needed --");
        response.setIpAddress("127.0.0.1");
        DemoData.checkIfInserted(response.insert(db), response);
        surveyAnswer = new SurveyAnswer();
        surveyAnswer.setResponseId(response.getId());
        surveyAnswer.setQuestionId(activeQuestion.getId());
        surveyAnswer.setComments("");
        DemoData.checkIfInserted(surveyAnswer.insert(db, response.getId()), surveyAnswer);
        Task task2 = new Task();
        task2.setEnteredBy(user1Id);
        task2.setModifiedBy(user1Id);
        task2.setPriority(1);
        task2.setDescription("Call Carter to set up meeting");
        task2.setNotes("");
        task2.setSharing(-1);
        task2.setOwner(user1Id);
        task2.setDueDate(DemoData.addCurrentTimestamp(-10));
        task2.setDueDateTimeZone(timeZone);
        task2.setEstimatedLOE(-1.0);
        task2.setEstimatedLOEType(2);
        task2.setType(1);
        task2.setContactId(contact5.getId());
        DemoData.checkIfInserted(task2.insert(db), (Object)task2);
        contact5 = new Contact();
        contact5.setAccessType(accountContactAccessTypes.getDefaultItem());
        contact5.setEnteredBy(user1Id);
        contact5.setModifiedBy(user1Id);
        contact5.setOwner(user1Id);
        contact5.setNameFirst("Barbara");
        contact5.setNameLast("Roxy");
        contact5.setTitle("Administrative Assistant");
        contact5.setOrgId(organization.getId());
        businessPhone5 = new ContactPhoneNumber();
        businessPhone5.setType(1);
        businessPhone5.setEnteredBy(user1Id);
        businessPhone5.setModifiedBy(user1Id);
        businessPhone5.setNumber("(767) 777-8787");
        businessPhone5.setExtension("");
        if (businessPhone5.isValid()) {
            PhoneNumberFormatter.format(businessPhone5, thisLocale);
            contact5.getPhoneNumberList().add(businessPhone5);
        } else {
            System.err.println("Business4 phone is invalid: " + businessPhone5.toString());
        }
        businessEmail5 = new ContactEmailAddress();
        businessEmail5.setType(1);
        businessEmail5.setEnteredBy(user4Id);
        businessEmail5.setModifiedBy(user4Id);
        businessEmail5.setEmail("test6@andanothercompany.com");
        if (businessEmail5.isValid()) {
            emailFormatter.format(businessEmail5);
            contact5.getEmailAddressList().add(businessEmail5);
        } else {
            System.err.println("Business4 email is invalid: " + businessEmail5.toString());
        }
        DemoData.checkIfInserted(contact5.insert(db), (Object)contact5);
        contact5.insertType(db, contactTypeList_ADMINISTRATIVE, 1);
        organization = new Organization();
        organization.setName("Bank of the Commonwealth");
        organization.setOwner(user4Id);
        organization.setAccountNumber("10022");
        organization.setIndustry(industryList_FINANCIAL_SERVICES);
        organization.setAlertText("Contract renewal negotiation");
        organization.setAlertDate(DemoData.addCurrentTimestamp(13));
        organization.setAlertDateTimeZone(timeZone);
        organization.setContractEndDate(DemoData.addCurrentTimestamp(20));
        organization.setContractEndDateTimeZone(timeZone);
        organization.setEnteredBy(user4Id);
        organization.setModifiedBy(user4Id);
        mainPhone = new OrganizationPhoneNumber();
        mainPhone.setType(1);
        mainPhone.setEnteredBy(user4Id);
        mainPhone.setModifiedBy(user4Id);
        mainPhone.setNumber("(999) 888-7878");
        if (mainPhone.isValid()) {
            PhoneNumberFormatter.format(mainPhone, thisLocale);
            organization.getPhoneNumberList().add(mainPhone);
        }
        mainPhone = new OrganizationPhoneNumber();
        mainPhone.setType(2);
        mainPhone.setEnteredBy(user4Id);
        mainPhone.setModifiedBy(user4Id);
        mainPhone.setNumber("(999) 878-4490");
        if (mainPhone.isValid()) {
            PhoneNumberFormatter.format(mainPhone, thisLocale);
            organization.getPhoneNumberList().add(mainPhone);
        }
        DemoData.checkIfInserted(organization.insert(db), (Object)organization);
        contact5 = new Contact();
        contact5.setAccessType(accountContactAccessTypes.getDefaultItem());
        contact5.setEnteredBy(user1Id);
        contact5.setModifiedBy(user1Id);
        contact5.setOwner(user1Id);
        contact5.setNameFirst("Frank");
        contact5.setNameLast("George");
        contact5.setTitle("Customer Service");
        contact5.setOrgId(organization.getId());
        businessPhone5 = new ContactPhoneNumber();
        businessPhone5.setType(1);
        businessPhone5.setEnteredBy(user1Id);
        businessPhone5.setModifiedBy(user1Id);
        businessPhone5.setNumber("(800) 443-2121");
        businessPhone5.setExtension("");
        if (businessPhone5.isValid()) {
            PhoneNumberFormatter.format(businessPhone5, thisLocale);
            contact5.getPhoneNumberList().add(businessPhone5);
        } else {
            System.err.println("Business4 phone is invalid: " + businessPhone5.toString());
        }
        ContactAddress businessAddress5 = new ContactAddress();
        businessAddress5.setType(1);
        businessAddress5.setEnteredBy(user1Id);
        businessAddress5.setModifiedBy(user1Id);
        businessAddress5.setStreetAddressLine1("220 W. Main Street");
        businessAddress5.setStreetAddressLine2("");
        businessAddress5.setStreetAddressLine3("");
        businessAddress5.setCity("Iowa City");
        businessAddress5.setState("HI");
        businessAddress5.setZip("");
        businessAddress5.setCountry("UNITED STATES");
        if (businessAddress5.isValid()) {
            addressFormatter.format(businessAddress5);
            contact5.getAddressList().add(businessAddress5);
        } else {
            System.err.println("Business2 address is invalid: " + businessAddress5.toString());
        }
        DemoData.checkIfInserted(contact5.insert(db), (Object)contact5);
        ActionItem actionItem = new ActionItem();
        actionItem.setActionId(actionList2.getId());
        actionItem.setLinkItemId(contact5.getId());
        actionItem.setEnteredBy(user1Id);
        actionItem.setModifiedBy(user1Id);
        actionItem.setEnabled(true);
        DemoData.checkIfInserted(actionItem.insert(db), (Object)actionItem);
        OpportunityHeader opportunity2 = new OpportunityHeader();
        opportunity2.setDescription("2000 Main Street Location");
        opportunity2.setAccountLink(organization.getId());
        opportunity2.setEnteredBy(user3Id);
        opportunity2.setModifiedBy(user3Id);
        opportunity2.setManager(user3Id);
        opportunity2.setAccessType(oppAccessTypes.getDefaultItem());
        DemoData.checkIfInserted(opportunity2.insert(db), (Object)opportunity2);
        OpportunityComponent component2 = new OpportunityComponent();
        component2.setHeaderId(opportunity2.getId());
        component2.setOwner(user3Id);
        component2.setDescription("Residential House Sale Recon");
        component2.setCloseProb("85");
        component2.setCloseDate(DemoData.addCurrentTimestamp(0));
        component2.setCloseDateTimeZone(timeZone);
        component2.setGuess("150000");
        component2.setTerms(6.0);
        component2.setUnits("M");
        component2.setType("N");
        component2.setStage(stageList_NEGOTIATION);
        component2.setStageDate(DemoData.addCurrentTimestamp(0));
        component2.setAlertText("Call back to confirm close");
        component2.setAlertDate(DemoData.addCurrentTimestamp(0));
        component2.setAlertDateTimeZone(timeZone);
        component2.setOnlyWarnings(true);
        component2.setEnteredBy(user1Id);
        component2.setModifiedBy(user1Id);
        DemoData.checkIfInserted(component2.insert(db), (Object)component2);
        component2 = new OpportunityComponent();
        component2.setHeaderId(opportunity2.getId());
        component2.setOwner(user1Id);
        component2.setDescription("One-time renovation");
        component2.setCloseProb("40");
        component2.setCloseDate(DemoData.addCurrentTimestamp(-2));
        component2.setCloseDateTimeZone(timeZone);
        component2.setGuess("60000");
        component2.setTerms(3.0);
        component2.setUnits("M");
        component2.setType("N");
        component2.setStage(stageList_PROPOSAL);
        component2.setStageDate(DemoData.addCurrentTimestamp(-1));
        component2.setEnteredBy(user1Id);
        component2.setModifiedBy(user1Id);
        DemoData.checkIfInserted(component2.insert(db), (Object)component2);
        component2.insertType(db, opportunityTypeList_SERVICES, 1);
        organization = new Organization();
        organization.setName("Freemason Restaurant");
        organization.setOwner(user1Id);
        organization.setAccountNumber("10017");
        organization.setIndustry(industryList_FOOD);
        organization.setAlertText("Contract renewal reminder");
        organization.setAlertDate(DemoData.addCurrentTimestamp(4));
        organization.setAlertDateTimeZone(timeZone);
        organization.setContractEndDate(DemoData.addCurrentTimestamp(24));
        organization.setContractEndDateTimeZone(timeZone);
        organization.setEnteredBy(user1Id);
        organization.setModifiedBy(user1Id);
        mainPhone = new OrganizationPhoneNumber();
        mainPhone.setType(1);
        mainPhone.setEnteredBy(user1Id);
        mainPhone.setModifiedBy(user1Id);
        mainPhone.setNumber("(777) 777-7777");
        if (mainPhone.isValid()) {
            PhoneNumberFormatter.format(mainPhone, thisLocale);
            organization.getPhoneNumberList().add(mainPhone);
        }
        mainPhone = new OrganizationPhoneNumber();
        mainPhone.setType(2);
        mainPhone.setEnteredBy(user1Id);
        mainPhone.setModifiedBy(user1Id);
        mainPhone.setNumber("(777) 777-7778");
        if (mainPhone.isValid()) {
            PhoneNumberFormatter.format(mainPhone, thisLocale);
            organization.getPhoneNumberList().add(mainPhone);
        }
        organizationAddress = new OrganizationAddress();
        organizationAddress.setType(1);
        organizationAddress.setEnteredBy(user1Id);
        organizationAddress.setModifiedBy(user1Id);
        organizationAddress.setStreetAddressLine1("46 Liken Lane");
        organizationAddress.setStreetAddressLine2("");
        organizationAddress.setStreetAddressLine3("");
        organizationAddress.setCity("Springfield");
        organizationAddress.setState("VT");
        organizationAddress.setZip("");
        organizationAddress.setCountry("UNITED STATES");
        if (organizationAddress.isValid()) {
            addressFormatter.format(organizationAddress);
            organization.getAddressList().add(organizationAddress);
        }
        primaryEmail = new OrganizationEmailAddress();
        primaryEmail.setType(1);
        primaryEmail.setEnteredBy(user1Id);
        primaryEmail.setModifiedBy(user1Id);
        primaryEmail.setEmail("support@freemason_restaurant.com");
        if (primaryEmail.isValid()) {
            emailFormatter.format(primaryEmail);
            organization.getEmailAddressList().add(primaryEmail);
        }
        DemoData.checkIfInserted(organization.insert(db), (Object)organization);
        contact5 = new Contact();
        contact5.setAccessType(accountContactAccessTypes.getDefaultItem());
        contact5.setEnteredBy(user1Id);
        contact5.setModifiedBy(user1Id);
        contact5.setOwner(user1Id);
        contact5.setNameFirst("Mary");
        contact5.setNameLast("Redhair");
        contact5.setTitle("Waitress");
        contact5.setOrgId(organization.getId());
        businessPhone5 = new ContactPhoneNumber();
        businessPhone5.setType(1);
        businessPhone5.setEnteredBy(user1Id);
        businessPhone5.setModifiedBy(user1Id);
        businessPhone5.setNumber("(767) 554-4444");
        businessPhone5.setExtension("");
        if (businessPhone5.isValid()) {
            PhoneNumberFormatter.format(businessPhone5, thisLocale);
            contact5.getPhoneNumberList().add(businessPhone5);
        } else {
            System.err.println("Business4 phone is invalid: " + businessPhone5.toString());
        }
        businessEmail5 = new ContactEmailAddress();
        businessEmail5.setType(1);
        businessEmail5.setEnteredBy(user1Id);
        businessEmail5.setModifiedBy(user1Id);
        businessEmail5.setEmail("mary@freemason_restaurant.com");
        if (businessEmail5.isValid()) {
            emailFormatter.format(businessEmail5);
            contact5.getEmailAddressList().add(businessEmail5);
        } else {
            System.err.println("Business1 email is invalid: " + businessEmail5.toString());
        }
        DemoData.checkIfInserted(contact5.insert(db), (Object)contact5);
        contact5.insertType(db, contactTypeList_BUSINESS_DEV, 1);
        actionItem = new ActionItem();
        actionItem.setActionId(actionList2.getId());
        actionItem.setLinkItemId(contact5.getId());
        actionItem.setEnteredBy(user1Id);
        actionItem.setModifiedBy(user1Id);
        actionItem.setEnabled(true);
        DemoData.checkIfInserted(actionItem.insert(db), (Object)actionItem);
        Task task3 = new Task();
        task3.setEnteredBy(user1Id);
        task3.setModifiedBy(user1Id);
        task3.setPriority(1);
        task3.setDescription("Meeting with Mary preparation - send contract");
        task3.setNotes("Modify existing document in Account folder");
        task3.setSharing(-1);
        task3.setOwner(user1Id);
        task3.setDueDate(DemoData.addCurrentTimestamp(0));
        task3.setDueDateTimeZone(timeZone);
        task3.setEstimatedLOE(-1.0);
        task3.setEstimatedLOEType(2);
        task3.setType(1);
        task3.setContactId(contact5.getId());
        DemoData.checkIfInserted(task3.insert(db), (Object)task3);
        opportunity2 = new OpportunityHeader();
        opportunity2.setDescription("2006 Tork Converter");
        opportunity2.setAccountLink(organization.getId());
        opportunity2.setEnteredBy(user1Id);
        opportunity2.setModifiedBy(user1Id);
        opportunity2.setManager(user1Id);
        opportunity2.setAccessType(oppAccessTypes.getDefaultItem());
        DemoData.checkIfInserted(opportunity2.insert(db), (Object)opportunity2);
        component2 = new OpportunityComponent();
        component2.setHeaderId(opportunity2.getId());
        component2.setOwner(user1Id);
        component2.setDescription("Maintenance agreement");
        component2.setCloseProb("33");
        component2.setCloseDate(DemoData.addCurrentTimestamp(14));
        component2.setCloseDateTimeZone(timeZone);
        component2.setGuess("96000");
        component2.setTerms(12.0);
        component2.setUnits("M");
        component2.setType("N");
        component2.setStage(stageList_NEGOTIATION);
        component2.setStageDate(DemoData.addCurrentTimestamp(0));
        component2.setAlertText("Last contract to attorney's confirmation");
        component2.setAlertDate(DemoData.addCurrentTimestamp(4));
        component2.setAlertDateTimeZone(timeZone);
        component2.setEnteredBy(user1Id);
        component2.setModifiedBy(user1Id);
        DemoData.checkIfInserted(component2.insert(db), (Object)component2);
        component2.insertType(db, opportunityTypeList_MAINTENANCE, 1);
        component2 = new OpportunityComponent();
        component2.setHeaderId(opportunity2.getId());
        component2.setOwner(user1Id);
        component2.setDescription("The new converter for their premises");
        component2.setCloseProb("25");
        component2.setCloseDate(DemoData.addCurrentTimestamp(34));
        component2.setCloseDateTimeZone(timeZone);
        component2.setGuess("75000");
        component2.setTerms(1.0);
        component2.setUnits("M");
        component2.setType("N");
        component2.setStage(stageList_NEEDS_ANALYSIS);
        component2.setStageDate(DemoData.addCurrentTimestamp(0));
        component2.setAlertText("Lunch meeting to revisit deal points with Bob");
        component2.setAlertDate(DemoData.addCurrentTimestamp(4));
        component2.setAlertDateTimeZone(timeZone);
        component2.setEnteredBy(user1Id);
        component2.setModifiedBy(user1Id);
        DemoData.checkIfInserted(component2.insert(db), (Object)component2);
        component2.insertType(db, opportunityTypeList_PRODUCT_SALES, 1);
        component2.insertType(db, opportunityTypeList_MAINTENANCE, 2);
        organization = new Organization();
        organization.setName("Harry's Diner");
        organization.setOwner(user1Id);
        organization.setAccountNumber("10006");
        organization.setIndustry(industryList_FOOD);
        organization.setAlertText("Contract renewal alert");
        organization.setAlertDate(DemoData.addCurrentTimestamp(60));
        organization.setAlertDateTimeZone(timeZone);
        organization.setContractEndDate(DemoData.addCurrentTimestamp(67));
        organization.setContractEndDateTimeZone(timeZone);
        organization.setEnteredBy(user1Id);
        organization.setModifiedBy(user1Id);
        mainPhone = new OrganizationPhoneNumber();
        mainPhone.setType(1);
        mainPhone.setEnteredBy(user1Id);
        mainPhone.setModifiedBy(user1Id);
        mainPhone.setNumber("(888) 888-8881");
        if (mainPhone.isValid()) {
            PhoneNumberFormatter.format(mainPhone, thisLocale);
            organization.getPhoneNumberList().add(mainPhone);
        }
        organizationAddress = new OrganizationAddress();
        organizationAddress.setType(1);
        organizationAddress.setEnteredBy(user1Id);
        organizationAddress.setModifiedBy(user1Id);
        organizationAddress.setStreetAddressLine1("4096 Fish Street");
        organizationAddress.setStreetAddressLine2("");
        organizationAddress.setStreetAddressLine3("");
        organizationAddress.setCity("St. Lucie");
        organizationAddress.setState("FL");
        organizationAddress.setZip("");
        organizationAddress.setCountry("UNITED STATES");
        if (organizationAddress.isValid()) {
            addressFormatter.format(organizationAddress);
            organization.getAddressList().add(organizationAddress);
        }
        DemoData.checkIfInserted(organization.insert(db), (Object)organization);
        contact5 = new Contact();
        contact5.setAccessType(accountContactAccessTypes.getDefaultItem());
        contact5.setEnteredBy(user1Id);
        contact5.setModifiedBy(user1Id);
        contact5.setOwner(user1Id);
        contact5.setNameFirst("Harold");
        contact5.setNameLast("Potter");
        contact5.setTitle("SVP / Sales");
        contact5.setOrgId(organization.getId());
        businessPhone5 = new ContactPhoneNumber();
        businessPhone5.setType(1);
        businessPhone5.setEnteredBy(user1Id);
        businessPhone5.setModifiedBy(user1Id);
        businessPhone5.setNumber("(667) 776-7624");
        businessPhone5.setExtension("");
        if (businessPhone5.isValid()) {
            PhoneNumberFormatter.format(businessPhone5, thisLocale);
            contact5.getPhoneNumberList().add(businessPhone5);
        } else {
            System.err.println("Business4 phone is invalid: " + businessPhone5.toString());
        }
        businessEmail5 = new ContactEmailAddress();
        businessEmail5.setType(1);
        businessEmail5.setEnteredBy(user1Id);
        businessEmail5.setModifiedBy(user1Id);
        businessEmail5.setEmail("harry@thisrestaurant.com");
        if (businessEmail5.isValid()) {
            emailFormatter.format(businessEmail5);
            contact5.getEmailAddressList().add(businessEmail5);
        } else {
            System.err.println("Business1 email is invalid: " + businessEmail5.toString());
        }
        DemoData.checkIfInserted(contact5.insert(db), (Object)contact5);
        contact5.insertType(db, contactTypeList_EXECUTIVE, 1);
        actionItem = new ActionItem();
        actionItem.setActionId(actionList1.getId());
        actionItem.setLinkItemId(contact5.getId());
        actionItem.setEnteredBy(user1Id);
        actionItem.setModifiedBy(user1Id);
        actionItem.setEnabled(true);
        DemoData.checkIfInserted(actionItem.insert(db), (Object)actionItem);
        contact5 = new Contact();
        contact5.setAccessType(accountContactAccessTypes.getDefaultItem());
        contact5.setEnteredBy(user1Id);
        contact5.setModifiedBy(user1Id);
        contact5.setOwner(user1Id);
        contact5.setNameFirst("Winona");
        contact5.setNameLast("Weldon");
        contact5.setTitle("Sales Rep");
        contact5.setOrgId(organization.getId());
        businessPhone5 = new ContactPhoneNumber();
        businessPhone5.setType(1);
        businessPhone5.setEnteredBy(user1Id);
        businessPhone5.setModifiedBy(user1Id);
        businessPhone5.setNumber("(667) 776-7644");
        businessPhone5.setExtension("");
        if (businessPhone5.isValid()) {
            PhoneNumberFormatter.format(businessPhone5, thisLocale);
            contact5.getPhoneNumberList().add(businessPhone5);
        } else {
            System.err.println("Business4 phone is invalid: " + businessPhone5.toString());
        }
        businessEmail5 = new ContactEmailAddress();
        businessEmail5.setType(1);
        businessEmail5.setEnteredBy(user1Id);
        businessEmail5.setModifiedBy(user1Id);
        businessEmail5.setEmail("winona@thisrestaurant.com");
        if (businessEmail5.isValid()) {
            emailFormatter.format(businessEmail5);
            contact5.getEmailAddressList().add(businessEmail5);
        } else {
            System.err.println("Business1 email is invalid: " + businessEmail5.toString());
        }
        DemoData.checkIfInserted(contact5.insert(db), (Object)contact5);
        contact5.insertType(db, contactTypeList_SALES, 1);
        opportunity2 = new OpportunityHeader();
        opportunity2.setDescription("New Bar & Grill");
        opportunity2.setAccountLink(organization.getId());
        opportunity2.setEnteredBy(user1Id);
        opportunity2.setModifiedBy(user1Id);
        opportunity2.setManager(user1Id);
        opportunity2.setAccessType(oppAccessTypes.getDefaultItem());
        DemoData.checkIfInserted(opportunity2.insert(db), (Object)opportunity2);
        component2 = new OpportunityComponent();
        component2.setHeaderId(opportunity2.getId());
        component2.setOwner(user3Id);
        component2.setDescription("Installation of equipment");
        component2.setCloseProb("50");
        component2.setCloseDate(DemoData.addCurrentTimestamp(62));
        component2.setCloseDateTimeZone(timeZone);
        component2.setGuess("36000");
        component2.setTerms(3.0);
        component2.setUnits("M");
        component2.setType("N");
        component2.setStage(stageList_PROPOSAL);
        component2.setStageDate(DemoData.addCurrentTimestamp(0));
        component2.setAlertText("Double check on installer's availability");
        component2.setAlertDate(DemoData.addCurrentTimestamp(59));
        component2.setAlertDateTimeZone(timeZone);
        component2.setEnteredBy(user3Id);
        component2.setModifiedBy(user3Id);
        DemoData.checkIfInserted(component2.insert(db), (Object)component2);
        component2.insertType(db, opportunityTypeList_SERVICES, 1);
        component2 = new OpportunityComponent();
        component2.setHeaderId(opportunity2.getId());
        component2.setOwner(user1Id);
        component2.setDescription("One-time design of grill");
        component2.setCloseProb("50");
        component2.setCloseDate(DemoData.addCurrentTimestamp(11));
        component2.setCloseDateTimeZone(timeZone);
        component2.setGuess("35000");
        component2.setTerms(2.0);
        component2.setUnits("M");
        component2.setType("N");
        component2.setStage(stageList_VALUE_PROP);
        component2.setStageDate(DemoData.addCurrentTimestamp(0));
        component2.setAlertText("Call back to set up lunch meeting");
        component2.setAlertDate(DemoData.addCurrentTimestamp(10));
        component2.setAlertDateTimeZone(timeZone);
        component2.setEnteredBy(user1Id);
        component2.setModifiedBy(user1Id);
        DemoData.checkIfInserted(component2.insert(db), (Object)component2);
        component2.insertType(db, opportunityTypeList_CONSULTATION, 1);
        component2 = new OpportunityComponent();
        component2.setHeaderId(opportunity2.getId());
        component2.setOwner(user1Id);
        component2.setDescription("Bar & Grill equipment purchase");
        component2.setCloseProb("50");
        component2.setCloseDate(DemoData.addCurrentTimestamp(30));
        component2.setCloseDateTimeZone(timeZone);
        component2.setGuess("125000");
        component2.setTerms(3.0);
        component2.setUnits("M");
        component2.setType("N");
        component2.setStage(stageList_VALUE_PROP);
        component2.setStageDate(DemoData.addCurrentTimestamp(0));
        component2.setAlertText("Contact ATL equipment for brochure");
        component2.setAlertDate(DemoData.addCurrentTimestamp(6));
        component2.setAlertDateTimeZone(timeZone);
        component2.setEnteredBy(user1Id);
        component2.setModifiedBy(user1Id);
        DemoData.checkIfInserted(component2.insert(db), (Object)component2);
        component2.insertType(db, opportunityTypeList_PRODUCT_SALES, 1);
        organization = new Organization();
        organization.setName("Hollerin Hank's Pizza");
        organization.setOwner(user1Id);
        organization.setAccountNumber("10021");
        organization.setIndustry(industryList_FOOD);
        organization.setAlertText("Contract renewal alert");
        organization.setAlertDate(DemoData.addCurrentTimestamp(70));
        organization.setAlertDateTimeZone(timeZone);
        organization.setContractEndDate(DemoData.addCurrentTimestamp(77));
        organization.setContractEndDateTimeZone(timeZone);
        organization.setEnteredBy(user1Id);
        organization.setModifiedBy(user1Id);
        mainPhone = new OrganizationPhoneNumber();
        mainPhone.setType(1);
        mainPhone.setEnteredBy(user1Id);
        mainPhone.setModifiedBy(user1Id);
        mainPhone.setNumber("(998) 889-9898");
        if (mainPhone.isValid()) {
            PhoneNumberFormatter.format(mainPhone, thisLocale);
            organization.getPhoneNumberList().add(mainPhone);
        }
        DemoData.checkIfInserted(organization.insert(db), (Object)organization);
        opportunity2 = new OpportunityHeader();
        opportunity2.setDescription("New Pizza Truck");
        opportunity2.setAccountLink(organization.getId());
        opportunity2.setEnteredBy(user1Id);
        opportunity2.setModifiedBy(user1Id);
        opportunity2.setManager(user1Id);
        opportunity2.setAccessType(oppAccessTypes.getDefaultItem());
        DemoData.checkIfInserted(opportunity2.insert(db), (Object)opportunity2);
        component2 = new OpportunityComponent();
        component2.setHeaderId(opportunity2.getId());
        component2.setOwner(user1Id);
        component2.setDescription("Converted F350 delivery");
        component2.setCloseProb("95");
        component2.setCloseDate(DemoData.addCurrentTimestamp(41));
        component2.setCloseDateTimeZone(timeZone);
        component2.setGuess("27500");
        component2.setTerms(1.0);
        component2.setUnits("M");
        component2.setType("N");
        component2.setStage(stageList_NEGOTIATION);
        component2.setStageDate(DemoData.addCurrentTimestamp(0));
        component2.setAlertText("Delivery follow-up with Ford factory");
        component2.setAlertDate(DemoData.addCurrentTimestamp(6));
        component2.setAlertDateTimeZone(timeZone);
        component2.setEnteredBy(user1Id);
        component2.setModifiedBy(user1Id);
        DemoData.checkIfInserted(component2.insert(db), (Object)component2);
        organization = new Organization();
        organization.setName("Joan's Tractor Sales");
        organization.setOwner(user1Id);
        organization.setAccountNumber("10012");
        organization.setAlertText("Lunch meeting contract signing");
        organization.setAlertDate(DemoData.addCurrentTimestamp(4));
        organization.setAlertDateTimeZone(timeZone);
        organization.setContractEndDate(DemoData.addCurrentTimestamp(44));
        organization.setContractEndDateTimeZone(timeZone);
        organization.setEnteredBy(user1Id);
        organization.setModifiedBy(user1Id);
        mainPhone = new OrganizationPhoneNumber();
        mainPhone.setType(1);
        mainPhone.setEnteredBy(user1Id);
        mainPhone.setModifiedBy(user1Id);
        mainPhone.setNumber("(523) 555-0890");
        if (mainPhone.isValid()) {
            PhoneNumberFormatter.format(mainPhone, thisLocale);
            organization.getPhoneNumberList().add(mainPhone);
        }
        mainPhone = new OrganizationPhoneNumber();
        mainPhone.setType(2);
        mainPhone.setEnteredBy(user1Id);
        mainPhone.setModifiedBy(user1Id);
        mainPhone.setNumber("(523) 555-0897");
        if (mainPhone.isValid()) {
            PhoneNumberFormatter.format(mainPhone, thisLocale);
            organization.getPhoneNumberList().add(mainPhone);
        }
        organizationAddress = new OrganizationAddress();
        organizationAddress.setType(1);
        organizationAddress.setEnteredBy(user1Id);
        organizationAddress.setModifiedBy(user1Id);
        organizationAddress.setStreetAddressLine1("286 Corn Row");
        organizationAddress.setStreetAddressLine2("Suite 200");
        organizationAddress.setStreetAddressLine3("");
        organizationAddress.setCity("Iowa City");
        organizationAddress.setState("IA");
        organizationAddress.setZip("");
        organizationAddress.setCountry("UNITED STATES");
        if (organizationAddress.isValid()) {
            addressFormatter.format(organizationAddress);
            organization.getAddressList().add(organizationAddress);
        }
        DemoData.checkIfInserted(organization.insert(db), (Object)organization);
        organization = new Organization();
        organization.setName("Ma & Pa Software");
        organization.setOwner(user4Id);
        organization.setAccountNumber("10033");
        organization.setIndustry(industryList_COMPUTER);
        organization.setAlertText("Contract renewal alert");
        organization.setAlertDate(DemoData.addCurrentTimestamp(32));
        organization.setAlertDateTimeZone(timeZone);
        organization.setContractEndDate(DemoData.addCurrentTimestamp(35));
        organization.setEnteredBy(user4Id);
        organization.setModifiedBy(user4Id);
        mainPhone = new OrganizationPhoneNumber();
        mainPhone.setType(1);
        mainPhone.setEnteredBy(user1Id);
        mainPhone.setModifiedBy(user1Id);
        mainPhone.setNumber("(323) 443-4444");
        if (mainPhone.isValid()) {
            PhoneNumberFormatter.format(mainPhone, thisLocale);
            organization.getPhoneNumberList().add(mainPhone);
        }
        organization.setOnlyWarnings(true);
        DemoData.checkIfInserted(organization.insert(db), (Object)organization);
        organization.insertType(db, accountTypeList_LARGE, 1);
        organization = new Organization();
        organization.setName("New City Mall");
        organization.setOwner(user3Id);
        organization.setAccountNumber("10045");
        organization.setIndustry(industryList_RETAIL);
        organization.setAlertText("Renewal signing at PLC");
        organization.setAlertDate(DemoData.addCurrentTimestamp(0));
        organization.setAlertDateTimeZone(timeZone);
        organization.setOnlyWarnings(true);
        organization.setContractEndDate(DemoData.addCurrentTimestamp(23));
        organization.setContractEndDateTimeZone(timeZone);
        organization.setEnteredBy(user3Id);
        organization.setModifiedBy(user3Id);
        mainPhone = new OrganizationPhoneNumber();
        mainPhone.setType(1);
        mainPhone.setEnteredBy(user1Id);
        mainPhone.setModifiedBy(user1Id);
        mainPhone.setNumber("(624) 555-0222");
        if (mainPhone.isValid()) {
            PhoneNumberFormatter.format(mainPhone, thisLocale);
            organization.getPhoneNumberList().add(mainPhone);
        }
        mainPhone = new OrganizationPhoneNumber();
        mainPhone.setType(2);
        mainPhone.setEnteredBy(user1Id);
        mainPhone.setModifiedBy(user1Id);
        mainPhone.setNumber("(624) 555-0981");
        if (mainPhone.isValid()) {
            PhoneNumberFormatter.format(mainPhone, thisLocale);
            organization.getPhoneNumberList().add(mainPhone);
        }
        organizationAddress = new OrganizationAddress();
        organizationAddress.setType(1);
        organizationAddress.setEnteredBy(user3Id);
        organizationAddress.setModifiedBy(user3Id);
        organizationAddress.setStreetAddressLine1("Big Mall Road");
        organizationAddress.setStreetAddressLine2("");
        organizationAddress.setStreetAddressLine3("");
        organizationAddress.setCity("Norfolk");
        organizationAddress.setState("CT");
        organizationAddress.setZip("");
        organizationAddress.setCountry("UNITED STATES");
        if (organizationAddress.isValid()) {
            addressFormatter.format(organizationAddress);
            organization.getAddressList().add(organizationAddress);
        }
        primaryEmail = new OrganizationEmailAddress();
        primaryEmail.setType(1);
        primaryEmail.setEnteredBy(user4Id);
        primaryEmail.setModifiedBy(user4Id);
        primaryEmail.setEmail("info@citymall.com");
        if (primaryEmail.isValid()) {
            emailFormatter.format(primaryEmail);
            organization.getEmailAddressList().add(primaryEmail);
        }
        DemoData.checkIfInserted(organization.insert(db), (Object)organization);
        organization.insertType(db, accountTypeList_LARGE, 1);
        organization.insertType(db, accountTypeList_CONTRACT, 2);
        organization.insertType(db, accountTypeList_TERRITORY1, 3);
        organization = new Organization();
        organization.setName("New Shoes Co.");
        organization.setOwner(user1Id);
        organization.setAccountNumber("10011");
        organization.setIndustry(industryList_RETAIL);
        organization.setAlertText("Send renewal contract");
        organization.setAlertDate(DemoData.addCurrentTimestamp(42));
        organization.setAlertDateTimeZone(timeZone);
        organization.setContractEndDate(DemoData.addCurrentTimestamp(48));
        organization.setContractEndDateTimeZone(timeZone);
        organization.setEnteredBy(user1Id);
        organization.setModifiedBy(user1Id);
        mainPhone = new OrganizationPhoneNumber();
        mainPhone.setType(1);
        mainPhone.setEnteredBy(user1Id);
        mainPhone.setModifiedBy(user1Id);
        mainPhone.setNumber("(888) 525-7794");
        if (mainPhone.isValid()) {
            PhoneNumberFormatter.format(mainPhone, thisLocale);
            organization.getPhoneNumberList().add(mainPhone);
        }
        organizationAddress = new OrganizationAddress();
        organizationAddress.setType(1);
        organizationAddress.setEnteredBy(user3Id);
        organizationAddress.setModifiedBy(user3Id);
        organizationAddress.setStreetAddressLine1("2042 Cobbler Parkway");
        organizationAddress.setStreetAddressLine2("");
        organizationAddress.setStreetAddressLine3("");
        organizationAddress.setCity("Peninsula City");
        organizationAddress.setState("AZ");
        organizationAddress.setZip("");
        organizationAddress.setCountry("UNITED STATES");
        if (organizationAddress.isValid()) {
            addressFormatter.format(organizationAddress);
            organization.getAddressList().add(organizationAddress);
        }
        organization.setOnlyWarnings(true);
        DemoData.checkIfInserted(organization.insert(db), (Object)organization);
        organization = new Organization();
        organization.setName("Signature Services");
        organization.setOwner(user1Id);
        organization.setIndustry(industryList_FINANCIAL_SERVICES);
        organization.setAlertText("Contract renewal alert");
        organization.setAlertDate(DemoData.addCurrentTimestamp(11));
        organization.setAlertDateTimeZone(timeZone);
        organization.setContractEndDate(DemoData.addCurrentTimestamp(28));
        organization.setContractEndDateTimeZone(timeZone);
        organization.setEnteredBy(user1Id);
        organization.setModifiedBy(user1Id);
        mainPhone = new OrganizationPhoneNumber();
        mainPhone.setType(1);
        mainPhone.setEnteredBy(user1Id);
        mainPhone.setModifiedBy(user1Id);
        mainPhone.setNumber("(778) 887-6222");
        if (mainPhone.isValid()) {
            PhoneNumberFormatter.format(mainPhone, thisLocale);
            organization.getPhoneNumberList().add(mainPhone);
        }
        mainPhone = new OrganizationPhoneNumber();
        mainPhone.setType(1);
        mainPhone.setEnteredBy(user1Id);
        mainPhone.setModifiedBy(user1Id);
        mainPhone.setNumber("(778) 887-6213");
        if (mainPhone.isValid()) {
            PhoneNumberFormatter.format(mainPhone, thisLocale);
            organization.getPhoneNumberList().add(mainPhone);
        }
        primaryEmail = new OrganizationEmailAddress();
        primaryEmail.setType(1);
        primaryEmail.setEnteredBy(user1Id);
        primaryEmail.setModifiedBy(user1Id);
        primaryEmail.setEmail("bossman@signatureservicesco.com");
        if (primaryEmail.isValid()) {
            emailFormatter.format(primaryEmail);
            organization.getEmailAddressList().add(primaryEmail);
        }
        DemoData.checkIfInserted(organization.insert(db), (Object)organization);
        organization.insertType(db, accountTypeList_TERRITORY5, 1);
        Ticket ticket3 = new Ticket();
        ticket3.setSourceCode(ticketSourceList_PHONE);
        ticket3.setProblem("I'm unable to connect to the file server. I can connect to the staging server.");
        ticket3.setComment("If you can't make it work, we're in serious trouble. But let me dust off my networking skills and I'll take a wack at it. Maybe Tom can give it a shot. Tom?");
        ticket3.setSeverityCode(ticketSeverityList_CRITICAL);
        ticket3.setOrgId(0);
        ticket3.setContactId(contact2Id);
        ticket3.setPriorityCode(ticketPriorityList_URGENT);
        ticket3.setDepartmentCode(departmentList_ENGINEERING);
        ticket3.setAssignedTo(user3Id);
        ticket3.setAssignedDate(DemoData.addCurrentTimestamp(-2));
        ticket3.setEntered(DemoData.addCurrentTimestamp(-2));
        ticket3.setEnteredBy(user1Id);
        ticket3.setModified(DemoData.addCurrentTimestamp(-2));
        ticket3.setModifiedBy(user1Id);
        DemoData.checkIfInserted(ticket3.insert(db), (Object)ticket3);
        ticket3 = new Ticket();
        ticket3.setSourceCode(ticketSourceList_EMAIL);
        ticket3.setProblem("Printer doesn't work.");
        ticket3.setSeverityCode(ticketSeverityList_NORMAL);
        ticket3.setOrgId(0);
        ticket3.setContactId(contact3Id);
        ticket3.setPriorityCode(ticketPriorityList_AS_SCHEDULED);
        ticket3.setDepartmentCode(departmentList_ENGINEERING);
        ticket3.setAssignedTo(user2Id);
        ticket3.setAssignedDate(DemoData.addCurrentTimestamp(-2));
        ticket3.setEntered(DemoData.addCurrentTimestamp(-2));
        ticket3.setEnteredBy(user2Id);
        ticket3.setModified(DemoData.addCurrentTimestamp(-2));
        ticket3.setModifiedBy(user2Id);
        DemoData.checkIfInserted(ticket3.insert(db), (Object)ticket3);
        Contact contact6 = new Contact();
        contact6.setAccessType(contactAccessTypes.getDefaultItem());
        contact6.setEnteredBy(user1Id);
        contact6.setModifiedBy(user1Id);
        contact6.setOwner(user1Id);
        contact6.setNameFirst("Gordon");
        contact6.setNameLast("Allenson");
        contact6.setCompany("Anderson Village");
        ContactPhoneNumber businessPhone6 = new ContactPhoneNumber();
        businessPhone6.setType(1);
        businessPhone6.setEnteredBy(user1Id);
        businessPhone6.setModifiedBy(user1Id);
        businessPhone6.setNumber("(323) 223-2121");
        businessPhone6.setExtension("");
        if (businessPhone6.isValid()) {
            PhoneNumberFormatter.format(businessPhone6, thisLocale);
            contact6.getPhoneNumberList().add(businessPhone6);
        } else {
            System.err.println("Business4 phone is invalid: " + businessPhone6.toString());
        }
        ContactEmailAddress businessEmail7 = new ContactEmailAddress();
        businessEmail7.setType(1);
        businessEmail7.setEnteredBy(user1Id);
        businessEmail7.setModifiedBy(user1Id);
        businessEmail7.setEmail("gman@fictitiouscompany.com");
        if (businessEmail7.isValid()) {
            emailFormatter.format(businessEmail7);
            contact6.getEmailAddressList().add(businessEmail7);
        } else {
            System.err.println("Business1 email is invalid: " + businessEmail7.toString());
        }
        DemoData.checkIfInserted(contact6.insert(db), (Object)contact6);
        contact6.insertType(db, contactTypeList_ACQUAINTANCE, 1);
        Call call2 = new Call();
        call2.setContactId(contact6.getId());
        call2.setCallTypeId(callTypeList_OUTGOING_CALL);
        call2.setLength(30);
        call2.setSubject("first meeting");
        call2.setEnteredBy(user1Id);
        call2.setModifiedBy(user1Id);
        call2.setEntered(DemoData.addCurrentTimestamp(-7));
        call2.setModified(DemoData.addCurrentTimestamp(-7));
        call2.setOwner(user1Id);
        call2.setAssignDate(DemoData.addCurrentTimestamp(0));
        call2.setCompletedBy(user1Id);
        call2.setCompleteDate(DemoData.addCurrentTimestamp(0));
        call2.setResultId(callResultList_YES_BUS_PROGRESSING);
        call2.setPriorityId(callPriorityList_HIGH);
        call2.setStatusId(2);
        DemoData.checkIfInserted(call2.insert(db), (Object)call2);
        call2 = new Call();
        call2.setContactId(contact6.getId());
        call2.setCallTypeId(callTypeList_OUTSIDE_APPT);
        call2.setLength(15);
        call2.setSubject("second meeting");
        call2.setEnteredBy(user1Id);
        call2.setModifiedBy(user1Id);
        call2.setEntered(DemoData.addCurrentTimestamp(-1));
        call2.setModified(DemoData.addCurrentTimestamp(-1));
        call2.setOwner(user1Id);
        call2.setAssignDate(DemoData.addCurrentTimestamp(0));
        call2.setCompletedBy(user1Id);
        call2.setCompleteDate(DemoData.addCurrentTimestamp(0));
        call2.setResultId(callResultList_YES_BUS_PROGRESSING);
        call2.setPriorityId(callPriorityList_HIGH);
        call2.setStatusId(2);
        DemoData.checkIfInserted(call2.insert(db), (Object)call2);
        call2 = new Call();
        call2.setContactId(contact6.getId());
        call2.setCallTypeId(callTypeList_OUTGOING_CALL);
        call2.setLength(0);
        call2.setSubject("Set up meeting for next Week");
        call2.setNotes("- Need to bring a projector for the meeting and donuts");
        call2.setAlertDate(DemoData.addCurrentTimestamp(7));
        call2.setAlertDateTimeZone(timeZone);
        call2.setFollowupNotes("Don't forget the donuts");
        call2.setEntered(DemoData.addCurrentTimestamp(0));
        call2.setEnteredBy(user1Id);
        call2.setModified(DemoData.addCurrentTimestamp(0));
        call2.setModifiedBy(user1Id);
        call2.setAlertText("Set up meeting for next Week");
        call2.setAlertCallTypeId(callTypeList_OUTSIDE_APPT);
        call2.setOwner(user1Id);
        call2.setAssignDate(DemoData.addCurrentTimestamp(0));
        call2.setCompletedBy(user1Id);
        call2.setCompleteDate(DemoData.addCurrentTimestamp(0));
        call2.setResultId(callResultList_YES_BUS_PROGRESSING);
        call2.setPriorityId(callPriorityList_HIGH);
        call2.setStatusId(3);
        call2.setReminderId(1);
        call2.setReminderTypeId(callReminderList_HOURS);
        DemoData.checkIfInserted(call2.insert(db), (Object)call2);
        opportunity2 = new OpportunityHeader();
        opportunity2.setDescription("Series 5000 to Westside Location");
        opportunity2.setContactLink(contact6.getId());
        opportunity2.setEnteredBy(user3Id);
        opportunity2.setModifiedBy(user3Id);
        opportunity2.setManager(user3Id);
        opportunity2.setAccessType(oppAccessTypes.getDefaultItem());
        DemoData.checkIfInserted(opportunity2.insert(db), (Object)opportunity2);
        component2 = new OpportunityComponent();
        component2.setHeaderId(opportunity2.getId());
        component2.setOwner(user3Id);
        component2.setDescription("One-time Installation");
        component2.setCloseProb("50");
        component2.setCloseDate(DemoData.addCurrentTimestamp(60));
        component2.setCloseDateTimeZone(timeZone);
        component2.setGuess("50000");
        component2.setTerms(2.0);
        component2.setUnits("M");
        component2.setType("N");
        component2.setStage(stageList_VALUE_PROP);
        component2.setStageDate(DemoData.addCurrentTimestamp(-1));
        component2.setAlertText("Set up meeting next week");
        component2.setAlertDate(DemoData.addCurrentTimestamp(3));
        component2.setAlertDateTimeZone(timeZone);
        component2.setEnteredBy(user4Id);
        component2.setModifiedBy(user4Id);
        DemoData.checkIfInserted(component2.insert(db), (Object)component2);
        component2.insertType(db, opportunityTypeList_DEVELOPMENT, 1);
        component2 = new OpportunityComponent();
        component2.setHeaderId(opportunity2.getId());
        component2.setOwner(user1Id);
        component2.setDescription("Series 5000 Hardware");
        component2.setCloseProb("50");
        component2.setCloseDate(DemoData.addCurrentTimestamp(25));
        component2.setCloseDateTimeZone(timeZone);
        component2.setGuess("75000");
        component2.setTerms(1.0);
        component2.setUnits("M");
        component2.setType("N");
        component2.setStage(stageList_PROSPECTING);
        component2.setStageDate(DemoData.addCurrentTimestamp(0));
        component2.setEnteredBy(user4Id);
        component2.setModifiedBy(user4Id);
        DemoData.checkIfInserted(component2.insert(db), (Object)component2);
        component2.insertType(db, opportunityTypeList_PRODUCT_SALES, 1);
        contact6 = new Contact();
        contact6.setAccessType(contactAccessTypes.getDefaultItem());
        contact6.setEnteredBy(user1Id);
        contact6.setModifiedBy(user1Id);
        contact6.setOwner(user1Id);
        contact6.setNameFirst("George");
        contact6.setNameLast("Anderson");
        contact6.setTitle("Founder");
        contact6.setCompany("Anderson Village");
        businessPhone6 = new ContactPhoneNumber();
        businessPhone6.setType(1);
        businessPhone6.setEnteredBy(user1Id);
        businessPhone6.setModifiedBy(user1Id);
        businessPhone6.setNumber("(323) 224-2121");
        businessPhone6.setExtension("");
        if (businessPhone6.isValid()) {
            PhoneNumberFormatter.format(businessPhone6, thisLocale);
            contact6.getPhoneNumberList().add(businessPhone6);
        } else {
            System.err.println("Business4 phone is invalid: " + businessPhone6.toString());
        }
        businessPhone6 = new ContactPhoneNumber();
        businessPhone6.setType(7);
        businessPhone6.setEnteredBy(user1Id);
        businessPhone6.setModifiedBy(user1Id);
        businessPhone6.setNumber("(323) 224-2121");
        businessPhone6.setExtension("");
        if (businessPhone6.isValid()) {
            PhoneNumberFormatter.format(businessPhone6, thisLocale);
            contact6.getPhoneNumberList().add(businessPhone6);
        } else {
            System.err.println("Business4 phone is invalid: " + businessPhone6.toString());
        }
        businessEmail7 = new ContactEmailAddress();
        businessEmail7.setType(1);
        businessEmail7.setEnteredBy(user1Id);
        businessEmail7.setModifiedBy(user1Id);
        businessEmail7.setEmail("ganderson@fictitiouscompany.com");
        if (businessEmail7.isValid()) {
            emailFormatter.format(businessEmail7);
            contact6.getEmailAddressList().add(businessEmail7);
        } else {
            System.err.println("Business1 email is invalid: " + businessEmail7.toString());
        }
        DemoData.checkIfInserted(contact6.insert(db), (Object)contact6);
        contact6 = new Contact();
        contact6.setAccessType(contactAccessTypes.getDefaultItem());
        contact6.setEnteredBy(user1Id);
        contact6.setModifiedBy(user1Id);
        contact6.setOwner(user1Id);
        contact6.setNameFirst("Fran");
        contact6.setNameLast("Baker");
        contact6.setTitle("Operations Manager");
        contact6.setCompany("Baker Company");
        businessPhone6 = new ContactPhoneNumber();
        businessPhone6.setType(1);
        businessPhone6.setEnteredBy(user1Id);
        businessPhone6.setModifiedBy(user1Id);
        businessPhone6.setNumber("(567) 890-6543");
        businessPhone6.setExtension("");
        if (businessPhone6.isValid()) {
            PhoneNumberFormatter.format(businessPhone6, thisLocale);
            contact6.getPhoneNumberList().add(businessPhone6);
        } else {
            System.err.println("Business4 phone is invalid: " + businessPhone6.toString());
        }
        DemoData.checkIfInserted(contact6.insert(db), (Object)contact6);
        call2 = new Call();
        call2.setContactId(contact6.getId());
        call2.setCallTypeId(callTypeList_OUTGOING_CALL);
        call2.setLength(15);
        call2.setSubject("Set up meeting for next week");
        call2.setNotes("We'll meet at Silvers");
        call2.setEnteredBy(user1Id);
        call2.setModifiedBy(user1Id);
        call2.setEntered(DemoData.addCurrentTimestamp(-7));
        call2.setModified(DemoData.addCurrentTimestamp(-7));
        call2.setAlertDate(DemoData.addCurrentTimestamp(1));
        call2.setAlertDateTimeZone(timeZone);
        call2.setAlertText("Check reservations at Silvers");
        call2.setAlertCallTypeId(callTypeList_OUTSIDE_APPT);
        call2.setOwner(user1Id);
        call2.setAssignDate(DemoData.addCurrentTimestamp(0));
        call2.setCompletedBy(user1Id);
        call2.setCompleteDate(DemoData.addCurrentTimestamp(0));
        call2.setResultId(callResultList_YES_BUS_PROGRESSING);
        call2.setPriorityId(callPriorityList_HIGH);
        call2.setStatusId(3);
        call2.setReminderId(1);
        call2.setReminderTypeId(callReminderList_HOURS);
        DemoData.checkIfInserted(call2.insert(db), (Object)call2);
        contact6 = new Contact();
        contact6.setAccessType(contactAccessTypes.getDefaultItem());
        contact6.setEnteredBy(user1Id);
        contact6.setModifiedBy(user1Id);
        contact6.setOwner(user1Id);
        contact6.setNameFirst("Slick");
        contact6.setNameLast("Crutchfield");
        contact6.setCompany("Motor Sports USA");
        businessPhone6 = new ContactPhoneNumber();
        businessPhone6.setType(1);
        businessPhone6.setEnteredBy(user1Id);
        businessPhone6.setModifiedBy(user1Id);
        businessPhone6.setNumber("(919) 556-4453");
        businessPhone6.setExtension("");
        if (businessPhone6.isValid()) {
            PhoneNumberFormatter.format(businessPhone6, thisLocale);
            contact6.getPhoneNumberList().add(businessPhone6);
        } else {
            System.err.println("Business4 phone is invalid: " + businessPhone6.toString());
        }
        businessPhone6 = new ContactPhoneNumber();
        businessPhone6.setType(7);
        businessPhone6.setEnteredBy(user1Id);
        businessPhone6.setModifiedBy(user1Id);
        businessPhone6.setNumber("(919) 889-8878");
        businessPhone6.setExtension("");
        if (businessPhone6.isValid()) {
            PhoneNumberFormatter.format(businessPhone6, thisLocale);
            contact6.getPhoneNumberList().add(businessPhone6);
        } else {
            System.err.println("Business4 phone is invalid: " + businessPhone6.toString());
        }
        businessEmail7 = new ContactEmailAddress();
        businessEmail7.setType(1);
        businessEmail7.setEnteredBy(user1Id);
        businessEmail7.setModifiedBy(user1Id);
        businessEmail7.setEmail("slick@fictitiouscompany.com");
        if (businessEmail7.isValid()) {
            emailFormatter.format(businessEmail7);
            contact6.getEmailAddressList().add(businessEmail7);
        } else {
            System.err.println("Business1 email is invalid: " + businessEmail7.toString());
        }
        DemoData.checkIfInserted(contact6.insert(db), (Object)contact6);
        ActionItem actionItem2 = new ActionItem();
        actionItem2.setActionId(actionList2.getId());
        actionItem2.setLinkItemId(contact6.getId());
        actionItem2.setEnteredBy(user1Id);
        actionItem2.setModifiedBy(user1Id);
        actionItem2.setEnabled(true);
        DemoData.checkIfInserted(actionItem2.insert(db), (Object)actionItem2);
        Call call3 = new Call();
        call3.setContactId(contact6.getId());
        call3.setCallTypeId(callTypeList_OUTGOING_CALL);
        call3.setSubject("Confirm he got presentation");
        call3.setEnteredBy(user1Id);
        call3.setModifiedBy(user1Id);
        call3.setEntered(DemoData.addCurrentTimestamp(0));
        call3.setModified(DemoData.addCurrentTimestamp(0));
        call3.setAlertDate(DemoData.addCurrentTimestamp(7));
        call3.setAlertDateTimeZone(timeZone);
        call3.setAlertText("Call back");
        call3.setActionId(actionItem2.getId());
        call3.setAlertCallTypeId(callTypeList_OUTGOING_CALL);
        call3.setOwner(user1Id);
        call3.setAssignDate(DemoData.addCurrentTimestamp(0));
        call3.setCompletedBy(user1Id);
        call3.setCompleteDate(DemoData.addCurrentTimestamp(0));
        call3.setResultId(callResultList_YES_BUS_PROGRESSING);
        call3.setPriorityId(callPriorityList_HIGH);
        call3.setStatusId(3);
        call3.setReminderId(1);
        call3.setReminderTypeId(callReminderList_HOURS);
        DemoData.checkIfInserted(call3.insert(db), (Object)call3);
        contact6 = new Contact();
        contact6.setAccessType(contactAccessTypes.getDefaultItem());
        contact6.setEnteredBy(user1Id);
        contact6.setModifiedBy(user1Id);
        contact6.setOwner(user1Id);
        contact6.setNameFirst("Fred");
        contact6.setNameLast("Davis");
        contact6.setCompany("Boating World");
        contact6.setTitle("Sales Rep");
        businessPhone6 = new ContactPhoneNumber();
        businessPhone6.setType(1);
        businessPhone6.setEnteredBy(user1Id);
        businessPhone6.setModifiedBy(user1Id);
        businessPhone6.setNumber("(443) 378-7765");
        businessPhone6.setExtension("");
        if (businessPhone6.isValid()) {
            PhoneNumberFormatter.format(businessPhone6, thisLocale);
            contact6.getPhoneNumberList().add(businessPhone6);
        } else {
            System.err.println("Business4 phone is invalid: " + businessPhone6.toString());
        }
        businessEmail7 = new ContactEmailAddress();
        businessEmail7.setType(1);
        businessEmail7.setEnteredBy(user1Id);
        businessEmail7.setModifiedBy(user1Id);
        businessEmail7.setEmail("davis@fictitiouscompany.com");
        if (businessEmail7.isValid()) {
            emailFormatter.format(businessEmail7);
            contact6.getEmailAddressList().add(businessEmail7);
        } else {
            System.err.println("Business1 email is invalid: " + businessEmail7.toString());
        }
        DemoData.checkIfInserted(contact6.insert(db), (Object)contact6);
        contact6.insertType(db, contactTypeList_CUSTOMER, 1);
        contact6.insertType(db, contactTypeList_FRIEND, 2);
        Task task4 = new Task();
        task4.setEnteredBy(user1Id);
        task4.setModifiedBy(user1Id);
        task4.setPriority(1);
        task4.setDescription("Call Fred re: meeting on the 4th");
        task4.setNotes("Confirm location and agenda");
        task4.setSharing(-1);
        task4.setOwner(user1Id);
        task4.setDueDate(DemoData.addCurrentTimestamp(1));
        task4.setDueDateTimeZone(timeZone);
        task4.setEstimatedLOE(-1.0);
        task4.setEstimatedLOEType(2);
        task4.setType(1);
        task4.setContactId(contact6.getId());
        DemoData.checkIfInserted(task4.insert(db), (Object)task4);
        contact6 = new Contact();
        contact6.setAccessType(contactAccessTypes.getDefaultItem());
        contact6.setEnteredBy(user1Id);
        contact6.setModifiedBy(user1Id);
        contact6.setOwner(user1Id);
        contact6.setNameFirst("Manny");
        contact6.setNameLast("Delmonico");
        contact6.setTitle("Taster");
        contact6.setCompany("The Great Steak Co.");
        businessPhone6 = new ContactPhoneNumber();
        businessPhone6.setType(1);
        businessPhone6.setEnteredBy(user1Id);
        businessPhone6.setModifiedBy(user1Id);
        businessPhone6.setNumber("(667) 220-4952");
        businessPhone6.setExtension("");
        if (businessPhone6.isValid()) {
            PhoneNumberFormatter.format(businessPhone6, thisLocale);
            contact6.getPhoneNumberList().add(businessPhone6);
        } else {
            System.err.println("Business4 phone is invalid: " + businessPhone6.toString());
        }
        businessPhone6 = new ContactPhoneNumber();
        businessPhone6.setType(7);
        businessPhone6.setEnteredBy(user1Id);
        businessPhone6.setModifiedBy(user1Id);
        businessPhone6.setNumber("(667) 775-4312");
        businessPhone6.setExtension("");
        if (businessPhone6.isValid()) {
            PhoneNumberFormatter.format(businessPhone6, thisLocale);
            contact6.getPhoneNumberList().add(businessPhone6);
        } else {
            System.err.println("Business4 phone is invalid: " + businessPhone6.toString());
        }
        businessEmail7 = new ContactEmailAddress();
        businessEmail7.setType(1);
        businessEmail7.setEnteredBy(user1Id);
        businessEmail7.setModifiedBy(user1Id);
        businessEmail7.setEmail("taster@fictitiouscompany.com");
        if (businessEmail7.isValid()) {
            emailFormatter.format(businessEmail7);
            contact6.getEmailAddressList().add(businessEmail7);
        } else {
            System.err.println("Business1 email is invalid: " + businessEmail7.toString());
        }
        DemoData.checkIfInserted(contact6.insert(db), (Object)contact6);
        actionItem2 = new ActionItem();
        actionItem2.setActionId(actionList1.getId());
        actionItem2.setLinkItemId(contact6.getId());
        actionItem2.setEnteredBy(user1Id);
        actionItem2.setModifiedBy(user1Id);
        actionItem2.setEnabled(true);
        DemoData.checkIfInserted(actionItem2.insert(db), (Object)actionItem2);
        call3 = new Call();
        call3.setContactId(contact6.getId());
        call3.setCallTypeId(callTypeList_OUTSIDE_APPT);
        call3.setSubject("To set up presentation");
        call3.setNotes("Wasn't in but managed to talk with assistant. I'll leave a ticket for Tom to follow up and coordinate with engineering. Assistant said he was almost sure to buy. Will also start an opportunity");
        call3.setEnteredBy(user1Id);
        call3.setModifiedBy(user1Id);
        call3.setEntered(DemoData.addCurrentTimestamp(0));
        call3.setModified(DemoData.addCurrentTimestamp(0));
        call3.setAlertDate(DemoData.addCurrentTimestamp(1));
        call3.setAlertDateTimeZone(timeZone);
        call3.setAlertText("Call back to confirm sale and send contract");
        call3.setActionId(actionItem2.getId());
        call3.setAlertCallTypeId(callTypeList_OUTSIDE_APPT);
        call3.setOwner(user1Id);
        call3.setAssignDate(DemoData.addCurrentTimestamp(0));
        call3.setCompletedBy(user1Id);
        call3.setCompleteDate(DemoData.addCurrentTimestamp(0));
        call3.setResultId(callResultList_YES_BUS_PROGRESSING);
        call3.setPriorityId(callPriorityList_HIGH);
        call3.setStatusId(3);
        call3.setReminderId(1);
        call3.setReminderTypeId(callReminderList_HOURS);
        DemoData.checkIfInserted(call3.insert(db), (Object)call3);
        OpportunityHeader opportunity3 = new OpportunityHeader();
        opportunity3.setDescription("Version Defib sale");
        opportunity3.setContactLink(contact6.getId());
        opportunity3.setEnteredBy(user1Id);
        opportunity3.setModifiedBy(user1Id);
        opportunity3.setManager(user1Id);
        opportunity3.setAccessType(oppAccessTypes.getDefaultItem());
        DemoData.checkIfInserted(opportunity3.insert(db), (Object)opportunity3);
        OpportunityComponent component3 = new OpportunityComponent();
        component3.setHeaderId(opportunity3.getId());
        component3.setOwner(user1Id);
        component3.setDescription("Latest model");
        component3.setCloseProb("80");
        component3.setCloseDate(DemoData.addCurrentTimestamp(23));
        component3.setCloseDateTimeZone(timeZone);
        component3.setGuess("28000");
        component3.setTerms(3.0);
        component3.setUnits("M");
        component3.setType("N");
        component3.setStage(stageList_NEGOTIATION);
        component3.setStageDate(DemoData.addCurrentTimestamp(-1));
        component3.setEnteredBy(user1Id);
        component3.setModifiedBy(user1Id);
        DemoData.checkIfInserted(component3.insert(db), (Object)component3);
        opportunity3.updateLog(db, actionItem2.getId());
        contact6 = new Contact();
        contact6.setAccessType(contactAccessTypes.getDefaultItem());
        contact6.setEnteredBy(user1Id);
        contact6.setModifiedBy(user1Id);
        contact6.setOwner(user1Id);
        contact6.setNameFirst("David");
        contact6.setNameLast("Jones");
        contact6.setTitle("President");
        contact6.setCompany("Jones Co.");
        businessPhone6 = new ContactPhoneNumber();
        businessPhone6.setType(1);
        businessPhone6.setEnteredBy(user1Id);
        businessPhone6.setModifiedBy(user1Id);
        businessPhone6.setNumber("(757) 555-0812");
        businessPhone6.setExtension("");
        if (businessPhone6.isValid()) {
            PhoneNumberFormatter.format(businessPhone6, thisLocale);
            contact6.getPhoneNumberList().add(businessPhone6);
        } else {
            System.err.println("Business4 phone is invalid: " + businessPhone6.toString());
        }
        businessEmail7 = new ContactEmailAddress();
        businessEmail7.setType(1);
        businessEmail7.setEnteredBy(user1Id);
        businessEmail7.setModifiedBy(user1Id);
        businessEmail7.setEmail("david@jonesco.com");
        if (businessEmail7.isValid()) {
            emailFormatter.format(businessEmail7);
            contact6.getEmailAddressList().add(businessEmail7);
        } else {
            System.err.println("Business1 email is invalid: " + businessEmail7.toString());
        }
        DemoData.checkIfInserted(contact6.insert(db), (Object)contact6);
        contact6.insertType(db, contactTypeList_FRIEND, 1);
        contact6.insertType(db, contactTypeList_PROSPECT, 2);
        contact6 = new Contact();
        contact6.setAccessType(contactAccessTypes.getDefaultItem());
        contact6.setEnteredBy(user1Id);
        contact6.setModifiedBy(user1Id);
        contact6.setOwner(user1Id);
        contact6.setNameFirst("Alice");
        contact6.setNameLast("Silver");
        contact6.setTitle("Operations Assistant");
        contact6.setCompany("Baker Company");
        businessPhone6 = new ContactPhoneNumber();
        businessPhone6.setType(1);
        businessPhone6.setEnteredBy(user1Id);
        businessPhone6.setModifiedBy(user1Id);
        businessPhone6.setNumber("(567) 890-6009");
        businessPhone6.setExtension("");
        if (businessPhone6.isValid()) {
            PhoneNumberFormatter.format(businessPhone6, thisLocale);
            contact6.getPhoneNumberList().add(businessPhone6);
        } else {
            System.err.println("Business4 phone is invalid: " + businessPhone6.toString());
        }
        DemoData.checkIfInserted(contact6.insert(db), (Object)contact6);
        contact6.insertType(db, contactTypeList_PROSPECT, 1);
        actionItem2 = new ActionItem();
        actionItem2.setActionId(actionList1.getId());
        actionItem2.setLinkItemId(contact6.getId());
        actionItem2.setEnteredBy(user1Id);
        actionItem2.setModifiedBy(user1Id);
        actionItem2.setEnabled(true);
        DemoData.checkIfInserted(actionItem2.insert(db), (Object)actionItem2);
        contact6 = new Contact();
        contact6.setAccessType(contactAccessTypes.getDefaultItem());
        contact6.setEnteredBy(user1Id);
        contact6.setModifiedBy(user1Id);
        contact6.setOwner(user1Id);
        contact6.setNameFirst("Willie");
        contact6.setNameLast("Sosa");
        contact6.setTitle("Delivery man");
        contact6.setCompany("Chicago Pizza");
        businessEmail7 = new ContactEmailAddress();
        businessEmail7.setType(1);
        businessEmail7.setEnteredBy(user1Id);
        businessEmail7.setModifiedBy(user1Id);
        businessEmail7.setEmail("willie.s@fictitiouscompany.com");
        if (businessEmail7.isValid()) {
            emailFormatter.format(businessEmail7);
            contact6.getEmailAddressList().add(businessEmail7);
        } else {
            System.err.println("Business1 email is invalid: " + businessEmail7.toString());
        }
        DemoData.checkIfInserted(contact6.insert(db), (Object)contact6);
        contact6.insertType(db, contactTypeList_VENDOR, 1);
        actionItem2 = new ActionItem();
        actionItem2.setActionId(actionList1.getId());
        actionItem2.setLinkItemId(contact6.getId());
        actionItem2.setEnteredBy(user1Id);
        actionItem2.setModifiedBy(user1Id);
        actionItem2.setEnabled(true);
        DemoData.checkIfInserted(actionItem2.insert(db), (Object)actionItem2);
        Project project = new Project();
        project.setTitle("AAA Automotive Gork Implementation Timeline");
        project.setShortDescription("The overview project plan to implement the Gork for AAA Automotive");
        project.setRequestedBy("John Robinson");
        project.setRequestedByDept("Robinson Electronics");
        project.setRequestDate(DemoData.addCurrentTimestamp(0));
        project.setRequestDateTimeZone(timeZone);
        project.setApprovalDate(DemoData.addCurrentTimestamp(0));
        project.setEntered(DemoData.addCurrentTimestamp(0));
        project.setEnteredBy(user1Id);
        project.setModified(DemoData.addCurrentTimestamp(0));
        project.setModifiedBy(user1Id);
        project.setShowNews(true);
        project.setShowDetails(true);
        project.setShowTeam(true);
        project.setShowPlan(true);
        project.setShowLists(true);
        project.setShowDiscussion(true);
        project.setShowTickets(true);
        project.setShowDocuments(true);
        project.setEstimatedCloseDate(DemoData.addCurrentTimestamp(60));
        project.setEstimatedCloseDateTimeZone(timeZone);
        project.setBudget(20000.0);
        project.setBudgetCurrency("USD");
        DemoData.checkIfInserted(project.insert(db), project);
        TeamMember teamMember = new TeamMember();
        teamMember.setProjectId(project.getId());
        teamMember.setUserId(user1Id);
        teamMember.setUserLevel(projectRoleList_LEAD);
        teamMember.setEnteredBy(user1Id);
        teamMember.setModifiedBy(user1Id);
        teamMember.setStatus(-1);
        DemoData.checkIfInserted(teamMember.insert(db), teamMember);
        teamMember = new TeamMember();
        teamMember.setProjectId(project.getId());
        teamMember.setUserId(user2Id);
        teamMember.setUserLevel(projectRoleList_OBSERVER);
        teamMember.setEnteredBy(user1Id);
        teamMember.setModifiedBy(user1Id);
        teamMember.setStatus(1);
        DemoData.checkIfInserted(teamMember.insert(db), teamMember);
        teamMember = new TeamMember();
        teamMember.setProjectId(project.getId());
        teamMember.setUserId(user3Id);
        teamMember.setUserLevel(projectRoleList_CONTRIBUTOR);
        teamMember.setEnteredBy(user1Id);
        teamMember.setModifiedBy(user1Id);
        teamMember.setStatus(1);
        DemoData.checkIfInserted(teamMember.insert(db), teamMember);
        NewsArticle newsArticle = new NewsArticle();
        newsArticle.setProjectId(project.getId());
        newsArticle.setSubject("Welcome new team members");
        newsArticle.setIntro("Welcome to the project new team members.  We look forward to providing AAA Automotive with the very best experience as they're one of our most valuable customers.  We'll make them happy if we all remember:<br /><br /><ul><li>Leave the weapons at home<br /></li><li>No drinking on the job</li><li>Get a good night sleep</li></ul>Thanks,<br /><br />Your team leader<br />");
        newsArticle.setEnteredBy(user1Id);
        newsArticle.setModifiedBy(user1Id);
        newsArticle.setStartDate(DemoData.addCurrentTimestamp(0));
        newsArticle.setStartDateTimeZone(timeZone);
        newsArticle.setPriorityId(10);
        newsArticle.setStatus(2);
        newsArticle.setEndDateTimeZone(timeZone);
        DemoData.checkIfInserted(newsArticle.insert(db), newsArticle);
        Requirement requirement = new Requirement();
        requirement.setProjectId(project.getId());
        requirement.setSubmittedBy("B. Franklin");
        requirement.setDepartmentBy("Postal");
        requirement.setShortDescription("Delivery");
        requirement.setDescription("These are the 10 -15 steps of the delivery process.  If we do these well we'll succeed");
        requirement.setEstimatedLoe("100");
        requirement.setEstimatedLoeTypeId(2);
        requirement.setActualLoeType("2");
        requirement.setDeadline(DemoData.addCurrentTimestamp(60));
        requirement.setApprovedBy(user1Id);
        requirement.setApprovalDate(DemoData.addCurrentTimestamp(0));
        requirement.setEntered(DemoData.addCurrentTimestamp(0));
        requirement.setEnteredBy(user1Id);
        requirement.setModified(DemoData.addCurrentTimestamp(0));
        requirement.setModifiedBy(user1Id);
        requirement.setStartDate(DemoData.addCurrentTimestamp(3));
        requirement.setStartDateTimeZone(timeZone);
        requirement.setDeadlineTimeZone(timeZone);
        DemoData.checkIfInserted(requirement.insert(db), requirement);
        AssignmentFolder assignmentFolder = new AssignmentFolder();
        assignmentFolder.setProjectId(project.getId());
        assignmentFolder.setRequirementId(requirement.getId());
        assignmentFolder.setIndent(0);
        assignmentFolder.setName("Hardware Ordering");
        assignmentFolder.setDescription(null);
        assignmentFolder.setEnteredBy(user1Id);
        assignmentFolder.setModifiedBy(user1Id);
        DemoData.checkIfInserted(assignmentFolder.insert(db), assignmentFolder);
        Assignment assignment = new Assignment();
        assignment.setProjectId(project.getId());
        assignment.setRequirementId(requirement.getId());
        assignment.setIndent(1);
        assignment.setUserAssignedId(user1Id);
        assignment.setRole("Order materials");
        assignment.setEstimatedLoe(5);
        assignment.setEstimatedLoeTypeId(2);
        assignment.setActualLoeTypeId(2);
        assignment.setPriorityId(2);
        assignment.setAssignDate(DemoData.addCurrentTimestamp(0));
        assignment.setStartDate(DemoData.addCurrentTimestamp(0));
        assignment.setDueDate(DemoData.addCurrentTimestamp(6));
        assignment.setStatusId(5);
        assignment.setStatusDate(DemoData.addCurrentTimestamp(0));
        assignment.setCompleteDate(DemoData.addCurrentTimestamp(0));
        assignment.setEntered(DemoData.addCurrentTimestamp(0));
        assignment.setEnteredBy(user1Id);
        assignment.setModified(DemoData.addCurrentTimestamp(0));
        assignment.setModifiedBy(user1Id);
        assignment.setFolderId(assignmentFolder.getId());
        assignment.setDueDateTimeZone(timeZone);
        DemoData.checkIfInserted(assignment.insert(db), assignment);
        assignment = new Assignment();
        assignment.setProjectId(project.getId());
        assignment.setRequirementId(requirement.getId());
        assignment.setIndent(1);
        assignment.setUserAssignedId(user3Id);
        assignment.setRole("Check to see if order received");
        assignment.setEstimatedLoe(1);
        assignment.setEstimatedLoeTypeId(2);
        assignment.setActualLoeTypeId(2);
        assignment.setPriorityId(2);
        assignment.setAssignDate(DemoData.addCurrentTimestamp(0));
        assignment.setStartDate(DemoData.addCurrentTimestamp(0));
        assignment.setStatusId(5);
        assignment.setStatusDate(DemoData.addCurrentTimestamp(0));
        assignment.setCompleteDate(DemoData.addCurrentTimestamp(0));
        assignment.setEntered(DemoData.addCurrentTimestamp(0));
        assignment.setEnteredBy(user1Id);
        assignment.setModified(DemoData.addCurrentTimestamp(0));
        assignment.setModifiedBy(user1Id);
        assignment.setDueDateTimeZone(timeZone);
        DemoData.checkIfInserted(assignment.insert(db), assignment);
        assignment = new Assignment();
        assignment.setProjectId(project.getId());
        assignment.setRequirementId(requirement.getId());
        assignment.setIndent(1);
        assignment.setUserAssignedId(user2Id);
        assignment.setRole("Send received equipment to project lead");
        assignment.setEstimatedLoe(1);
        assignment.setEstimatedLoeTypeId(2);
        assignment.setActualLoeTypeId(2);
        assignment.setPriorityId(2);
        assignment.setAssignDate(DemoData.addCurrentTimestamp(0));
        assignment.setStartDate(DemoData.addCurrentTimestamp(0));
        assignment.setStatusId(3);
        assignment.setStatusDate(DemoData.addCurrentTimestamp(0));
        assignment.setEntered(DemoData.addCurrentTimestamp(0));
        assignment.setEnteredBy(user1Id);
        assignment.setModified(DemoData.addCurrentTimestamp(0));
        assignment.setModifiedBy(user1Id);
        assignment.setDueDateTimeZone(timeZone);
        DemoData.checkIfInserted(assignment.insert(db), assignment);
        assignment = new Assignment();
        assignment.setProjectId(project.getId());
        assignment.setRequirementId(requirement.getId());
        assignment.setIndent(1);
        assignment.setUserAssignedId(user1Id);
        assignment.setRole("Confirm delivery");
        assignment.setEstimatedLoe(2);
        assignment.setEstimatedLoeTypeId(2);
        assignment.setActualLoeTypeId(2);
        assignment.setPriorityId(2);
        assignment.setAssignDate(DemoData.addCurrentTimestamp(0));
        assignment.setDueDate(DemoData.addCurrentTimestamp(14));
        assignment.setStatusId(1);
        assignment.setStatusDate(DemoData.addCurrentTimestamp(0));
        assignment.setEntered(DemoData.addCurrentTimestamp(0));
        assignment.setEnteredBy(user1Id);
        assignment.setModified(DemoData.addCurrentTimestamp(0));
        assignment.setModifiedBy(user1Id);
        assignment.setDueDateTimeZone(timeZone);
        DemoData.checkIfInserted(assignment.insert(db), assignment);
        assignment = new Assignment();
        assignment.setProjectId(project.getId());
        assignment.setRequirementId(requirement.getId());
        assignment.setIndent(1);
        assignment.setUserAssignedId(user1Id);
        assignment.setRole("Complete asset information form in Centric CRM");
        assignment.setEstimatedLoe(1);
        assignment.setEstimatedLoeTypeId(2);
        assignment.setActualLoeTypeId(2);
        assignment.setPriorityId(2);
        assignment.setAssignDate(DemoData.addCurrentTimestamp(0));
        assignment.setDueDate(DemoData.addCurrentTimestamp(15));
        assignment.setStatusId(1);
        assignment.setStatusDate(DemoData.addCurrentTimestamp(0));
        assignment.setEntered(DemoData.addCurrentTimestamp(0));
        assignment.setEnteredBy(user1Id);
        assignment.setModified(DemoData.addCurrentTimestamp(0));
        assignment.setModifiedBy(user1Id);
        assignment.setDueDateTimeZone(timeZone);
        DemoData.checkIfInserted(assignment.insert(db), assignment);
        assignmentFolder = new AssignmentFolder();
        assignmentFolder.setProjectId(project.getId());
        assignmentFolder.setRequirementId(requirement.getId());
        assignmentFolder.setIndent(0);
        assignmentFolder.setName("Installation");
        assignmentFolder.setDescription(null);
        assignmentFolder.setEnteredBy(user1Id);
        assignmentFolder.setModifiedBy(user1Id);
        DemoData.checkIfInserted(assignmentFolder.insert(db), assignmentFolder);
        assignment = new Assignment();
        assignment.setProjectId(project.getId());
        assignment.setRequirementId(requirement.getId());
        assignment.setIndent(1);
        assignment.setUserAssignedId(user3Id);
        assignment.setRole("Site prep'd");
        assignment.setEstimatedLoe(16);
        assignment.setEstimatedLoeTypeId(2);
        assignment.setActualLoeTypeId(2);
        assignment.setPriorityId(2);
        assignment.setAssignDate(DemoData.addCurrentTimestamp(0));
        assignment.setStartDate(DemoData.addCurrentTimestamp(0));
        assignment.setDueDate(DemoData.addCurrentTimestamp(10));
        assignment.setStatusId(5);
        assignment.setStatusDate(DemoData.addCurrentTimestamp(0));
        assignment.setCompleteDate(DemoData.addCurrentTimestamp(0));
        assignment.setEntered(DemoData.addCurrentTimestamp(0));
        assignment.setEnteredBy(user1Id);
        assignment.setModified(DemoData.addCurrentTimestamp(0));
        assignment.setModifiedBy(user1Id);
        assignment.setFolderId(assignmentFolder.getId());
        assignment.setDueDateTimeZone(timeZone);
        DemoData.checkIfInserted(assignment.insert(db), assignment);
        assignment = new Assignment();
        assignment.setProjectId(project.getId());
        assignment.setRequirementId(requirement.getId());
        assignment.setIndent(1);
        assignment.setUserAssignedId(user2Id);
        assignment.setRole("Hardware installed");
        assignment.setEstimatedLoe(12);
        assignment.setEstimatedLoeTypeId(2);
        assignment.setActualLoeTypeId(2);
        assignment.setPriorityId(2);
        assignment.setAssignDate(DemoData.addCurrentTimestamp(0));
        assignment.setDueDate(DemoData.addCurrentTimestamp(11));
        assignment.setStatusId(1);
        assignment.setStatusDate(DemoData.addCurrentTimestamp(0));
        assignment.setEntered(DemoData.addCurrentTimestamp(0));
        assignment.setEnteredBy(user1Id);
        assignment.setModified(DemoData.addCurrentTimestamp(0));
        assignment.setModifiedBy(user1Id);
        assignment.setDueDateTimeZone(timeZone);
        DemoData.checkIfInserted(assignment.insert(db), assignment);
        assignment = new Assignment();
        assignment.setProjectId(project.getId());
        assignment.setRequirementId(requirement.getId());
        assignment.setIndent(1);
        assignment.setUserAssignedId(user1Id);
        assignment.setRole("Hardware QA'd");
        assignment.setEstimatedLoe(12);
        assignment.setEstimatedLoeTypeId(2);
        assignment.setActualLoeTypeId(2);
        assignment.setPriorityId(2);
        assignment.setAssignDate(DemoData.addCurrentTimestamp(0));
        assignment.setDueDate(DemoData.addCurrentTimestamp(15));
        assignment.setStatusId(1);
        assignment.setStatusDate(DemoData.addCurrentTimestamp(0));
        assignment.setEntered(DemoData.addCurrentTimestamp(0));
        assignment.setEnteredBy(user1Id);
        assignment.setModified(DemoData.addCurrentTimestamp(0));
        assignment.setModifiedBy(user1Id);
        assignment.setDueDateTimeZone(timeZone);
        DemoData.checkIfInserted(assignment.insert(db), assignment);
        assignment = new Assignment();
        assignment.setProjectId(project.getId());
        assignment.setRequirementId(requirement.getId());
        assignment.setIndent(1);
        assignment.setUserAssignedId(user3Id);
        assignment.setRole("Project Manager notified");
        assignment.setEstimatedLoe(1);
        assignment.setEstimatedLoeTypeId(2);
        assignment.setActualLoeTypeId(2);
        assignment.setPriorityId(2);
        assignment.setAssignDate(DemoData.addCurrentTimestamp(0));
        assignment.setDueDate(DemoData.addCurrentTimestamp(15));
        assignment.setStatusId(1);
        assignment.setStatusDate(DemoData.addCurrentTimestamp(0));
        assignment.setEntered(DemoData.addCurrentTimestamp(0));
        assignment.setEnteredBy(user1Id);
        assignment.setModified(DemoData.addCurrentTimestamp(0));
        assignment.setModifiedBy(user1Id);
        assignment.setDueDateTimeZone(timeZone);
        DemoData.checkIfInserted(assignment.insert(db), assignment);
        requirement = new Requirement();
        requirement.setProjectId(project.getId());
        requirement.setSubmittedBy("T. Jefferson");
        requirement.setDepartmentBy("Louisiana Warehouse");
        requirement.setShortDescription("Training");
        requirement.setDescription("Two basic groups have to be trained.  The administrator and the \"Train-the-Trainor\"");
        requirement.setEstimatedLoe("24");
        requirement.setEstimatedLoeTypeId(2);
        requirement.setActualLoeType("2");
        requirement.setDeadline(DemoData.addCurrentTimestamp(35));
        requirement.setApprovedBy(user1Id);
        requirement.setApprovalDate(DemoData.addCurrentTimestamp(0));
        requirement.setEntered(DemoData.addCurrentTimestamp(0));
        requirement.setEnteredBy(user1Id);
        requirement.setModified(DemoData.addCurrentTimestamp(0));
        requirement.setModifiedBy(user1Id);
        requirement.setStartDate(DemoData.addCurrentTimestamp(18));
        requirement.setStartDateTimeZone(timeZone);
        requirement.setDeadlineTimeZone(timeZone);
        DemoData.checkIfInserted(requirement.insert(db), requirement);
        assignmentFolder = new AssignmentFolder();
        assignmentFolder.setProjectId(project.getId());
        assignmentFolder.setRequirementId(requirement.getId());
        assignmentFolder.setIndent(0);
        assignmentFolder.setName("Administrator");
        assignmentFolder.setDescription(null);
        assignmentFolder.setEnteredBy(user1Id);
        assignmentFolder.setModifiedBy(user1Id);
        DemoData.checkIfInserted(assignmentFolder.insert(db), assignmentFolder);
        assignment = new Assignment();
        assignment.setProjectId(project.getId());
        assignment.setRequirementId(requirement.getId());
        assignment.setIndent(1);
        assignment.setUserAssignedId(user3Id);
        assignment.setRole("Send data capture worksheet to administrator/s");
        assignment.setEstimatedLoe(2);
        assignment.setEstimatedLoeTypeId(2);
        assignment.setActualLoeTypeId(2);
        assignment.setPriorityId(2);
        assignment.setAssignDate(DemoData.addCurrentTimestamp(0));
        assignment.setStartDate(DemoData.addCurrentTimestamp(0));
        assignment.setDueDate(DemoData.addCurrentTimestamp(3));
        assignment.setStatusId(5);
        assignment.setStatusDate(DemoData.addCurrentTimestamp(0));
        assignment.setCompleteDate(DemoData.addCurrentTimestamp(0));
        assignment.setEntered(DemoData.addCurrentTimestamp(0));
        assignment.setEnteredBy(user1Id);
        assignment.setModified(DemoData.addCurrentTimestamp(0));
        assignment.setModifiedBy(user1Id);
        assignment.setFolderId(assignmentFolder.getId());
        assignment.setDueDateTimeZone(timeZone);
        DemoData.checkIfInserted(assignment.insert(db), assignment);
        assignment = new Assignment();
        assignment.setProjectId(project.getId());
        assignment.setRequirementId(requirement.getId());
        assignment.setIndent(1);
        assignment.setUserAssignedId(user1Id);
        assignment.setRole("Enter data from worksheets into CentricCRM document mgr");
        assignment.setEstimatedLoe(1);
        assignment.setEstimatedLoeTypeId(2);
        assignment.setActualLoeTypeId(2);
        assignment.setPriorityId(2);
        assignment.setAssignDate(DemoData.addCurrentTimestamp(0));
        assignment.setStartDate(DemoData.addCurrentTimestamp(0));
        assignment.setDueDate(DemoData.addCurrentTimestamp(6));
        assignment.setStatusId(5);
        assignment.setStatusDate(DemoData.addCurrentTimestamp(0));
        assignment.setCompleteDate(DemoData.addCurrentTimestamp(0));
        assignment.setEntered(DemoData.addCurrentTimestamp(0));
        assignment.setEnteredBy(user1Id);
        assignment.setModified(DemoData.addCurrentTimestamp(0));
        assignment.setModifiedBy(user1Id);
        assignment.setFolderId(assignmentFolder.getId());
        assignment.setDueDateTimeZone(timeZone);
        DemoData.checkIfInserted(assignment.insert(db), assignment);
        assignment = new Assignment();
        assignment.setProjectId(project.getId());
        assignment.setRequirementId(requirement.getId());
        assignment.setIndent(1);
        assignment.setUserAssignedId(user2Id);
        assignment.setRole("Train administrator based on feedback after installation");
        assignment.setEstimatedLoe(8);
        assignment.setEstimatedLoeTypeId(2);
        assignment.setActualLoeTypeId(2);
        assignment.setPriorityId(2);
        assignment.setAssignDate(DemoData.addCurrentTimestamp(0));
        assignment.setDueDate(DemoData.addCurrentTimestamp(25));
        assignment.setStatusId(1);
        assignment.setStatusDate(DemoData.addCurrentTimestamp(0));
        assignment.setEntered(DemoData.addCurrentTimestamp(0));
        assignment.setEnteredBy(user1Id);
        assignment.setModified(DemoData.addCurrentTimestamp(0));
        assignment.setModifiedBy(user1Id);
        assignment.setFolderId(assignmentFolder.getId());
        assignment.setDueDateTimeZone(timeZone);
        DemoData.checkIfInserted(assignment.insert(db), assignment);
        assignmentFolder = new AssignmentFolder();
        assignmentFolder.setProjectId(project.getId());
        assignmentFolder.setRequirementId(requirement.getId());
        assignmentFolder.setIndent(0);
        assignmentFolder.setName("Train-the-Trainor");
        assignmentFolder.setDescription(null);
        assignmentFolder.setEnteredBy(user1Id);
        assignmentFolder.setModifiedBy(user1Id);
        DemoData.checkIfInserted(assignmentFolder.insert(db), assignmentFolder);
        assignment = new Assignment();
        assignment.setProjectId(project.getId());
        assignment.setRequirementId(requirement.getId());
        assignment.setIndent(1);
        assignment.setUserAssignedId(user1Id);
        assignment.setRole("Send data worksheets to capture info on users");
        assignment.setEstimatedLoe(2);
        assignment.setEstimatedLoeTypeId(2);
        assignment.setActualLoeTypeId(2);
        assignment.setPriorityId(2);
        assignment.setAssignDate(DemoData.addCurrentTimestamp(0));
        assignment.setStartDate(DemoData.addCurrentTimestamp(0));
        assignment.setDueDate(DemoData.addCurrentTimestamp(6));
        assignment.setStatusId(5);
        assignment.setStatusDate(DemoData.addCurrentTimestamp(0));
        assignment.setCompleteDate(DemoData.addCurrentTimestamp(0));
        assignment.setEntered(DemoData.addCurrentTimestamp(0));
        assignment.setEnteredBy(user1Id);
        assignment.setModified(DemoData.addCurrentTimestamp(0));
        assignment.setModifiedBy(user1Id);
        assignment.setFolderId(assignmentFolder.getId());
        assignment.setDueDateTimeZone(timeZone);
        DemoData.checkIfInserted(assignment.insert(db), assignment);
        assignment = new Assignment();
        assignment.setProjectId(project.getId());
        assignment.setRequirementId(requirement.getId());
        assignment.setIndent(1);
        assignment.setUserAssignedId(user3Id);
        assignment.setRole("Analyze data and format into training materials");
        assignment.setEstimatedLoe(8);
        assignment.setEstimatedLoeTypeId(2);
        assignment.setActualLoeTypeId(2);
        assignment.setPriorityId(2);
        assignment.setAssignDate(DemoData.addCurrentTimestamp(0));
        assignment.setStartDate(DemoData.addCurrentTimestamp(0));
        assignment.setDueDate(DemoData.addCurrentTimestamp(14));
        assignment.setStatusId(2);
        assignment.setStatusDate(DemoData.addCurrentTimestamp(0));
        assignment.setEntered(DemoData.addCurrentTimestamp(0));
        assignment.setEnteredBy(user1Id);
        assignment.setModified(DemoData.addCurrentTimestamp(0));
        assignment.setModifiedBy(user1Id);
        assignment.setDueDateTimeZone(timeZone);
        DemoData.checkIfInserted(assignment.insert(db), assignment);
        assignment = new Assignment();
        assignment.setProjectId(project.getId());
        assignment.setRequirementId(requirement.getId());
        assignment.setIndent(1);
        assignment.setUserAssignedId(user2Id);
        assignment.setRole("Train-the-trainer");
        assignment.setEstimatedLoe(16);
        assignment.setEstimatedLoeTypeId(2);
        assignment.setActualLoeTypeId(2);
        assignment.setPriorityId(2);
        assignment.setAssignDate(DemoData.addCurrentTimestamp(0));
        assignment.setDueDate(DemoData.addCurrentTimestamp(28));
        assignment.setStatusId(1);
        assignment.setStatusDate(DemoData.addCurrentTimestamp(0));
        assignment.setEntered(DemoData.addCurrentTimestamp(0));
        assignment.setEnteredBy(user1Id);
        assignment.setModified(DemoData.addCurrentTimestamp(0));
        assignment.setModifiedBy(user1Id);
        assignment.setFolderId(assignmentFolder.getId());
        assignment.setDueDateTimeZone(timeZone);
        DemoData.checkIfInserted(assignment.insert(db), assignment);
        IssueCategory issueCategory = new IssueCategory();
        issueCategory.setProjectId(project.getId());
        issueCategory.setSubject("Technical Musings");
        issueCategory.setEnteredBy(user1Id);
        issueCategory.setModifiedBy(user1Id);
        DemoData.checkIfInserted(issueCategory.insert(db), issueCategory);
        FileFolder fileFolder = new FileFolder();
        fileFolder.setLinkModuleId(4);
        fileFolder.setLinkItemId(project.getId());
        fileFolder.setSubject("Technical Docs");
        fileFolder.setEnteredBy(user1Id);
        fileFolder.setModifiedBy(user1Id);
        DemoData.checkIfInserted(fileFolder.insert(db), fileFolder);
        fileFolder = new FileFolder();
        fileFolder.setLinkModuleId(4);
        fileFolder.setLinkItemId(project.getId());
        fileFolder.setSubject("Marketing Docs");
        fileFolder.setEnteredBy(user1Id);
        fileFolder.setModifiedBy(user1Id);
        DemoData.checkIfInserted(fileFolder.insert(db), fileFolder);
        fileFolder = new FileFolder();
        fileFolder.setLinkModuleId(4);
        fileFolder.setLinkItemId(project.getId());
        fileFolder.setSubject("Specifications");
        fileFolder.setEnteredBy(user1Id);
        fileFolder.setModifiedBy(user1Id);
        DemoData.checkIfInserted(fileFolder.insert(db), fileFolder);
        fileFolder = new FileFolder();
        fileFolder.setLinkModuleId(4);
        fileFolder.setLinkItemId(project.getId());
        fileFolder.setSubject("Group Time Sheets");
        fileFolder.setEnteredBy(user1Id);
        fileFolder.setModifiedBy(user1Id);
        DemoData.checkIfInserted(fileFolder.insert(db), fileFolder);
        return true;
    }
}

