/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.service.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;

public class ProcessLog
extends GenericBean {
    private int id = -1;
    private int systemId = -1;
    private int clientId = -1;
    private String name = null;
    private String version = null;
    private int status = -1;
    private String message = null;
    private Timestamp entered = null;

    public ProcessLog() {
    }

    public ProcessLog(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public ProcessLog(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setSystemId(int tmp) {
        this.systemId = tmp;
    }

    public void setSystemId(String tmp) {
        this.systemId = Integer.parseInt(tmp);
    }

    public void setClientId(int tmp) {
        this.clientId = tmp;
    }

    public void setClientId(String tmp) {
        this.clientId = Integer.parseInt(tmp);
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setVersion(String tmp) {
        this.version = tmp;
    }

    public void setStatus(int tmp) {
        this.status = tmp;
    }

    public void setStatus(String tmp) {
        this.status = Integer.parseInt(tmp);
    }

    public void setMessage(String tmp) {
        this.message = tmp;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DateUtils.parseTimestampString(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getSystemId() {
        return this.systemId;
    }

    public int getClientId() {
        return this.clientId;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public int getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public String getEnteredString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Process Log ID");
        }
        PreparedStatement pst = db.prepareStatement("SELECT p.* FROM process_log p WHERE p.process_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (id == -1) {
            throw new SQLException("Process Log not found");
        }
    }

    public void insert(Connection db) throws SQLException {
        if (this.systemId == -1 || this.clientId == -1) {
            throw new SQLException("Log Entry must be associated with a System and Client");
        }
        StringBuffer sql = new StringBuffer();
        try {
            this.id = DatabaseUtils.getNextSeq(db, "process_log_process_id_seq");
            sql.append("INSERT INTO process_log (system_id, client_id, process_name, process_version, status, ");
            if (this.id > -1) {
                sql.append("process_id, ");
            }
            if (this.entered != null) {
                sql.append("entered, ");
            }
            sql.append("message ) ");
            sql.append("VALUES (?, ?, ?, ?, ?, ");
            if (this.id > -1) {
                sql.append("?, ");
            }
            if (this.entered != null) {
                sql.append("?, ");
            }
            sql.append("?) ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            pst.setInt(++i, this.systemId);
            pst.setInt(++i, this.clientId);
            pst.setString(++i, this.name);
            pst.setString(++i, this.version);
            pst.setInt(++i, this.status);
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            if (this.entered != null) {
                pst.setTimestamp(++i, this.entered);
            }
            pst.setString(++i, this.message);
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "process_log_process_id_seq", this.id);
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Process Log ID not specified.");
        }
        PreparedStatement pst = db.prepareStatement("DELETE FROM process_log WHERE process_id = ? ");
        pst.setInt(1, this.getId());
        pst.executeUpdate();
        pst.close();
        return true;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("process_id");
        this.systemId = rs.getInt("system_id");
        this.clientId = rs.getInt("client_id");
        this.entered = rs.getTimestamp("entered");
        this.name = rs.getString("process_name");
        this.version = rs.getString("process_version");
        this.status = rs.getInt("status");
        this.message = rs.getString("message");
    }
}

