/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.service.base;

import com.darkhorseventures.framework.actions.ActionContext;
import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.utils.DatabaseUtils;

public class SyncClient
extends GenericBean {
    private int id = -1;
    private String type = null;
    private String version = null;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;
    private Timestamp anchor = null;
    private boolean enabled = false;
    private String code = null;

    public SyncClient() {
    }

    public SyncClient(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public SyncClient(Connection db, int clientId) throws SQLException {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("SyncClient-> Looking up: " + clientId);
        }
        PreparedStatement pst = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM sync_client WHERE client_id = ? ");
        pst = db.prepareStatement(sql.toString());
        pst.setInt(1, clientId);
        rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Sync Client record not found.");
        }
    }

    public boolean checkNormalSync(Connection db) throws SQLException {
        boolean result = false;
        PreparedStatement pst = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM sync_client WHERE client_id = ? ");
        if (this.anchor == null) {
            sql.append("AND anchor is null ");
        } else {
            sql.append("AND anchor = ? ");
        }
        pst = db.prepareStatement(sql.toString());
        pst.setInt(1, this.id);
        if (this.anchor != null) {
            pst.setTimestamp(2, this.anchor);
        }
        result = (rs = pst.executeQuery()).next();
        rs.close();
        pst.close();
        return result;
    }

    public boolean updateSyncAnchor(Connection db) throws SQLException {
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE sync_client SET anchor = ? WHERE client_id = ? ");
        pst = db.prepareStatement(sql.toString());
        pst.setTimestamp(1, this.anchor);
        pst.setInt(2, this.id);
        pst.executeUpdate();
        pst.close();
        return true;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setType(String tmp) {
        this.type = tmp;
    }

    public void setVersion(String tmp) {
        this.version = tmp;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setAnchor(Timestamp tmp) {
        this.anchor = tmp;
    }

    public int getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getAnchor() {
        return this.anchor;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String tmp) {
        this.code = tmp;
    }

    public boolean insert(Connection db) throws SQLException {
        if (this.id == -1) {
            this.id = DatabaseUtils.getNextSeq(db, "sync_client_client_id_seq");
        }
        PreparedStatement pst = db.prepareStatement("INSERT INTO sync_client (" + (this.id > -1 ? "client_id, " : "") + "" + DatabaseUtils.addQuotes(db, "type") + ", " + DatabaseUtils.addQuotes(db, "version") + ", enabled, code, enteredby, modifiedby) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?) ");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setString(++i, this.type);
        pst.setString(++i, this.version);
        pst.setBoolean(++i, this.enabled);
        pst.setString(++i, this.code);
        pst.setInt(++i, this.getEnteredBy());
        pst.setInt(++i, this.getModifiedBy());
        pst.execute();
        pst.close();
        if (this.id == -1) {
            this.id = DatabaseUtils.getCurrVal(db, "sync_client_client_id_seq", this.id);
        }
        return true;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("ID was not specified");
        }
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = null;
            pst = db.prepareStatement("DELETE FROM sync_map WHERE client_id = ? ");
            pst.setInt(1, this.id);
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE FROM sync_conflict_log WHERE client_id = ? ");
            pst.setInt(1, this.id);
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE FROM sync_log WHERE client_id = ? ");
            pst.setInt(1, this.id);
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE FROM process_log WHERE client_id = ? ");
            pst.setInt(1, this.id);
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE FROM sync_client WHERE client_id = ? ");
            pst.setInt(1, this.id);
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
    }

    public int update(Connection db, ActionContext context) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Call ID was not specified");
        }
        int resultCount = 0;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE sync_client SET " + DatabaseUtils.addQuotes(db, "type") + " = ?, " + DatabaseUtils.addQuotes(db, "version") + " = ?, code = ?, modifiedby = ?, " + "enabled = ?, " + "modified = CURRENT_TIMESTAMP " + "WHERE client_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setString(++i, this.type);
        pst.setString(++i, this.version);
        pst.setString(++i, this.code);
        pst.setInt(++i, this.modifiedBy);
        pst.setBoolean(++i, this.enabled);
        pst.setInt(++i, this.id);
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("client_id");
        this.type = rs.getString("type");
        this.version = rs.getString("version");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.anchor = rs.getTimestamp("anchor");
        this.enabled = rs.getBoolean("enabled");
        this.code = rs.getString("code");
    }
}

