/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.service.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;

public class SyncClientManager
extends Hashtable {
    public Hashtable addClient(Connection db, int clientId) throws SQLException {
        if (this.containsKey(new Integer(clientId))) {
            return (Hashtable)this.get(new Integer(clientId));
        }
        Hashtable client = new Hashtable();
        this.put(new Integer(clientId), client);
        String sql = "SELECT table_id, record_id, cuid FROM sync_map WHERE client_id = ? ORDER BY table_id ";
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(1, clientId);
        ResultSet rs = pst.executeQuery();
        int lastTableId = -1;
        Hashtable<Integer, Integer> lastTable = null;
        while (rs.next()) {
            int tableId = rs.getInt("table_id");
            int recordId = rs.getInt("record_id");
            int cuid = rs.getInt("cuid");
            if (lastTableId != tableId) {
                lastTableId = tableId;
                lastTable = new Hashtable<Integer, Integer>();
                client.put(new Integer(lastTableId), lastTable);
            }
            lastTable.put(new Integer(recordId), new Integer(cuid));
        }
        rs.close();
        pst.close();
        return client;
    }

    public void removeClient(int clientId) {
        if (this.containsKey(new Integer(clientId))) {
            this.remove(new Integer(clientId));
        }
    }

    public void insert(int clientId, int tableId, Integer recordId, Integer cuid) {
        Hashtable clientLookup = (Hashtable)this.get(new Integer(clientId));
        Hashtable<Integer, Integer> tableLookup = (Hashtable<Integer, Integer>)clientLookup.get(new Integer(tableId));
        if (tableLookup == null) {
            tableLookup = new Hashtable<Integer, Integer>();
            clientLookup.put(new Integer(tableId), tableLookup);
        }
        tableLookup.put(recordId, cuid);
    }

    public void remove(int clientId, int tableId, Integer recordId) {
        Hashtable clientLookup = (Hashtable)this.get(new Integer(clientId));
        Hashtable tableLookup = (Hashtable)clientLookup.get(new Integer(tableId));
        if (tableLookup != null) {
            tableLookup.remove(recordId);
        }
    }
}

