/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.service.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Iterator;
import org.aspcfs.modules.service.base.RecordList;
import org.aspcfs.modules.service.base.SyncClientManager;

public class SyncClientMap {
    private int clientId = -1;
    private int tableId = -1;
    private int recordId = -1;
    private int clientUniqueId = -1;
    private boolean complete = false;
    private Timestamp statusDate = null;

    public void setClientId(int tmp) {
        this.clientId = tmp;
    }

    public void setTableId(int tmp) {
        this.tableId = tmp;
    }

    public void setRecordId(int tmp) {
        this.recordId = tmp;
    }

    public void setClientUniqueId(String tmp) {
        this.clientUniqueId = Integer.parseInt(tmp);
    }

    public void setClientUniqueId(int tmp) {
        this.clientUniqueId = tmp;
    }

    public void setComplete(boolean tmp) {
        this.complete = tmp;
    }

    public void setStatusDate(Timestamp tmp) {
        this.statusDate = tmp;
    }

    public int getClientId() {
        return this.clientId;
    }

    public int getTableId() {
        return this.tableId;
    }

    public int getRecordId() {
        return this.recordId;
    }

    public int getClientUniqueId() {
        return this.clientUniqueId;
    }

    public boolean getComplete() {
        return this.complete;
    }

    public Timestamp getStatusDate() {
        return this.statusDate;
    }

    public boolean insert(Connection db, String timestamp) throws SQLException {
        if (timestamp != null && !timestamp.trim().equals("")) {
            return this.insertMap(db, Timestamp.valueOf(timestamp));
        }
        if (System.getProperty("DEBUG") != null) {
            System.out.println("NULL TIMESTAMP-> " + this.getTableId() + " " + this.getRecordId());
        }
        return this.insertMap(db, null);
    }

    public boolean insertMap(Connection db, Timestamp timestamp) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO sync_map (client_id, table_id, record_id, cuid, complete, status_date) VALUES (?, ?, ?, ?, ?, ?) ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setInt(++i, this.clientId);
        pst.setInt(++i, this.tableId);
        pst.setInt(++i, this.recordId);
        pst.setInt(++i, this.clientUniqueId);
        pst.setBoolean(++i, this.complete);
        if (timestamp != null) {
            pst.setTimestamp(++i, timestamp);
        } else {
            pst.setNull(++i, 91);
        }
        pst.execute();
        pst.close();
        return true;
    }

    public boolean insertConflict(Connection db) throws SQLException {
        String sql = "INSERT INTO sync_conflict_log (client_id, table_id, record_id) VALUES (?, ?, ?) ";
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(++i, this.clientId);
        pst.setInt(++i, this.tableId);
        pst.setInt(++i, this.recordId);
        pst.execute();
        pst.close();
        return true;
    }

    public int lookupClientId(Connection db, int referenceTable, String serverId) throws SQLException {
        int resultId = -1;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT cuid FROM sync_map WHERE client_id = ? AND table_id = ? AND record_id = ? ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setInt(++i, this.clientId);
        pst.setInt(++i, referenceTable);
        pst.setInt(++i, Integer.parseInt(serverId));
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            resultId = rs.getInt("cuid");
        }
        rs.close();
        pst.close();
        return resultId;
    }

    public int lookupClientId(SyncClientManager clientManager, int referenceTable, String serverId) {
        int resultId = -1;
        if (clientManager == null) {
            System.out.println("SyncClientMap-> clientManager is null (needs to be initialized first)");
        }
        if (clientManager.containsKey(new Integer(this.clientId)) && serverId != null) {
            Integer serverNum;
            Hashtable tableLookup;
            Hashtable clientLookup = (Hashtable)clientManager.get(new Integer(this.clientId));
            if (clientLookup.containsKey(new Integer(referenceTable)) && (tableLookup = (Hashtable)clientLookup.get(new Integer(referenceTable))).containsKey(serverNum = new Integer(serverId))) {
                Integer value = (Integer)tableLookup.get(serverNum);
                if (value != null) {
                    resultId = value;
                } else if (System.getProperty("DEBUG") != null) {
                    System.out.println("SyncClientMap-> lookupClientId: Null value for table " + referenceTable + " record " + serverId);
                }
            }
        } else if (System.getProperty("DEBUG") != null) {
            System.out.println("SyncClientMap-> lookupClientId: Skipping search table " + referenceTable + " record " + serverId);
        }
        return resultId;
    }

    public int lookupServerId(Connection db, int referenceTable, String clientCuid) throws SQLException {
        int resultId = -1;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT record_id FROM sync_map WHERE client_id = ? AND table_id = ? AND cuid = ? ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setInt(++i, this.clientId);
        pst.setInt(++i, referenceTable);
        pst.setInt(++i, Integer.parseInt(clientCuid));
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            resultId = rs.getInt("record_id");
        }
        rs.close();
        pst.close();
        return resultId;
    }

    public int lookupServerId(SyncClientManager clientManager, int referenceTable, String clientCuid) {
        int resultId = -1;
        if (clientManager.containsKey(new Integer(this.clientId)) && clientCuid != null) {
            Hashtable clientLookup = (Hashtable)clientManager.get(new Integer(this.clientId));
            Hashtable tableLookup = (Hashtable)clientLookup.get(new Integer(referenceTable));
            if (tableLookup == null && System.getProperty("DEBUG") != null) {
                System.out.println("SyncClientMap-> Referenced table is null: " + referenceTable);
            }
            Iterator i = tableLookup.keySet().iterator();
            if (System.getProperty("DEBUG") != null) {
                System.out.println("SyncClientMap-> Table count: " + tableLookup.size());
            }
            while (i.hasNext()) {
                Integer serverNum = (Integer)i.next();
                if ((Integer)tableLookup.get(serverNum) != Integer.parseInt(clientCuid)) continue;
                return serverNum;
            }
        }
        return resultId;
    }

    public void buildStatusDate(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT status_date FROM sync_map WHERE client_id = ? AND table_id = ? AND record_id = ? AND cuid = ? ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setInt(++i, this.clientId);
        pst.setInt(++i, this.tableId);
        pst.setInt(++i, this.recordId);
        pst.setInt(++i, this.clientUniqueId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.statusDate = rs.getTimestamp("status_date");
            System.out.println("SyncClientMap-> Retrieved status date: " + this.statusDate);
        }
        rs.close();
        pst.close();
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.clientId == -1 && this.tableId == -1 && this.recordId == -1) {
            throw new SQLException("ID was not specified");
        }
        PreparedStatement pst = null;
        int recordCount = 0;
        pst = db.prepareStatement("DELETE FROM sync_map WHERE client_id = ? AND table_id = ? AND record_id = ? ");
        int i = 0;
        pst.setInt(++i, this.clientId);
        pst.setInt(++i, this.tableId);
        pst.setInt(++i, this.recordId);
        recordCount = pst.executeUpdate();
        pst.close();
        return recordCount != 0;
    }

    public int updateStatus(Connection db) throws SQLException {
        if (this.clientId == -1 && this.tableId == -1 && this.recordId == -1) {
            throw new SQLException("Record ID was not specified");
        }
        int resultCount = 0;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE sync_map SET complete = ? WHERE client_id = ? AND table_id = ? AND record_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setBoolean(++i, this.complete);
        pst.setInt(++i, this.clientId);
        pst.setInt(++i, this.tableId);
        pst.setInt(++i, this.recordId);
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public int updateStatusDate(Connection db, String timestamp) throws SQLException {
        if (timestamp != null && !timestamp.trim().equals("")) {
            return this.updateStatusDate(db, Timestamp.valueOf(timestamp));
        }
        if (System.getProperty("DEBUG") != null) {
            System.out.println("NULL TIMESTAMP-> " + this.getTableId() + " " + this.getRecordId());
        }
        return this.updateStatusDate(db, (Timestamp)null);
    }

    public int updateStatusDate(Connection db, Timestamp timestamp) throws SQLException {
        if (this.clientId == -1 && this.tableId == -1 && this.recordId == -1) {
            throw new SQLException("Record ID was not specified");
        }
        int resultCount = 0;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE sync_map SET status_date = ? WHERE client_id = ? AND table_id = ? AND record_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        if (timestamp != null) {
            pst.setTimestamp(++i, timestamp);
        } else {
            pst.setNull(++i, 91);
        }
        pst.setInt(++i, this.clientId);
        pst.setInt(++i, this.tableId);
        pst.setInt(++i, this.recordId);
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public ResultSet buildSyncDeletes(Connection db, PreparedStatement pst, String uniqueField, String tableName, RecordList recordList) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT cuid, record_id FROM sync_map WHERE client_id = ? AND table_id = ? AND record_id NOT IN (SELECT " + uniqueField + " FROM " + tableName + ") ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setInt(++i, this.clientId);
        pst.setInt(++i, this.tableId);
        ResultSet rs = pst.executeQuery();
        return rs;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.clientId = rs.getInt("client_id");
        this.tableId = rs.getInt("table_id");
        this.recordId = rs.getInt("record_id");
        this.clientUniqueId = rs.getInt("cuid");
        this.complete = rs.getBoolean("complete");
        this.statusDate = rs.getTimestamp("status_date");
    }

    public String toString() {
        String lf = System.getProperty("line.separator");
        StringBuffer tmp = new StringBuffer();
        tmp.append("SyncClientMap=============" + lf);
        tmp.append(" clientId: " + this.clientId + lf);
        tmp.append(" tableId: " + this.tableId + lf);
        tmp.append(" recordId: " + this.recordId + lf);
        tmp.append(" cuid: " + this.clientUniqueId + lf);
        tmp.append(" statusDate: " + this.statusDate + lf);
        return tmp.toString();
    }
}

