/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.service.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.utils.DatabaseUtils;

public class SyncSystem
extends GenericBean {
    private int id = -1;
    private String applicationName = null;
    private boolean enabled = false;

    public SyncSystem() {
    }

    public SyncSystem(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("system_id");
        this.applicationName = rs.getString("application_name");
        this.enabled = rs.getBoolean("enabled");
    }

    public void insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "sync_system_system_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO sync_system (" + (this.id > -1 ? "system_id, " : "") + "application_name, enabled" + ") " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?) ");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setString(++i, this.applicationName);
        pst.setBoolean(++i, this.enabled);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "sync_system_system_id_seq", this.id);
    }

    public static int getSystemId(Connection db, String applicationName) throws SQLException {
        int systemId = -1;
        PreparedStatement pst = db.prepareStatement("SELECT system_id FROM sync_system WHERE application_name = ? ");
        pst.setString(1, applicationName);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            systemId = rs.getInt("system_id");
        }
        rs.close();
        pst.close();
        return systemId;
    }
}

