/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.service.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.utils.DatabaseUtils;

public class SyncTable
extends GenericBean {
    private int id = -1;
    private int systemId = -1;
    private String name = null;
    private String mappedClassName = null;
    private Timestamp entered = null;
    private Timestamp modified = null;
    private String createStatement = null;
    private int orderId = -1;
    private boolean syncItem = false;
    private String key = null;
    private boolean buildTextFields = true;

    public SyncTable() {
    }

    public SyncTable(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public static int lookupTableId(Connection db, int systemId, String className) throws SQLException {
        int tableId = -1;
        String sql = "SELECT table_id FROM sync_table WHERE system_id = ? AND mapped_class_name = ? ";
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(1, systemId);
        pst.setString(2, className);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            tableId = rs.getInt("table_id");
        }
        rs.close();
        pst.close();
        return tableId;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setSystemId(int tmp) {
        this.systemId = tmp;
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setMappedClassName(String tmp) {
        this.mappedClassName = tmp;
    }

    public void setKey(String tmp) {
        this.key = tmp;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setCreateStatement(String tmp) {
        this.createStatement = tmp;
    }

    public void setOrderId(int tmp) {
        this.orderId = tmp;
    }

    public void setBuildTextFields(boolean tmp) {
        this.buildTextFields = tmp;
    }

    public int getId() {
        return this.id;
    }

    public int getSystemId() {
        return this.systemId;
    }

    public String getName() {
        return this.name;
    }

    public String getMappedClassName() {
        return this.mappedClassName;
    }

    public String getKey() {
        return this.key;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public String getCreateStatement() {
        return this.createStatement;
    }

    public int getOrderId() {
        return this.orderId;
    }

    public boolean getSyncItem() {
        return this.syncItem;
    }

    public boolean getBuildTextFields() {
        return this.buildTextFields;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("table_id");
        this.systemId = rs.getInt("system_id");
        this.name = rs.getString("element_name");
        this.mappedClassName = rs.getString("mapped_class_name");
        this.entered = rs.getTimestamp("entered");
        this.modified = rs.getTimestamp("modified");
        if (this.buildTextFields) {
            this.createStatement = rs.getString("create_statement");
        }
        this.orderId = rs.getInt("order_id");
        this.syncItem = rs.getBoolean("sync_item");
        this.key = rs.getString("object_key");
    }

    public void insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "sync_table_table_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO sync_table (" + (this.id > -1 ? "table_id, " : "") + "system_id, element_name, mapped_class_name, create_statement, order_id, sync_item, object_key" + ") " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?, ?) ");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.systemId);
        pst.setString(++i, this.name);
        pst.setString(++i, this.mappedClassName);
        pst.setString(++i, this.createStatement);
        pst.setInt(++i, this.orderId);
        pst.setBoolean(++i, this.syncItem);
        pst.setString(++i, this.key);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "sync_table_table_id_seq", this.id);
    }

    public void updateKey(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE sync_table SET object_key = ? WHERE system_id = ? AND element_name = ? ");
        int i = 0;
        pst.setString(++i, this.key);
        pst.setInt(++i, this.systemId);
        pst.setString(++i, this.name);
        pst.executeUpdate();
        pst.close();
    }

    public static boolean hasMapping(Connection db, String name) throws SQLException {
        int count = -1;
        PreparedStatement pst = db.prepareStatement("SELECT COUNT(*) as recordcount FROM sync_table WHERE element_name = ? ");
        pst.setString(1, name);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            count = rs.getInt("recordcount");
        }
        rs.close();
        pst.close();
        return count > 0;
    }
}

