/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.service.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.modules.service.base.SyncTable;
import org.aspcfs.utils.web.PagedListInfo;

public class SyncTableList
extends ArrayList {
    public static final String tableName = "sync_table";
    public static final String uniqueField = "table_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private int systemId = -1;
    private boolean buildTextFields = true;
    private boolean buildSyncElementsOnly = false;
    private boolean buildCreateStatementsOnly = false;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public void setSystemId(int tmp) {
        this.systemId = tmp;
    }

    public void setSystemId(String tmp) {
        this.systemId = Integer.parseInt(tmp);
    }

    public void setBuildTextFields(boolean tmp) {
        this.buildTextFields = tmp;
    }

    public void setBuildSyncElementsOnly(boolean tmp) {
        this.buildSyncElementsOnly = tmp;
    }

    public void setBuildSyncElementsOnly(String tmp) {
        this.buildSyncElementsOnly = tmp.equalsIgnoreCase("true") || tmp.equalsIgnoreCase("on");
    }

    public void setBuildCreateStatementsOnly(boolean tmp) {
        this.buildCreateStatementsOnly = tmp;
    }

    public void setBuildCreateStatementsOnly(String tmp) {
        this.buildCreateStatementsOnly = tmp.equalsIgnoreCase("true") || tmp.equalsIgnoreCase("on");
    }

    public int getSystemId() {
        return this.systemId;
    }

    public boolean getBuildTextFields() {
        return this.buildTextFields;
    }

    public boolean getBuildSyncElementsOnly() {
        return this.buildSyncElementsOnly;
    }

    public boolean getBuildCreateStatementsOnly() {
        return this.buildCreateStatementsOnly;
    }

    public void select(Connection db) throws SQLException {
        this.buildList(db);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT table_id, system_id, element_name, mapped_class_name, entered, modified ");
        if (this.buildTextFields) {
            sql.append(", create_statement ");
        }
        sql.append(", order_id, sync_item, object_key ");
        sql.append("FROM sync_table ");
        sql.append("WHERE table_id > -1 ");
        this.createFilter(sql);
        sql.append("ORDER BY order_id ");
        pst = db.prepareStatement(sql.toString());
        items = this.prepareFilter(pst);
        rs = pst.executeQuery();
        while (rs.next()) {
            SyncTable thisTable = new SyncTable();
            thisTable.setBuildTextFields(this.buildTextFields);
            thisTable.buildRecord(rs);
            this.add(thisTable);
        }
        rs.close();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.systemId != -1) {
            sqlFilter.append("AND system_id = ? ");
        }
        if (this.buildSyncElementsOnly) {
            sqlFilter.append("AND sync_item = ? ");
        }
        if (this.buildCreateStatementsOnly) {
            sqlFilter.append("AND create_statement IS NOT NULL ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.systemId != -1) {
            pst.setInt(++i, this.systemId);
        }
        if (this.buildSyncElementsOnly) {
            pst.setBoolean(++i, true);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public HashMap getObjectMapping(int thisSystemId) {
        HashMap<String, SyncTable> objectMap = new HashMap<String, SyncTable>();
        for (SyncTable thisTable : this) {
            if (thisTable.getSystemId() != thisSystemId || thisTable.getMappedClassName() == null) continue;
            objectMap.put(thisTable.getName(), thisTable);
        }
        return objectMap;
    }

    public boolean clearObjectMapping(int thisSystemId) {
        Iterator iList = this.iterator();
        while (iList.hasNext()) {
            SyncTable thisTable = (SyncTable)((Object)iList.next());
            if (thisTable.getSystemId() != thisSystemId) continue;
            iList.remove();
            return true;
        }
        return false;
    }
}

