/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.service.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import org.aspcfs.modules.service.base.SyncTransactionLogItem;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;

public class SyncTransactionLog
extends ArrayList {
    private int id = -1;
    private int systemId = -1;
    private int clientId = -1;
    private String ip = null;
    private Timestamp entered = null;

    public SyncTransactionLog() {
    }

    public SyncTransactionLog(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public SyncTransactionLog(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Transaction Log ID");
        }
        PreparedStatement pst = db.prepareStatement("SELECT sl.* FROM sync_log sl WHERE sl.log_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (id == -1) {
            throw new SQLException("Sync Transaction Log not found");
        }
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setSystemId(int tmp) {
        this.systemId = tmp;
    }

    public void setSystemId(String tmp) {
        this.systemId = Integer.parseInt(tmp);
    }

    public void setClientId(int tmp) {
        this.clientId = tmp;
    }

    public void setClientId(String tmp) {
        this.clientId = Integer.parseInt(tmp);
    }

    public void setIp(String tmp) {
        this.ip = tmp;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DateUtils.parseTimestampString(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getSystemId() {
        return this.systemId;
    }

    public int getClientId() {
        return this.clientId;
    }

    public String getIp() {
        return this.ip;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public String getEnteredString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public void insert(Connection db) throws SQLException {
        if (this.systemId == -1 || this.clientId == -1) {
            throw new SQLException("Log Entry must be associated with a System and Client");
        }
        StringBuffer sql = new StringBuffer();
        try {
            db.setAutoCommit(false);
            this.id = DatabaseUtils.getNextSeq(db, "sync_log_log_id_seq");
            sql.append("INSERT INTO sync_log (" + (this.id > -1 ? "log_id, " : "") + "system_id, client_id, ip ");
            if (this.entered != null) {
                sql.append(", entered ");
            }
            sql.append(") ");
            sql.append("VALUES (?, ?, ? ");
            if (this.id > -1) {
                sql.append(", ? ");
            }
            if (this.entered != null) {
                sql.append(", ? ");
            }
            sql.append(") ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, this.systemId);
            pst.setInt(++i, this.clientId);
            pst.setString(++i, this.ip);
            if (this.entered != null) {
                pst.setTimestamp(++i, this.entered);
            }
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "sync_log_log_id_seq", this.id);
            if (this.size() > 0) {
                for (SyncTransactionLogItem thisItem : this) {
                    thisItem.insert(db);
                }
            }
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Access Log ID not specified.");
        }
        try {
            db.setAutoCommit(false);
            if (this.size() > 0) {
                for (SyncTransactionLogItem thisItem : this) {
                    thisItem.delete(db);
                }
            }
            PreparedStatement pst = db.prepareStatement("DELETE FROM sync_log WHERE log_id = ? ");
            pst.setInt(1, this.id);
            pst.executeUpdate();
            pst.close();
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("log_id");
        this.systemId = rs.getInt("system_id");
        this.clientId = rs.getInt("client_id");
        this.ip = rs.getString("ip");
        this.entered = rs.getTimestamp("entered");
    }
}

