/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.service.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.utils.DatabaseUtils;

public class SyncTransactionLogItem {
    private int id = -1;
    private int logId = -1;
    private String referenceId = null;
    private String elementName = null;
    private String action = null;
    private int linkItemId = -1;
    private int statusCode = -1;
    private int recordCount = -1;
    private String message = null;

    public SyncTransactionLogItem() {
    }

    public SyncTransactionLogItem(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public SyncTransactionLogItem(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Transaction Log Item ID");
        }
        PreparedStatement pst = db.prepareStatement("SELECT stl.* FROM sync_transaction_log stl WHERE stl.transaction_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (id == -1) {
            throw new SQLException("Sync Transaction Log not found");
        }
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setLogId(int tmp) {
        this.logId = tmp;
    }

    public void setLogId(String tmp) {
        this.logId = Integer.parseInt(tmp);
    }

    public void setReferenceId(String tmp) {
        this.referenceId = tmp;
    }

    public void setElementName(String tmp) {
        this.elementName = tmp;
    }

    public void setAction(String tmp) {
        this.action = tmp;
    }

    public void setLinkItemId(int tmp) {
        this.linkItemId = tmp;
    }

    public void setLinkItemId(String tmp) {
        this.linkItemId = Integer.parseInt(tmp);
    }

    public void setStatusCode(int tmp) {
        this.statusCode = tmp;
    }

    public void setStatusCode(String tmp) {
        this.statusCode = Integer.parseInt(tmp);
    }

    public void setRecordCount(int tmp) {
        this.recordCount = tmp;
    }

    public void setRecordCount(String tmp) {
        this.recordCount = Integer.parseInt(tmp);
    }

    public void setMessage(String tmp) {
        this.message = tmp;
    }

    public int getId() {
        return this.id;
    }

    public int getLogId() {
        return this.logId;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getAction() {
        return this.action;
    }

    public int getLinkItemId() {
        return this.linkItemId;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public String getMessage() {
        return this.message;
    }

    public void insert(Connection db) throws SQLException {
        if (this.logId == -1) {
            throw new SQLException("Log Transaction entry must be associated with a Log");
        }
        this.id = DatabaseUtils.getNextSeq(db, "sync_transact_transaction_i_seq");
        int i = 0;
        PreparedStatement pst = db.prepareStatement("INSERT INTO sync_transaction_log (" + (this.id > -1 ? "transaction_id, " : "") + "log_id, reference_id, element_name, " + "action, link_item_id, status_code, record_count, message) VALUES " + "(" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?, ?, ?)");
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.logId);
        pst.setString(++i, this.referenceId);
        pst.setString(++i, this.elementName);
        pst.setString(++i, this.action);
        DatabaseUtils.setInt(pst, ++i, this.linkItemId);
        DatabaseUtils.setInt(pst, ++i, this.statusCode);
        DatabaseUtils.setInt(pst, ++i, this.recordCount);
        pst.setString(++i, this.message);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "sync_transact_transaction_i_seq", this.id);
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Transaction Log ID not specified.");
        }
        PreparedStatement pst = db.prepareStatement("DELETE FROM sync_transaction_log WHERE transaction_id = ? ");
        pst.setInt(1, this.id);
        pst.executeUpdate();
        pst.close();
        return true;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("transaction_id");
        this.logId = rs.getInt("log_id");
        this.referenceId = rs.getString("reference_id");
        this.elementName = rs.getString("element_name");
        this.action = rs.getString("action");
        this.linkItemId = DatabaseUtils.getInt(rs, "link_item_id");
        this.statusCode = DatabaseUtils.getInt(rs, "status_code");
        this.recordCount = DatabaseUtils.getInt(rs, "record_count");
        this.message = rs.getString("message");
    }
}

