/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.service.base;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.aspcfs.apps.transfer.DataRecord;
import org.aspcfs.modules.service.base.PacketContext;
import org.aspcfs.modules.service.base.RecordList;
import org.aspcfs.modules.service.base.SyncTable;
import org.aspcfs.modules.service.base.TransactionContext;
import org.aspcfs.modules.service.base.TransactionItem;
import org.aspcfs.modules.service.base.TransactionMeta;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.ObjectUtils;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Element;

public class Transaction
extends ArrayList {
    private int id = -1;
    private StringBuffer errorMessage = new StringBuffer();
    private RecordList recordList = null;
    private TransactionMeta meta = null;
    private PacketContext packetContext = null;
    private boolean validateObject = true;

    public boolean getValidateObject() {
        return this.validateObject;
    }

    public void setValidateObject(boolean tmp) {
        this.validateObject = tmp;
    }

    public void setValidateObject(String tmp) {
        this.validateObject = DatabaseUtils.parseBoolean(tmp);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        try {
            this.id = Integer.parseInt(tmp);
        }
        catch (Exception e) {
            this.id = -1;
        }
    }

    public void setPacketContext(PacketContext tmp) {
        this.packetContext = tmp;
    }

    public int getId() {
        return this.id;
    }

    public String getErrorMessage() {
        return this.errorMessage.toString();
    }

    public RecordList getRecordList() {
        return this.recordList;
    }

    public void build(Element transactionElement) {
        if (transactionElement.hasAttributes()) {
            this.setId(transactionElement.getAttribute("id"));
        }
        ArrayList objectElements = new ArrayList();
        XMLUtils.getAllChildren(transactionElement, objectElements);
        for (Element objectElement : objectElements) {
            TransactionItem thisItem = new TransactionItem(objectElement, this.packetContext.getObjectMap(), this.packetContext.getUserBean());
            thisItem.setPacketContext(this.packetContext);
            if (thisItem.getName().equals("meta")) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("Transaction-> Meta data found");
                }
                this.meta = (TransactionMeta)thisItem.getObject();
                continue;
            }
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Transaction-> Adding transaction item");
            }
            this.add(thisItem);
        }
    }

    public void build(DataRecord record) {
        TransactionItem item = new TransactionItem(record, this.packetContext.getObjectMap());
        item.setPacketContext(this.packetContext);
        this.add(item);
    }

    public void addMapping(String key, SyncTable value) {
        this.packetContext.getObjectMap().put(key, value);
    }

    public void addTransaction(TransactionItem tmp) {
        this.add(tmp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(Connection db, Connection dbLookup) throws SQLException {
        Exception exception = null;
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            TransactionContext transactionContext = new TransactionContext();
            for (TransactionItem thisItem : this) {
                String keyName;
                thisItem.setMeta(this.meta);
                thisItem.setTransactionContext(transactionContext);
                if (this.validateObject && !thisItem.isObjectValid(db)) {
                    this.appendErrorMessage("Object validation error");
                    throw new Exception("Object Validation Failed");
                }
                thisItem.execute(db, dbLookup);
                if (thisItem.hasError()) {
                    this.appendErrorMessage(thisItem.getErrorMessage());
                }
                if (thisItem.hasRecordList() && this.recordList == null) {
                    this.recordList = thisItem.getRecordList();
                }
                if (!thisItem.getShareKey() || (keyName = ((SyncTable)((Object)this.packetContext.getObjectMap().get(thisItem.getName()))).getKey()) == null) continue;
                transactionContext.getPropertyMap().put(thisItem.getName() + "." + keyName, ObjectUtils.getParam(thisItem.getObject(), keyName));
            }
            if (commit) {
                db.commit();
            }
        }
        catch (Exception e) {
            exception = e;
            e.printStackTrace(System.out);
            this.appendErrorMessage("Transaction failed");
            if (commit) {
                db.rollback();
            }
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        if (exception == null && this.errorMessage.length() == 0) {
            return 0;
        }
        if (exception != null) {
            this.appendErrorMessage(exception.getMessage());
        }
        return 1;
    }

    public boolean hasError() {
        return this.errorMessage.length() > 0;
    }

    public void appendErrorMessage(String tmp) {
        if (tmp != null) {
            if (this.errorMessage.length() > 0) {
                this.errorMessage.append(System.getProperty("line.separator"));
            }
            this.errorMessage.append(tmp);
        }
    }
}

