/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.service.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.apps.transfer.DataRecord;
import org.aspcfs.controller.ObjectValidator;
import org.aspcfs.modules.base.UserCentric;
import org.aspcfs.modules.login.beans.UserBean;
import org.aspcfs.modules.service.base.PacketContext;
import org.aspcfs.modules.service.base.Record;
import org.aspcfs.modules.service.base.RecordList;
import org.aspcfs.modules.service.base.SyncClient;
import org.aspcfs.modules.service.base.SyncClientMap;
import org.aspcfs.modules.service.base.SyncTable;
import org.aspcfs.modules.service.base.TransactionContext;
import org.aspcfs.modules.service.base.TransactionMeta;
import org.aspcfs.utils.ObjectUtils;
import org.aspcfs.utils.XMLUtils;
import org.aspcfs.utils.web.CustomLookupElement;
import org.aspcfs.utils.web.PagedListInfo;
import org.w3c.dom.Element;

public class TransactionItem {
    private static final byte INSERT = 1;
    private static final byte SELECT = 2;
    private static final byte UPDATE = 3;
    private static final byte DELETE = 4;
    private static final byte SYNC = 5;
    private static final byte SYNC_START = 6;
    private static final byte SYNC_END = 7;
    private static final byte SYNC_DELETE = 8;
    private static final byte GET_DATETIME = 9;
    private static final byte CUSTOM_ACTION = 10;
    private String name = null;
    private Object object = null;
    private int action = -1;
    private String actionMethod = null;
    private int identity = 1;
    private PagedListInfo pagedListInfo = null;
    private StringBuffer errorMessage = new StringBuffer();
    private RecordList recordList = null;
    private TransactionMeta meta = null;
    private HashMap ignoredProperties = null;
    private SyncClientMap syncClientMap = null;
    private PacketContext packetContext = null;
    private TransactionContext transactionContext = null;
    private boolean shareKey = false;

    public TransactionItem() {
    }

    public TransactionItem(Element objectElement, HashMap mapping, UserBean thisUser) {
        try {
            this.setAction(objectElement);
            this.setObject(objectElement, mapping);
            this.ignoredProperties = XMLUtils.populateObject(this.object, objectElement);
            this.populateUserData(thisUser);
        }
        catch (Exception e) {
            if (System.getProperty("DEBUG") != null) {
                System.out.println("TransactionItem-> Cannot create: " + objectElement.getTagName());
                e.printStackTrace(System.out);
            }
            this.appendErrorMessage("Invalid element: " + objectElement.getTagName());
        }
    }

    public TransactionItem(DataRecord record, HashMap mapping) {
        try {
            this.setAction(record.getAction());
            this.setObject(record.getName(), mapping);
            this.ignoredProperties = ObjectUtils.populateObject(this.object, record);
            this.shareKey = record.getShareKey();
        }
        catch (Exception e) {
            if (System.getProperty("DEBUG") != null) {
                System.out.println("TransactionItem-> Cannot create: " + record.getName());
                e.printStackTrace(System.out);
            }
            this.appendErrorMessage("Invalid element: " + record.getName());
        }
    }

    public void populateUserData(UserBean thisUser) {
        try {
            ArrayList userIdParams;
            if (thisUser != null && (userIdParams = (ArrayList)ObjectUtils.getObject(this.object, "UserIdParams")) != null) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("TransactionItem-> Found userId params");
                }
                for (String param : userIdParams) {
                    String value = String.valueOf(thisUser.getUserId());
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("TransactionItem-> userIdParams trying to set: " + param + "=" + value);
                    }
                    ObjectUtils.setParam(this.object, param, value);
                }
            }
        }
        catch (Exception e) {
            if (System.getProperty("DEBUG") != null) {
                System.out.println("TransactionItem-> Cannot populate User related data: " + this.object.getClass().getName());
                e.printStackTrace(System.out);
            }
            this.appendErrorMessage("Cannot populate User related data: " + this.object.getClass().getName());
        }
    }

    public void setObject(Object tmp) {
        this.object = tmp;
    }

    public void setObject(String name, HashMap mapping) throws Exception {
        this.name = name;
        if (mapping.containsKey(name)) {
            this.object = Class.forName(((SyncTable)((Object)mapping.get(name))).getMappedClassName()).newInstance();
            if (System.getProperty("DEBUG") != null) {
                System.out.println("TransactionItem-> New: " + this.object.getClass().getName());
            }
        }
    }

    public void setObject(Element element, HashMap mapping) throws Exception {
        this.setObject(element.getTagName(), mapping);
    }

    public void setAction(int tmp) {
        this.action = tmp;
    }

    public void setAction(String tmp) {
        if ("insert".equals(tmp) || tmp.startsWith("insert")) {
            this.setAction(1);
            if (tmp.length() > 6) {
                this.actionMethod = tmp;
            }
        } else if ("update".equals(tmp)) {
            this.setAction(3);
        } else if ("select".equals(tmp)) {
            this.setAction(2);
        } else if ("delete".equals(tmp)) {
            this.setAction(4);
        } else if ("sync".equals(tmp)) {
            this.setAction(5);
        } else if ("syncStart".equals(tmp)) {
            this.setAction(6);
        } else if ("syncEnd".equals(tmp)) {
            this.setAction(7);
        } else if ("getDateTime".equals(tmp)) {
            this.setAction(9);
        } else if ("syncDelete".equals(tmp)) {
            this.setAction(8);
        } else if ("execute".equals(tmp)) {
            this.setAction(10);
        }
    }

    public void setAction(Element objectElement) {
        if (objectElement.hasAttributes()) {
            String thisAction = objectElement.getAttribute("type");
            if (thisAction == null || thisAction.trim().equals("")) {
                thisAction = objectElement.getAttribute("action");
            }
            this.setAction(thisAction);
            String thisIdentity = objectElement.getAttribute("identity");
            try {
                this.identity = Integer.parseInt(thisIdentity);
            }
            catch (Exception e) {
                // empty catch block
            }
            String thisCurrentOffset = objectElement.getAttribute("offset");
            String thisItemsPerPage = objectElement.getAttribute("items");
            if (thisCurrentOffset != null && !"".equals(thisCurrentOffset) || thisItemsPerPage != null && !"".equals(thisItemsPerPage)) {
                this.pagedListInfo = new PagedListInfo();
                this.pagedListInfo.setItemsPerPage(thisItemsPerPage);
                this.pagedListInfo.setCurrentOffset(thisCurrentOffset);
            }
            this.shareKey = "true".equals(objectElement.getAttribute("shareKey"));
        }
    }

    public void setMeta(TransactionMeta tmp) {
        this.meta = tmp;
    }

    public void setPacketContext(PacketContext tmp) {
        this.packetContext = tmp;
    }

    public void setTransactionContext(TransactionContext tmp) {
        this.transactionContext = tmp;
    }

    public void setShareKey(boolean tmp) {
        this.shareKey = tmp;
    }

    public String getErrorMessage() {
        return this.errorMessage.toString();
    }

    public String getName() {
        return this.name;
    }

    public Object getObject() {
        return this.object;
    }

    public RecordList getRecordList() {
        return this.recordList;
    }

    public TransactionMeta getMeta() {
        return this.meta;
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public boolean getShareKey() {
        return this.shareKey;
    }

    public void insertClientMapping(Connection db, Record record) throws SQLException {
        if (record.containsKey("guid")) {
            this.packetContext.getClientManager().insert(this.syncClientMap.getClientId(), this.syncClientMap.getTableId(), new Integer(record.getRecordId()), new Integer((String)record.get("guid")));
            this.syncClientMap.setRecordId(record.getRecordId());
            this.syncClientMap.setClientUniqueId((String)record.get("guid"));
            this.syncClientMap.insert(db, (String)record.get("modified"));
        }
    }

    public void insertClientMapping(Connection db, String modified) throws SQLException {
        this.packetContext.getClientManager().insert(this.syncClientMap.getClientId(), this.syncClientMap.getTableId(), new Integer(this.syncClientMap.getRecordId()), new Integer(this.syncClientMap.getClientUniqueId()));
        this.syncClientMap.insert(db, modified);
    }

    public void updateClientMapping(Connection db, Record record) throws SQLException {
        if (record.containsKey("guid")) {
            this.syncClientMap.setRecordId(record.getRecordId());
            this.syncClientMap.setClientUniqueId((String)record.get("guid"));
            this.syncClientMap.updateStatusDate(db, (String)record.get("modified"));
        }
    }

    public void deleteClientMapping(Connection db, Record record) throws SQLException {
        if (record.containsKey("guid")) {
            this.syncClientMap.setRecordId(record.getRecordId());
            this.syncClientMap.setClientUniqueId((String)record.get("guid"));
            this.syncClientMap.delete(db);
        }
        this.packetContext.getClientManager().remove(this.syncClientMap.getClientId(), this.syncClientMap.getTableId(), new Integer(record.getRecordId()));
    }

    public boolean isObjectValid(Connection db) throws Exception {
        if (this.action == 1 || this.action == 3) {
            if (System.getProperty("DEBUG") != null) {
                System.out.println("TransactionItem-> Validating Object");
            }
            ObjectValidator.validate(this.packetContext.getSystemStatus(), db, this.object);
            HashMap errors = (HashMap)ObjectUtils.getObject(this.object, "errors");
            if (errors != null && errors.size() > 0) {
                for (String errorKey : errors.keySet()) {
                    String errorMsg = (String)errors.get(errorKey);
                    this.appendErrorMessage(errorMsg);
                    if (System.getProperty("DEBUG") == null) continue;
                    System.out.println(" Object Validation Error-> " + errorKey + "=" + errorMsg);
                }
                return false;
            }
        }
        return true;
    }

    public void execute(Connection db, Connection dbLookup) throws Exception {
        Record thisRecord;
        String permission;
        if (System.getProperty("DEBUG") != null) {
            System.out.println("TransactionItem-> Executing transaction");
        }
        if (!(this.object != null && this.name != null || "system".equals(this.name))) {
            this.appendErrorMessage("Unsupported object specified");
            return;
        }
        if (this.packetContext.getAuthenticationItem().getType() == 3 && !this.hasPermission(permission = ObjectUtils.getParam(this.object, "permission"))) {
            this.appendErrorMessage("User denied permission to perform action on the object");
            return;
        }
        this.syncClientMap = new SyncClientMap();
        this.syncClientMap.setClientId(this.packetContext.getAuthenticationItem().getClientId());
        this.syncClientMap.setTableId(((SyncTable)((Object)this.packetContext.getObjectMap().get(this.name))).getId());
        if (this.recordList == null) {
            this.recordList = new RecordList(this.name);
        }
        if (this.pagedListInfo != null) {
            this.doSetPagedListInfo();
        }
        if (this.action == 9) {
            thisRecord = new Record("info");
            thisRecord.put("dateTime", String.valueOf(new Timestamp(new Date().getTime())));
            this.recordList.add(thisRecord);
        } else if (this.action == 6) {
            ObjectUtils.setParam(this.object, "id", String.valueOf(this.packetContext.getAuthenticationItem().getClientId()));
            ObjectUtils.setParam(this.object, "anchor", this.packetContext.getAuthenticationItem().getLastAnchor());
            if (!((SyncClient)((Object)this.object)).checkNormalSync(db)) {
                this.appendErrorMessage("Client and server not in sync!");
            }
        } else if (this.action == 7) {
            ObjectUtils.setParam(this.object, "id", String.valueOf(this.packetContext.getAuthenticationItem().getClientId()));
            ObjectUtils.setParam(this.object, "anchor", this.packetContext.getAuthenticationItem().getNextAnchor());
            ((SyncClient)((Object)this.object)).updateSyncAnchor(db);
            thisRecord = new Record("syncEnd");
            thisRecord.put("endDateTime", String.valueOf(new Timestamp(new Date().getTime())));
            this.recordList.add(thisRecord);
        } else if (this.action == 5) {
            ObjectUtils.setParam(this.object, "lastAnchor", this.packetContext.getAuthenticationItem().getLastAnchor());
            ObjectUtils.setParam(this.object, "nextAnchor", this.packetContext.getAuthenticationItem().getNextAnchor());
            this.setGuidParameters(db);
            if (this.packetContext.getAuthenticationItem().getNextAnchor() != null) {
                this.buildRecords(this.object, db, dbLookup, 2);
            }
            if (this.packetContext.getAuthenticationItem().getLastAnchor() != null) {
                this.buildRecords(this.object, db, dbLookup, 3);
            }
        } else if (this.action == 8) {
            String uniqueField = ObjectUtils.getParam(this.object, "uniqueField");
            String tableName = ObjectUtils.getParam(this.object, "tableName");
            if (uniqueField != null && tableName != null) {
                Statement pst = null;
                ResultSet rs = this.syncClientMap.buildSyncDeletes(db, (PreparedStatement)pst, uniqueField, tableName, this.recordList);
                while (rs.next()) {
                    Record thisRecord2 = new Record("delete");
                    int cuid = rs.getInt("cuid");
                    int recordId = rs.getInt("record_id");
                    thisRecord2.put("guid", String.valueOf(cuid));
                    thisRecord2.setRecordId(recordId);
                    this.recordList.add(thisRecord2);
                }
                rs.close();
                if (pst != null) {
                    pst.close();
                }
            }
        } else if (this.action == 10) {
            Class[] paramClass = new Class[]{this.packetContext.getClass(), Class.forName("java.sql.Connection"), this.ignoredProperties.getClass()};
            Object[] paramObject = new Object[]{this.packetContext, db, this.ignoredProperties};
            Method method = this.object.getClass().getMethod("process", paramClass);
            Object result = method.invoke(this.object, paramObject);
            this.checkResult(result);
        } else {
            if (System.getProperty("DEBUG") != null) {
                System.out.println("TransactionItem-> Base request");
            }
            String executeMethod = null;
            switch (this.action) {
                case -1: {
                    this.appendErrorMessage("Action not specified");
                    break;
                }
                case 1: {
                    if (this.actionMethod != null) {
                        executeMethod = this.actionMethod;
                        break;
                    }
                    executeMethod = "insert";
                    break;
                }
                case 3: {
                    executeMethod = "update";
                    break;
                }
                case 4: {
                    executeMethod = "delete";
                    break;
                }
                case 2: {
                    executeMethod = "select";
                    break;
                }
                default: {
                    this.appendErrorMessage("Unsupported action specified");
                }
            }
            if (executeMethod != null) {
                if (this.action == 1 || this.action == 3) {
                    this.setGuidParameters(db);
                    this.setContextParameters();
                }
                if (this.action == 4 && this.ignoredProperties.containsKey("guid")) {
                    this.setObjectId(db);
                    this.syncClientMap.setRecordId(Integer.parseInt(ObjectUtils.getParam(this.object, "id")));
                    this.syncClientMap.setClientUniqueId((String)this.ignoredProperties.get("guid"));
                }
                if (this.action == 3 && this.ignoredProperties.containsKey("guid")) {
                    this.setObjectId(db);
                    this.syncClientMap.setRecordId(Integer.parseInt(ObjectUtils.getParam(this.object, "id")));
                    this.syncClientMap.setClientUniqueId((String)this.ignoredProperties.get("guid"));
                    this.setReferencedTable();
                    this.syncClientMap.buildStatusDate(db);
                    ObjectUtils.setParam(this.object, "modified", this.syncClientMap.getStatusDate());
                }
                Object result = this.doExecute(db, executeMethod);
                this.checkResult(result);
                System.out.println("TransactionItem-> " + this.object.getClass().getName() + " " + executeMethod);
                if (this.action == 1) {
                    if (this.ignoredProperties != null && this.ignoredProperties.containsKey("guid")) {
                        Object insertedObject;
                        this.syncClientMap.setRecordId(Integer.parseInt(ObjectUtils.getParam(this.object, "id")));
                        if (this.setReferencedTable()) {
                            this.syncClientMap.setClientUniqueId((String)this.ignoredProperties.get("guid"));
                        }
                        if ((insertedObject = ObjectUtils.constructObject(this.object.getClass(), db, Integer.parseInt(ObjectUtils.getParam(this.object, "id")))) == null) {
                            insertedObject = ObjectUtils.constructObject(this.object.getClass(), db, Integer.parseInt(ObjectUtils.getParam(this.object, "id")), ObjectUtils.getParam(this.object, "tableName"));
                        }
                        if (insertedObject == null) {
                            insertedObject = ObjectUtils.constructObject(this.object.getClass(), db, Integer.parseInt(ObjectUtils.getParam(this.object, "id")), ObjectUtils.getParam(this.object, "tableName"), ObjectUtils.getParam(this.object, "uniqueField"));
                        }
                        if (insertedObject == null && System.getProperty("DEBUG") != null) {
                            System.out.println("TransactionItem-> The object was inserted, but could not be reloaded: possible invalid constructor");
                        }
                        this.insertClientMapping(db, ObjectUtils.getParam(insertedObject, "modified"));
                    }
                    this.addRecords(this.object, this.recordList, "processed");
                } else if (this.action == 3) {
                    if ((Integer)result == 1) {
                        if (this.ignoredProperties != null && this.ignoredProperties.containsKey("guid")) {
                            Object updatedObject = ObjectUtils.constructObject(this.object.getClass(), db, Integer.parseInt(ObjectUtils.getParam(this.object, "id")));
                            this.syncClientMap.updateStatusDate(db, ObjectUtils.getParam(updatedObject, "modified"));
                        }
                        this.addRecords(this.object, this.recordList, "processed");
                    } else {
                        this.addRecords(this.object, this.recordList, "conflict");
                        this.syncClientMap.insertConflict(db);
                    }
                } else if (this.action == 4) {
                    Record thisRecord3 = this.addRecords(this.object, this.recordList, "delete");
                    this.setReferencedTable();
                    if (thisRecord3 != null && this.syncClientMap.lookupClientId(this.packetContext.getClientManager(), this.syncClientMap.getTableId(), ObjectUtils.getParam(this.object, "id")) != -1) {
                        this.deleteClientMapping(dbLookup, thisRecord3);
                    } else if (System.getProperty("DEBUG") != null) {
                        System.out.println("TransactionItem-> Mapping not found for delete");
                    }
                } else {
                    this.addRecords(this.object, this.recordList, null);
                }
            }
        }
        if (this.pagedListInfo != null) {
            this.recordList.setTotalRecords(this.pagedListInfo.getMaxRecords());
        }
    }

    public boolean hasError() {
        return this.errorMessage.length() > 0;
    }

    public boolean hasRecordList() {
        return this.recordList != null;
    }

    public void appendErrorMessage(String tmp) {
        if (tmp != null) {
            if (this.errorMessage.length() > 0) {
                this.errorMessage.append(System.getProperty("line.separator"));
            }
            this.errorMessage.append(tmp);
        }
    }

    public void setObjectId(Connection db) throws SQLException {
        SyncTable referencedTable;
        if (this.ignoredProperties != null && this.ignoredProperties.containsKey("guid") && (referencedTable = (SyncTable)((Object)this.packetContext.getObjectMap().get(this.name + "List"))) != null) {
            String value = (String)this.ignoredProperties.get("guid");
            int recordId = this.syncClientMap.lookupServerId(this.packetContext.getClientManager(), referencedTable.getId(), value);
            ObjectUtils.setParam(this.object, "id", String.valueOf(recordId));
            if (System.getProperty("DEBUG") != null) {
                System.out.println("TransactionItem-> Setting object id: " + recordId);
            }
        }
    }

    private void setGuidParameters(Connection db) throws SQLException {
        if (this.ignoredProperties != null && this.ignoredProperties.size() > 0) {
            for (String param : this.ignoredProperties.keySet()) {
                if (param == null || !param.endsWith("Guid")) continue;
                String value = (String)this.ignoredProperties.get(param);
                if ((param = param.substring(0, param.lastIndexOf("Guid"))).indexOf("^") > -1) {
                    String lookupField = param.substring(param.indexOf("^") + 1);
                    param = param.substring(0, param.indexOf("^"));
                    SyncTable referencedTable = (SyncTable)((Object)this.packetContext.getObjectMap().get(lookupField + "List"));
                    if (referencedTable == null) continue;
                    if (this.object instanceof CustomLookupElement) {
                        String field = value.substring(0, value.indexOf("="));
                        value = value.substring(value.indexOf("=") + 1);
                        int recordId = this.syncClientMap.lookupServerId(this.packetContext.getClientManager(), referencedTable.getId(), value.equals("-1") ? null : value);
                        ObjectUtils.setParam(this.object, "serverMapId", field + "=" + String.valueOf(recordId));
                        if (System.getProperty("DEBUG") == null) continue;
                        System.out.println("TransactionItem-> Setting server parameter: " + param + " data: " + recordId);
                        continue;
                    }
                    int recordId = this.syncClientMap.lookupServerId(this.packetContext.getClientManager(), referencedTable.getId(), value);
                    ObjectUtils.setParam(this.object, param, String.valueOf(recordId));
                    if (System.getProperty("DEBUG") == null) continue;
                    System.out.println("TransactionItem-> Setting server parameter: " + param + " data: " + recordId);
                    continue;
                }
                SyncTable referencedTable = (SyncTable)((Object)this.packetContext.getObjectMap().get(param + "List"));
                if (referencedTable != null) {
                    int recordId = this.syncClientMap.lookupServerId(this.packetContext.getClientManager(), referencedTable.getId(), value);
                    ObjectUtils.setParam(this.object, param + "Id", String.valueOf(recordId));
                    if (System.getProperty("DEBUG") == null) continue;
                    System.out.println("TransactionItem-> Setting new parameter: " + param + "Id" + " data: " + recordId);
                    continue;
                }
                throw new SQLException("Sync reference does not exist, you must sync referenced tables first");
            }
        }
    }

    private void setContextParameters() {
        if (this.ignoredProperties != null && this.ignoredProperties.size() > 0) {
            for (String param : this.ignoredProperties.keySet()) {
                String value;
                if (param == null || (value = (String)this.ignoredProperties.get(param)) == null || value.indexOf("$C{") <= -1 || (value = (String)this.transactionContext.getPropertyMap().get(value.substring(value.indexOf("$C{") + 3, value.indexOf("}")))) == null) continue;
                ObjectUtils.setParam(this.object, param, value);
                if (System.getProperty("DEBUG") == null) continue;
                System.out.println("TransactionItem-> Setting context parameter: " + param + " data: " + value);
            }
        }
    }

    private Object doExecute(Connection db, String executeMethod) throws Exception {
        Class[] dbClass = new Class[]{Class.forName("java.sql.Connection")};
        Object[] dbObject = new Object[]{db};
        Method method = this.object.getClass().getMethod(executeMethod, dbClass);
        Object previousObject = null;
        if (this.packetContext.getObjectHookManager() != null && (this.action == 3 || this.action == 4)) {
            previousObject = ObjectUtils.constructObject(this.object.getClass(), db, Integer.parseInt(ObjectUtils.getParam(this.object, "id")));
        }
        if (this.object instanceof UserCentric && this.packetContext.getUserBean() != null) {
            ((UserCentric)this.object).accessedBy(this.packetContext.getUserBean().getUserId());
        }
        Object result = method.invoke(this.object, dbObject);
        if (this.packetContext.getObjectHookManager() != null) {
            switch (this.action) {
                case 1: {
                    this.packetContext.getObjectHookManager().process(this.packetContext, 1, null, this.object);
                    break;
                }
                case 3: {
                    this.packetContext.getObjectHookManager().process(this.packetContext, 2, previousObject, this.object);
                    break;
                }
                case 4: {
                    this.packetContext.getObjectHookManager().process(this.packetContext, 3, previousObject, null);
                    break;
                }
            }
        }
        return result;
    }

    private void checkResult(Object result) {
        try {
            if (result instanceof Boolean && !((Boolean)result).booleanValue()) {
                System.out.println("TransactionItem-> Object failed");
                if (this.object instanceof GenericBean) {
                    HashMap errors = ((GenericBean)this.object).getErrors();
                    Iterator i = errors.keySet().iterator();
                    while (i.hasNext()) {
                        String errorText = (String)errors.get((String)i.next());
                        System.out.println("--------> " + errorText);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doSetPagedListInfo() {
        block2: {
            try {
                Class[] theClass = new Class[]{this.pagedListInfo.getClass()};
                Object[] theObject = new Object[]{this.pagedListInfo};
                Method method = this.object.getClass().getMethod("setPagedListInfo", theClass);
                method.invoke(this.object, theObject);
            }
            catch (Exception e) {
                if (System.getProperty("DEBUG") == null) break block2;
                System.out.println("TransactionItem-> Object does not have setPagedListInfo method");
            }
        }
    }

    private void buildRecords(Object object, Connection db, Connection dbLookup, int syncType) throws Exception {
        Statement pst = null;
        Class[] dbClass = new Class[]{Class.forName("java.sql.Connection"), Class.forName("java.sql.PreparedStatement")};
        Object[] dbObject = new Object[]{db, pst};
        String executeMethod = "queryList";
        ObjectUtils.setParam(object, "syncType", String.valueOf(syncType));
        Method method = object.getClass().getMethod(executeMethod, dbClass);
        Object result = method.invoke(object, dbObject);
        while (((ResultSet)result).next()) {
            Record thisRecord;
            String objectMethod = "getObject";
            Class[] rsClass = new Class[]{Class.forName("java.sql.ResultSet")};
            Object[] rsObject = new Object[]{result};
            Method getObject = object.getClass().getMethod(objectMethod, rsClass);
            Object thisObject = getObject.invoke(object, rsObject);
            String recordAction = null;
            switch (syncType) {
                case 2: {
                    recordAction = "insert";
                    break;
                }
                case 3: {
                    recordAction = "update";
                    break;
                }
            }
            if (syncType == 2) {
                if (this.syncClientMap.lookupClientId(this.packetContext.getClientManager(), this.syncClientMap.getTableId(), ObjectUtils.getParam(thisObject, "id")) != -1) continue;
                thisRecord = this.addRecords(thisObject, this.recordList, recordAction);
                this.insertClientMapping(dbLookup, thisRecord);
                continue;
            }
            if (syncType != 3) continue;
            thisRecord = this.addRecords(thisObject, this.recordList, recordAction);
            this.updateClientMapping(dbLookup, thisRecord);
        }
        ((ResultSet)result).close();
        if (pst != null) {
            pst.close();
        }
        ((AbstractList)object).clear();
    }

    private Record addRecords(Object object, RecordList recordList, String recordAction) throws SQLException {
        if (recordList != null) {
            if (object instanceof AbstractList) {
                for (Object objectItem : (AbstractList)object) {
                    Record thisRecord = new Record(recordAction);
                    this.addFields(thisRecord, this.meta, objectItem);
                    recordList.add(thisRecord);
                }
                return null;
            }
            Record thisRecord = new Record(recordAction);
            this.addFields(thisRecord, this.meta, object);
            recordList.add(thisRecord);
            return thisRecord;
        }
        return null;
    }

    private void addFields(Record thisRecord, TransactionMeta thisMeta, Object thisObject) throws SQLException {
        if (thisMeta != null && thisMeta.getFields() != null) {
            for (String thisField : thisMeta.getFields()) {
                String lookupField;
                String thisValue = null;
                if (thisField.endsWith("Guid")) {
                    int recordId;
                    SyncTable referencedTable;
                    lookupField = thisField.substring(0, thisField.lastIndexOf("Guid"));
                    String param = thisField.substring(0, thisField.lastIndexOf("Guid"));
                    if (param.indexOf("^") > -1) {
                        param = param.substring(param.indexOf("^") + 1);
                        lookupField = thisField.substring(0, thisField.indexOf("^"));
                        thisField = thisField.substring(0, thisField.indexOf("^"));
                        referencedTable = (SyncTable)((Object)this.packetContext.getObjectMap().get(param + "List"));
                        if (referencedTable != null) {
                            recordId = this.syncClientMap.lookupClientId(this.packetContext.getClientManager(), referencedTable.getId(), ObjectUtils.getParam(thisObject, lookupField));
                            thisValue = String.valueOf(recordId);
                        }
                    } else {
                        referencedTable = (SyncTable)((Object)this.packetContext.getObjectMap().get(param + "List"));
                        if (referencedTable != null) {
                            recordId = this.syncClientMap.lookupClientId(this.packetContext.getClientManager(), referencedTable.getId(), ObjectUtils.getParam(thisObject, lookupField + "Id"));
                            thisValue = String.valueOf(recordId);
                        }
                    }
                } else {
                    thisValue = ObjectUtils.getParam(thisObject, thisField);
                    if (thisField.indexOf(".guid") > -1) {
                        lookupField = thisField.substring(0, thisField.indexOf(".guid"));
                        SyncTable referencedTable = (SyncTable)((Object)this.packetContext.getObjectMap().get(lookupField + "List"));
                        if (referencedTable != null) {
                            int recordId = this.syncClientMap.lookupClientId(this.packetContext.getClientManager(), referencedTable.getId(), thisValue);
                            thisValue = String.valueOf(recordId);
                        }
                    }
                }
                if (thisValue == null) {
                    thisValue = "";
                }
                thisRecord.put(thisField, thisValue);
            }
            try {
                thisRecord.setRecordId(ObjectUtils.getParam(thisObject, "id"));
                if (thisRecord.containsKey("guid")) {
                    if (thisRecord.getAction().equals("processed")) {
                        thisRecord.put("guid", this.ignoredProperties.get("guid"));
                    } else if (thisRecord.getAction().equals("insert")) {
                        thisRecord.put("guid", String.valueOf(this.identity++));
                    } else if (thisRecord.getAction().equals("update")) {
                        thisRecord.put("guid", this.syncClientMap.lookupClientId(this.packetContext.getClientManager(), this.syncClientMap.getTableId(), ObjectUtils.getParam(thisObject, "id")));
                    } else if (thisRecord.getAction().equals("delete")) {
                        thisRecord.put("guid", this.ignoredProperties.get("guid"));
                    } else if (thisRecord.getAction().equals("conflict")) {
                        thisRecord.put("guid", this.ignoredProperties.get("guid"));
                    }
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    public boolean setReferencedTable() {
        SyncTable referencedTable;
        if (!this.name.endsWith("List") && (referencedTable = (SyncTable)((Object)this.packetContext.getObjectMap().get(this.name + "List"))) != null) {
            this.syncClientMap.setTableId(referencedTable.getId());
            return true;
        }
        return false;
    }

    protected boolean hasPermission(String permission) {
        if (permission != null && !"".equals(permission.trim())) {
            if (this.action == 2) {
                permission = permission + "-view";
            } else if (this.action == 1) {
                permission = permission + "-add";
            } else if (this.action == 3) {
                permission = permission + "-edit";
            } else if (this.action == 4) {
                permission = permission + "-delete";
            }
            if (this.packetContext.getSystemStatus() != null && this.packetContext.getUserBean() != null) {
                return this.packetContext.getSystemStatus().hasPermission(this.packetContext.getUserBean().getUserId(), permission);
            }
        }
        return true;
    }
}

