/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.service.base;

import org.aspcfs.modules.service.base.RecordList;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Element;

public class TransactionStatus {
    private int id = -1;
    private int statusCode = -1;
    private String message = null;
    private RecordList recordList = null;

    public TransactionStatus() {
    }

    public TransactionStatus(int statusCode) {
        this.statusCode = statusCode;
    }

    public TransactionStatus(String message) {
        this.message = message;
    }

    public TransactionStatus(int statusCode, String message) {
        this.statusCode = statusCode;
        this.message = message;
    }

    public TransactionStatus(Element responseNode) {
        this.setId(responseNode.getAttribute("id"));
        this.setStatusCode(XMLUtils.getNodeText(XMLUtils.getFirstChild(responseNode, "status")));
        this.setMessage(XMLUtils.getNodeText(XMLUtils.getFirstChild(responseNode, "errorText")));
        Element recordListNode = XMLUtils.getFirstChild(responseNode, "recordSet");
        if (recordListNode != null) {
            this.recordList = new RecordList(recordListNode);
        }
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        try {
            this.id = Integer.parseInt(tmp);
        }
        catch (Exception e) {
            this.id = -1;
        }
    }

    public void setStatusCode(int tmp) {
        this.statusCode = tmp;
    }

    public void setStatusCode(String tmp) {
        try {
            this.statusCode = Integer.parseInt(tmp);
        }
        catch (Exception e) {
            this.statusCode = -1;
        }
    }

    public void setMessage(String tmp) {
        this.message = tmp;
    }

    public void setRecordList(RecordList tmp) {
        this.recordList = tmp;
    }

    public int getId() {
        return this.id;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getMessage() {
        return this.message;
    }

    public RecordList getRecordList() {
        return this.recordList;
    }

    public boolean hasError() {
        return this.statusCode > 0;
    }

    public boolean hasRecordList() {
        return this.recordList != null;
    }
}

