/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.servicecontracts.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import org.aspcfs.modules.assets.base.AssetList;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.contacts.base.ContactHistory;
import org.aspcfs.modules.servicecontracts.base.ServiceContractHoursList;
import org.aspcfs.modules.servicecontracts.base.ServiceContractProduct;
import org.aspcfs.modules.servicecontracts.base.ServiceContractProductList;
import org.aspcfs.modules.troubletickets.base.TicketList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;

public class ServiceContract
extends GenericBean {
    private int id = -1;
    private String serviceContractNumber = null;
    private int orgId = -1;
    private double contractValue = -1.0;
    private Timestamp initialStartDate = null;
    private Timestamp currentStartDate = null;
    private Timestamp currentEndDate = null;
    private int category = -1;
    private int type = -1;
    private int contactId = -1;
    private String description = null;
    private String contractBillingNotes = null;
    private double totalHoursRemaining = 0.0;
    private int responseTime = -1;
    private int telephoneResponseModel = -1;
    private int onsiteResponseModel = -1;
    private int emailResponseModel = -1;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;
    private boolean enabled = true;
    private boolean override = false;
    private String serviceModelNotes = null;
    private ArrayList productList = null;
    private ServiceContractProductList serviceContractProductList = null;
    private String initialStartDateTimeZone = null;
    private String currentStartDateTimeZone = null;
    private String currentEndDateTimeZone = null;
    private Timestamp trashedDate = null;
    private double adjustmentHours = 0.0;
    private int adjustmentReason = -1;
    private String adjustmentNotes = null;
    private double netHours = 0.0;

    public ServiceContract() {
        this.errors.clear();
    }

    public ServiceContract(Connection db, String scId) throws SQLException {
        this.errors.clear();
        this.queryRecord(db, Integer.parseInt(scId));
    }

    public ServiceContract(Connection db, int scId) throws SQLException {
        this.errors.clear();
        this.queryRecord(db, scId);
    }

    public ServiceContract(ResultSet rs) throws SQLException {
        this.errors.clear();
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setServiceContractNumber(String tmp) {
        this.serviceContractNumber = tmp;
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setOrgId(String tmp) {
        this.orgId = Integer.parseInt(tmp);
    }

    public void setContractValue(double tmp) {
        this.contractValue = tmp;
    }

    public void setContractValue(String tmp) {
        this.contractValue = Double.parseDouble(tmp);
    }

    public void setInitialStartDate(Timestamp tmp) {
        this.initialStartDate = tmp;
    }

    public void setInitialStartDate(String tmp) {
        this.initialStartDate = DatabaseUtils.parseDateToTimestamp(tmp);
    }

    public void setCurrentStartDate(Timestamp tmp) {
        this.currentStartDate = tmp;
    }

    public void setCurrentStartDate(String tmp) {
        this.currentStartDate = DatabaseUtils.parseDateToTimestamp(tmp);
    }

    public void setCurrentEndDate(Timestamp tmp) {
        this.currentEndDate = tmp;
    }

    public void setCurrentEndDate(String tmp) {
        this.currentEndDate = DatabaseUtils.parseDateToTimestamp(tmp);
    }

    public void setCategory(int tmp) {
        this.category = tmp;
    }

    public void setCategory(String tmp) {
        this.category = Integer.parseInt(tmp);
    }

    public void setType(int tmp) {
        this.type = tmp;
    }

    public void setType(String tmp) {
        this.type = Integer.parseInt(tmp);
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
    }

    public void setContactId(String tmp) {
        this.contactId = Integer.parseInt(tmp);
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setContractBillingNotes(String tmp) {
        this.contractBillingNotes = tmp;
    }

    public void setTotalHoursRemaining(double tmp) {
        this.totalHoursRemaining = tmp;
    }

    public void setTotalHoursRemaining(String tmp) {
        this.totalHoursRemaining = Double.parseDouble(tmp);
    }

    public void setResponseTime(int tmp) {
        this.responseTime = tmp;
    }

    public void setResponseTime(String tmp) {
        this.responseTime = Integer.parseInt(tmp);
    }

    public void setTelephoneResponseModel(int tmp) {
        this.telephoneResponseModel = tmp;
    }

    public void setTelephoneResponseModel(String tmp) {
        this.telephoneResponseModel = Integer.parseInt(tmp);
    }

    public void setOnsiteResponseModel(int tmp) {
        this.onsiteResponseModel = tmp;
    }

    public void setOnsiteResponseModel(String tmp) {
        this.onsiteResponseModel = Integer.parseInt(tmp);
    }

    public void setEmailResponseModel(int tmp) {
        this.emailResponseModel = tmp;
    }

    public void setEmailResponseModel(String tmp) {
        this.emailResponseModel = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DateUtils.parseTimestampString(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DateUtils.parseTimestampString(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setProductList(ArrayList tmpProducts) {
        this.productList = tmpProducts;
    }

    public void setProductList(String[] criteriaString) {
        this.productList = criteriaString != null ? new ArrayList<String>(Arrays.asList(criteriaString)) : new ArrayList();
    }

    public void setServiceContractProductList(ServiceContractProductList tmp) {
        this.serviceContractProductList = tmp;
    }

    public void addProduct(int productId) {
        if (this.productList == null) {
            this.productList = new ArrayList();
        }
        this.productList.add(String.valueOf(productId));
    }

    public void addType(String productId) {
        if (this.productList == null) {
            this.productList = new ArrayList();
        }
        this.productList.add(productId);
    }

    public void setInitialStartDateTimeZone(String tmp) {
        this.initialStartDateTimeZone = tmp;
    }

    public void setCurrentStartDateTimeZone(String tmp) {
        this.currentStartDateTimeZone = tmp;
    }

    public void setCurrentEndDateTimeZone(String tmp) {
        this.currentEndDateTimeZone = tmp;
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public boolean isTrashed() {
        return this.trashedDate != null;
    }

    public String getInitialStartDateTimeZone() {
        return this.initialStartDateTimeZone;
    }

    public String getCurrentStartDateTimeZone() {
        return this.currentStartDateTimeZone;
    }

    public String getCurrentEndDateTimeZone() {
        return this.currentEndDateTimeZone;
    }

    public ArrayList getProductList() {
        return this.productList;
    }

    public ServiceContractProductList getServiceContractProductList() {
        return this.serviceContractProductList;
    }

    public void setOverride(boolean tmp) {
        this.override = tmp;
    }

    public void setOverride(String tmp) {
        this.override = DatabaseUtils.parseBoolean(tmp);
    }

    public void setServiceModelNotes(String tmp) {
        this.serviceModelNotes = tmp;
    }

    public void setAdjustmentHours(double tmp) {
        this.adjustmentHours = tmp;
    }

    public void setAdjustmentHours(String tmp) {
        this.adjustmentHours = Double.parseDouble(tmp);
    }

    public void setAdjustmentReason(int tmp) {
        this.adjustmentReason = tmp;
    }

    public void setAdjustmentReason(String tmp) {
        this.adjustmentReason = Integer.parseInt(tmp);
    }

    public void setAdjustmentNotes(String tmp) {
        this.adjustmentNotes = tmp;
    }

    public void setNetHours(String tmp) {
        this.netHours = Double.parseDouble(tmp);
    }

    public void setNetHours(double tmp) {
        this.netHours = tmp;
    }

    public int getId() {
        return this.id;
    }

    public String getServiceContractNumber() {
        return this.serviceContractNumber;
    }

    public int getOrgId() {
        return this.orgId;
    }

    public double getContractValue() {
        return this.contractValue;
    }

    public Timestamp getInitialStartDate() {
        return this.initialStartDate;
    }

    public String getInitialStartDateString() {
        String tmp = "";
        try {
            return this.initialStartDate.toString();
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public Timestamp getCurrentStartDate() {
        return this.currentStartDate;
    }

    public String getCurrentStartDateString() {
        String tmp = "";
        try {
            return this.currentStartDate.toString();
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public Timestamp getCurrentEndDate() {
        return this.currentEndDate;
    }

    public String getCurrentEndDateString() {
        String tmp = "";
        try {
            return this.currentEndDate.toString();
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public int getCategory() {
        return this.category;
    }

    public int getType() {
        return this.type;
    }

    public int getContactId() {
        return this.contactId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getContractBillingNotes() {
        return this.contractBillingNotes;
    }

    public double getTotalHoursRemaining() {
        return ServiceContract.round((double)this.totalHoursRemaining, (int)2);
    }

    public int getResponseTime() {
        return this.responseTime;
    }

    public int getTelephoneResponseModel() {
        return this.telephoneResponseModel;
    }

    public int getOnsiteResponseModel() {
        return this.onsiteResponseModel;
    }

    public int getEmailResponseModel() {
        return this.emailResponseModel;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public boolean getOverride() {
        return this.override;
    }

    public String getServiceModelNotes() {
        return this.serviceModelNotes;
    }

    public double getAdjustmentHours() {
        return this.adjustmentHours;
    }

    public int getAdjustmentReason() {
        return this.adjustmentReason;
    }

    public String getAdjustmentNotes() {
        return this.adjustmentNotes;
    }

    public double getNetHours() {
        return this.netHours;
    }

    public static ArrayList getTimeZoneParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("initialStartDate");
        thisList.add("currentStartDate");
        thisList.add("currentEndDate");
        return thisList;
    }

    public static ArrayList getNumberParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("contractValue");
        return thisList;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = -1;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE service_contract SET contract_number = ? , account_id = ? , contract_value = ? , initial_start_date = ? , initial_start_date_timezone = ? , current_start_date = ? , current_start_date_timezone = ? , current_end_date = ? , current_end_date_timezone = ? , category = ? , " + DatabaseUtils.addQuotes(db, "type") + " = ? , " + "contact_id = ? , " + "description = ? , " + "contract_billing_notes = ? , " + "total_hours_remaining = ? , " + "response_time = ? , " + "telephone_service_model= ? , " + "onsite_service_model = ? , " + "email_service_model = ? , " + "service_model_notes = ? , " + "trashed_date = ? ");
        if (!this.override) {
            sql.append(" , modified = " + DatabaseUtils.getCurrentTimestamp(db) + " , modifiedby = ? ");
        }
        sql.append("WHERE contract_id = ? ");
        if (!this.override) {
            sql.append("AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        }
        pst = db.prepareStatement(sql.toString());
        int i = 0;
        pst.setString(++i, this.serviceContractNumber);
        pst.setInt(++i, this.orgId);
        DatabaseUtils.setDouble(pst, ++i, this.contractValue);
        pst.setTimestamp(++i, this.initialStartDate);
        pst.setString(++i, this.initialStartDateTimeZone);
        if (this.currentStartDate == null) {
            pst.setTimestamp(++i, this.initialStartDate);
        } else {
            pst.setTimestamp(++i, this.currentStartDate);
        }
        pst.setString(++i, this.currentStartDateTimeZone);
        DatabaseUtils.setTimestamp(pst, ++i, this.currentEndDate);
        pst.setString(++i, this.currentEndDateTimeZone);
        DatabaseUtils.setInt(pst, ++i, this.category);
        DatabaseUtils.setInt(pst, ++i, this.type);
        DatabaseUtils.setInt(pst, ++i, this.contactId);
        pst.setString(++i, this.description);
        pst.setString(++i, this.contractBillingNotes);
        pst.setDouble(++i, this.totalHoursRemaining);
        DatabaseUtils.setInt(pst, ++i, this.responseTime);
        DatabaseUtils.setInt(pst, ++i, this.telephoneResponseModel);
        DatabaseUtils.setInt(pst, ++i, this.onsiteResponseModel);
        DatabaseUtils.setInt(pst, ++i, this.emailResponseModel);
        pst.setString(++i, this.serviceModelNotes);
        DatabaseUtils.setTimestamp(pst, ++i, this.trashedDate);
        if (!this.override) {
            pst.setInt(++i, this.modifiedBy);
        }
        pst.setInt(++i, this.id);
        if (!this.override && this.getModified() != null) {
            pst.setTimestamp(++i, this.modified);
        }
        resultCount = pst.executeUpdate();
        pst.close();
        this.insertProductList(db);
        return resultCount;
    }

    public boolean insertProductList(Connection db) throws SQLException {
        ServiceContractProductList scpList = new ServiceContractProductList();
        scpList.setContractId(this.getId());
        scpList.buildList(db);
        scpList.delete(db);
        if (this.productList != null) {
            for (int k = 0; k < this.productList.size(); ++k) {
                String productId = (String)this.productList.get(k);
                if (productId == null || "".equals(productId)) continue;
                ServiceContractProduct scp = new ServiceContractProduct();
                scp.setContractId(this.getId());
                scp.setProductId(Integer.parseInt(productId));
                scp.insert(db);
            }
        }
        return true;
    }

    public static void updateHoursRemaining(Connection db, int tmpContractId, double tmpHoursChanged) throws SQLException {
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE service_contract SET total_hours_remaining = total_hours_remaining + ? WHERE contract_id = ? ");
        pst = db.prepareStatement(sql.toString());
        int i = 0;
        pst.setDouble(++i, tmpHoursChanged);
        pst.setInt(++i, tmpContractId);
        pst.executeUpdate();
        pst.close();
    }

    public boolean updateStatus(Connection db, boolean toTrash, int tmpUserId) throws SQLException {
        int resultCount = 0;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        boolean count = false;
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            sql.append("UPDATE service_contract SET trashed_date = ? , modified = " + DatabaseUtils.getCurrentTimestamp(db) + " , " + "modifiedby = ? " + "WHERE contract_id = ? ");
            int i = 0;
            pst = db.prepareStatement(sql.toString());
            if (toTrash) {
                DatabaseUtils.setTimestamp(pst, ++i, new Timestamp(System.currentTimeMillis()));
            } else {
                DatabaseUtils.setTimestamp(pst, ++i, null);
            }
            DatabaseUtils.setInt(pst, ++i, tmpUserId);
            pst.setInt(++i, this.id);
            resultCount = pst.executeUpdate();
            pst.close();
            ContactHistory.trash(db, 7, this.getId(), !toTrash);
            AssetList assetList = new AssetList();
            assetList.setServiceContractId(this.getId());
            if (!toTrash) {
                assetList.setIncludeOnlyTrashed(true);
            }
            assetList.buildList(db);
            assetList.updateStatus(db, toTrash, tmpUserId);
            TicketList ticketList = new TicketList();
            ticketList.setServiceContractId(this.getId());
            if (!toTrash) {
                ticketList.setIncludeOnlyTrashed(true);
            }
            ticketList.buildList(db);
            ticketList.updateStatus(db, toTrash, tmpUserId);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        DependencyList dependencyList = new DependencyList();
        try {
            Dependency assetDependency = new Dependency();
            assetDependency.setName("assets");
            assetDependency.setCount(AssetList.retrieveRecordCount(db, 209041109, this.getId()));
            assetDependency.setCanDelete(true);
            dependencyList.add(assetDependency);
            Dependency ticDependency = new Dependency();
            ticDependency.setName("tickets");
            ticDependency.setCount(TicketList.retrieveRecordCount(db, 209041109, this.getId()));
            ticDependency.setCanDelete(true);
            dependencyList.add(ticDependency);
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        return dependencyList;
    }

    public boolean delete(Connection db, String baseFilePath) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Service Contract Id not specified.");
        }
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            ContactHistory.deleteObject(db, 7, this.getId());
            TicketList ticketList = new TicketList();
            ticketList.setServiceContractId(this.getId());
            ticketList.buildList(db);
            ticketList.delete(db, baseFilePath);
            ticketList = null;
            ticketList = new TicketList();
            ticketList.setServiceContractId(this.getId());
            ticketList.setIncludeOnlyTrashed(false);
            ticketList.buildList(db);
            ticketList.delete(db, baseFilePath);
            ticketList = null;
            AssetList assetList = new AssetList();
            assetList.setServiceContractId(this.getId());
            assetList.setAllAssets(false);
            assetList.buildList(db);
            assetList.delete(db, baseFilePath);
            assetList = null;
            assetList = new AssetList();
            assetList.setServiceContractId(this.getId());
            assetList.setIncludeOnlyTrashed(true);
            assetList.setAllAssets(false);
            assetList.buildList(db);
            assetList.delete(db, baseFilePath);
            assetList = null;
            ServiceContractHoursList scHoursList = new ServiceContractHoursList();
            scHoursList.setContractId(this.id);
            scHoursList.buildList(db);
            scHoursList.delete(db);
            scHoursList = null;
            ServiceContractProductList scProductList = new ServiceContractProductList();
            scProductList.setContractId(this.id);
            scProductList.buildList(db);
            scProductList.delete(db);
            scProductList = null;
            ContactHistory.deleteObject(db, 7, this.getId());
            Statement st = db.createStatement();
            st.executeUpdate("DELETE FROM service_contract WHERE contract_id = " + this.getId());
            st.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "service_contract_contract_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO service_contract (" + (this.id > -1 ? "contract_id, " : "") + "contract_number , " + "account_id , " + "contract_value , " + "initial_start_date , " + "initial_start_date_timezone, " + "current_start_date , " + "current_start_date_timezone, " + "current_end_date , " + "current_end_date_timezone , " + "category , " + DatabaseUtils.addQuotes(db, "type") + " , " + "contact_id , " + "description , " + "contract_billing_notes , " + "total_hours_remaining , " + "response_time , " + "telephone_service_model , " + "onsite_service_model , " + "email_service_model , " + "service_model_notes , " + "enteredby , " + "modifiedby , " + "trashed_date ) " + "VALUES (" + (this.id > -1 ? "?," : "") + "?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setString(++i, this.serviceContractNumber);
        pst.setInt(++i, this.orgId);
        DatabaseUtils.setDouble(pst, ++i, this.contractValue);
        pst.setTimestamp(++i, this.initialStartDate);
        pst.setString(++i, this.initialStartDateTimeZone);
        if (this.currentStartDate == null) {
            pst.setTimestamp(++i, this.initialStartDate);
        } else {
            pst.setTimestamp(++i, this.currentStartDate);
        }
        pst.setString(++i, this.currentStartDateTimeZone);
        DatabaseUtils.setTimestamp(pst, ++i, this.currentEndDate);
        pst.setString(++i, this.currentEndDateTimeZone);
        DatabaseUtils.setInt(pst, ++i, this.category);
        DatabaseUtils.setInt(pst, ++i, this.type);
        DatabaseUtils.setInt(pst, ++i, this.contactId);
        pst.setString(++i, this.description);
        pst.setString(++i, this.contractBillingNotes);
        pst.setDouble(++i, this.totalHoursRemaining);
        DatabaseUtils.setInt(pst, ++i, this.responseTime);
        DatabaseUtils.setInt(pst, ++i, this.telephoneResponseModel);
        DatabaseUtils.setInt(pst, ++i, this.onsiteResponseModel);
        DatabaseUtils.setInt(pst, ++i, this.emailResponseModel);
        pst.setString(++i, this.serviceModelNotes);
        pst.setInt(++i, this.enteredBy);
        pst.setInt(++i, this.modifiedBy);
        DatabaseUtils.setTimestamp(pst, ++i, this.trashedDate);
        pst.execute();
        this.id = DatabaseUtils.getCurrVal(db, "service_contract_contract_id_seq", this.id);
        pst.close();
        this.insertProductList(db);
        return true;
    }

    public void queryRecord(Connection db, int tmpContractId) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement(" SELECT *  FROM service_contract  WHERE contract_id = ? ");
        pst.setInt(1, tmpContractId);
        rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        this.buildServiceContractProductList(db);
    }

    public void buildServiceContractProductList(Connection db) throws SQLException {
        this.serviceContractProductList = new ServiceContractProductList();
        this.serviceContractProductList.setContractId(this.id);
        this.serviceContractProductList.buildList(db);
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("contract_id");
        this.serviceContractNumber = rs.getString("contract_number");
        this.orgId = rs.getInt("account_id");
        this.initialStartDate = rs.getTimestamp("initial_start_date");
        this.currentStartDate = rs.getTimestamp("current_start_date");
        this.currentEndDate = rs.getTimestamp("current_end_date");
        this.category = DatabaseUtils.getInt(rs, "category");
        this.type = DatabaseUtils.getInt(rs, "type");
        this.contactId = DatabaseUtils.getInt(rs, "contact_id");
        this.description = rs.getString("description");
        this.contractBillingNotes = rs.getString("contract_billing_notes");
        this.responseTime = DatabaseUtils.getInt(rs, "response_time");
        this.telephoneResponseModel = DatabaseUtils.getInt(rs, "telephone_service_model");
        this.onsiteResponseModel = DatabaseUtils.getInt(rs, "onsite_service_model");
        this.emailResponseModel = DatabaseUtils.getInt(rs, "email_service_model");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.enabled = rs.getBoolean("enabled");
        this.contractValue = DatabaseUtils.getDouble(rs, "contract_value");
        this.totalHoursRemaining = rs.getDouble("total_hours_remaining");
        this.serviceModelNotes = rs.getString("service_model_notes");
        this.initialStartDateTimeZone = rs.getString("initial_start_date_timezone");
        this.currentStartDateTimeZone = rs.getString("current_start_date_timezone");
        this.currentEndDateTimeZone = rs.getString("current_end_date_timezone");
        this.trashedDate = rs.getTimestamp("trashed_date");
    }
}

