/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.servicecontracts.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.utils.DatabaseUtils;

public class ServiceContractHours
extends GenericBean {
    private int id = -1;
    private int serviceContractId = -1;
    private double adjustmentHours = 0.0;
    private int adjustmentReason = -1;
    private String adjustmentNotes = null;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;

    public ServiceContractHours() {
    }

    public ServiceContractHours(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setServiceContractId(int tmp) {
        this.serviceContractId = tmp;
    }

    public void setServiceContractId(String tmp) {
        this.serviceContractId = Integer.parseInt(tmp);
    }

    public void setAdjustmentHours(double tmp) {
        this.adjustmentHours = tmp;
    }

    public void setAdjustmentHours(String tmp) {
        this.adjustmentHours = Double.parseDouble(tmp);
    }

    public void setAdjustmentReason(int tmp) {
        this.adjustmentReason = tmp;
    }

    public void setAdjustmentReason(String tmp) {
        this.adjustmentReason = Integer.parseInt(tmp);
    }

    public void setAdjustmentNotes(String tmp) {
        this.adjustmentNotes = tmp;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getServiceContractId() {
        return this.serviceContractId;
    }

    public double getAdjustmentHours() {
        return ServiceContractHours.round((double)this.adjustmentHours, (int)2);
    }

    public int getAdjustmentReason() {
        return this.adjustmentReason;
    }

    public String getAdjustmentNotes() {
        return this.adjustmentNotes;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public void delete(Connection db) throws SQLException {
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE  FROM service_contract_hours WHERE history_id = ? ");
        pst = db.prepareStatement(sql.toString());
        int i = 0;
        pst.setInt(++i, this.id);
        pst.execute();
        pst.close();
    }

    public void queryRecord(Connection db) throws SQLException {
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM service_contract_hours WHERE id = ? ");
        pst = db.prepareStatement(sql.toString());
        int i = 0;
        pst.setInt(++i, this.id);
        pst.executeQuery();
        pst.close();
    }

    public boolean insert(Connection db) throws SQLException {
        int resultCount = -1;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        this.id = DatabaseUtils.getNextSeq(db, "service_contract_hours_history_id_seq");
        sql.append("INSERT INTO service_contract_hours (" + (this.id > -1 ? "history_id, " : "") + "link_contract_id, " + "adjustment_hours, " + "adjustment_reason, " + "adjustment_notes, " + "enteredby , " + "modifiedby ) " + "VALUES " + "(" + (this.id > -1 ? "?," : "") + "?,?,?,?,?,?)");
        pst = db.prepareStatement(sql.toString());
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.serviceContractId);
        pst.setDouble(++i, this.adjustmentHours);
        DatabaseUtils.setInt(pst, ++i, this.adjustmentReason);
        pst.setString(++i, this.adjustmentNotes);
        pst.setInt(++i, this.enteredBy);
        pst.setInt(++i, this.modifiedBy);
        pst.execute();
        this.id = DatabaseUtils.getCurrVal(db, "service_contract_hours_history_id_seq", this.id);
        pst.close();
        return true;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("history_id");
        this.serviceContractId = rs.getInt("link_contract_id");
        this.adjustmentHours = rs.getFloat("adjustment_hours");
        this.adjustmentReason = rs.getInt("adjustment_reason");
        this.adjustmentNotes = rs.getString("adjustment_notes");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
    }
}

