/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.servicecontracts.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.servicecontracts.base.ServiceContract;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.PagedListInfo;

public class ServiceContractList
extends ArrayList {
    public static final String tableName = "service_contract";
    public static final String uniqueField = "contract_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private String emptyHtmlSelectRecord = null;
    private String jsEvent = null;
    private int id = -1;
    private int orgId = -1;
    private int contactId = -1;
    private String serviceContractNumber = null;
    private int enteredBy = -1;
    private Timestamp trashedDate = null;
    private boolean includeOnlyTrashed = false;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public ServiceContractList() {
    }

    public ServiceContractList(Connection db) throws SQLException {
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setEmptyHtmlSelectRecord(String tmp) {
        this.emptyHtmlSelectRecord = tmp;
    }

    public void setJsEvent(String tmp) {
        this.jsEvent = tmp;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setOrgId(String tmp) {
        this.orgId = Integer.parseInt(tmp);
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
    }

    public void setContactId(String tmp) {
        this.contactId = Integer.parseInt(tmp);
    }

    public void setServiceContractNumber(String tmp) {
        this.serviceContractNumber = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setIncludeOnlyTrashed(boolean tmp) {
        this.includeOnlyTrashed = tmp;
    }

    public void setIncludeOnlyTrashed(String tmp) {
        this.includeOnlyTrashed = DatabaseUtils.parseBoolean(tmp);
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public String getEmptyHtmlSelectRecord() {
        return this.emptyHtmlSelectRecord;
    }

    public String getJsEvent() {
        return this.jsEvent;
    }

    public int getId() {
        return this.id;
    }

    public int getOrgId() {
        return this.orgId;
    }

    public int getContactId() {
        return this.contactId;
    }

    public String getServiceContractNumber() {
        return this.serviceContractNumber;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public boolean getIncludeOnlyTrashed() {
        return this.includeOnlyTrashed;
    }

    public void buildList(Connection db) throws SQLException {
        Statement pst = null;
        ResultSet rs = this.queryList(db, (PreparedStatement)pst);
        while (rs.next()) {
            ServiceContract thisContract = this.getObject(rs);
            this.add(thisContract);
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
    }

    public ResultSet queryList(Connection db, PreparedStatement pst) throws SQLException {
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM service_contract WHERE contract_id > -1 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("entered", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY entered ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("sc.* FROM service_contract sc WHERE contract_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        return rs;
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) throws SQLException {
        if (this.enteredBy > -1) {
            sqlFilter.append("AND enteredby = ? ");
        }
        if (this.id > -1) {
            sqlFilter.append("AND contract_id = ? ");
        }
        if (this.orgId > -1) {
            sqlFilter.append("AND account_id = ? ");
        }
        if (this.contactId > -1) {
            sqlFilter.append("AND contact_id = ? ");
        }
        if (this.serviceContractNumber != null) {
            sqlFilter.append("AND contract_number = ? ");
        }
        if (this.includeOnlyTrashed) {
            sqlFilter.append("AND trashed_date IS NOT NULL ");
        } else if (this.trashedDate != null) {
            sqlFilter.append("AND trashed_date = ? ");
        } else {
            sqlFilter.append("AND trashed_date IS NULL ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.enteredBy > -1) {
            pst.setInt(++i, this.enteredBy);
        }
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.orgId > -1) {
            pst.setInt(++i, this.orgId);
        }
        if (this.contactId > -1) {
            pst.setInt(++i, this.contactId);
        }
        if (this.serviceContractNumber != null) {
            pst.setString(++i, this.serviceContractNumber);
        }
        if (!this.includeOnlyTrashed && this.trashedDate != null) {
            pst.setTimestamp(++i, this.trashedDate);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public ServiceContract getObject(ResultSet rs) throws SQLException {
        ServiceContract thisContract = new ServiceContract(rs);
        return thisContract;
    }

    public static int retrieveRecordCount(Connection db, int moduleId, int itemId) throws SQLException {
        ResultSet rs;
        int count = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT COUNT(*) AS itemcount FROM service_contract sc WHERE sc.contract_id > 0 AND sc.trashed_date IS NULL ");
        if (moduleId == 1) {
            sql.append("AND sc.account_id = ?");
        }
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (moduleId == 1) {
            pst.setInt(1, itemId);
        }
        if ((rs = pst.executeQuery()).next()) {
            count = rs.getInt("itemcount");
        }
        rs.close();
        pst.close();
        return count;
    }

    public void delete(Connection db, String baseFilePath) throws SQLException {
        for (ServiceContract thisContract : this) {
            thisContract.delete(db, baseFilePath);
        }
    }

    public String getHtmlSelect(String selectName) {
        return this.getHtmlSelect(selectName, -1);
    }

    public String getHtmlSelect(String selectName, int defaultKey) {
        HtmlSelect contractListSelect = new HtmlSelect();
        if (this.emptyHtmlSelectRecord != null) {
            contractListSelect.addItem(-1, this.emptyHtmlSelectRecord);
        }
        for (ServiceContract thisContract : this) {
            contractListSelect.addItem(thisContract.getId(), thisContract.getServiceContractNumber());
        }
        return contractListSelect.getHtml(selectName, defaultKey);
    }

    public boolean updateStatus(Connection db, boolean toTrash, int tmpUserId) throws SQLException {
        for (ServiceContract tmpServiceContract : this) {
            tmpServiceContract.updateStatus(db, toTrash, tmpUserId);
        }
        return true;
    }
}

