/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.servicecontracts.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.utils.DatabaseUtils;

public class ServiceContractProduct
extends GenericBean {
    private int id = -1;
    private int contractId = -1;
    private int productId = -1;
    private String productSku = null;
    private String productName = null;

    public ServiceContractProduct() {
    }

    public ServiceContractProduct(Connection db, int tmpId) throws SQLException {
        this.id = tmpId;
        this.queryRecord(db);
    }

    public ServiceContractProduct(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setContractId(int tmp) {
        this.contractId = tmp;
    }

    public void setContractId(String tmp) {
        this.contractId = Integer.parseInt(tmp);
    }

    public void setProductId(int tmp) {
        this.productId = tmp;
    }

    public void setProductId(String tmp) {
        this.productId = Integer.parseInt(tmp);
    }

    public void setProductSku(String tmp) {
        this.productSku = tmp;
    }

    public void setProductName(String tmp) {
        this.productName = tmp;
    }

    public int getId() {
        return this.id;
    }

    public int getContractId() {
        return this.contractId;
    }

    public int getProductId() {
        return this.productId;
    }

    public String getProductSku() {
        return this.productSku;
    }

    public String getProductName() {
        return this.productName;
    }

    public void delete(Connection db) throws SQLException {
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE  FROM service_contract_products WHERE id = ? ");
        pst = db.prepareStatement(sql.toString());
        int i = 0;
        pst.setInt(++i, this.id);
        pst.execute();
        pst.close();
    }

    public void queryRecord(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT scp.* ,  pc.sku AS productsku ,  pc.product_name AS productname  FROM service_contract_products scp  LEFT JOIN product_catalog pc ON (pc.product_id = scp.link_product_id)  WHERE id = ? ");
        pst = db.prepareStatement(sql.toString());
        int i = 0;
        pst.setInt(++i, this.id);
        rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
    }

    public boolean insert(Connection db) throws SQLException {
        int resultCount = -1;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        this.id = DatabaseUtils.getNextSeq(db, "service_contract_products_id_seq");
        sql.append("INSERT INTO service_contract_products (" + (this.id > -1 ? "id, " : "") + "link_contract_id,  " + " link_product_id ) " + "VALUES (" + (this.id > -1 ? "?," : "") + "?,?) ");
        pst = db.prepareStatement(sql.toString());
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.contractId);
        pst.setInt(++i, this.productId);
        pst.execute();
        this.id = DatabaseUtils.getCurrVal(db, "service_contract_products_id_seq", this.id);
        pst.close();
        return true;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("id");
        this.contractId = rs.getInt("link_contract_id");
        this.productId = rs.getInt("link_product_id");
        this.productSku = rs.getString("productsku");
        this.productName = rs.getString("productname");
    }
}

