/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.setup.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.darkhorseventures.framework.hooks.CustomHook;
import java.io.File;
import java.io.IOException;
import java.security.Key;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.TimeZone;
import org.apache.commons.codec.binary.Hex;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactEmailAddress;
import org.aspcfs.modules.setup.beans.DatabaseBean;
import org.aspcfs.modules.setup.beans.ServerBean;
import org.aspcfs.modules.setup.beans.UserSetupBean;
import org.aspcfs.modules.setup.utils.Prefs;
import org.aspcfs.modules.setup.utils.SetupUtils;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.FileUtils;
import org.aspcfs.utils.LDAPUtils;
import org.aspcfs.utils.PrivateString;
import org.aspcfs.utils.SMTPMessage;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.Template;
import org.aspcfs.utils.web.RequestUtils;

public class Setup
extends CFSModule {
    public static final String os = System.getProperty("os.name");

    public String executeCommandDefault(ActionContext context) {
        if (Setup.isAlreadySetup(context)) {
            return "SetupCompleteError";
        }
        this.addModuleBean(context, null, "Welcome");
        return "SetupOK";
    }

    public String executeCommandWelcome(ActionContext context) {
        if (Setup.isAlreadySetup(context)) {
            return "SetupCompleteError";
        }
        this.addModuleBean(context, null, "Welcome");
        String language = context.getRequest().getParameter("language");
        ApplicationPrefs prefs = this.getApplicationPrefs(context);
        prefs.add("SYSTEM.LANGUAGE", language);
        prefs.loadApplicationDictionary(context.getServletContext());
        CustomHook.populateSetup((ActionContext)context, (String)this.getPath(context));
        return "WelcomeOK";
    }

    public String executeCommandRegister(ActionContext context) {
        if (Setup.isAlreadySetup(context)) {
            return "SetupCompleteError";
        }
        this.addModuleBean(context, null, "Register");
        return CustomHook.populateRegister((ActionContext)context, (String)this.getPath(context));
    }

    public String executeCommandSendReg(ActionContext context) {
        this.addModuleBean(context, null, "Register");
        return CustomHook.populateSendReg((ActionContext)context, (ApplicationPrefs)this.getApplicationPrefs(context));
    }

    public String executeCommandValidate(ActionContext context) {
        this.addModuleBean(context, null, "Register");
        return CustomHook.populateValidate((ActionContext)context, (ApplicationPrefs)this.getApplicationPrefs(context), (String)this.getPath(context));
    }

    public String executeCommandConfigureDirectoryCheck(ActionContext context) {
        if (Setup.isAlreadySetup(context)) {
            return "SetupCompleteError";
        }
        this.addModuleBean(context, null, "Storage");
        String path = context.getRequest().getParameter("fileLibrary");
        if (path == null) {
            path = Setup.getPref(context, "FILELIBRARY");
        }
        if (path == null) {
            File testDirectory;
            String instanceName = context.getServletContext().getRealPath("/");
            if (instanceName != null) {
                File instance = new File(instanceName);
                instanceName = instance.getName();
            } else {
                instanceName = "centric";
            }
            path = os.startsWith("Windows") ? "c:\\CentricCRM\\fileLibrary\\" + instanceName + "\\" : (os.startsWith("Mac") ? "/Library/Application Support/CentricCRM/fileLibrary/" + instanceName + "/" : ((testDirectory = new File("/opt")).exists() ? "/opt/centric_crm/fileLibrary/" + instanceName + "/" : "/var/lib/centric_crm/fileLibrary/" + instanceName + "/"));
        }
        context.getRequest().setAttribute("fileLibrary", (Object)path);
        return "ConfigureDirectoryCheckOK";
    }

    public String executeCommandConfigureDirectory(ActionContext context) {
        if (Setup.isAlreadySetup(context)) {
            return "SetupCompleteError";
        }
        this.addModuleBean(context, null, "Storage");
        ApplicationPrefs prefs = this.getApplicationPrefs(context);
        String fileLibrary = context.getRequest().getParameter("fileLibrary");
        if (fileLibrary == null || fileLibrary.trim().length() == 0) {
            context.getRequest().setAttribute("actionError", (Object)prefs.getLabel("object.validation.incorrectTargetDirectoryName", prefs.get("SYSTEM.LANGUAGE")));
            return "ConfigureDirectoryERROR";
        }
        try {
            File targetDirectory;
            if (!fileLibrary.endsWith(fs)) {
                fileLibrary = fileLibrary + fs;
            }
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Setup-> ConfigureDirectory path = " + fileLibrary);
            }
            if ((targetDirectory = new File(fileLibrary)).exists()) {
                File propertiesFile = new File(fileLibrary + "build.properties");
                if (propertiesFile.exists()) {
                    prefs = new ApplicationPrefs(fileLibrary + "build.properties");
                    prefs.add("FILELIBRARY", fileLibrary);
                    prefs.add("CONTROL", null);
                    prefs.add("WEB-INF", null);
                    context.getServletContext().setAttribute("applicationPrefs", (Object)prefs);
                } else {
                    prefs.setFilename(fileLibrary + "build.properties");
                    prefs.add("FILELIBRARY", fileLibrary);
                    prefs.save();
                }
                return "ConfigureDirectoryOK";
            }
            return "ConfigureDirectoryConfirmOK";
        }
        catch (Exception e) {
            return "ConfigureDirectoryConfirmOK";
        }
    }

    public String executeCommandConfigureDirectoryMake(ActionContext context) {
        if (Setup.isAlreadySetup(context)) {
            return "SetupCompleteError";
        }
        this.addModuleBean(context, null, "Storage");
        try {
            File targetDirectory;
            String path = context.getRequest().getParameter("fileLibrary");
            if (!path.endsWith(fs)) {
                path = path + fs;
            }
            if (!(targetDirectory = new File(path)).exists()) {
                targetDirectory.mkdirs();
            }
            ApplicationPrefs prefs = this.getApplicationPrefs(context);
            prefs.setFilename(path + "build.properties");
            prefs.add("FILELIBRARY", path);
            prefs.save();
            return "ConfigureDirectoryOK";
        }
        catch (Exception e) {
            context.getRequest().setAttribute("actionError", (Object)("An error occurred while trying to create the directory, the following error was provided: " + e.getMessage()));
            return "ConfigureDirectoryERROR";
        }
    }

    public String executeCommandConfigureDirectoryFinalize(ActionContext context) {
        if (Setup.isAlreadySetup(context)) {
            return "SetupCompleteError";
        }
        this.addModuleBean(context, null, "Storage");
        ApplicationPrefs prefs = this.getApplicationPrefs(context);
        String userFileLibrary = Setup.getPref(context, "FILELIBRARY");
        if (System.getProperty("DEBUG") != null) {
            System.out.println("Setup-> ConfigureDirectoryFinalize path = " + userFileLibrary);
        }
        File userLibraryPath = new File(userFileLibrary);
        if (userFileLibrary == null || !userLibraryPath.isDirectory()) {
            context.getRequest().setAttribute("actionError", (Object)prefs.getLabel("object.validation.actionError.fileLibraryPathNotConfigured", prefs.get("SYSTEM.LANGUAGE")));
            return "ConfigureDirectoryERROR";
        }
        try {
            File destPath = new File(userFileLibrary + "init" + fs);
            destPath.mkdirs();
            if (!CustomHook.populateDirectory((ActionContext)context, (ApplicationPrefs)prefs, (String)userFileLibrary)) {
                return "ConfigureDirectoryERROR";
            }
            String dir = Prefs.retrieveContextPrefName(context.getServletContext());
            Prefs.savePref(dir, userFileLibrary);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("actionError", (Object)prefs.getLabel("object.validation.actionError.incorrectDirectoryRWPermissions", prefs.get("SYSTEM.LANGUAGE")));
            return "ConfigureDirectoryERROR";
        }
        return "ConfigureDirectoryCompleteOK";
    }

    public String executeCommandConfigureDatabaseCheck(ActionContext context) {
        if (Setup.isAlreadySetup(context)) {
            return "SetupCompleteError";
        }
        this.addModuleBean(context, null, "Database");
        CustomHook.populateDatabaseCheck((ActionContext)context);
        DatabaseBean bean = (DatabaseBean)((Object)context.getFormBean());
        if (bean.getConfigured() == -1) {
            try {
                String fileLibrary = Setup.getPref(context, "FILELIBRARY") + "init" + fs;
                File dbPref = new File(fileLibrary + "conn.sgml");
                if (dbPref.exists()) {
                    String dbInfo = StringUtils.loadText(fileLibrary + "conn.sgml");
                    Key key = Setup.getOrMakeKey(fileLibrary);
                    bean.setConnection(PrivateString.decrypt(key, dbInfo));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "ConfigureDatabaseCheckOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfigureDatabase(ActionContext context) {
        if (Setup.isAlreadySetup(context)) {
            return "SetupCompleteError";
        }
        this.addModuleBean(context, null, "Database");
        CustomHook.populateDatabaseCheck((ActionContext)context);
        ApplicationPrefs prefs = this.getApplicationPrefs(context);
        DatabaseBean bean = (DatabaseBean)((Object)context.getFormBean());
        CustomHook.populateDatabaseBean((DatabaseBean)bean);
        int timeout = DriverManager.getLoginTimeout();
        try {
            boolean isValid = false;
            isValid = this.validateObject(context, null, (Object)bean);
            if (!isValid) {
                String string = "ConfigureDatabaseERROR";
                return string;
            }
            String dbPath = Setup.getPref(context, "FILELIBRARY") + bean.getName() + fs;
            File dbDirectory = new File(dbPath);
            String setupPath = context.getServletContext().getRealPath("/") + "WEB-INF" + fs + "setup" + fs;
            try {
                Class.forName(bean.getDriver());
            }
            catch (ClassNotFoundException e) {
                context.getRequest().setAttribute("actionError", (Object)("Driver missing -- class not found: " + e.getMessage()));
                String string = "ConfigureDatabaseERROR";
                DriverManager.setLoginTimeout(timeout);
                return string;
            }
            DriverManager.setLoginTimeout(10);
            if (bean.isEmbedded()) {
                bean.setPath(dbPath);
            }
            Connection db = DatabaseUtils.getConnection(bean.getUrl(), bean.getUser(), bean.getPassword());
            String fileLibrary = Setup.getPref(context, "FILELIBRARY") + "init" + fs;
            String dbInfo = bean.getConnection();
            Key key = Setup.getKey(fileLibrary);
            StringUtils.saveText(fileLibrary + "conn.sgml", PrivateString.encrypt(key, dbInfo));
            dbDirectory.mkdirs();
            FileUtils.copyFile(new File(setupPath + "init" + fs + "application.xml"), new File(dbPath + "application.xml"), true);
            FileUtils.copyFile(new File(setupPath + "init" + fs + "system.xml"), new File(dbPath + "system.xml"), false);
            FileUtils.copyFile(new File(setupPath + "init" + fs + "workflow_*.xml"), new File(dbPath), true);
            FileUtils.copyFile(new File(setupPath + "init" + fs + "templates_*.xml"), new File(dbPath), true);
            boolean databaseExists = this.isDatabaseInstalled(db);
            db.close();
            prefs.add("GATEKEEPER.APPCODE", (String)context.getServletContext().getAttribute("SiteCode"));
            prefs.add("GATEKEEPER.DBTYPE", bean.getTypeValue());
            prefs.add("GATEKEEPER.DRIVER", bean.getDriver());
            prefs.add("GATEKEEPER.URL", bean.getUrl());
            prefs.add("GATEKEEPER.DATABASE", bean.getName());
            prefs.add("GATEKEEPER.USER", bean.getUser());
            prefs.add("GATEKEEPER.PASSWORD", bean.getPassword());
            prefs.save();
            if (databaseExists) {
                String string = "ConfigureDatabaseCreateOK";
                return string;
            }
            String string = "ConfigureDatabaseOK";
            return string;
        }
        catch (Exception e) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("${error.message}", e.getMessage());
            context.getRequest().setAttribute("actionError", (Object)Setup.getLabel(map, prefs.getLabel("object.validation.actionError.databaseConnectionError", prefs.get("SYSTEM.LANGUAGE"))));
            String string = "ConfigureDatabaseERROR";
            return string;
        }
        finally {
            DriverManager.setLoginTimeout(timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String executeCommandConfigureDatabaseData(ActionContext context) {
        String cle3;
        if (Setup.isAlreadySetup(context)) {
            return "SetupCompleteError";
        }
        this.addModuleBean(context, null, "Database");
        ApplicationPrefs prefs = this.getApplicationPrefs(context);
        String locale = prefs.get("SYSTEM.LANGUAGE");
        String setupPath = context.getServletContext().getRealPath("/") + "WEB-INF" + fs + "setup" + fs;
        String dbFileLibraryPath = prefs.get("FILELIBRARY") + prefs.get("GATEKEEPER.DATABASE") + fs;
        String backupFile = context.getRequest().getParameter("backupFile");
        boolean isRestoreFromBackup = backupFile != null && !"".equals(backupFile);
        Connection db = null;
        Connection dbLookup = null;
        try {
            File restoreFile;
            if (isRestoreFromBackup && !(restoreFile = new File(backupFile)).exists()) {
                context.getRequest().setAttribute("actionError", (Object)("The backup file was not found: " + backupFile));
                String string = "ConfigureDatabaseRestoreERROR";
                return string;
            }
            db = this.getDbConnection(context);
            if (!this.isDatabaseInstalled(db)) {
                try {
                    SetupUtils.createDatabaseSchema(db, setupPath);
                    SetupUtils.insertDefaultData(db, dbFileLibraryPath, setupPath, locale, isRestoreFromBackup);
                    if (isRestoreFromBackup) {
                        dbLookup = this.getDbConnection(context);
                        SetupUtils.restoreFromBackup(db, dbLookup, backupFile);
                    }
                }
                catch (SQLException cre) {
                    throw new SQLException(cre.getMessage());
                }
                if (db != null) {
                    try {
                        db.close();
                    }
                    catch (Exception cle2) {
                        // empty catch block
                    }
                }
                if (dbLookup != null) {
                    try {
                        dbLookup.close();
                    }
                    catch (Exception cle3) {
                        // empty catch block
                    }
                }
            }
            cle3 = "ConfigureDatabaseCreateOK";
        }
        catch (Exception e) {
            if (System.getProperty("DEBUG") != null) {
                System.out.println(e.getMessage());
                e.printStackTrace(System.out);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("${error.message}", e.getMessage());
            context.getRequest().setAttribute("actionError", (Object)Setup.getLabel(map, prefs.getLabel("object.validation.actionError.databaseCreationError", prefs.get("SYSTEM.LANGUAGE"))));
            String string = "ConfigureDatabaseCreateERROR";
            return string;
        }
        finally {
            if (db != null) {
                try {
                    db.close();
                }
                catch (Exception e) {}
            }
            if (dbLookup != null) {
                try {
                    dbLookup.close();
                }
                catch (Exception e) {}
            }
        }
        return cle3;
    }

    public String executeCommandConfigureServerCheck(ActionContext context) {
        if (Setup.isAlreadySetup(context)) {
            return "SetupCompleteError";
        }
        this.addModuleBean(context, null, "Servers");
        ServerBean bean = (ServerBean)((Object)context.getFormBean());
        if (bean.getConfigured() == -1) {
            ApplicationPrefs prefs = this.getApplicationPrefs(context);
            try {
                String fileLibrary = Setup.getPref(context, "FILELIBRARY") + "init" + fs;
                File serverPref = new File(fileLibrary + "srv1.sgml");
                if (serverPref.exists()) {
                    String serverInfo = StringUtils.loadText(fileLibrary + "srv1.sgml");
                    Key key = Setup.getOrMakeKey(fileLibrary);
                    bean.setServerInfo(PrivateString.decrypt(key, serverInfo));
                    bean.setServerInfo(prefs);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            if (bean.getUrl() == null) {
                bean.setUrl(RequestUtils.getServerUrl(context.getRequest()));
            }
            if (bean.getTimeZone() == null) {
                bean.setTimeZone(TimeZone.getDefault().getID());
            }
            if (bean.getLanguage() == null) {
                bean.setLanguage(prefs.get("SYSTEM.LANGUAGE"));
            }
        }
        return "ConfigureServerCheckOK";
    }

    public String executeCommandConfigureServer(ActionContext context) {
        if (Setup.isAlreadySetup(context)) {
            return "SetupCompleteError";
        }
        this.addModuleBean(context, null, "Servers");
        ServerBean bean = (ServerBean)((Object)context.getFormBean());
        ApplicationPrefs prefs = this.getApplicationPrefs(context);
        try {
            boolean isValid = false;
            isValid = this.validateObject(context, null, (Object)bean);
            if (!isValid) {
                return "ConfigureServerERROR";
            }
            String fileLibrary = Setup.getPref(context, "FILELIBRARY") + "init" + fs;
            Key key = Setup.getOrMakeKey(fileLibrary);
            String serverInfo = bean.getServerInfo();
            StringUtils.saveText(fileLibrary + "srv1.sgml", PrivateString.encrypt(key, serverInfo));
            CustomHook.populateServerInfo((ActionContext)context, (String)this.getPath(context), (Key)key);
            prefs.add("WEBSERVER.URL", bean.getUrl());
            prefs.add("MAILSERVER", bean.getEmail());
            prefs.add("FAXSERVER", bean.getFax());
            if (bean.getFax() != null && !"".equals(bean.getFax().trim())) {
                prefs.add("FAXENABLED", "true");
            } else {
                prefs.add("FAXENABLED", "false");
            }
            prefs.add("EMAILADDRESS", bean.getEmailAddress());
            prefs.add("SYSTEM.TIMEZONE", bean.getTimeZone());
            prefs.add("SYSTEM.CURRENCY", bean.getCurrency());
            prefs.add("SYSTEM.LANGUAGE", bean.getLanguage());
            prefs.add("SYSTEM.COUNTRY", bean.getCountry());
            prefs.add("ASTERISK.OUTBOUND.ENABLED", StringUtils.valueOf(bean.getAsteriskOutbound()));
            prefs.add("ASTERISK.INBOUND.ENABLED", StringUtils.valueOf(bean.getAsteriskInbound()));
            prefs.add("ASTERISK.URL", bean.getAsteriskUrl());
            prefs.add("ASTERISK.USERNAME", bean.getAsteriskUsername());
            prefs.add("ASTERISK.PASSWORD", bean.getAsteriskPassword());
            prefs.add("ASTERISK.CONTEXT", bean.getAsteriskContext());
            prefs.add("XMPP.ENABLED", StringUtils.valueOf(bean.getXmppEnabled()));
            prefs.add("XMPP.CONNECTION.SSL", StringUtils.valueOf(bean.getXmppSSL()));
            prefs.add("XMPP.CONNECTION.URL", bean.getXmppUrl());
            prefs.add("XMPP.CONNECTION.PORT", String.valueOf(bean.getXmppPort()));
            prefs.add("XMPP.MANAGER.USERNAME", bean.getXmppUsername());
            prefs.add("XMPP.MANAGER.PASSWORD", bean.getXmppPassword());
            prefs.add("LDAP.ENABLED", StringUtils.valueOf(bean.getLdapEnabled()));
            prefs.add("LDAP.CENTRIC_CRM.FIELD", bean.getLdapCentricCRMField());
            prefs.add("LDAP.FACTORY", bean.getLdapFactory());
            prefs.add("LDAP.SERVER", bean.getLdapUrl());
            prefs.add("LDAP.SEARCH.BY_ATTRIBUTE", StringUtils.valueOf(bean.getLdapSearchByAttribute()));
            prefs.add("LDAP.SEARCH.USERNAME", bean.getLdapSearchUsername());
            prefs.add("LDAP.SEARCH.PASSWORD", bean.getLdapSearchPassword());
            prefs.add("LDAP.SEARCH.CONTAINER", bean.getLdapSearchContainer());
            prefs.add("LDAP.SEARCH.ORGPERSON", bean.getLdapSearchOrgPerson());
            prefs.add("LDAP.SEARCH.SUBTREE", StringUtils.valueOf(bean.getLdapSearchSubtree()));
            prefs.add("LDAP.SEARCH.ATTRIBUTE", bean.getLdapSearchAttribute());
            prefs.loadApplicationDictionary(context.getServletContext());
            prefs.save();
            return "ConfigureServerOK";
        }
        catch (Exception e) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("${error.message}", e.getMessage());
            context.getRequest().setAttribute("actionError", (Object)Setup.getLabel(map, prefs.getLabel("object.validation.actionError.preferencesSaveError", prefs.get("SYSTEM.LANGUAGE"))));
            return "ConfigureServerERROR";
        }
    }

    public String executeCommandTestEmail(ActionContext context) {
        if (Setup.isAlreadySetup(context)) {
            return "SetupCompleteError";
        }
        ApplicationPrefs prefs = this.getApplicationPrefs(context);
        SMTPMessage message = new SMTPMessage();
        message.setHost(context.getRequest().getParameter("server"));
        message.setFrom(context.getRequest().getParameter("from"));
        message.setTo(context.getRequest().getParameter("to"));
        message.setSubject(prefs.getLabel("mail.subject.test", prefs.get("SYSTEM.LANGUAGE")));
        message.setSubject(prefs.getLabel("mail.body.congratulations", prefs.get("SYSTEM.LANGUAGE")));
        int result = message.send();
        if (result == 0) {
            return "SendMailOK";
        }
        context.getRequest().setAttribute("actionError", (Object)message.getErrorMsg());
        return "SendMailERROR";
    }

    public String executeCommandTestLDAP(ActionContext context) {
        String password;
        String username;
        if (Setup.isAlreadySetup(context)) {
            return "SetupCompleteError";
        }
        ApplicationPrefs prefs = this.getApplicationPrefs(context);
        int result = LDAPUtils.authenticateUser(prefs, username = context.getRequest().getParameter("username"), password = context.getRequest().getParameter("password"));
        if (result == LDAPUtils.RESULT_VALID) {
            return "LDAPLoginOK";
        }
        context.getRequest().setAttribute("actionError", (Object)"Additional information was written to the webserver's log file.");
        return "LDAPLoginERROR";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfigureUserCheck(ActionContext context) {
        String string;
        if (Setup.isAlreadySetup(context)) {
            return "SetupCompleteError";
        }
        this.addModuleBean(context, null, "CRMSetup");
        UserSetupBean bean = (UserSetupBean)((Object)context.getFormBean());
        Connection db = null;
        ApplicationPrefs prefs = this.getApplicationPrefs(context);
        try {
            db = this.getDbConnection(context);
            if (!this.isDatabaseInstalled(db)) {
                String string2 = "ConfigureUserDatabaseERROR";
                return string2;
            }
            if (this.hasAdminUser(db)) {
                this.finalizePrefs(context);
                String string3 = "ConfigureUserOK";
                return string3;
            }
            CustomHook.populateDatabaseUser((ActionContext)context, (String)this.getPath(context), (UserSetupBean)bean);
            string = "ConfigureUserCheckOK";
        }
        catch (Exception e) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("${error.message}", e.getMessage());
            context.getRequest().setAttribute("actionError", (Object)Setup.getLabel(map, prefs.getLabel("object.validation.actionError.databaseVerificationError", prefs.get("SYSTEM.LANGUAGE"))));
            String string4 = "ConfigureUserDatabaseERROR";
            return string4;
        }
        finally {
            if (db != null) {
                try {
                    db.close();
                }
                catch (Exception e) {}
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfigureUser(ActionContext context) {
        Object thisContact;
        if (Setup.isAlreadySetup(context)) {
            return "SetupCompleteError";
        }
        this.addModuleBean(context, null, "CRMSetup");
        UserSetupBean bean = (UserSetupBean)((Object)context.getFormBean());
        Connection db = null;
        ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
        try {
            db = this.getDbConnection(context);
            boolean isValid = false;
            isValid = this.validateObject(context, db, (Object)bean);
            if (!isValid) {
                String string = "ConfigureUserERROR";
                return string;
            }
            if (!this.isDatabaseInstalled(db)) {
                String string = "ConfigureUserDatabaseERROR";
                return string;
            }
            if (!this.hasAdminUser(db)) {
                db.setAutoCommit(false);
                thisContact = new Contact();
                ((Contact)((Object)thisContact)).setOrgId(0);
                ((Contact)((Object)thisContact)).setNameFirst(bean.getNameFirst());
                ((Contact)((Object)thisContact)).setNameLast(bean.getNameLast());
                ((Contact)((Object)thisContact)).setEmployee(true);
                ((Contact)((Object)thisContact)).setEnteredBy(0);
                ((Contact)((Object)thisContact)).setModifiedBy(0);
                ((Contact)((Object)thisContact)).setAccessType(5);
                ((Contact)((Object)thisContact)).insert(db);
                ContactEmailAddress email = new ContactEmailAddress();
                email.setContactId(((Contact)((Object)thisContact)).getId());
                email.setType(1);
                email.setEmail(bean.getEmail());
                email.setEnteredBy(0);
                email.setModifiedBy(0);
                email.insert(db);
                Organization.renameMyCompany(db, bean.getCompany());
                User thisUser = new User();
                thisUser.setUsername(bean.getUsername());
                thisUser.setPassword1(bean.getPassword1());
                thisUser.setContactId(((Contact)((Object)thisContact)).getId());
                thisUser.setRoleId(1);
                thisUser.setEnteredBy(0);
                thisUser.setModifiedBy(0);
                thisUser.setTimeZone(prefs.get("SYSTEM.TIMEZONE"));
                thisUser.setCurrency(prefs.get("SYSTEM.CURRENCY"));
                thisUser.setLanguage(prefs.get("SYSTEM.LANGUAGE"));
                thisUser.insert(db);
                db.commit();
            }
            this.finalizePrefs(context);
            thisContact = "ConfigureUserOK";
        }
        catch (Exception e) {
            if (db != null) {
                try {
                    db.rollback();
                }
                catch (Exception se) {
                    // empty catch block
                }
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("${error.message}", e.getMessage());
            context.getRequest().setAttribute("actionError", (Object)Setup.getLabel(map, prefs.getLabel("object.validation.actionError.adminAddError", prefs.get("SYSTEM.LANGUAGE"))));
            String string = "ConfigureUserERROR";
            return string;
        }
        finally {
            if (db != null) {
                try {
                    db.setAutoCommit(true);
                    db.close();
                }
                catch (Exception e) {}
            }
        }
        return thisContact;
    }

    private boolean isDatabaseInstalled(Connection db) {
        boolean databaseExists = false;
        try {
            int nocols;
            PreparedStatement pst = db.prepareStatement("SELECT count(*) AS nocols FROM database_version ");
            ResultSet rs = pst.executeQuery();
            if (rs.next() && (nocols = rs.getInt("nocols")) > 0) {
                databaseExists = true;
            }
            rs.close();
            pst.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return databaseExists;
    }

    private boolean hasAdminUser(Connection db) {
        int count = 0;
        try {
            PreparedStatement pst = db.prepareStatement("SELECT count(*) AS record_count FROM " + DatabaseUtils.addQuotes(db, "access") + " " + "WHERE user_id > 0 ");
            ResultSet rs = pst.executeQuery();
            rs.next();
            count = rs.getInt("record_count");
            rs.close();
            pst.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return count > 0;
    }

    public static synchronized Key getOrMakeKey(String fileLibrary) throws IOException {
        String hexKeyFile = fileLibrary + "zlib2.jar";
        File thisHexKeyFile = new File(hexKeyFile);
        if (!thisHexKeyFile.exists()) {
            String keyFile = fileLibrary + "zlib.jar";
            File thisKeyFile = new File(keyFile);
            if (thisKeyFile.exists()) {
                Key oldKey = PrivateString.loadSerializedKey(keyFile);
                String hex = new String(Hex.encodeHex((byte[])oldKey.getEncoded()));
                StringUtils.saveText(hexKeyFile, hex);
            } else {
                PrivateString.generateEncodedKeyFile(hexKeyFile);
            }
        }
        return PrivateString.loadEncodedKey(hexKeyFile);
    }

    public static Key getKey(String fileLibrary) throws IOException {
        String hexKeyFile = fileLibrary + "zlib2.jar";
        File thisHexKeyFile = new File(hexKeyFile);
        if (!thisHexKeyFile.exists()) {
            String keyFile = fileLibrary + "zlib.jar";
            File thisKeyFile = new File(keyFile);
            if (thisKeyFile.exists()) {
                Key oldKey = PrivateString.loadSerializedKey(keyFile);
                String hex = new String(Hex.encodeHex((byte[])oldKey.getEncoded()));
                StringUtils.saveText(hexKeyFile, hex);
            } else {
                return null;
            }
        }
        return PrivateString.loadEncodedKey(hexKeyFile);
    }

    private Connection getDbConnection(ActionContext context) throws Exception {
        ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
        String fileLibrary = prefs.get("FILELIBRARY") + "init" + fs;
        Key key = Setup.getKey(fileLibrary);
        DatabaseBean dbBean = new DatabaseBean();
        try {
            File dbPref = new File(fileLibrary + "conn.sgml");
            if (dbPref.exists()) {
                String dbInfo = StringUtils.loadText(fileLibrary + "conn.sgml");
                dbBean.setConnection(PrivateString.decrypt(key, dbInfo));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Class.forName(dbBean.getDriver());
        return DatabaseUtils.getConnection(dbBean.getUrl(), dbBean.getUser(), dbBean.getPassword());
    }

    public static boolean isAlreadySetup(ActionContext context) {
        return context.getServletContext().getAttribute("cfs.setup") != null;
    }

    private ApplicationPrefs getApplicationPrefs(ActionContext context) {
        ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
        if (prefs == null) {
            prefs = new ApplicationPrefs();
            context.getServletContext().setAttribute("applicationPrefs", (Object)prefs);
        }
        return prefs;
    }

    private void finalizePrefs(ActionContext context) {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("Setup-> finalizePrefs - start");
        }
        ApplicationPrefs prefs = this.getApplicationPrefs(context);
        prefs.add("CONTROL", "configured");
        prefs.add("CRON.ENABLED", "true");
        prefs.add("CONNECTION_POOL.DEBUG", "false");
        prefs.add("CONNECTION_POOL.TEST_CONNECTIONS", "false");
        prefs.add("CONNECTION_POOL.ALLOW_SHRINKING", "true");
        prefs.add("CONNECTION_POOL.MAX_CONNECTIONS", "10");
        prefs.add("CONNECTION_POOL.MAX_IDLE_TIME.SECONDS", "60");
        prefs.add("CONNECTION_POOL.MAX_DEAD_TIME.SECONDS", "300");
        prefs.add("WEB-INF", context.getServletContext().getRealPath("/") + "WEB-INF" + fs);
        prefs.add("IMPORT_QUEUE_MAX", "1");
        prefs.save();
        prefs.populateContext(context.getServletContext());
        if (System.getProperty("DEBUG") != null) {
            System.out.println("Setup-> finalizePrefs - end (" + prefs.getPrefs().size() + ")");
        }
    }

    public static String getLabel(HashMap map, String input) {
        Template template = new Template(input);
        template.setParseElements(map);
        return template.getParsedText();
    }
}

