/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.setup.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.io.BufferedReader;
import java.sql.Connection;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.login.base.AuthenticationItem;
import org.aspcfs.modules.service.base.Record;
import org.aspcfs.modules.service.base.RecordList;
import org.aspcfs.modules.service.base.TransactionStatus;
import org.aspcfs.modules.service.base.TransactionStatusList;
import org.aspcfs.modules.setup.base.Registration;
import org.aspcfs.modules.setup.base.RegistrationList;
import org.aspcfs.modules.setup.beans.Zlib;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SetupServer
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSubmitRegistration(ActionContext context) {
        try {
            boolean sendReg = false;
            HttpServletRequest request = context.getRequest();
            StringBuffer data = new StringBuffer();
            BufferedReader br = request.getReader();
            String line = null;
            if (System.getProperty("DEBUG") != null) {
                System.out.println("XMLUtils->Reading XML from request");
            }
            while ((line = br.readLine()) != null) {
                data.append(line.trim() + System.getProperty("line.separator"));
            }
            if (System.getProperty("DEBUG") != null) {
                System.out.println("  XML: " + data.toString());
            }
            XMLUtils xml = new XMLUtils(data.toString());
            Zlib license = new Zlib(xml);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document document = builder.newDocument();
            Element app = document.createElement("aspcfs");
            document.appendChild(app);
            TransactionStatusList statusList = new TransactionStatusList();
            TransactionStatus thisStatus = new TransactionStatus();
            if (license.isValid()) {
                Connection db = null;
                try {
                    AuthenticationItem auth = new AuthenticationItem();
                    db = auth.getConnection(context, false);
                    if (db == null && System.getProperty("DEBUG") != null) {
                        System.out.println("SetupServer-> FATAL: db IS NULL!!!");
                    }
                    db.setAutoCommit(false);
                    Registration previousRegistration = RegistrationList.locate(db, license.getEmail(), license.getProfile(), true);
                    if (previousRegistration != null) {
                        previousRegistration.setEnabled(false);
                        previousRegistration.updateEnabled(db);
                        license.setEdition(previousRegistration.getEdition());
                        license.setText2(previousRegistration.getText2());
                    } else if (license.getText().startsWith("CENTRICCRM_SC_")) {
                        license.setText2(StringUtils.randomString(7, 7) + license.getText().substring(14));
                    } else if (license.getText().startsWith("ENTERPRISE-")) {
                        license.setEdition("Enterprise Edition");
                        license.setText2(StringUtils.randomString(7, 7) + "-1");
                    } else {
                        license.setEdition("Enterprise Edition (5 seats)");
                        license.setText2(StringUtils.randomString(7, 7) + "5");
                    }
                    Registration registration = new Registration();
                    registration.setKeyFile(license.getKeyText());
                    registration.setKeyHex(license.getKeyHex());
                    registration.setNameFirst(license.getNameFirst());
                    registration.setNameLast(license.getNameLast());
                    registration.setCompany(license.getCompany());
                    registration.setEmail(license.getEmail());
                    registration.setProfile(license.getProfile());
                    registration.setText(license.getText());
                    registration.setOs(license.getOs());
                    registration.setJava(license.getJava());
                    registration.setWebserver(license.getWebserver());
                    registration.setIp(context.getIpAddress());
                    registration.setEdition(license.getEdition());
                    registration.setText2(license.getText2());
                    registration.insert(db);
                    thisStatus.setStatusCode(0);
                    thisStatus.setMessage("SUCCESS");
                    db.commit();
                    sendReg = true;
                }
                catch (Exception e) {
                    thisStatus.setStatusCode(1);
                    thisStatus.setMessage("FAILURE");
                    db.rollback();
                    e.printStackTrace(System.out);
                }
                finally {
                    if (db != null) {
                        db.setAutoCommit(true);
                    }
                    this.freeConnection(context, db);
                }
                if (sendReg) {
                    if ("ent1source".equals(context.getRequest().getParameter("ent1source"))) {
                        RecordList recordList = new RecordList("license");
                        Record record = new Record("processed");
                        record.put("license", license.getCode());
                        recordList.add(record);
                        thisStatus.setRecordList(recordList);
                    } else {
                        license.setSystemStatus(this.getSystemStatus(context));
                        license.sendEmailRegistration(context);
                    }
                }
            } else {
                thisStatus.setStatusCode(1);
                thisStatus.setMessage("FAILURE");
            }
            statusList.add(thisStatus);
            statusList.appendResponse(document, app);
            context.getRequest().setAttribute("statusXML", (Object)XMLUtils.toString(document, "UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return "SubmitProcessOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandRequestLicense(ActionContext context) {
        try {
            TransactionStatus thisStatus;
            TransactionStatusList statusList;
            Element app;
            Document document;
            block12: {
                block13: {
                    Connection db;
                    block11: {
                        HttpServletRequest request = context.getRequest();
                        StringBuffer data = new StringBuffer();
                        BufferedReader br = request.getReader();
                        String line = null;
                        if (System.getProperty("DEBUG") != null) {
                            System.out.println("XMLUtils->Reading XML from request");
                        }
                        while ((line = br.readLine()) != null) {
                            data.append(line.trim() + System.getProperty("line.separator"));
                        }
                        if (System.getProperty("DEBUG") != null) {
                            System.out.println("  XML: " + data.toString());
                        }
                        XMLUtils xml = new XMLUtils(data.toString());
                        Zlib license = new Zlib(xml);
                        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                        DocumentBuilder builder = dbf.newDocumentBuilder();
                        document = builder.newDocument();
                        app = document.createElement("aspcfs");
                        document.appendChild(app);
                        statusList = new TransactionStatusList();
                        thisStatus = new TransactionStatus();
                        if (!license.isValid()) break block13;
                        db = null;
                        try {
                            Registration previousRegistration;
                            AuthenticationItem auth = new AuthenticationItem();
                            db = auth.getConnection(context, false);
                            if (db == null && System.getProperty("DEBUG") != null) {
                                System.out.println("SetupServer-> FATAL: db IS NULL!!!");
                            }
                            if ((previousRegistration = RegistrationList.locate(db, license.getEmail(), license.getProfile(), true)) == null) {
                                thisStatus.setStatusCode(1);
                                thisStatus.setMessage("FAILURE");
                            }
                            if (previousRegistration == null) break block11;
                            thisStatus.setStatusCode(0);
                            thisStatus.setMessage("SUCCESS");
                            if (previousRegistration.getText2().equals(license.getText2())) break block11;
                            license.setNameFirst(previousRegistration.getNameFirst());
                            license.setNameLast(previousRegistration.getNameLast());
                            license.setCompany(previousRegistration.getCompany());
                            license.setEdition(previousRegistration.getEdition());
                            license.setText(previousRegistration.getText());
                            license.setText2(previousRegistration.getText2());
                            RecordList recordList = new RecordList("license");
                            Record record = new Record("update");
                            record.put("license", license.getCode());
                            recordList.add(record);
                            thisStatus.setRecordList(recordList);
                        }
                        catch (Exception e) {
                            try {
                                thisStatus.setStatusCode(1);
                                thisStatus.setMessage("FAILURE");
                            }
                            catch (Throwable throwable) {
                                this.freeConnection(context, db);
                                throw throwable;
                            }
                            this.freeConnection(context, db);
                            break block12;
                        }
                    }
                    this.freeConnection(context, db);
                    break block12;
                }
                thisStatus.setStatusCode(1);
                thisStatus.setMessage("FAILURE");
            }
            statusList.add(thisStatus);
            statusList.appendResponse(document, app);
            context.getRequest().setAttribute("statusXML", (Object)XMLUtils.toString(document, "UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return "UpdateProcessOK";
    }
}

