/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.setup.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.darkhorseventures.framework.hooks.CustomHook;
import java.sql.Connection;
import java.util.ArrayList;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.login.beans.UserBean;
import org.aspcfs.modules.system.base.ApplicationVersion;

public class Upgrade
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        this.addModuleBean(context, null, "Upgrade");
        return "NeedUpgradeOK";
    }

    public String executeCommandCheck(ActionContext context) {
        if (!this.isAdministrator(context)) {
            return "NeedUpgradeOK";
        }
        this.addModuleBean(context, null, "Upgrade");
        ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
        if (prefs.isUpgradeable()) {
            context.getRequest().setAttribute("status", (Object)"1");
        } else {
            context.getRequest().setAttribute("status", (Object)"0");
        }
        context.getRequest().setAttribute("installedVersion", (Object)ApplicationVersion.getInstalledVersion(prefs));
        context.getRequest().setAttribute("newVersion", (Object)"Centric CRM 4.1.1 (2007-03-12)");
        return "CheckOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String executeCommandPerformUpgrade(ActionContext context) {
        if (!this.isAdministrator(context)) {
            return "NeedUpgradeOK";
        }
        this.addModuleBean(context, null, "Upgrade");
        ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
        if (prefs.isUpgradeable()) {
            ArrayList installLog = new ArrayList();
            context.getRequest().setAttribute("installLog", installLog);
            context.getRequest().setAttribute("installedVersion", (Object)ApplicationVersion.getInstalledVersion(prefs));
            context.getRequest().setAttribute("newVersion", (Object)"Centric CRM 4.1.1 (2007-03-12)");
            Connection db = null;
            try {
                db = this.getConnection(context);
                CustomHook.verifyDatabase((ActionContext)context, (Connection)db, (ApplicationPrefs)prefs, installLog, (String)Upgrade.getDbNamePath(context));
                prefs.add("WEB-INF", context.getServletContext().getRealPath("/") + "WEB-INF" + fs);
                if (!prefs.save()) {
                    context.getRequest().setAttribute("errorMessage", (Object)"No write permission on file library, build.properties");
                    String string = "UpgradeERROR";
                    return string;
                }
            }
            catch (Exception e) {
                context.getRequest().setAttribute("errorMessage", (Object)e.getMessage());
                String string = "UpgradeERROR";
                return string;
            }
            finally {
                this.freeConnection(context, db);
            }
        }
        return "UpgradeOK";
    }

    private boolean isAdministrator(ActionContext context) {
        UserBean thisUser = (UserBean)((Object)context.getSession().getAttribute("User"));
        if (thisUser != null) {
            String status = (String)context.getSession().getAttribute("UPGRADEOK");
            return "UPGRADEOK".equals(status);
        }
        return false;
    }
}

