/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.setup.beans;

import com.darkhorseventures.framework.beans.GenericBean;
import java.util.StringTokenizer;

public class DatabaseBean
extends GenericBean {
    private int configured = -1;
    private String type = "none";
    private String driver = null;
    private String ip = "127.0.0.1";
    private int port = 0;
    private String name = "centric_crm";
    private String user = "centric_crm";
    private String password = null;
    private String path = "";

    public void setConfigured(int tmp) {
        this.configured = tmp;
    }

    public void setConfigured(String tmp) {
        this.configured = Integer.parseInt(tmp);
    }

    public void setType(String tmp) {
        this.type = tmp;
    }

    public void setIp(String tmp) {
        this.ip = tmp;
    }

    public void setPort(int tmp) {
        this.port = tmp;
    }

    public void setPort(String tmp) {
        this.port = Integer.parseInt(tmp);
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setUser(String tmp) {
        this.user = tmp;
    }

    public void setPassword(String tmp) {
        this.password = tmp;
    }

    public int getConfigured() {
        return this.configured;
    }

    public String getType() {
        return this.type;
    }

    public String getDriver() {
        if (this.driver == null) {
            if ("DaffodilDB".equals(this.type)) {
                this.driver = "in.co.daffodil.db.jdbc.DaffodilDBDriver";
            }
            if ("DB2".equals(this.type)) {
                this.driver = "com.ibm.db2.jcc.DB2Driver";
            }
            if ("Firebird".equals(this.type)) {
                this.driver = "org.firebirdsql.jdbc.FBDriver";
            }
            if ("MSSQL".equals(this.type)) {
                this.driver = "net.sourceforge.jtds.jdbc.Driver";
            }
            if ("Oracle".equals(this.type)) {
                this.driver = "oracle.jdbc.driver.OracleDriver";
            }
            if ("PostgreSQL".equals(this.type)) {
                this.driver = "org.postgresql.Driver";
            }
            if ("MySQL".equals(this.type)) {
                this.driver = "com.mysql.jdbc.Driver";
            }
            if ("Derby".equals(this.type)) {
                this.driver = "org.apache.derby.jdbc.EmbeddedDriver";
            }
            if ("InterBase".equalsIgnoreCase(this.type)) {
                this.driver = "interbase.interclient.Driver";
            }
        }
        return this.driver;
    }

    public boolean isEmbedded() {
        return "DaffodilDB".equals(this.type) || "Derby".equals(this.type);
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String getName() {
        return this.name;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUrl() {
        if ("in.co.daffodil.db.jdbc.DaffodilDBDriver".equals(this.getDriver())) {
            return "jdbc:daffodilDB_embedded:" + this.getName() + ";create=true;path=" + this.path + "daffodildb";
        }
        if ("org.postgresql.Driver".equals(this.getDriver())) {
            return "jdbc:postgresql://" + this.getIp() + ":" + this.getPort() + "/" + this.getName();
        }
        if ("net.sourceforge.jtds.jdbc.Driver".equals(this.getDriver())) {
            return "jdbc:jtds:sqlserver://" + this.getIp() + ":" + this.getPort() + "/" + this.getName();
        }
        if ("com.ibm.db2.jcc.DB2Driver".equals(this.getDriver())) {
            return "jdbc:db2://" + this.getIp() + ":" + this.getPort() + "/" + this.getName();
        }
        if ("com.microsoft.jdbc.sqlserver.SQLServerDriver".equals(this.getDriver())) {
            return "jdbc:microsoft:sqlserver://" + this.getIp() + ":" + this.getPort() + ";SelectMethod=cursor;DatabaseName=" + this.getName();
        }
        if ("org.firebirdsql.jdbc.FBDriver".equals(this.getDriver())) {
            return "jdbc:firebirdsql:" + this.getIp() + "/" + this.getPort() + ":" + this.path;
        }
        if ("oracle.jdbc.driver.OracleDriver".equals(this.getDriver())) {
            return "jdbc:oracle:thin:@//" + this.getIp() + ":" + this.getPort() + "/" + this.getName();
        }
        if ("com.mysql.jdbc.Driver".equals(this.getDriver())) {
            return "jdbc:mysql://" + this.getIp() + ":" + this.getPort() + "/" + this.getName();
        }
        if ("org.apache.derby.jdbc.EmbeddedDriver".equals(this.getDriver())) {
            return "jdbc:derby:" + this.path + "derbydb" + ";create=true;upgrade=true";
        }
        if ("interbase.interclient.Driver".equalsIgnoreCase(this.getDriver())) {
            return "jdbc:interbase://" + this.getIp() + ":" + this.getPort() + "/" + this.path + this.getName();
        }
        return "";
    }

    public void setConnection(String tmp) {
        StringTokenizer st = new StringTokenizer(tmp, "|");
        this.type = st.nextToken();
        this.driver = st.nextToken();
        this.ip = st.nextToken();
        this.port = Integer.parseInt(st.nextToken());
        this.name = st.nextToken();
        this.user = st.nextToken();
        this.password = st.nextToken();
        if (st.hasMoreTokens()) {
            this.path = st.nextToken();
        }
    }

    public String getConnection() {
        return this.type + "|" + this.driver + "|" + this.ip + "|" + this.port + "|" + this.name + "|" + this.user + "|" + this.password + "|" + this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getTypeValue() {
        if ("DaffodilDB".equals(this.type)) {
            return "daffodildb";
        }
        if ("DB2".equals(this.type)) {
            return "db2";
        }
        if ("PostgreSQL".equals(this.type)) {
            return "postgresql";
        }
        if ("MSSQL".equals(this.type)) {
            return "mssql";
        }
        if ("Oracle".equals(this.type)) {
            return "oracle";
        }
        if ("Firebird".equals(this.type)) {
            return "firebird";
        }
        if ("MySQL".equals(this.type)) {
            return "mysql";
        }
        if ("Derby".equals(this.type)) {
            return "derby";
        }
        return null;
    }
}

