/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.setup.beans;

import com.darkhorseventures.framework.beans.GenericBean;
import java.text.NumberFormat;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.utils.DatabaseUtils;

public class ServerBean
extends GenericBean {
    private int configured = -1;
    private String url = null;
    private String email = null;
    private String emailAddress = null;
    private String fax = null;
    private String timeZone = null;
    private String currency = null;
    private String language = null;
    private String country = null;
    private String asteriskUrl = null;
    private String asteriskUsername = null;
    private String asteriskPassword = null;
    private String asteriskContext = null;
    private boolean asteriskInbound = false;
    private boolean asteriskOutbound = false;
    private String xmppUrl = null;
    private int xmppPort = 5222;
    private boolean xmppSSL = false;
    private String xmppUsername = null;
    private String xmppPassword = null;
    private boolean xmppEnabled = false;
    private String ldapCentricCRMField = null;
    private String ldapFactory = null;
    private String ldapUrl = null;
    private boolean ldapSearchByAttribute = true;
    private String ldapSearchUsername = null;
    private String ldapSearchPassword = null;
    private String ldapSearchContainer = null;
    private String ldapSearchOrgPerson = null;
    private boolean ldapSearchSubtree = true;
    private String ldapSearchAttribute = null;
    private String ldapSearchPrefix = null;
    private String ldapSearchPostfix = null;
    private boolean ldapEnabled = false;

    public void setConfigured(int tmp) {
        this.configured = tmp;
    }

    public void setConfigured(String tmp) {
        this.configured = Integer.parseInt(tmp);
    }

    public void setUrl(String tmp) {
        this.url = tmp;
    }

    public void setEmail(String tmp) {
        this.email = tmp;
    }

    public void setEmailAddress(String tmp) {
        this.emailAddress = tmp;
    }

    public void setFax(String tmp) {
        this.fax = tmp;
    }

    public void setTimeZone(String tmp) {
        this.timeZone = tmp;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String tmp) {
        this.currency = tmp;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String tmp) {
        this.language = tmp;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String tmp) {
        this.country = tmp;
    }

    public int getConfigured() {
        return this.configured;
    }

    public String getUrl() {
        return this.url;
    }

    public String getEmail() {
        return this.email;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getFax() {
        return this.fax;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String getTimeZoneDefault() {
        if (this.timeZone != null) {
            return this.timeZone;
        }
        return TimeZone.getDefault().getID();
    }

    public String getCurrencyDefault() {
        if (this.currency != null) {
            return this.currency;
        }
        return NumberFormat.getCurrencyInstance().getCurrency().getCurrencyCode();
    }

    public String getLanguageDefault() {
        if (this.language != null) {
            return this.language;
        }
        return "en_US";
    }

    public String getCountryDefault() {
        if (this.country != null) {
            return this.country;
        }
        return "UNITED STATES";
    }

    public String getAsteriskUrl() {
        return this.asteriskUrl;
    }

    public void setAsteriskUrl(String asteriskUrl) {
        this.asteriskUrl = asteriskUrl;
    }

    public String getAsteriskUsername() {
        return this.asteriskUsername;
    }

    public void setAsteriskUsername(String asteriskUsername) {
        this.asteriskUsername = asteriskUsername;
    }

    public String getAsteriskPassword() {
        return this.asteriskPassword;
    }

    public void setAsteriskPassword(String asteriskPassword) {
        this.asteriskPassword = asteriskPassword;
    }

    public String getAsteriskContext() {
        return this.asteriskContext;
    }

    public String getAsteriskContextDefault() {
        if (this.asteriskContext != null) {
            return this.asteriskContext;
        }
        return "from-internal";
    }

    public void setAsteriskContext(String asteriskContext) {
        this.asteriskContext = asteriskContext;
    }

    public boolean getAsteriskInbound() {
        return this.asteriskInbound;
    }

    public void setAsteriskInbound(boolean asteriskInbound) {
        this.asteriskInbound = asteriskInbound;
    }

    public void setAsteriskInbound(String tmp) {
        this.asteriskInbound = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getAsteriskOutbound() {
        return this.asteriskOutbound;
    }

    public void setAsteriskOutbound(boolean asteriskOutbound) {
        this.asteriskOutbound = asteriskOutbound;
    }

    public void setAsteriskOutbound(String tmp) {
        this.asteriskOutbound = DatabaseUtils.parseBoolean(tmp);
    }

    public String getXmppUrl() {
        return this.xmppUrl;
    }

    public void setXmppUrl(String xmppUrl) {
        this.xmppUrl = xmppUrl;
    }

    public int getXmppPort() {
        return this.xmppPort;
    }

    public void setXmppPort(String xmppPort) {
        this.xmppPort = Integer.parseInt(xmppPort);
    }

    public void setXmppPort(int xmppPort) {
        this.xmppPort = xmppPort;
    }

    public String getXmppUsername() {
        return this.xmppUsername;
    }

    public void setXmppUsername(String xmppUsername) {
        this.xmppUsername = xmppUsername;
    }

    public String getXmppPassword() {
        return this.xmppPassword;
    }

    public void setXmppPassword(String xmppPassword) {
        this.xmppPassword = xmppPassword;
    }

    public boolean getXmppEnabled() {
        return this.xmppEnabled;
    }

    public void setXmppEnabled(boolean xmppEnabled) {
        this.xmppEnabled = xmppEnabled;
    }

    public void setXmppEnabled(String tmp) {
        this.xmppEnabled = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getXmppSSL() {
        return this.xmppSSL;
    }

    public void setXmppSSL(boolean xmppSSL) {
        this.xmppSSL = xmppSSL;
    }

    public void setXmppSSL(String tmp) {
        this.xmppSSL = DatabaseUtils.parseBoolean(tmp);
    }

    public String getLdapCentricCRMField() {
        if (this.ldapCentricCRMField == null) {
            return "username";
        }
        return this.ldapCentricCRMField;
    }

    public void setLdapCentricCRMField(String ldapCentricCRMField) {
        this.ldapCentricCRMField = ldapCentricCRMField;
    }

    public String getLdapFactory() {
        if (this.ldapFactory == null) {
            return "com.sun.jndi.ldap.LdapCtxFactory";
        }
        return this.ldapFactory;
    }

    public void setLdapFactory(String ldapFactory) {
        this.ldapFactory = ldapFactory;
    }

    public String getLdapUrl() {
        if (this.ldapUrl == null) {
            return "ldap://127.0.0.1:389";
        }
        return this.ldapUrl;
    }

    public void setLdapUrl(String ldapUrl) {
        this.ldapUrl = ldapUrl;
    }

    public String getLdapSearchUsername() {
        if (this.ldapSearchUsername == null) {
            return "cn=admin,ou=IT,o=COMPANY";
        }
        return this.ldapSearchUsername;
    }

    public void setLdapSearchUsername(String ldapSearchUsername) {
        this.ldapSearchUsername = ldapSearchUsername;
    }

    public String getLdapSearchPassword() {
        return this.ldapSearchPassword;
    }

    public void setLdapSearchPassword(String ldapSearchPassword) {
        this.ldapSearchPassword = ldapSearchPassword;
    }

    public String getLdapSearchContainer() {
        if (this.ldapSearchContainer == null) {
            return "o=COMPANY";
        }
        return this.ldapSearchContainer;
    }

    public void setLdapSearchContainer(String ldapSearchContainer) {
        this.ldapSearchContainer = ldapSearchContainer;
    }

    public String getLdapSearchOrgPerson() {
        if (this.ldapSearchOrgPerson == null) {
            return "inetOrgPerson";
        }
        return this.ldapSearchOrgPerson;
    }

    public void setLdapSearchOrgPerson(String ldapSearchOrgPerson) {
        this.ldapSearchOrgPerson = ldapSearchOrgPerson;
    }

    public boolean getLdapSearchSubtree() {
        return this.ldapSearchSubtree;
    }

    public void setLdapSearchSubtree(boolean ldapSearchSubtree) {
        this.ldapSearchSubtree = ldapSearchSubtree;
    }

    public void setLdapSearchSubtree(String tmp) {
        this.ldapSearchSubtree = DatabaseUtils.parseBoolean(tmp);
    }

    public String getLdapSearchAttribute() {
        if (this.ldapSearchAttribute == null) {
            return "mail";
        }
        return this.ldapSearchAttribute;
    }

    public void setLdapSearchAttribute(String ldapSearchAttribute) {
        this.ldapSearchAttribute = ldapSearchAttribute;
    }

    public String getLdapSearchPrefix() {
        if (this.ldapSearchPrefix == null) {
            return "cn=";
        }
        return this.ldapSearchPrefix;
    }

    public void setLdapSearchPrefix(String ldapSearchPrefix) {
        this.ldapSearchPrefix = ldapSearchPrefix;
    }

    public String getLdapSearchPostfix() {
        if (this.ldapSearchPostfix == null) {
            return ",o=COMPANY";
        }
        return this.ldapSearchPostfix;
    }

    public void setLdapSearchPostfix(String ldapSearchPostfix) {
        this.ldapSearchPostfix = ldapSearchPostfix;
    }

    public boolean getLdapSearchByAttribute() {
        return this.ldapSearchByAttribute;
    }

    public void setLdapSearchByAttribute(boolean ldapSearchByAttribute) {
        this.ldapSearchByAttribute = ldapSearchByAttribute;
    }

    public void setLdapSearchByAttribute(String tmp) {
        this.ldapSearchByAttribute = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getLdapEnabled() {
        return this.ldapEnabled;
    }

    public void setLdapEnabled(boolean ldapEnabled) {
        this.ldapEnabled = ldapEnabled;
    }

    public void setLdapEnabled(String tmp) {
        this.ldapEnabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setServerInfo(String tmp) {
        StringTokenizer st = new StringTokenizer(tmp, "|");
        while (st.hasMoreTokens()) {
            String pair = st.nextToken();
            String param = pair.substring(0, pair.indexOf("="));
            String value = pair.substring(pair.indexOf("=") + 1);
            if ("email".equals(param)) {
                this.email = value;
                continue;
            }
            if ("addr".equals(param)) {
                this.emailAddress = value;
                continue;
            }
            if ("fax".equals(param)) {
                this.fax = value;
                continue;
            }
            if ("url".equals(param)) {
                this.url = value;
                continue;
            }
            if (!"timezone".equals(param)) continue;
            this.timeZone = value;
        }
    }

    public void setServerInfo(ApplicationPrefs prefs) {
        if (prefs.has("SYSTEM.CURRENCY")) {
            this.currency = prefs.get("SYSTEM.CURRENCY");
        }
        if (prefs.has("SYSTEM.LANGUAGE")) {
            this.language = prefs.get("SYSTEM.LANGUAGE");
        }
        if (prefs.has("SYSTEM.COUNTRY")) {
            this.country = prefs.get("SYSTEM.COUNTRY");
        }
        if (prefs.has("ASTERISK.URL")) {
            this.asteriskUrl = prefs.get("ASTERISK.URL");
        }
        if (prefs.has("ASTERISK.USERNAME")) {
            this.asteriskUsername = prefs.get("ASTERISK.USERNAME");
        }
        if (prefs.has("ASTERISK.PASSWORD")) {
            this.asteriskPassword = prefs.get("ASTERISK.PASSWORD");
        }
        if (prefs.has("ASTERISK.CONTEXT")) {
            this.asteriskContext = prefs.get("ASTERISK.CONTEXT");
        }
        if (prefs.has("ASTERISK.OUTBOUND.ENABLED")) {
            this.asteriskInbound = "true".equals(prefs.get("ASTERISK.OUTBOUND.ENABLED"));
        }
        if (prefs.has("ASTERISK.INBOUND.ENABLED")) {
            this.asteriskOutbound = "true".equals(prefs.get("ASTERISK.INBOUND.ENABLED"));
        }
        if (prefs.has("XMPP.CONNECTION.URL")) {
            this.xmppUrl = prefs.get("XMPP.CONNECTION.URL");
        }
        if (prefs.has("XMPP.CONNECTION.PORT")) {
            this.xmppPort = Integer.parseInt(prefs.get("XMPP.CONNECTION.PORT"));
        }
        if (prefs.has("XMPP.CONNECTION.SSL")) {
            this.xmppSSL = "true".equals(prefs.get("XMPP.CONNECTION.SSL"));
        }
        if (prefs.has("XMPP.MANAGER.USERNAME")) {
            this.xmppUsername = prefs.get("XMPP.MANAGER.USERNAME");
        }
        if (prefs.has("XMPP.MANAGER.PASSWORD")) {
            this.xmppPassword = prefs.get("XMPP.MANAGER.PASSWORD");
        }
        if (prefs.has("XMPP.ENABLED")) {
            this.xmppEnabled = "true".equals(prefs.get("XMPP.ENABLED"));
        }
        if (prefs.has("LDAP.CENTRIC_CRM.FIELD")) {
            this.ldapCentricCRMField = prefs.get("LDAP.CENTRIC_CRM.FIELD");
        }
        if (prefs.has("LDAP.FACTORY")) {
            this.ldapFactory = prefs.get("LDAP.FACTORY");
        }
        if (prefs.has("LDAP.SERVER")) {
            this.ldapUrl = prefs.get("LDAP.SERVER");
        }
        if (prefs.has("LDAP.SEARCH.BY_ATTRIBUTE")) {
            this.ldapSearchByAttribute = "true".equals(prefs.get("LDAP.SEARCH.BY_ATTRIBUTE"));
        }
        if (prefs.has("LDAP.SEARCH.USERNAME")) {
            this.ldapSearchUsername = prefs.get("LDAP.SEARCH.USERNAME");
        }
        if (prefs.has("LDAP.SEARCH.PASSWORD")) {
            this.ldapSearchPassword = prefs.get("LDAP.SEARCH.PASSWORD");
        }
        if (prefs.has("LDAP.SEARCH.CONTAINER")) {
            this.ldapSearchContainer = prefs.get("LDAP.SEARCH.CONTAINER");
        }
        if (prefs.has("LDAP.SEARCH.ORGPERSON")) {
            this.ldapSearchOrgPerson = prefs.get("LDAP.SEARCH.ORGPERSON");
        }
        if (prefs.has("LDAP.SEARCH.SUBTREE")) {
            this.ldapSearchSubtree = "true".equals(prefs.get("LDAP.SEARCH.SUBTREE"));
        }
        if (prefs.has("LDAP.SEARCH.ATTRIBUTE")) {
            this.ldapSearchAttribute = prefs.get("LDAP.SEARCH.ATTRIBUTE");
        }
        if (prefs.has("LDAP.SEARCH.PREFIX")) {
            this.ldapSearchPrefix = prefs.get("LDAP.SEARCH.PREFIX");
        }
        if (prefs.has("LDAP.SEARCH.POSTFIX")) {
            this.ldapSearchPostfix = prefs.get("LDAP.SEARCH.POSTFIX");
        }
        if (prefs.has("LDAP.ENABLED")) {
            this.ldapEnabled = "true".equals(prefs.get("LDAP.ENABLED"));
        }
    }

    public String getServerInfo() {
        return "email=" + this.email + "|" + "addr=" + this.emailAddress + "|" + "fax=" + this.fax + "|" + "url=" + this.url + "|" + "timezone=" + this.timeZone;
    }
}

