/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.setup.beans;

import com.darkhorseventures.framework.actions.ActionContext;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.utils.ObjectUtils;
import org.aspcfs.utils.PrivateString;
import org.aspcfs.utils.SMTPMessage;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.Template;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Zlib {
    public static final String CRLF = System.getProperty("line.separator");
    public static final int UNDEFINED = -1;
    public static final int METHOD1 = 1;
    public static final int METHOD2 = 2;
    public static final int CENTRIC_CRM = 1;
    public static final int POETIC = 2;
    private int format = -1;
    private Key key = null;
    private String keyText = null;
    private String keyHex = null;
    private String nameFirst = null;
    private String nameLast = null;
    private String company = null;
    private String email = null;
    private String edition = null;
    private String text = null;
    private String text2 = null;
    private String profile = null;
    private String mailError = null;
    private String os = null;
    private String java = null;
    private String webserver = null;
    private SystemStatus systemStatus = null;

    public Zlib() {
    }

    public Zlib(XMLUtils xml) {
        try {
            if (!"Poetic".equals(xml.getDocumentElement().getNodeName())) {
                this.format = 1;
                this.keyText = XMLUtils.getNodeText(xml.getFirstChild("zlib"));
                this.keyHex = XMLUtils.getNodeText(xml.getFirstChild("zlib2"));
                this.nameFirst = XMLUtils.getNodeText(xml.getFirstChild("nameFirst"));
                this.nameLast = XMLUtils.getNodeText(xml.getFirstChild("nameLast"));
                this.company = XMLUtils.getNodeText(xml.getFirstChild("company"));
                this.email = XMLUtils.getNodeText(xml.getFirstChild("email"));
                this.profile = XMLUtils.getNodeText(xml.getFirstChild("profile"));
                this.os = XMLUtils.getNodeText(xml.getFirstChild("os"));
                this.java = XMLUtils.getNodeText(xml.getFirstChild("java"));
                this.webserver = XMLUtils.getNodeText(xml.getFirstChild("webserver"));
                this.text2 = XMLUtils.getNodeText(xml.getFirstChild("text2"));
                if (this.keyHex != null) {
                    SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
                    DESKeySpec keySpec = new DESKeySpec(Hex.decodeHex((char[])this.keyHex.toCharArray()));
                    this.key = keyFactory.generateSecret(keySpec);
                } else if (this.keyText != null) {
                    this.key = (Key)ObjectUtils.toObject(Base64.decodeBase64((byte[])this.keyText.getBytes("UTF8")));
                }
                this.text = PrivateString.decrypt(this.key, XMLUtils.getNodeText(xml.getFirstChild("text")));
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void setKey(Key tmp) {
        this.key = tmp;
    }

    public void setKeyText(String tmp) {
        this.keyText = tmp;
    }

    public void setKeyHex(String tmp) {
        this.keyHex = tmp;
    }

    public void setNameFirst(String tmp) {
        this.nameFirst = tmp;
    }

    public void setNameLast(String tmp) {
        this.nameLast = tmp;
    }

    public void setCompany(String tmp) {
        this.company = tmp;
    }

    public void setEmail(String tmp) {
        this.email = tmp;
    }

    public void setEdition(String tmp) {
        this.edition = tmp;
    }

    public void setText(String tmp) {
        this.text = tmp;
    }

    public void setText2(String tmp) {
        this.text2 = tmp;
    }

    public void setProfile(String tmp) {
        this.profile = tmp;
    }

    public void setMailError(String tmp) {
        this.mailError = tmp;
    }

    public void setOs(String tmp) {
        this.os = tmp;
    }

    public void setJava(String tmp) {
        this.java = tmp;
    }

    public void setWebserver(String tmp) {
        this.webserver = tmp;
    }

    public void setSystemStatus(SystemStatus tmp) {
        this.systemStatus = tmp;
    }

    public SystemStatus getSystemStatus() {
        return this.systemStatus;
    }

    public int getFormat() {
        return this.format;
    }

    public Key getKey() {
        return this.key;
    }

    public String getKeyText() {
        return this.keyText;
    }

    public String getKeyHex() {
        return this.keyHex;
    }

    public String getNameFirst() {
        return this.nameFirst;
    }

    public String getNameLast() {
        return this.nameLast;
    }

    public String getCompany() {
        return this.company;
    }

    public String getEmail() {
        return this.email;
    }

    public String getEdition() {
        return this.edition;
    }

    public String getText() {
        return this.text;
    }

    public String getText2() {
        return this.text2;
    }

    public String getProfile() {
        return this.profile;
    }

    public String getMailError() {
        return this.mailError;
    }

    public String getOs() {
        return this.os;
    }

    public String getJava() {
        return this.java;
    }

    public String getWebserver() {
        return this.webserver;
    }

    public int getMethod() {
        if (this.keyText != null) {
            return 1;
        }
        if (this.keyHex != null) {
            return 2;
        }
        return -1;
    }

    public boolean isValid() {
        try {
            if (this.text.startsWith("5USERBINARY") || this.text.startsWith("ENTERPRISE") || this.text.startsWith("UPGRADE")) {
                return true;
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return false;
    }

    public boolean sendEmailRegistration(ActionContext context) throws Exception {
        String theLicense = "<license>" + this.getCode() + "</license>" + CRLF;
        SMTPMessage mail = new SMTPMessage();
        mail.setHost(ApplicationPrefs.getPref(context.getServletContext(), "MAILSERVER"));
        mail.setType("text/plain");
        mail.addTo(this.email);
        mail.setFrom("Centric CRM Registration <registration@centriccrm.com>");
        mail.addReplyTo("registration@centriccrm.com");
        if (this.systemStatus != null) {
            mail.setSubject(this.systemStatus.getLabel("mail.subject.crmRegistration"));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("${crlf}", "" + CRLF);
            Template template = new Template(this.systemStatus.getLabel("mail.body.crmRegistration"));
            template.setParseElements(map);
            mail.setBody(template.getParsedText() + CRLF);
        } else {
            mail.setSubject("Centric CRM Registration");
            mail.setBody("Thank you for registering Centric CRM." + CRLF + CRLF + "Paste the complete registation code from the attached file " + "(including the <license> tags) into the Centric CRM license validation field." + CRLF + CRLF + "Some mail programs may have a problem with the attachment, if so please report " + "the client mail application name and the mail server software name to Centric CRM." + CRLF + CRLF + "The Centric CRM Team" + CRLF + CRLF);
        }
        mail.addByteArrayAttachment("license.txt", theLicense, "text/plain");
        if (mail.send() == 2) {
            this.mailError = mail.getErrorMsg();
            return false;
        }
        return true;
    }

    public String getCode() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document document = builder.newDocument();
        Element rootElement = document.createElement("crmLicense");
        document.appendChild(rootElement);
        Element nameFirstElement = document.createElement("nameFirst");
        nameFirstElement.appendChild(document.createTextNode(StringUtils.toString(this.nameFirst)));
        rootElement.appendChild(nameFirstElement);
        Element nameLastElement = document.createElement("nameLast");
        nameLastElement.appendChild(document.createTextNode(StringUtils.toString(this.nameLast)));
        rootElement.appendChild(nameLastElement);
        Element companyElement = document.createElement("company");
        companyElement.appendChild(document.createTextNode(StringUtils.toString(this.company)));
        rootElement.appendChild(companyElement);
        Element emailElement = document.createElement("email");
        emailElement.appendChild(document.createTextNode(StringUtils.toString(this.email)));
        rootElement.appendChild(emailElement);
        Element profileElement = document.createElement("profile");
        profileElement.appendChild(document.createTextNode(StringUtils.toString(this.profile)));
        rootElement.appendChild(profileElement);
        Element licenseElement = document.createElement("license");
        licenseElement.appendChild(document.createTextNode(StringUtils.toString(this.text)));
        rootElement.appendChild(licenseElement);
        Element editionElement = document.createElement("edition");
        editionElement.appendChild(document.createTextNode(StringUtils.toString(this.edition)));
        rootElement.appendChild(editionElement);
        Element crcElement = document.createElement("text2");
        crcElement.appendChild(document.createTextNode(StringUtils.toString(this.text2)));
        rootElement.appendChild(crcElement);
        Element dateTimeElement = document.createElement("entered");
        dateTimeElement.appendChild(document.createTextNode(String.valueOf(new Date())));
        rootElement.appendChild(dateTimeElement);
        return PrivateString.encrypt(this.key, XMLUtils.toString(rootElement));
    }
}

