/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.setup.utils;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.aspcfs.apps.help.ImportHelp;
import org.aspcfs.apps.icelets.ImportIcelets;
import org.aspcfs.apps.lookuplists.ImportLookupLists;
import org.aspcfs.apps.transfer.reader.cfs.InitPermissionsAndRoles;
import org.aspcfs.apps.transfer.writer.cfsdatabasewriter.PermissionsAndRolesWriter;
import org.aspcfs.modules.service.base.SyncClient;
import org.aspcfs.modules.service.utils.BackupUtils;
import org.aspcfs.modules.system.base.DatabaseVersion;
import org.aspcfs.modules.website.base.IceletList;
import org.aspcfs.utils.DatabaseUtils;

public class SetupUtils {
    public static final String fs = System.getProperty("file.separator");

    public static void createDatabaseSchema(Connection db, String setupPath) throws Exception {
        String dbPath = null;
        switch (DatabaseUtils.getType(db)) {
            case 1: {
                dbPath = "postgresql";
                break;
            }
            case 4: {
                dbPath = "firebird";
                break;
            }
            case 2: {
                dbPath = "mssql";
                break;
            }
            case 3: {
                dbPath = "oracle";
                break;
            }
            case 6: {
                dbPath = "db2";
                break;
            }
            case 5: {
                dbPath = "daffodildb";
                break;
            }
            case 7: {
                dbPath = "mysql";
                break;
            }
            case 8: {
                dbPath = "derby";
                break;
            }
            default: {
                if (System.getProperty("DEBUG") == null) break;
                System.out.println("Setup-> * Database could not be determined: " + DatabaseUtils.getType(db));
            }
        }
        if (System.getProperty("DEBUG") != null) {
            System.out.println("SetupUtils-> Installing Schema: " + setupPath + dbPath);
        }
        DatabaseUtils.executeSQL(db, setupPath + dbPath + fs + "new_cdb.sql");
        DatabaseUtils.executeSQL(db, setupPath + dbPath + fs + "new_opportunity.sql");
        DatabaseUtils.executeSQL(db, setupPath + dbPath + fs + "new_project.sql");
        DatabaseUtils.executeSQL(db, setupPath + dbPath + fs + "new_product.sql");
        DatabaseUtils.executeSQL(db, setupPath + dbPath + fs + "new_service_contract.sql");
        DatabaseUtils.executeSQL(db, setupPath + dbPath + fs + "new_tms.sql");
        DatabaseUtils.executeSQL(db, setupPath + dbPath + fs + "new_quote.sql");
        DatabaseUtils.executeSQL(db, setupPath + dbPath + fs + "new_order.sql");
        DatabaseUtils.executeSQL(db, setupPath + dbPath + fs + "new_custom_field.sql");
        DatabaseUtils.executeSQL(db, setupPath + dbPath + fs + "new_campaign.sql");
        DatabaseUtils.executeSQL(db, setupPath + dbPath + fs + "new_help.sql");
        DatabaseUtils.executeSQL(db, setupPath + dbPath + fs + "new_sync.sql");
        DatabaseUtils.executeSQL(db, setupPath + dbPath + fs + "new_autoguide.sql");
        DatabaseUtils.executeSQL(db, setupPath + dbPath + fs + "new_revenue.sql");
        DatabaseUtils.executeSQL(db, setupPath + dbPath + fs + "new_task.sql");
        DatabaseUtils.executeSQL(db, setupPath + dbPath + fs + "new_documents.sql");
        DatabaseUtils.executeSQL(db, setupPath + dbPath + fs + "new_workflow.sql");
        DatabaseUtils.executeSQL(db, setupPath + dbPath + fs + "new_tms_append_fields.sql");
        DatabaseUtils.executeSQL(db, setupPath + dbPath + fs + "new_quote_adjustment.sql");
        DatabaseUtils.executeSQL(db, setupPath + dbPath + fs + "new_history.sql");
        DatabaseUtils.executeSQL(db, setupPath + dbPath + fs + "new_actionplan.sql");
        DatabaseUtils.executeSQL(db, setupPath + dbPath + fs + "new_knowledgebase.sql");
        DatabaseUtils.executeSQL(db, setupPath + dbPath + fs + "new_netapp.sql");
        DatabaseUtils.executeSQL(db, setupPath + dbPath + fs + "new_website.sql");
    }

    public static boolean insertDefaultData(Connection db, String dbFileLibraryPath, String setupPath, String locale, boolean syncOnly) throws Exception, EvalError, IOException {
        Interpreter script = new Interpreter();
        script.set("db", (Object)db);
        script.set("dbFileLibraryPath", (Object)dbFileLibraryPath);
        script.set("locale", (Object)locale);
        script.set("prefsPath", (Object)(setupPath + "init" + fs));
        script.source(setupPath + "init" + fs + "sync.bsh");
        script.source(setupPath + "init" + fs + "sync-mappings.bsh");
        if (syncOnly) {
            return true;
        }
        script.source(setupPath + "init" + fs + "database.bsh");
        String lookupFile = "lookuplists_en_US.xml";
        File checkLookupFile = new File(setupPath + "init" + fs + "lookuplists_" + locale + ".xml");
        if (checkLookupFile.exists()) {
            lookupFile = "lookuplists_" + locale + ".xml";
        }
        ImportLookupLists lookups = new ImportLookupLists();
        lookups.importLookups(db, setupPath + "init" + fs + lookupFile);
        String permissionsFile = "permissions_en_US.xml";
        File checkPermissionFile = new File(setupPath + "init" + fs + "permissions_" + locale + ".xml");
        if (checkPermissionFile.exists()) {
            permissionsFile = "permissions_" + locale + ".xml";
        }
        InitPermissionsAndRoles permissionsReader = new InitPermissionsAndRoles();
        permissionsReader.setProcessConfigFile(setupPath + "init" + fs + permissionsFile);
        PermissionsAndRolesWriter permissionsWriter = new PermissionsAndRolesWriter();
        permissionsWriter.setDb(db);
        permissionsReader.execute(permissionsWriter);
        script.source(setupPath + "init" + fs + "workflow.bsh");
        String filePath = setupPath + "../icelets/icelet_en_US.xml";
        HashMap iceletMap = IceletList.load(filePath);
        ImportIcelets.insertIceletList(db, iceletMap);
        ImportHelp help = new ImportHelp();
        help.buildHelpInformation(setupPath + "init" + fs + "help.xml");
        help.buildExistingPermissionCategories(db);
        help.insertHelpRecords(db);
        help.buildTableOfContents();
        help.insertTableOfContents(db);
        DatabaseVersion.insertVersion(db, DatabaseUtils.getTypeName(db), "2004-06-15");
        DatabaseVersion.insertVersion(db, DatabaseUtils.getTypeName(db), "2004-08-30");
        DatabaseVersion.insertVersion(db, DatabaseUtils.getTypeName(db), "2005-01-14");
        DatabaseVersion.insertVersion(db, DatabaseUtils.getTypeName(db), "2005-03-30");
        DatabaseVersion.insertVersion(db, DatabaseUtils.getTypeName(db), "2005-05-02");
        DatabaseVersion.insertVersion(db, DatabaseUtils.getTypeName(db), "2005-07-08");
        DatabaseVersion.insertVersion(db, DatabaseUtils.getTypeName(db), "2005-08-24");
        DatabaseVersion.insertVersion(db, DatabaseUtils.getTypeName(db), "2005-08-30");
        DatabaseVersion.insertVersion(db, DatabaseUtils.getTypeName(db), "2005-10-17");
        DatabaseVersion.insertVersion(db, DatabaseUtils.getTypeName(db), "2005-10-24");
        DatabaseVersion.insertVersion(db, DatabaseUtils.getTypeName(db), "2005-11-02");
        DatabaseVersion.insertVersion(db, DatabaseUtils.getTypeName(db), "2005-11-03");
        DatabaseVersion.insertVersion(db, DatabaseUtils.getTypeName(db), "2005-11-14");
        DatabaseVersion.insertVersion(db, DatabaseUtils.getTypeName(db), "2005-12-14");
        DatabaseVersion.insertVersion(db, DatabaseUtils.getTypeName(db), "2005-12-19");
        DatabaseVersion.insertVersion(db, DatabaseUtils.getTypeName(db), "2006-01-25");
        DatabaseVersion.insertVersion(db, DatabaseUtils.getTypeName(db), "2006-04-12");
        DatabaseVersion.insertVersion(db, DatabaseUtils.getTypeName(db), "2006-04-17");
        DatabaseVersion.insertVersion(db, DatabaseUtils.getTypeName(db), "2006-05-08");
        DatabaseVersion.insertVersion(db, DatabaseUtils.getTypeName(db), "2006-06-01");
        DatabaseVersion.insertVersion(db, DatabaseUtils.getTypeName(db), "2006-06-16");
        DatabaseVersion.insertVersion(db, DatabaseUtils.getTypeName(db), "2006-06-30");
        DatabaseVersion.insertVersion(db, DatabaseUtils.getTypeName(db), "2006-07-11");
        DatabaseVersion.insertVersion(db, DatabaseUtils.getTypeName(db), "2006-09-05");
        DatabaseVersion.insertVersion(db, DatabaseUtils.getTypeName(db), "2006-11-02");
        DatabaseVersion.insertVersion(db, DatabaseUtils.getTypeName(db), "2006-11-16");
        DatabaseVersion.insertVersion(db, DatabaseUtils.getTypeName(db), "2006-12-28");
        DatabaseVersion.insertVersion(db, DatabaseUtils.getTypeName(db), "2007-01-16");
        DatabaseVersion.insertVersion(db, DatabaseUtils.getTypeName(db), "2007-01-29");
        return true;
    }

    public static void restoreFromBackup(Connection db, Connection dbLookup, String backupFile) throws SQLException {
        SyncClient thisClient = new SyncClient();
        thisClient.setId(0);
        thisClient.setType("Restore client");
        thisClient.setEnabled(true);
        thisClient.setEnteredBy(0);
        thisClient.setModifiedBy(0);
        thisClient.insert(db);
        try {
            BackupUtils.restore(db, dbLookup, backupFile, thisClient);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new SQLException(e.getMessage());
        }
        finally {
            thisClient.delete(db);
        }
    }
}

