/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.system.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.utils.DatabaseUtils;

public class DatabaseVersion {
    private int id = -1;
    private String scriptFilename = null;
    private String scriptVersion = null;
    private Timestamp entered = null;

    public DatabaseVersion() {
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getScriptFilename() {
        return this.scriptFilename;
    }

    public void setScriptFilename(String scriptFilename) {
        this.scriptFilename = scriptFilename;
    }

    public String getScriptVersion() {
        return this.scriptVersion;
    }

    public void setScriptVersion(String scriptVersion) {
        this.scriptVersion = scriptVersion;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public void setEntered(Timestamp entered) {
        this.entered = entered;
    }

    public DatabaseVersion(Connection db, int versionId) throws SQLException {
        this.queryRecord(db, versionId);
    }

    public void queryRecord(Connection db, int versionId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT dv.* FROM database_version dv WHERE dv.version_id = ? ");
        pst.setInt(1, this.id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.getId() == -1) {
            throw new SQLException("Record Not Found");
        }
    }

    public DatabaseVersion(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("version_id");
        this.scriptFilename = rs.getString("script_filename");
        this.scriptVersion = rs.getString("script_version");
        this.entered = rs.getTimestamp("entered");
    }

    public void insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "database_version_version_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO database_version (" + (this.id > -1 ? "version_id, " : "") + "script_filename, " + "script_version) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?) ");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setString(++i, this.scriptFilename);
        pst.setString(++i, this.scriptVersion);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "database_version_version_id_seq", this.id);
    }

    public static String getLatestVersion(Connection db) throws SQLException {
        String version = "";
        PreparedStatement pst = db.prepareStatement("SELECT max(script_version) AS version FROM database_version ");
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            version = rs.getString("version");
        }
        rs.close();
        pst.close();
        return version;
    }

    public static void insertVersion(Connection db, String typeName, String version) throws SQLException {
        DatabaseVersion thisVersion = new DatabaseVersion();
        thisVersion.setScriptFilename(typeName);
        thisVersion.setScriptVersion(version);
        thisVersion.insert(db);
    }

    public static ArrayList recordList(Connection db) throws SQLException {
        ArrayList<DatabaseVersion> records = new ArrayList<DatabaseVersion>();
        PreparedStatement pst = db.prepareStatement("SELECT * FROM database_version WHERE version_id > -1 ");
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            DatabaseVersion version = new DatabaseVersion(rs);
            records.add(version);
        }
        rs.close();
        pst.close();
        return records;
    }
}

