/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.system.base;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.utils.DatabaseUtils;

public class Site
extends GenericBean {
    private int id = -1;
    private String siteCode = null;
    private String virtualHost = null;
    private String databaseUrl = null;
    private String databaseName = null;
    private int databasePort = -1;
    private String databaseUsername = null;
    private String databasePassword = null;
    private String databaseDriver = null;
    private String accessCode = null;
    private boolean enabled = true;
    private String language = null;

    public Site() {
    }

    public Site(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public Site(Connection db, int siteId) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("Site record not found.");
        }
        PreparedStatement pst = db.prepareStatement("SELECT * FROM sites s WHERE site_id = ? ");
        pst.setInt(1, this.id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Site record not found.");
        }
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setSiteCode(String tmp) {
        this.siteCode = tmp;
    }

    public void setVirtualHost(String tmp) {
        this.virtualHost = tmp;
    }

    public void setDatabaseUrl(String tmp) {
        this.databaseUrl = tmp;
    }

    public void setDatabaseName(String tmp) {
        this.databaseName = tmp;
    }

    public void setDatabasePort(int tmp) {
        this.databasePort = tmp;
    }

    public void setDatabasePort(String tmp) {
        this.databasePort = Integer.parseInt(tmp);
    }

    public void setDatabaseUsername(String tmp) {
        this.databaseUsername = tmp;
    }

    public void setDatabasePassword(String tmp) {
        this.databasePassword = tmp;
    }

    public void setDatabaseDriver(String tmp) {
        this.databaseDriver = tmp;
    }

    public void setAccessCode(String tmp) {
        this.accessCode = tmp;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public int getId() {
        return this.id;
    }

    public String getSiteCode() {
        return this.siteCode;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public String getDatabaseUrl() {
        return this.databaseUrl;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public int getDatabasePort() {
        return this.databasePort;
    }

    public String getDatabaseUsername() {
        return this.databaseUsername;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public String getDatabaseDriver() {
        return this.databaseDriver;
    }

    public String getAccessCode() {
        return this.accessCode;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String s) {
        this.language = s;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("site_id");
        this.siteCode = rs.getString("sitecode");
        this.virtualHost = rs.getString("vhost");
        this.databaseUrl = rs.getString("dbhost");
        this.databaseName = rs.getString("dbname");
        this.databasePort = rs.getInt("dbport");
        this.databaseUsername = rs.getString("dbuser");
        this.databasePassword = rs.getString("dbpw");
        this.databaseDriver = rs.getString("driver");
        this.accessCode = rs.getString("code");
        this.enabled = rs.getBoolean("enabled");
        this.language = rs.getString("language");
    }

    public ConnectionElement getConnectionElement() {
        ConnectionElement ce = new ConnectionElement(this.databaseUrl, this.databaseUsername, this.databasePassword);
        ce.setDriver(this.databaseDriver);
        ce.setDbName(this.databaseName);
        return ce;
    }
}

