/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.system.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.aspcfs.modules.system.base.Site;
import org.aspcfs.utils.web.PagedListInfo;

public class SiteList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int enabled = -1;
    private String siteCode = null;
    private String virtualHost = null;
    private String databaseName = null;
    private String dbHost = null;

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void setEnabled(int tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = Integer.parseInt(tmp);
    }

    public int getEnabled() {
        return this.enabled;
    }

    public void setSiteCode(String tmp) {
        this.siteCode = tmp;
    }

    public String getSiteCode() {
        return this.siteCode;
    }

    public void setVirtualHost(String tmp) {
        this.virtualHost = tmp;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public String getDbHost() {
        return this.dbHost;
    }

    public void setDbHost(String dbHost) {
        this.dbHost = dbHost;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM sites s WHERE s.site_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("site_id", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY site_id ");
        }
        sqlSelect.append("SELECT * FROM sites s WHERE s.site_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            Site thisSite = new Site(rs);
            this.add(thisSite);
        }
        rs.close();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.enabled != -1) {
            sqlFilter.append("AND enabled = ? ");
        }
        if (this.siteCode != null) {
            sqlFilter.append("AND sitecode = ? ");
        }
        if (this.virtualHost != null) {
            sqlFilter.append("AND vhost = ? ");
        }
        if (this.dbHost != null) {
            sqlFilter.append("AND dbhost = ? ");
        }
        if (this.databaseName != null) {
            sqlFilter.append("AND dbname = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.enabled != -1) {
            pst.setBoolean(++i, this.enabled == 1);
        }
        if (this.siteCode != null) {
            pst.setString(++i, this.siteCode);
        }
        if (this.virtualHost != null) {
            pst.setString(++i, this.virtualHost);
        }
        if (this.dbHost != null) {
            pst.setString(++i, this.dbHost);
        }
        if (this.databaseName != null) {
            pst.setString(++i, this.databaseName);
        }
        return i;
    }
}

