/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.tasks.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.webutils.FileDownload;
import java.net.SocketException;
import java.sql.Connection;
import java.util.StringTokenizer;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.tasks.base.Task;
import org.aspcfs.modules.tasks.base.TaskList;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;

public final class MyTasks
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-tasks-view")) {
            return "PermissionError";
        }
        return this.executeCommandListTasks(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandListTasks(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-tasks-view")) {
            return "PermissionError";
        }
        PagedListInfo taskListInfo = this.getPagedListInfo(context, "TaskListInfo");
        taskListInfo.setLink("MyTasks.do?command=ListTasks");
        Connection db = null;
        TaskList taskList = new TaskList();
        if (!taskListInfo.hasListFilters()) {
            taskListInfo.addFilter(1, "my");
            taskListInfo.addFilter(2, "false");
        }
        try {
            db = this.getConnection(context);
            taskList.setPagedListInfo(taskListInfo);
            if ("tasksbyme".equals(taskListInfo.getFilterValue("listFilter1"))) {
                taskList.setTasksAssignedByUser(this.getUserId(context));
            } else {
                taskList.setOwner(this.getUserId(context));
            }
            if (!"all".equals(taskListInfo.getFilterValue("listFilter2"))) {
                if ("false".equals(taskListInfo.getFilterValue("listFilter2"))) {
                    taskList.setComplete(0);
                } else {
                    taskList.setComplete(1);
                }
            }
            taskList.buildList(db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("TaskList", (Object)taskList);
        this.addModuleBean(context, "My Tasks", "Task Home");
        return "TaskListOK";
    }

    public String executeCommandNew(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-tasks-add")) {
            return "PermissionError";
        }
        Task newTask = (Task)((Object)context.getFormBean());
        context.getRequest().setAttribute("Task", (Object)newTask);
        this.addModuleBean(context, "My Tasks", "New Task");
        return MyTasks.getReturn(context, "NewTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-tasks-view")) {
            return "PermissionError";
        }
        Connection db = null;
        Task thisTask = null;
        String id = context.getRequest().getParameter("id");
        if (id == null || "".equals(id.trim())) {
            id = (String)context.getRequest().getAttribute("id");
        }
        try {
            db = this.getConnection(context);
            thisTask = new Task(db, Integer.parseInt(id));
            context.getRequest().setAttribute("Task", (Object)thisTask);
            LookupList list = this.getSystemStatus(context).getLookupList(db, "lookup_ticket_task_category");
            context.getRequest().setAttribute("ticketTaskCategoryList", (Object)list);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (this.hasAuthority(context, thisTask.getOwner()) || this.hasAuthority(context, thisTask.getEnteredBy())) {
            return MyTasks.getReturn(context, "TaskDetails");
        }
        return "PermissionError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        Task thisTask;
        Connection db;
        Exception errorMessage;
        block12: {
            errorMessage = null;
            db = null;
            thisTask = null;
            int id = -1;
            String forward = context.getRequest().getParameter("return");
            if (forward != null && !"".equals(forward.trim())) {
                context.getRequest().setAttribute("return", (Object)forward);
            }
            if (!this.hasPermission(context, "myhomepage-tasks-edit")) {
                return "PermissionError";
            }
            context.getSession().removeAttribute("contactListInfo");
            try {
                if (context.getRequest().getParameter("id") != null) {
                    id = Integer.parseInt(context.getRequest().getParameter("id"));
                }
                db = this.getConnection(context);
                thisTask = (Task)((Object)context.getFormBean());
                if (thisTask.getId() == -1) {
                    thisTask = new Task(db, id);
                    thisTask.buildResources(db);
                }
                thisTask.checkEnabledOwnerAccount(db);
                if (thisTask.getContactId() > -1) {
                    thisTask.checkEnabledLinkAccount(db);
                    Contact contact = new Contact(db, thisTask.getContactId());
                    thisTask.setContactName(contact.getNameFull());
                }
                if (thisTask.getTicketId() <= -1) break block12;
                LookupList list = this.getSystemStatus(context).getLookupList(db, "lookup_ticket_task_category");
                context.getRequest().setAttribute("ticketTaskCategoryList", (Object)list);
            }
            catch (Exception e) {
                try {
                    errorMessage = e;
                }
                catch (Throwable throwable) {
                    this.freeConnection(context, db);
                    throw throwable;
                }
                this.freeConnection(context, db);
            }
        }
        this.freeConnection(context, db);
        if (errorMessage == null) {
            if (!this.hasAuthority(context, thisTask.getOwner())) {
                if (this.hasAuthority(context, thisTask.getEnteredBy())) {
                    context.getRequest().setAttribute("Task", (Object)thisTask);
                    return MyTasks.getReturn(context, "TaskDetails");
                }
                return "PermissionError";
            }
            this.addModuleBean(context, "My Tasks", "Task Home");
            context.getRequest().setAttribute("Task", (Object)thisTask);
            return MyTasks.getReturn(context, "NewTask");
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsert(ActionContext context) {
        Connection db = null;
        int id = -1;
        boolean inserted = false;
        boolean isValid = false;
        if (!this.hasPermission(context, "myhomepage-tasks-add")) {
            return "PermissionError";
        }
        if (context.getRequest().getParameter("id") != null) {
            id = Integer.parseInt(context.getRequest().getParameter("id"));
        }
        try {
            db = this.getConnection(context);
            Task newTask = (Task)((Object)context.getFormBean());
            newTask.setEnteredBy(this.getUserId(context));
            newTask.setModifiedBy(this.getUserId(context));
            isValid = this.validateObject(context, db, (Object)newTask);
            if (isValid) {
                inserted = newTask.insert(db);
            }
            if (inserted) {
                Task bufferTask = new Task(db, newTask.getId());
                this.processInsertHook(context, (Object)bufferTask);
            } else {
                if (newTask.getContactId() > -1) {
                    newTask.checkEnabledLinkAccount(db);
                    Contact contact = new Contact(db, newTask.getContactId());
                    newTask.setContactName(contact.getNameFull());
                    context.getRequest().setAttribute("Task", (Object)newTask);
                }
                if (newTask.getTicketId() > -1) {
                    LookupList list = this.getSystemStatus(context).getLookupList(db, "lookup_ticket_task_category");
                    context.getRequest().setAttribute("ticketTaskCategoryList", (Object)list);
                }
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        String addAnother = context.getRequest().getParameter("addAnother");
        if (addAnother != null && "true".equals(addAnother.trim())) {
            context.getRequest().setAttribute("Task", (Object)new Task());
            return MyTasks.getReturn(context, "NewTask");
        }
        if (inserted) {
            return MyTasks.getReturn(context, "InsertTask");
        }
        return this.executeCommandNew(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdate(ActionContext context) {
        Connection db = null;
        boolean isValid = false;
        if (!this.hasPermission(context, "myhomepage-tasks-edit")) {
            return "PermissionError";
        }
        int count = -1;
        String forward = context.getRequest().getParameter("return");
        if (forward != null && !"".equals(forward.trim())) {
            context.getRequest().setAttribute("return", (Object)forward);
        }
        String id = context.getRequest().getParameter("id");
        Task thisTask = (Task)((Object)context.getFormBean());
        try {
            db = this.getConnection(context);
            Task previousTask = new Task(db, thisTask.getId());
            thisTask.setModifiedBy(this.getUserId(context));
            Task oldTask = new Task(db, Integer.parseInt(id));
            if (!this.hasAuthority(context, oldTask.getOwner())) {
                String string = "PermissionError";
                return string;
            }
            isValid = this.validateObject(context, db, (Object)thisTask);
            if (isValid) {
                count = thisTask.update(db);
            }
            if (count == 1) {
                this.processUpdateHook(context, (Object)previousTask, (Object)thisTask);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (count == -1 || !isValid) {
            return this.executeCommandModify(context);
        }
        if (forward != null && "details".equals(forward.trim())) {
            context.getRequest().setAttribute("id", (Object)String.valueOf(thisTask.getId()));
            return MyTasks.getReturn(context, "DetailsTask");
        }
        return MyTasks.getReturn(context, "InsertTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        Connection db = null;
        Task thisTask = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        int id = -1;
        if (!this.hasPermission(context, "myhomepage-tasks-delete")) {
            return "PermissionError";
        }
        if (context.getRequest().getParameter("id") != null) {
            id = Integer.parseInt(context.getRequest().getParameter("id"));
        }
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            thisTask = new Task(db, id);
            if (!this.hasAuthority(context, thisTask.getOwner())) {
                String string = "PermissionError";
                return string;
            }
            DependencyList dependencies = thisTask.processDependencies(db);
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            if (dependencies.size() == 0) {
                htmlDialog.setShowAndConfirm(false);
                htmlDialog.setDeleteUrl("javascript:window.location.href='MyTasks.do?command=Delete&id=" + id + "'");
            } else {
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.header2"));
                htmlDialog.addButton(systemStatus.getLabel("button.deleteAll"), "javascript:window.location.href='MyTasks.do?command=Delete&id=" + id + "'");
                htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        return "ConfirmDeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        Connection db = null;
        Task thisTask = null;
        int id = -1;
        int action = -1;
        if (!this.hasPermission(context, "myhomepage-tasks-delete")) {
            return "PermissionError";
        }
        if (context.getRequest().getParameter("id") != null) {
            id = Integer.parseInt(context.getRequest().getParameter("id"));
        }
        if (context.getRequest().getParameter("action") != null) {
            action = Integer.parseInt(context.getRequest().getParameter("action"));
        }
        try {
            db = this.getConnection(context);
            thisTask = new Task(db, id);
            if (!this.hasAuthority(context, thisTask.getOwner())) {
                String string = "PermissionError";
                return string;
            }
            thisTask.delete(db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("Task", (Object)thisTask);
        context.getRequest().setAttribute("refreshUrl", (Object)"MyTasks.do?command=ListTasks");
        return "DeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String executeCommandProcessImage(ActionContext context) {
        Connection db = null;
        int count = 0;
        boolean isValid = false;
        String id = context.getRequest().getParameter("id");
        String from = context.getRequest().getParameter("return");
        String imageId = context.getRequest().getParameter("imageId");
        if (imageId != null && !"".equals(imageId)) {
            context.getRequest().setAttribute("imageId", (Object)imageId);
        }
        try {
            StringTokenizer st = new StringTokenizer(id, "|");
            String fileName = st.nextToken();
            String imageType = st.nextToken();
            int taskId = Integer.parseInt(st.nextToken());
            int status = Integer.parseInt(st.nextToken());
            db = this.getConnection(context);
            Task thisTask = new Task(db, taskId);
            Task previousTask = new Task(db, taskId);
            if (!this.hasAuthority(context, thisTask.getOwner())) {
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            if (status == Task.DONE) {
                thisTask.setComplete(true);
            } else {
                thisTask.setComplete(false);
            }
            thisTask.setOnlyWarnings(true);
            isValid = this.validateObject(context, db, (Object)thisTask);
            if (isValid) {
                count = thisTask.update(db);
            }
            if (count == 1) {
                this.processUpdateHook(context, (Object)previousTask, (Object)thisTask);
            }
            if (from != null && "list".equals(from)) {
                context.getRequest().setAttribute("image", (Object)("images/" + fileName));
            } else if (count != -1) {
                String filePath = context.getServletContext().getRealPath("/") + "images" + fs + fileName;
                FileDownload fileDownload = new FileDownload();
                fileDownload.setFullPath(filePath);
                fileDownload.setDisplayName(fileName);
                if (fileDownload.fileExists()) {
                    fileDownload.sendFile(context, "image/" + imageType);
                } else {
                    System.err.println("Image-> Trying to send a file that does not exist");
                }
            }
            this.freeConnection(context, db);
        }
        catch (SocketException se) {
            System.out.println("MyTasks-> ProcessImage : Download canceled or connection lost");
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.freeConnection(context, db);
        }
        if (from != null && "list".equals(from)) {
            return "SetStatusOK";
        }
        return "-none-";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandReassignTask(ActionContext context) {
        Connection db = null;
        boolean isValid = false;
        if (!this.hasPermission(context, "myhomepage-tasks-edit")) {
            return "PermissionError";
        }
        int count = -1;
        String forward = context.getRequest().getParameter("return");
        if (forward != null && !"".equals(forward.trim())) {
            context.getRequest().setAttribute("return", (Object)forward);
        }
        String id = context.getRequest().getParameter("id");
        String ownerId = context.getRequest().getParameter("ownerId");
        Task thisTask = null;
        try {
            db = this.getConnection(context);
            thisTask = new Task(db, Integer.parseInt(id));
            thisTask.setOwner(ownerId);
            Task previousTask = new Task(db, thisTask.getId());
            thisTask.setModifiedBy(this.getUserId(context));
            Task oldTask = new Task(db, Integer.parseInt(id));
            if (!this.hasAuthority(context, oldTask.getOwner())) {
                String string = "PermissionError";
                return string;
            }
            count = thisTask.update(db);
            if (count == 1) {
                this.processUpdateHook(context, (Object)previousTask, (Object)thisTask);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "AssignTaskOK";
    }
}

