/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.tasks.base;

import com.darkhorseventures.framework.beans.GenericBean;
import com.zeroio.webdav.utils.ICalendar;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.TimeZone;
import org.aspcfs.modules.actionlist.base.ActionItemLog;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactHistory;
import org.aspcfs.modules.tasks.base.TaskLink;
import org.aspcfs.modules.troubletickets.base.Ticket;
import org.aspcfs.utils.DatabaseUtils;

public class Task
extends GenericBean {
    public static int DONE = 1;
    public static int GENERAL = 1;
    private int id = -1;
    private int enteredBy = -1;
    private int priority = -1;
    private int reminderId = -1;
    private int sharing = -1;
    private int modifiedBy = -1;
    private double estimatedLOE = -1.0;
    private int estimatedLOEType = -1;
    private int owner = -1;
    private int categoryId = -1;
    private int age = -1;
    private int type = -1;
    private String notes = null;
    private String description = null;
    private boolean complete = false;
    private boolean enabled = false;
    private Timestamp dueDate = null;
    private Timestamp modified = null;
    private Timestamp entered = null;
    private Timestamp completeDate = null;
    private String dueDateTimeZone = null;
    private Timestamp trashedDate = null;
    private int ticketTaskCategoryId = -1;
    private int contactId = -1;
    private int ticketId = -1;
    private int projectId = -1;
    private boolean hasLinks = false;
    private String contactName = null;
    private Contact contact = null;
    private Ticket ticket = null;
    private TaskLink linkDetails = new TaskLink();
    private boolean hasEnabledOwnerAccount = true;
    private boolean hasEnabledLinkAccount = true;
    private int actionId = -1;

    public Task() {
    }

    public Task(Connection db, int thisId) throws SQLException {
        if (thisId == -1) {
            throw new SQLException("Task ID not specified");
        }
        PreparedStatement pst = db.prepareStatement("SELECT t.task_id, t.entered, t.enteredby, t.priority, t.description, t.duedate, t.notes, t.sharing, t.complete, t.estimatedloe, t.estimatedloetype, t." + DatabaseUtils.addQuotes(db, "type") + ", t.owner, t.completedate, t.modified, " + "t.modifiedby, t.category_id, t.duedate_timezone, t.trashed_date, t.ticket_task_category_id " + "FROM task t " + "WHERE task_id = ? ");
        int i = 0;
        pst.setInt(++i, thisId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (thisId == -1) {
            throw new SQLException("Task ID not found");
        }
        this.buildResources(db);
    }

    public Task(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setCompleteDate(String tmp) {
        this.completeDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setReminderId(int tmp) {
        this.reminderId = tmp;
    }

    public void setReminderId(String tmp) {
        this.reminderId = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp entered) {
        this.entered = entered;
    }

    public void setEntered(String entered) {
        this.entered = DatabaseUtils.parseTimestamp(entered);
    }

    public void setEnteredBy(int enteredBy) {
        this.enteredBy = enteredBy;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setType(String type) {
        this.type = Integer.parseInt(type);
    }

    public void setDueDateTimeZone(String tmp) {
        this.dueDateTimeZone = tmp;
    }

    public String getDueDateTimeZone() {
        return this.dueDateTimeZone;
    }

    public int getType() {
        return this.type;
    }

    public boolean getHasEnabledOwnerAccount() {
        return this.hasEnabledOwnerAccount;
    }

    public boolean getHasEnabledLinkAccount() {
        return this.hasEnabledLinkAccount;
    }

    public void setHasEnabledOwnerAccount(boolean tmp) {
        this.hasEnabledOwnerAccount = tmp;
    }

    public void setHasEnabledLinkAccount(boolean tmp) {
        this.hasEnabledLinkAccount = tmp;
    }

    public void setEnteredBy(String enteredBy) {
        this.enteredBy = Integer.parseInt(enteredBy);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setPriority(String priority) {
        this.priority = Integer.parseInt(priority);
    }

    public void setDueDate(Timestamp dueDate) {
        this.dueDate = dueDate;
    }

    public void setDueDate(String tmp) {
        this.dueDate = DatabaseUtils.parseDateToTimestamp(tmp);
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public void setSharing(int sharing) {
        this.sharing = sharing;
    }

    public void setSharing(String sharing) {
        this.sharing = Integer.parseInt(sharing);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public void setComplete(String complete) {
        this.complete = DatabaseUtils.parseBoolean(complete);
    }

    public void setEstimatedLOE(double estimatedLOE) {
        this.estimatedLOE = estimatedLOE;
    }

    public void setEstimatedLOE(String estimatedLOE) {
        this.estimatedLOE = Double.parseDouble(estimatedLOE);
    }

    public void setOwner(int owner) {
        this.owner = owner;
    }

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public void setCategoryId(String tmp) {
        this.setCategoryId(Integer.parseInt(tmp));
    }

    public void setOwner(String owner) {
        this.owner = Integer.parseInt(owner);
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setId(String id) {
        this.id = Integer.parseInt(id);
    }

    public void setAge(int age) {
        this.age = age;
    }

    public void setAge(String age) {
        this.age = Integer.parseInt(age);
    }

    public void setContactId(int contactId) {
        this.contactId = contactId;
    }

    public void setContactId(String contactId) {
        this.contactId = Integer.parseInt(contactId);
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public void setContact(String contact_id) {
        this.contactId = Integer.parseInt(contact_id);
    }

    public void setTicketId(int ticketId) {
        this.ticketId = ticketId;
    }

    public void setTicketId(String ticketId) {
        this.ticketId = Integer.parseInt(ticketId);
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int tmp) {
        this.projectId = tmp;
    }

    public void setProjectId(String tmp) {
        this.projectId = Integer.parseInt(tmp);
    }

    public void setEstimatedLOEType(int estimatedLOEType) {
        this.estimatedLOEType = estimatedLOEType;
    }

    public void setEstimatedLOEType(String estimatedLOEType) {
        this.estimatedLOEType = Integer.parseInt(estimatedLOEType);
    }

    public void setLinkDetails(TaskLink linkDetails) {
        this.linkDetails = linkDetails;
    }

    public void buildLinkDetails(Connection db) throws SQLException {
        if (this.linkDetails == null) {
            this.linkDetails = new TaskLink();
        }
        this.linkDetails.setType(this.getType());
        this.linkDetails.setTaskId(this.getId());
        this.linkDetails.build(db);
    }

    public TaskLink getLinkDetails() {
        return this.linkDetails;
    }

    public int getEstimatedLOEType() {
        return this.estimatedLOEType;
    }

    public void setCompleteDate(Timestamp completeDate) {
        this.completeDate = completeDate;
    }

    public void setModified(Timestamp modified) {
        this.modified = modified;
    }

    public void setModified(String modified) {
        this.modified = DatabaseUtils.parseTimestamp(modified);
    }

    public void setActionId(int actionId) {
        this.actionId = actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = Integer.parseInt(actionId);
    }

    public int getActionId() {
        return this.actionId;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getCompleteDate() {
        return this.completeDate;
    }

    public String getCompleteDateString() {
        String tmp = "";
        try {
            return DateFormat.getDateInstance(3).format(this.completeDate);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public Contact getContact() {
        return this.contact;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public boolean getHasLinks() {
        return this.hasLinks;
    }

    public int getTicketId() {
        return this.ticketId;
    }

    public String getContactName() {
        return this.contactName;
    }

    public int getContactId() {
        return this.contactId;
    }

    public int getAge() {
        return this.age;
    }

    public String getAgeString() {
        return this.age + "d";
    }

    public double getEstimatedLOE() {
        return this.estimatedLOE;
    }

    public String getEstimatedLOEValue() {
        String toReturn = String.valueOf(this.estimatedLOE);
        if (toReturn.endsWith(".0")) {
            toReturn = toReturn.substring(0, toReturn.length() - 2);
        }
        if ("0".equals(toReturn) || this.estimatedLOE < 0.0) {
            toReturn = "";
        }
        return toReturn;
    }

    public void checkEnabledOwnerAccount(Connection db) throws SQLException {
        if (this.getOwner() == -1) {
            throw new SQLException("ID not specified for lookup.");
        }
        PreparedStatement pst = db.prepareStatement("SELECT * FROM " + DatabaseUtils.addQuotes(db, "access") + " " + "WHERE user_id = ? AND enabled = ? ");
        pst.setInt(1, this.getOwner());
        pst.setBoolean(2, true);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.setHasEnabledOwnerAccount(true);
        } else {
            this.setHasEnabledOwnerAccount(false);
        }
        rs.close();
        pst.close();
    }

    public void checkEnabledLinkAccount(Connection db) throws SQLException {
        if (this.getContactId() == -1) {
            throw new SQLException("ID not specified for lookup.");
        }
        PreparedStatement pst = db.prepareStatement("SELECT * FROM " + DatabaseUtils.addQuotes(db, "access") + " " + "WHERE user_id = ? AND enabled = ? ");
        pst.setInt(1, this.getContactId());
        pst.setBoolean(2, true);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.setHasEnabledLinkAccount(true);
        } else {
            this.setHasEnabledLinkAccount(false);
        }
        rs.close();
        pst.close();
    }

    public int getSharing() {
        return this.sharing;
    }

    public int getOwner() {
        return this.owner;
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public boolean getComplete() {
        return this.complete;
    }

    public String getNotes() {
        return this.notes;
    }

    public int getReminderId() {
        return this.reminderId;
    }

    public Timestamp getDueDate() {
        return this.dueDate;
    }

    public String getDueDateString() {
        String tmp = "";
        try {
            return DateFormat.getDateInstance(3).format(this.dueDate);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public String getEnteredString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public int getId() {
        return this.id;
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public int getTicketTaskCategoryId() {
        return this.ticketTaskCategoryId;
    }

    public void setTicketTaskCategoryId(int tmp) {
        this.ticketTaskCategoryId = tmp;
    }

    public void setTicketTaskCategoryId(String tmp) {
        this.ticketTaskCategoryId = Integer.parseInt(tmp);
    }

    public boolean insert(Connection db) throws SQLException {
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            this.id = DatabaseUtils.getNextSeq(db, "task_task_id_seq");
            PreparedStatement pst = db.prepareStatement("INSERT INTO task (" + (this.id > -1 ? "task_id, " : "") + "enteredby, modifiedby, priority, description, notes, sharing, owner, duedate, duedate_timezone, estimatedloe, " + (this.estimatedLOEType == -1 ? "" : "estimatedLOEType, ") + (this.type == -1 ? "" : "" + DatabaseUtils.addQuotes(db, "type") + ", ") + "complete, completedate, category_id, trashed_date, ticket_task_category_id) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " + (this.estimatedLOEType == -1 ? "" : "?, ") + (this.type == -1 ? "" : "?, ") + "?, ?, ?, ?, ?) ");
            int i = 0;
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, this.getEnteredBy());
            pst.setInt(++i, this.getModifiedBy());
            pst.setInt(++i, this.getPriority());
            pst.setString(++i, this.getDescription());
            pst.setString(++i, this.getNotes());
            pst.setInt(++i, this.getSharing());
            DatabaseUtils.setInt(pst, ++i, this.getOwner());
            pst.setTimestamp(++i, this.getDueDate());
            pst.setString(++i, this.getDueDateTimeZone());
            pst.setDouble(++i, this.getEstimatedLOE());
            if (this.getEstimatedLOEType() != -1) {
                pst.setInt(++i, this.getEstimatedLOEType());
            }
            if (this.getType() != -1) {
                pst.setInt(++i, this.getType());
            }
            pst.setBoolean(++i, this.getComplete());
            if (this.getComplete()) {
                pst.setTimestamp(++i, new Timestamp(System.currentTimeMillis()));
            } else {
                pst.setTimestamp(++i, null);
            }
            DatabaseUtils.setInt(pst, ++i, this.categoryId);
            DatabaseUtils.setTimestamp(pst, ++i, this.getTrashedDate());
            DatabaseUtils.setInt(pst, ++i, this.getTicketTaskCategoryId());
            pst.execute();
            this.id = DatabaseUtils.getCurrVal(db, "task_task_id_seq", this.id);
            pst.close();
            if (this.getContactId() > -1) {
                this.processContacts(db, true);
            }
            if (this.actionId > 0) {
                this.updateLog(db);
            }
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public void updateLog(Connection db) throws SQLException {
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            ActionItemLog thisLog = new ActionItemLog();
            thisLog.setEnteredBy(this.getEnteredBy());
            thisLog.setModifiedBy(this.getModifiedBy());
            thisLog.setItemId(this.getActionId());
            thisLog.setLinkItemId(this.getId());
            thisLog.setType(42420033);
            thisLog.insert(db);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
    }

    public int update(Connection db) throws SQLException {
        String sql = null;
        PreparedStatement pst = null;
        int count = 0;
        if (this.id == -1) {
            throw new SQLException("Task ID not specified");
        }
        try {
            db.setAutoCommit(false);
            Task previousTask = new Task(db, this.id);
            sql = "UPDATE task SET modifiedby = ?, priority = ?, description = ?, notes = ?, sharing = ?, owner = ?, duedate = ?, duedate_timezone = ?, estimatedloe = ?, " + (this.estimatedLOEType == -1 ? "" : "estimatedloetype = ?, ") + "modified = CURRENT_TIMESTAMP, complete = ?, completedate = ?, " + "category_id = ?, trashed_date = ?, ticket_task_category_id = ? " + "WHERE task_id = ? AND modified " + (this.getModified() == null ? "IS NULL " : "= ? ");
            int i = 0;
            pst = db.prepareStatement(sql);
            pst.setInt(++i, this.getModifiedBy());
            pst.setInt(++i, this.getPriority());
            pst.setString(++i, this.getDescription());
            pst.setString(++i, this.getNotes());
            pst.setInt(++i, this.getSharing());
            DatabaseUtils.setInt(pst, ++i, this.getOwner());
            pst.setTimestamp(++i, this.getDueDate());
            pst.setString(++i, this.getDueDateTimeZone());
            pst.setDouble(++i, this.getEstimatedLOE());
            if (this.getEstimatedLOEType() != -1) {
                pst.setInt(++i, this.getEstimatedLOEType());
            }
            pst.setBoolean(++i, this.getComplete());
            if (previousTask.getComplete() && this.getComplete()) {
                pst.setTimestamp(++i, previousTask.getCompleteDate());
            } else if (this.getComplete() && !previousTask.getComplete()) {
                pst.setTimestamp(++i, new Timestamp(System.currentTimeMillis()));
            } else {
                DatabaseUtils.setTimestamp(pst, ++i, null);
            }
            DatabaseUtils.setInt(pst, ++i, this.categoryId);
            DatabaseUtils.setTimestamp(pst, ++i, this.getTrashedDate());
            DatabaseUtils.setInt(pst, ++i, this.getTicketTaskCategoryId());
            pst.setInt(++i, this.id);
            if (this.getModified() != null) {
                pst.setTimestamp(++i, this.getModified());
            }
            count = pst.executeUpdate();
            pst.close();
            if (this.contactId == -1) {
                this.processContacts(db, false);
            } else {
                this.processContacts(db, true);
            }
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return count;
    }

    public boolean processContacts(Connection db, boolean linkContacts) throws SQLException {
        String sql = null;
        if (this.getId() == -1) {
            throw new SQLException("Task ID not specified");
        }
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            sql = "DELETE FROM tasklink_contact WHERE task_id = ? ";
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql);
            pst.setInt(++i, this.getId());
            pst.execute();
            pst.close();
            if (linkContacts) {
                if (this.contactId == -1) {
                    throw new SQLException("Contact ID incorrect");
                }
                sql = "INSERT INTO tasklink_contact (task_id, contact_id) VALUES (?, ?) ";
                i = 0;
                pst = db.prepareStatement(sql);
                pst.setInt(++i, this.getId());
                pst.setInt(++i, this.getContactId());
                pst.execute();
                pst.close();
            }
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        DependencyList dependencyList = new DependencyList();
        return dependencyList;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Task ID not specified");
        }
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            this.deleteRelationships(db);
            ContactHistory.deleteObject(db, 16, this.getId());
            PreparedStatement pst = db.prepareStatement("DELETE from task WHERE task_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public boolean deleteRelationships(Connection db) throws SQLException {
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = db.prepareStatement("DELETE from tasklink_contact WHERE task_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE from tasklink_ticket WHERE task_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE from tasklink_project WHERE task_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            ActionItemLog.deleteLink(db, this.getId(), 42420033);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public void buildResources(Connection db) throws SQLException {
        ResultSet rs = null;
        String sql = null;
        if (this.getId() == -1) {
            throw new SQLException("Task ID not specified");
        }
        try {
            sql = "SELECT contact_id FROM tasklink_contact tl_ct WHERE task_id = ? ";
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql);
            pst.setInt(++i, this.getId());
            rs = pst.executeQuery();
            if (rs.next()) {
                this.contactId = rs.getInt("contact_id");
                this.hasLinks = true;
            }
            rs.close();
            pst.close();
            if (this.contactId > 0) {
                this.contact = new Contact(db, this.contactId);
                this.contactName = this.contact.getNameFull();
            }
            sql = "SELECT ticket_id FROM tasklink_ticket WHERE task_id = ? ";
            i = 0;
            pst = db.prepareStatement(sql);
            pst.setInt(++i, this.getId());
            rs = pst.executeQuery();
            if (rs.next()) {
                this.ticketId = rs.getInt("ticket_id");
            }
            rs.close();
            pst.close();
            if (this.ticketId > 0) {
                this.ticket = new Ticket(db, this.ticketId);
            }
            sql = "SELECT project_id FROM tasklink_project WHERE task_id = ? ";
            i = 0;
            pst = db.prepareStatement(sql);
            pst.setInt(++i, this.getId());
            rs = pst.executeQuery();
            if (rs.next()) {
                this.projectId = rs.getInt("project_id");
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
    }

    private void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("task_id");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.priority = rs.getInt("priority");
        this.description = rs.getString("description");
        this.dueDate = rs.getTimestamp("duedate");
        this.notes = rs.getString("notes");
        this.sharing = rs.getInt("sharing");
        this.complete = rs.getBoolean("complete");
        this.estimatedLOE = rs.getDouble("estimatedloe");
        this.estimatedLOEType = rs.getInt("estimatedloetype");
        if (rs.wasNull()) {
            this.estimatedLOEType = -1;
        }
        this.type = rs.getInt("type");
        this.owner = rs.getInt("owner");
        this.completeDate = rs.getTimestamp("completeDate");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.categoryId = DatabaseUtils.getInt(rs, "category_id");
        this.dueDateTimeZone = rs.getString("duedate_timezone");
        this.trashedDate = rs.getTimestamp("trashed_date");
        this.ticketTaskCategoryId = DatabaseUtils.getInt(rs, "ticket_task_category_id");
        if (this.entered != null) {
            float ageCheck = (System.currentTimeMillis() - this.entered.getTime()) / 86400000L;
            this.age = Math.round(ageCheck);
        }
    }

    public void insertProjectLink(Connection db, int projectId) throws SQLException {
        String sql = "INSERT INTO tasklink_project (task_id, project_id) VALUES (?, ?) ";
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(++i, this.getId());
        pst.setInt(++i, projectId);
        pst.execute();
        pst.close();
    }

    public void deleteProjectLink(Connection db, int projectId) throws SQLException {
        int i = 0;
        PreparedStatement pst = db.prepareStatement("DELETE FROM tasklink_project WHERE task_id = ? AND project_id = ?");
        pst.setInt(++i, this.getId());
        pst.setInt(++i, projectId);
        pst.execute();
        pst.close();
    }

    public void updateCategoryId(Connection db, int newCategoryId) throws SQLException {
        int i = 0;
        PreparedStatement pst = db.prepareStatement("UPDATE task SET category_id = ? WHERE task_id = ? ");
        pst.setInt(++i, newCategoryId);
        pst.setInt(++i, this.id);
        pst.execute();
        pst.close();
    }

    public static void markComplete(Connection db, int taskId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE task SET complete = ?, completedate = ? WHERE task_id = ? ");
        pst.setBoolean(1, true);
        pst.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
        pst.setInt(3, taskId);
        pst.execute();
        pst.close();
    }

    public static void markIncomplete(Connection db, int taskId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE task SET complete = ?, completedate = ? WHERE task_id = ? ");
        pst.setBoolean(1, false);
        pst.setNull(2, 93);
        pst.setInt(3, taskId);
        pst.execute();
        pst.close();
    }

    public static ArrayList getUserIdParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("enteredBy");
        thisList.add("modifiedBy");
        thisList.add("owner");
        return thisList;
    }

    public static ArrayList getTimeZoneParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("dueDate");
        return thisList;
    }

    public static ArrayList getNumberParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("estimatedLOE");
        return thisList;
    }

    public boolean updateStatus(Connection db, boolean toTrash, int tmpUserId) throws SQLException {
        boolean commit = true;
        int resultCount = -1;
        PreparedStatement pst = null;
        Object rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE task SET trashed_date = ? , modified = " + DatabaseUtils.getCurrentTimestamp(db) + " , " + "modifiedby = ? " + "WHERE task_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        if (toTrash) {
            DatabaseUtils.setTimestamp(pst, ++i, new Timestamp(System.currentTimeMillis()));
        } else {
            DatabaseUtils.setTimestamp(pst, ++i, null);
        }
        DatabaseUtils.setInt(pst, ++i, tmpUserId);
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        ContactHistory.trash(db, 16, this.getId(), !toTrash);
        return resultCount == 1;
    }

    public boolean reassign(Connection db, int newOwner) throws SQLException {
        int result = -1;
        this.setOwner(newOwner);
        result = this.update(db);
        return result != -1;
    }

    public String generateWebcalEvent(String category, TimeZone tz, Timestamp created) {
        StringBuffer webcal = new StringBuffer();
        String CRLF = System.getProperty("line.separator");
        String summary = "";
        if (this.description != null) {
            summary = summary + this.description;
        }
        webcal.append("BEGIN:VTODO" + CRLF);
        webcal.append("UID:www.centriccrm.com-myhomepage-tasks-" + this.getId() + CRLF);
        if (created != null) {
            webcal.append("DTSTAMP:" + ICalendar.getDateTimeUTC((Timestamp)created) + CRLF);
        }
        if (this.entered != null) {
            webcal.append("CREATED:" + ICalendar.getDateTimeUTC((Timestamp)this.entered) + CRLF);
        }
        if (summary != null) {
            webcal.append(ICalendar.foldLine((String)("SUMMARY:" + summary)) + CRLF);
        }
        if (this.priority != -1) {
            webcal.append("PRIORITY;VALUE=INTEGER:" + ICalendar.getPriority((int)this.priority) + CRLF);
        }
        if (this.age != -1) {
            webcal.append(ICalendar.foldLine((String)("DESCRIPTION:Age: " + this.getAgeString())) + CRLF);
        }
        if (category != null) {
            webcal.append("CATEGORIES:" + category + CRLF);
        }
        if (this.dueDate != null) {
            webcal.append("DUE;TZID=" + tz.getID() + ":" + ICalendar.getDateTime((TimeZone)tz, (Timestamp)this.dueDate) + CRLF);
        }
        if (this.contactName != null) {
            webcal.append("CONTACT:" + this.contactName + CRLF);
        }
        if (this.complete) {
            webcal.append("STATUS:COMPLETE" + CRLF);
        } else {
            webcal.append("STATUS:NEEDS-ACTION" + CRLF);
        }
        webcal.append("END:VTODO" + CRLF);
        return webcal.toString();
    }
}

