/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.tasks.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.utils.DatabaseUtils;

public class TaskCategory
extends GenericBean {
    private int id = -1;
    private String description = null;
    private boolean defaultItem = false;
    private int level = 0;
    private boolean enabled = true;
    private int linkModuleId = -1;
    private int linkItemId = -1;
    private int taskCount = 0;
    private Timestamp lastTaskEntered = null;
    private int lastTaskEnteredBy = -1;

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setDefaultItem(boolean tmp) {
        this.defaultItem = tmp;
    }

    public void setDefaultItem(String tmp) {
        this.defaultItem = DatabaseUtils.parseBoolean(tmp);
    }

    public void setLevel(int tmp) {
        this.level = tmp;
    }

    public void setLevel(String tmp) {
        this.level = Integer.parseInt(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setTaskCount(int tmp) {
        this.taskCount = tmp;
    }

    public void setTaskCount(String tmp) {
        this.taskCount = Integer.parseInt(tmp);
    }

    public void setLastTaskEntered(Timestamp tmp) {
        this.lastTaskEntered = tmp;
    }

    public void setLastTaskEnteredBy(int tmp) {
        this.lastTaskEnteredBy = tmp;
    }

    public void setLastTaskEntered(String tmp) {
        this.lastTaskEntered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setLinkModuleId(int tmp) {
        this.linkModuleId = tmp;
    }

    public void setLinkModuleId(String tmp) {
        this.linkModuleId = Integer.parseInt(tmp);
    }

    public void setLinkItemId(int tmp) {
        this.linkItemId = tmp;
    }

    public void setLinkItemId(String tmp) {
        this.linkItemId = Integer.parseInt(tmp);
    }

    public int getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getDefaultItem() {
        return this.defaultItem;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public int getLinkModuleId() {
        return this.linkModuleId;
    }

    public int getLinkItemId() {
        return this.linkItemId;
    }

    public int getTaskCount() {
        return this.taskCount;
    }

    public Timestamp getLastTaskEntered() {
        return this.lastTaskEntered;
    }

    public int getLastTaskEnteredBy() {
        return this.lastTaskEnteredBy;
    }

    public TaskCategory() {
    }

    public TaskCategory(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public TaskCategory(Connection db, int categoryId) throws SQLException {
        if (categoryId == -1) {
            throw new SQLException("Category ID not specified");
        }
        PreparedStatement pst = db.prepareStatement("SELECT * FROM lookup_task_category WHERE code = ? ");
        pst.setInt(1, categoryId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Category ID not found");
        }
        this.buildResources(db);
    }

    public void buildResources(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT max(entered) AS latest, count(task_id) AS thecount FROM task WHERE category_id = ? ");
        pst.setInt(1, this.id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.lastTaskEntered = rs.getTimestamp("latest");
            this.taskCount = rs.getInt("thecount");
        }
        rs.close();
        pst.close();
    }

    public boolean insert(Connection db) throws SQLException {
        String sql = null;
        try {
            db.setAutoCommit(false);
            this.id = DatabaseUtils.getNextSeq(db, "lookup_task_category_code_seq");
            sql = "INSERT INTO lookup_task_category (" + (this.id > -1 ? "code, " : "") + "description, default_item, " + DatabaseUtils.addQuotes(db, "level") + ", enabled) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?) ";
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql);
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setString(++i, this.description);
            pst.setBoolean(++i, this.defaultItem);
            pst.setInt(++i, this.level);
            pst.setBoolean(++i, this.enabled);
            pst.execute();
            this.id = DatabaseUtils.getCurrVal(db, "lookup_task_category_code_seq", this.id);
            pst.close();
            if (this.linkModuleId == 4) {
                pst = db.prepareStatement("INSERT INTO taskcategory_project (category_id, project_id) VALUES (?, ?) ");
                pst.setInt(1, this.id);
                pst.setInt(2, this.linkItemId);
                pst.execute();
                pst.close();
            }
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Record ID was not specified");
        }
        int resultCount = 0;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE lookup_task_category SET description = ?, default_item = ?, " + DatabaseUtils.addQuotes(db, "level") + " = ?, enabled = ? " + "WHERE code = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setString(++i, this.description);
        pst.setBoolean(++i, this.defaultItem);
        pst.setInt(++i, this.level);
        pst.setBoolean(++i, this.enabled);
        pst.setInt(++i, this.id);
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    private void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("code");
        this.description = rs.getString("description");
        this.defaultItem = rs.getBoolean("default_item");
        this.level = rs.getInt("level");
        this.enabled = rs.getBoolean("enabled");
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("ID not specified");
        }
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = null;
            pst = db.prepareStatement("DELETE from tasklink_project WHERE task_id IN (SELECT task_id FROM task WHERE category_id = ?) ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE from taskcategorylink_news WHERE category_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE from task WHERE category_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE from taskcategory_project WHERE category_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE from lookup_task_category WHERE code = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }
}

