/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.tasks.base;

import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.iteam.base.Indexer;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.aspcfs.modules.tasks.base.TaskCategory;
import org.aspcfs.utils.DatabaseUtils;

public class TaskCategoryIndexer
implements Indexer {
    public static void add(IndexWriter writer, Connection db, ActionContext context) throws SQLException, IOException {
        int count = 0;
        PreparedStatement pst = db.prepareStatement("SELECT code, project_id, description FROM lookup_task_category t, taskcategory_project c WHERE t.code = c.category_id ");
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            ++count;
            TaskCategory taskCategory = new TaskCategory();
            taskCategory.setId(rs.getInt("code"));
            taskCategory.setLinkModuleId(4);
            taskCategory.setLinkItemId(rs.getInt("project_id"));
            taskCategory.setDescription(rs.getString("description"));
            TaskCategoryIndexer.add(writer, taskCategory, false);
            DatabaseUtils.renewConnection(context, db);
        }
        rs.close();
        pst.close();
        System.out.println("TaskCategoryIndexer-> Finished: " + count);
    }

    public static void add(IndexWriter writer, TaskCategory taskCategory, boolean modified) throws IOException {
        Document document = new Document();
        document.add(Field.Keyword((String)"type", (String)"listCategory"));
        document.add(Field.Keyword((String)"listCategoryKeyId", (String)String.valueOf(taskCategory.getId())));
        document.add(Field.Keyword((String)"listCategoryId", (String)String.valueOf(taskCategory.getId())));
        document.add(Field.Keyword((String)"projectId", (String)String.valueOf(taskCategory.getLinkItemId())));
        document.add(Field.Text((String)"title", (String)taskCategory.getDescription()));
        document.add(Field.Text((String)"contents", (String)taskCategory.getDescription()));
        writer.addDocument(document);
        if (System.getProperty("DEBUG") != null && modified) {
            System.out.println("TaskCategoryIndexer-> Added: " + taskCategory.getId());
        }
    }

    public static Term getSearchTerm(TaskCategory taskCategory) {
        Term searchTerm = new Term("listCategoryKeyId", String.valueOf(taskCategory.getId()));
        return searchTerm;
    }

    public static Term getDeleteTerm(TaskCategory taskCategory) {
        Term searchTerm = new Term("listCategoryId", String.valueOf(taskCategory.getId()));
        return searchTerm;
    }
}

