/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.tasks.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.tasks.base.TaskCategory;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.PagedListInfo;

public class TaskCategoryList
extends ArrayList {
    protected PagedListInfo pagedListInfo = null;
    protected int projectId = -1;

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setProjectId(int tmp) {
        this.projectId = tmp;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM lookup_task_category c WHERE c.code > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND c.description > ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("c." + DatabaseUtils.addQuotes(db, "level") + ", c.description", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY c." + DatabaseUtils.addQuotes(db, "level") + ", c.description ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("c.code, c.description, c.default_item, c." + DatabaseUtils.addQuotes(db, "level") + ", c.enabled " + "FROM lookup_task_category c " + "WHERE c.code > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            TaskCategory thisCategory = new TaskCategory(rs);
            this.add(thisCategory);
        }
        rs.close();
        pst.close();
        for (TaskCategory thisCategory : this) {
            thisCategory.buildResources(db);
        }
    }

    protected void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.projectId > 0) {
            sqlFilter.append("AND c.code IN (SELECT category_id FROM taskcategory_project WHERE project_id = ?) ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.projectId > 0) {
            pst.setInt(++i, this.projectId);
        }
        return i;
    }

    public void delete(Connection db) throws SQLException {
        for (TaskCategory thisCategory : this) {
            thisCategory.delete(db);
        }
    }

    public String getHtmlSelect(SystemStatus thisSystem, String selectName, int selectedId) {
        HtmlSelect thisSelect = new HtmlSelect();
        thisSelect.addItem(-1, thisSystem.getLabel("calendar.none.4dashes"));
        for (TaskCategory thisCategory : this) {
            thisSelect.addItem(thisCategory.getId(), thisCategory.getDescription());
        }
        return thisSelect.getHtml(selectName, selectedId);
    }

    public String getValueFromId(int id) {
        for (TaskCategory thisCategory : this) {
            if (thisCategory.getId() != id) continue;
            return thisCategory.getDescription();
        }
        return null;
    }

    public HtmlSelect getHtmlSelect() {
        HtmlSelect thisSelect = new HtmlSelect();
        for (TaskCategory thisCategory : this) {
            thisSelect.addItem(thisCategory.getId(), thisCategory.getDescription());
        }
        return thisSelect;
    }
}

