/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.tasks.base;

import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.iteam.base.Indexer;
import com.zeroio.utils.ContentUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.aspcfs.modules.tasks.base.Task;
import org.aspcfs.utils.DatabaseUtils;

public class TaskIndexer
implements Indexer {
    public static void add(IndexWriter writer, Connection db, ActionContext context) throws SQLException, IOException {
        int count = 0;
        PreparedStatement pst = db.prepareStatement("SELECT t.task_id, t.category_id, project_id, description, notes, modified FROM task t, tasklink_project l WHERE t.task_id = l.task_id ");
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            ++count;
            Task task = new Task();
            task.setId(rs.getInt("task_id"));
            task.setCategoryId(rs.getInt("category_id"));
            task.setProjectId(rs.getInt("project_id"));
            task.setDescription(rs.getString("description"));
            task.setNotes(rs.getString("notes"));
            task.setModified(rs.getTimestamp("modified"));
            TaskIndexer.add(writer, task, false);
            DatabaseUtils.renewConnection(context, db);
        }
        rs.close();
        pst.close();
        System.out.println("TaskIndexer-> Finished: " + count);
    }

    public static void add(IndexWriter writer, Task task, boolean modified) throws IOException {
        Document document = new Document();
        document.add(Field.Keyword((String)"type", (String)"list"));
        document.add(Field.Keyword((String)"listId", (String)String.valueOf(task.getId())));
        document.add(Field.Keyword((String)"listCategoryId", (String)String.valueOf(task.getCategoryId())));
        document.add(Field.Keyword((String)"projectId", (String)String.valueOf(task.getProjectId())));
        document.add(Field.Text((String)"title", (String)task.getDescription()));
        document.add(Field.Text((String)"contents", (String)(task.getDescription() + " " + ContentUtils.toText((String)task.getNotes()))));
        if (modified) {
            document.add(Field.Keyword((String)"modified", (String)String.valueOf(System.currentTimeMillis())));
        } else {
            document.add(Field.Keyword((String)"modified", (String)String.valueOf(task.getModified().getTime())));
        }
        writer.addDocument(document);
        if (System.getProperty("DEBUG") != null && modified) {
            System.out.println("TaskIndexer-> Added: " + task.getId());
        }
    }

    public static Term getSearchTerm(Task task) {
        Term searchTerm = new Term("listId", String.valueOf(task.getId()));
        return searchTerm;
    }

    public static Term getDeleteTerm(Task task) {
        Term searchTerm = new Term("listId", String.valueOf(task.getId()));
        return searchTerm;
    }
}

