/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.tasks.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TimeZone;
import org.aspcfs.modules.base.UserCentric;
import org.aspcfs.modules.tasks.base.Task;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class TaskList
extends ArrayList
implements UserCentric {
    public static final String tableName = "task";
    public static final String uniqueField = "task_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    protected int enteredBy = -1;
    protected PagedListInfo pagedListInfo = null;
    protected int owner = -1;
    protected int complete = -1;
    protected int sharing = -1;
    protected int tasksAssignedByUser = -1;
    protected Timestamp alertRangeStart = null;
    protected Timestamp alertRangeEnd = null;
    protected int categoryId = -1;
    protected int projectId = -1;
    protected int ticketId = -1;
    protected int hasLinkedContact = -1;
    protected int hasLinkedTicket = -1;
    protected int areAssigned = -1;
    private Timestamp trashedDate = null;
    private boolean includeOnlyTrashed = false;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public int getSharing() {
        return this.sharing;
    }

    public void setSharing(int tmp) {
        this.sharing = tmp;
    }

    public void setSharing(String tmp) {
        this.sharing = Integer.parseInt(tmp);
    }

    public void setEnteredBy(int enteredBy) {
        this.enteredBy = enteredBy;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setComplete(int tmp) {
        this.complete = tmp;
    }

    public void setOwner(int owner) {
        this.owner = owner;
    }

    public void setTasksAssignedByUser(int tmp) {
        this.tasksAssignedByUser = tmp;
    }

    public void setAlertRangeStart(Timestamp alertRangeStart) {
        this.alertRangeStart = alertRangeStart;
    }

    public void setTicketId(int ticketId) {
        this.ticketId = ticketId;
    }

    public int getTasksAssignedByUser() {
        return this.tasksAssignedByUser;
    }

    public int getOwner() {
        return this.owner;
    }

    public int getTicketId() {
        return this.ticketId;
    }

    public void setAlertRangeEnd(Timestamp alertRangeEnd) {
        this.alertRangeEnd = alertRangeEnd;
    }

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public void setProjectId(int tmp) {
        this.projectId = tmp;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getHasLinkedContact() {
        return this.hasLinkedContact;
    }

    public void setHasLinkedContact(int tmp) {
        this.hasLinkedContact = tmp;
    }

    public void setHasLinkedContact(String tmp) {
        this.hasLinkedContact = Integer.parseInt(tmp);
    }

    public int getHasLinkedTicket() {
        return this.hasLinkedTicket;
    }

    public void setHasLinkedTicket(int tmp) {
        this.hasLinkedTicket = tmp;
    }

    public void setHasLinkedTicket(String tmp) {
        this.hasLinkedTicket = Integer.parseInt(tmp);
    }

    public int getAreAssigned() {
        return this.areAssigned;
    }

    public void setAreAssigned(int tmp) {
        this.areAssigned = tmp;
    }

    public void setAreAssigned(String tmp) {
        this.areAssigned = Integer.parseInt(tmp);
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public boolean getIncludeOnlyTrashed() {
        return this.includeOnlyTrashed;
    }

    public void setIncludeOnlyTrashed(boolean tmp) {
        this.includeOnlyTrashed = tmp;
    }

    public void setIncludeOnlyTrashed(String tmp) {
        this.includeOnlyTrashed = DatabaseUtils.parseBoolean(tmp);
    }

    public HashMap queryRecordCount(Connection db, TimeZone timeZone) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        HashMap<String, Integer> events = new HashMap<String, Integer>();
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlTail = new StringBuffer();
        sqlSelect.append("SELECT duedate, count(*) AS nocols FROM task t WHERE t.task_id > -1 ");
        this.createFilter(sqlFilter);
        sqlFilter.append("AND duedate IS NOT NULL ");
        sqlFilter.append("AND t.complete = ? ");
        sqlTail.append("GROUP BY duedate");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlTail.toString());
        int i = this.prepareFilter(pst);
        pst.setBoolean(++i, false);
        rs = pst.executeQuery();
        if (System.getProperty("DEBUG") != null) {
            System.out.println("TaskList-> Building Record Count ");
        }
        while (rs.next()) {
            String dueDate = DateUtils.getServerToUserDateString(timeZone, 3, rs.getTimestamp("duedate"));
            events.put(dueDate, new Integer(rs.getInt("nocols")));
        }
        rs.close();
        pst.close();
        return events;
    }

    public void buildShortList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        this.createFilter(sqlFilter);
        sqlSelect.append("SELECT t.task_id, t.description, t.duedate, t.complete, t.priority, t.entered, tc.contact_id FROM task t LEFT JOIN tasklink_contact tc ON (t.task_id = tc.task_id) WHERE t.task_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString());
        this.prepareFilter(pst);
        rs = pst.executeQuery();
        while (rs.next()) {
            Task thisTask = new Task();
            thisTask.setId(rs.getInt(uniqueField));
            thisTask.setDescription(rs.getString("description"));
            thisTask.setDueDate(rs.getTimestamp("duedate"));
            thisTask.setComplete(rs.getBoolean("complete"));
            thisTask.setPriority(rs.getInt("priority"));
            thisTask.setEntered(rs.getTimestamp("entered"));
            float ageCheck = (System.currentTimeMillis() - thisTask.getEntered().getTime()) / 86400000L;
            thisTask.setAge(Math.round(ageCheck));
            thisTask.setContactId(DatabaseUtils.getInt(rs, "contact_id"));
            this.add(thisTask);
        }
        rs.close();
        pst.close();
    }

    public void accessedBy(int userId) {
        if (userId > -1) {
            this.setOwner(userId);
        }
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM task t WHERE t.task_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND t.priority > ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            if (this.pagedListInfo.getMaxRecords() == 0) {
                this.pagedListInfo.setCurrentOffset(0);
            }
            this.pagedListInfo.setDefaultSort("t.priority, description", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY t.priority, description ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("t.task_id, t.entered, t.enteredby, t.priority, t.description, t.duedate, t.notes, t.sharing, t.complete, t.estimatedloe, t.estimatedloetype, t." + DatabaseUtils.addQuotes(db, "type") + ", t.owner, t.completedate, t.modified, " + "t.modifiedby, t.category_id, t.duedate_timezone, t.trashed_date, t.ticket_task_category_id " + "FROM task t " + "WHERE t.task_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            Task thisTask = new Task(rs);
            this.add(thisTask);
        }
        rs.close();
        pst.close();
        for (Task thisTask : this) {
            thisTask.buildResources(db);
            if (thisTask.getType() == Task.GENERAL) continue;
            thisTask.buildLinkDetails(db);
        }
    }

    public int reassignElements(Connection db, int newOwner) throws SQLException {
        int total = 0;
        for (Task thisTask : this) {
            if (!thisTask.reassign(db, newOwner)) continue;
            ++total;
        }
        return total;
    }

    public int reassignElements(Connection db, int newOwner, int userId) throws SQLException {
        int total = 0;
        for (Task thisTask : this) {
            thisTask.setModifiedBy(userId);
            if (!thisTask.reassign(db, newOwner)) continue;
            ++total;
        }
        return total;
    }

    protected void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.enteredBy != -1) {
            sqlFilter.append("AND t.enteredby = ? ");
        }
        if (this.tasksAssignedByUser > 0) {
            sqlFilter.append("AND t.enteredby = ? AND t.owner NOT IN (SELECT user_id FROM contact WHERE user_id = ?) AND t.owner IS NOT NULL ");
        }
        if (this.owner > 0) {
            sqlFilter.append("AND t.owner = ? ");
        }
        if (this.complete != -1) {
            sqlFilter.append("AND t.complete = ? ");
        }
        if (this.sharing != -1) {
            if (this.sharing == 1) {
                sqlFilter.append("AND t.sharing > 0 ");
            } else if (this.sharing == 0) {
                sqlFilter.append("AND t.sharing <= 0 ");
            }
        }
        if (this.alertRangeStart != null) {
            sqlFilter.append("AND t.duedate >= ? ");
        }
        if (this.alertRangeEnd != null) {
            sqlFilter.append("AND t.duedate < ? ");
        }
        if (this.categoryId > 0) {
            sqlFilter.append("AND t.category_id = ? ");
        }
        if (this.projectId > 0) {
            sqlFilter.append("AND t.task_id IN (SELECT task_id FROM tasklink_project WHERE project_id = ?) ");
        } else {
            sqlFilter.append("AND t.task_id NOT IN (SELECT task_id FROM tasklink_project) ");
        }
        if (this.ticketId > 0) {
            sqlFilter.append("AND t.task_id IN (SELECT task_id FROM tasklink_ticket WHERE ticket_id = ?) ");
        }
        if (this.hasLinkedContact == 1) {
            sqlFilter.append("AND t.task_id IN (SELECT tlc.task_id FROM tasklink_contact tlc WHERE tlc.contact_id IS NOT NULL) ");
        } else if (this.hasLinkedContact == 0) {
            sqlFilter.append("AND t.task_id NOT IN (SELECT tlc.task_id FROM tasklink_contact tlc WHERE tlc.contact_id IS NOT NULL) ");
        }
        if (this.hasLinkedTicket == 1) {
            sqlFilter.append("AND t.task_id IN (SELECT tlt.task_id FROM tasklink_ticket tlt WHERE tlt.ticket_id IS NOT NULL) ");
        } else if (this.hasLinkedTicket == 0) {
            sqlFilter.append("AND t.task_id NOT IN (SELECT tlt.task_id FROM tasklink_ticket tlt WHERE tlt.ticket_id IS NOT NULL) ");
        }
        if (this.areAssigned == 1) {
            sqlFilter.append("AND t.owner IS NOT NULL ");
        } else if (this.areAssigned == 0) {
            sqlFilter.append("AND t.owner IS NULL ");
        }
        if (this.includeOnlyTrashed) {
            sqlFilter.append("AND t.trashed_date IS NOT NULL ");
        } else if (this.trashedDate != null) {
            sqlFilter.append("AND t.trashed_date = ? ");
        } else {
            sqlFilter.append("AND t.trashed_date IS NULL ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.enteredBy != -1) {
            pst.setInt(++i, this.enteredBy);
        }
        if (this.tasksAssignedByUser > 0) {
            pst.setInt(++i, this.tasksAssignedByUser);
            pst.setInt(++i, this.tasksAssignedByUser);
        }
        if (this.owner > 0) {
            pst.setInt(++i, this.owner);
        }
        if (this.complete != -1) {
            pst.setBoolean(++i, this.complete == 1);
        }
        if (this.alertRangeStart != null) {
            pst.setTimestamp(++i, this.alertRangeStart);
        }
        if (this.alertRangeEnd != null) {
            pst.setTimestamp(++i, this.alertRangeEnd);
        }
        if (this.categoryId > 0) {
            pst.setInt(++i, this.categoryId);
        }
        if (this.projectId > 0) {
            pst.setInt(++i, this.projectId);
        }
        if (this.ticketId > 0) {
            pst.setInt(++i, this.ticketId);
        }
        if (!this.includeOnlyTrashed && this.trashedDate != null) {
            pst.setTimestamp(++i, this.trashedDate);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public static int queryPendingCount(Connection db, int userId) throws SQLException {
        int toReturn = 0;
        String sql = "SELECT count(*) as taskcount FROM task WHERE owner = ? AND complete = ? AND trashed_date IS NULL AND task_id NOT IN (SELECT task_id FROM tasklink_project) ";
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(++i, userId);
        pst.setBoolean(++i, false);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            toReturn = rs.getInt("taskcount");
        }
        rs.close();
        pst.close();
        return toReturn;
    }

    public void delete(Connection db) throws SQLException {
        for (Task thisTask : this) {
            thisTask.delete(db);
        }
    }

    public boolean updateStatus(Connection db, boolean toTrash, int tmpUserId) throws SQLException {
        for (Task tmpTask : this) {
            tmpTask.updateStatus(db, toTrash, tmpUserId);
        }
        return true;
    }
}

