/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.tasks.base;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Set;
import java.util.TimeZone;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.base.ScheduledActions;
import org.aspcfs.modules.mycfs.base.CalendarEventList;
import org.aspcfs.modules.tasks.base.Task;
import org.aspcfs.modules.tasks.base.TaskList;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.web.CalendarView;

public class TaskListScheduledActions
extends TaskList
implements ScheduledActions {
    private ActionContext context = null;
    private CFSModule module = null;
    private int userId = -1;
    private int loginId = -1;

    public int getLoginId() {
        return this.loginId;
    }

    public void setLoginId(int tmp) {
        this.loginId = tmp;
    }

    public void setLoginId(String tmp) {
        this.loginId = Integer.parseInt(tmp);
    }

    public void setModule(CFSModule tmp) {
        this.module = tmp;
    }

    public void setContext(ActionContext tmp) {
        this.context = tmp;
    }

    public void setUserId(int tmp) {
        this.userId = tmp;
    }

    public void setUserId(String tmp) {
        this.userId = Integer.parseInt(tmp);
    }

    public ActionContext getContext() {
        return this.context;
    }

    public CFSModule getModule() {
        return this.module;
    }

    public int getUserId() {
        return this.userId;
    }

    public void buildAlerts(CalendarView companyCalendar, Connection db) throws SQLException {
        try {
            if (this.module != null && this.context != null) {
                this.loginId = this.module.getUserId(this.context);
            }
            if (System.getProperty("DEBUG") != null) {
                System.out.println("TaskListScheduledActions-> Building Task Alerts for user " + this.userId);
            }
            TimeZone timeZone = companyCalendar.getCalendarInfo().getTimeZone();
            this.setOwner(this.userId);
            if (this.loginId != this.userId) {
                this.setSharing(0);
            }
            this.setComplete(0);
            this.buildShortList(db);
            for (Task thisTask : this) {
                thisTask.buildResources(db);
                String alertDate = DateUtils.getServerToUserDateString(timeZone, 3, thisTask.getDueDate());
                companyCalendar.addEvent(alertDate, CalendarEventList.EVENT_TYPES[0], (Object)thisTask);
            }
        }
        catch (SQLException e) {
            throw new SQLException("Error Building Task Calendar Alerts");
        }
    }

    public void buildAlertCount(CalendarView companyCalendar, Connection db) throws SQLException {
        try {
            if (System.getProperty("DEBUG") != null) {
                System.out.println("TaskListScheduledActions-> Building Alert Count ");
            }
            if (this.module != null && this.context != null) {
                this.loginId = this.module.getUserId(this.context);
            }
            TimeZone timeZone = companyCalendar.getCalendarInfo().getTimeZone();
            this.setOwner(this.userId);
            if (this.loginId != this.userId) {
                this.setSharing(0);
            }
            this.setComplete(0);
            HashMap dayEvents = this.queryRecordCount(db, timeZone);
            Set s = dayEvents.keySet();
            for (String thisDay : s) {
                companyCalendar.addEventCount(thisDay, CalendarEventList.EVENT_TYPES[0], dayEvents.get(thisDay));
                if (System.getProperty("DEBUG") == null) continue;
                System.out.println("TaskListScheduledActions-> Added Tasks for " + thisDay + "- " + String.valueOf(dayEvents.get(thisDay)));
            }
        }
        catch (SQLException e) {
            throw new SQLException("Error Building Task Calendar Alerts: " + e.getMessage());
        }
    }
}

