/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.isavvix.tools.FileInfo;
import com.isavvix.tools.HttpMultiPartParser;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemVersion;
import com.zeroio.webutils.FileDownload;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.troubletickets.base.KnowledgeBase;
import org.aspcfs.modules.troubletickets.base.KnowledgeBaseList;
import org.aspcfs.modules.troubletickets.base.TicketCategory;
import org.aspcfs.modules.troubletickets.base.TicketCategoryList;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;

public final class KnowledgeBaseManager
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        if (!this.hasPermission(context, "tickets-knowledge-base-view")) {
            return "DefaultError";
        }
        return this.executeCommandSearch(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSearch(ActionContext context) {
        if (!this.hasPermission(context, "tickets-knowledge-base-view")) {
            return "PermissionError";
        }
        String popupString = context.getRequest().getParameter("popup");
        boolean popup = popupString != null && !"".equals(popupString.trim());
        PagedListInfo kbListInfo = this.getPagedListInfo(context, popup ? "kbListInfoPopup" : "kbListInfo");
        kbListInfo.setLink("KnowledgeBaseManager.do?command=Search" + (popup ? "&popup=true" : ""));
        KnowledgeBaseList kbList = new KnowledgeBaseList();
        String siteId = kbListInfo.getSearchOptionValue("searchcodeSiteId");
        User user = this.getUser(context, this.getUserId(context));
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (siteId == null || "".equals(siteId)) {
                siteId = String.valueOf(user.getSiteId());
            } else {
                int siteIdInt = Integer.parseInt(siteId);
                if (user.getSiteId() != -1 && siteIdInt != user.getSiteId()) {
                    String string = "PermissionError";
                    return string;
                }
            }
            context.getRequest().setAttribute("siteId", (Object)siteId);
            kbList.setBuildResources(true);
            kbList.setPagedListInfo(kbListInfo);
            kbListInfo.setSearchCriteria(kbList, context);
            if (kbList.getCatCode() == 0 && kbList.getSubCat1() == 0 && kbList.getSubCat2() == 0 && kbList.getSubCat3() == 0) {
                kbList.setCategoryId(0);
            }
            kbList.buildList(db);
            context.getRequest().setAttribute("kbList", (Object)kbList);
            LookupList siteid = new LookupList(db, "lookup_site_id");
            siteid.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteid);
            TicketCategoryList categoryList = new TicketCategoryList();
            categoryList.setCatLevel(0);
            categoryList.setParentCode(0);
            categoryList.setSiteId(siteId);
            categoryList.setExclusiveToSite(true);
            categoryList.setHtmlJsEvent("onChange=\"javascript:updateSubList1();\"");
            categoryList.buildList(db);
            categoryList.getCatListSelect().addItem(0, "Undetermined");
            context.getRequest().setAttribute("CategoryList", (Object)categoryList);
            TicketCategoryList subList1 = new TicketCategoryList();
            subList1.setCatLevel(1);
            subList1.setParentCode(kbList.getCatCode());
            subList1.setSiteId(siteId);
            subList1.setExclusiveToSite(true);
            subList1.setHtmlJsEvent("onChange=\"javascript:updateSubList2();\"");
            subList1.buildList(db);
            subList1.getCatListSelect().addItem(0, "Undetermined");
            context.getRequest().setAttribute("SubList1", (Object)subList1);
            TicketCategoryList subList2 = new TicketCategoryList();
            subList2.setCatLevel(2);
            subList2.setParentCode(kbList.getSubCat1());
            subList2.setSiteId(siteId);
            subList2.setExclusiveToSite(true);
            subList2.getCatListSelect().setDefaultKey(kbList.getSubCat2());
            subList2.setHtmlJsEvent("onChange=\"javascript:updateSubList3();\"");
            subList2.buildList(db);
            subList2.getCatListSelect().addItem(0, "Undetermined");
            context.getRequest().setAttribute("SubList2", (Object)subList2);
            TicketCategoryList subList3 = new TicketCategoryList();
            subList3.setCatLevel(3);
            subList3.setParentCode(kbList.getSubCat2());
            subList3.setSiteId(siteId);
            subList3.setExclusiveToSite(true);
            subList3.getCatListSelect().setDefaultKey(kbList.getSubCat3());
            subList3.setHtmlJsEvent("onChange=\"javascript:updateSubList4();\"");
            subList3.buildList(db);
            subList3.getCatListSelect().addItem(0, "Undetermined");
            context.getRequest().setAttribute("SubList3", (Object)subList3);
            boolean canAddCategory = true;
            if (kbList.getCategoryId() > 0) {
                TicketCategory category = new TicketCategory(db, kbList.getCategoryId());
                canAddCategory = category.getEnabled();
            }
            context.getRequest().setAttribute("canAddCategory", (Object)String.valueOf(canAddCategory));
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return KnowledgeBaseManager.getReturn(context, "Search");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String executeCommandCategoryJSList(ActionContext context) {
        block11: {
            Connection db;
            block10: {
                User user;
                String subCat2;
                String subCat1;
                String catCode;
                String reset;
                String siteId;
                block9: {
                    db = null;
                    SystemStatus systemStatus = this.getSystemStatus(context);
                    siteId = context.getRequest().getParameter("siteId");
                    reset = context.getRequest().getParameter("reset");
                    catCode = context.getRequest().getParameter("catCode");
                    subCat1 = context.getRequest().getParameter("subCat1");
                    subCat2 = context.getRequest().getParameter("subCat2");
                    String subCat3 = context.getRequest().getParameter("subCat3");
                    user = this.getUser(context, this.getUserId(context));
                    if (KnowledgeBaseManager.isSiteAccessPermitted(context, siteId)) break block9;
                    String string = "PermissionError";
                    this.freeConnection(context, db);
                    return string;
                }
                try {
                    db = this.getConnection(context);
                    LookupList siteid = new LookupList(db, "lookup_site_id");
                    siteid.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
                    context.getRequest().setAttribute("SiteIdList", (Object)siteid);
                    if (siteId == null || "".equals(siteId.trim())) {
                        siteId = String.valueOf(user.getSiteId());
                    }
                    if (reset != null && "true".equals(reset.trim())) {
                        TicketCategoryList catList = new TicketCategoryList();
                        catList.setCatLevel(0);
                        catList.setSiteId(siteId);
                        catList.setExclusiveToSite(true);
                        catList.setParentCode(0);
                        catList.buildList(db);
                        context.getRequest().setAttribute("CategoryList", (Object)catList);
                        break block10;
                    }
                    if (catCode != null) {
                        TicketCategoryList subList1 = new TicketCategoryList();
                        subList1.setCatLevel(1);
                        subList1.setSiteId(siteId);
                        subList1.setParentCode(Integer.parseInt(catCode));
                        subList1.buildList(db);
                        context.getRequest().setAttribute("SubList1", (Object)subList1);
                        break block10;
                    }
                    if (subCat1 != null) {
                        TicketCategoryList subList2 = new TicketCategoryList();
                        subList2.setCatLevel(2);
                        subList2.setSiteId(siteId);
                        subList2.setParentCode(Integer.parseInt(subCat1));
                        subList2.buildList(db);
                        context.getRequest().setAttribute("SubList2", (Object)subList2);
                        break block10;
                    }
                    if (subCat2 == null) break block10;
                    TicketCategoryList subList3 = new TicketCategoryList();
                    subList3.setCatLevel(3);
                    subList3.setSiteId(siteId);
                    subList3.setParentCode(Integer.parseInt(subCat2));
                    subList3.buildList(db);
                    context.getRequest().setAttribute("SubList3", (Object)subList3);
                }
                catch (Exception errorMessage) {
                    this.freeConnection(context, db);
                    break block11;
                    catch (Throwable throwable) {
                        this.freeConnection(context, db);
                        throw throwable;
                    }
                }
            }
            this.freeConnection(context, db);
        }
        return "CategoryJSListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        if (!this.hasPermission(context, "tickets-knowledge-base-add")) {
            return "PermissionError";
        }
        String categoryId = context.getRequest().getParameter("categoryId");
        if (categoryId == null || "".equals(categoryId.trim())) {
            categoryId = (String)context.getRequest().getAttribute("categoryId");
        }
        String title = (String)context.getRequest().getAttribute("title");
        String description = (String)context.getRequest().getAttribute("description");
        KnowledgeBase kb = new KnowledgeBase();
        kb.setTitle(title);
        kb.setDescription(description);
        kb.setCategoryId(categoryId);
        Connection db = null;
        try {
            db = this.getConnection(context);
            TicketCategory category = new TicketCategory(db, Integer.parseInt(categoryId));
            context.getRequest().setAttribute("thisCategory", (Object)category);
            context.getRequest().setAttribute("kb", (Object)kb);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return KnowledgeBaseManager.getReturn(context, "Add");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "tickets-knowledge-base-view")) {
            return "PermissionError";
        }
        String kbId = context.getRequest().getParameter("kbId");
        if (kbId == null || "".equals(kbId)) {
            kbId = (String)context.getRequest().getAttribute("kbId");
        }
        String title = (String)context.getRequest().getAttribute("title");
        String description = (String)context.getRequest().getAttribute("description");
        String categoryId = (String)context.getRequest().getAttribute("categoryId");
        KnowledgeBase kb = new KnowledgeBase();
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (kb.getId() == -1) {
                kb = new KnowledgeBase();
                kb.setBuildResources(true);
                kb.queryRecord(db, Integer.parseInt(kbId));
            } else {
                kb.setTitle(title);
                kb.setDescription(description);
                kb.setCategoryId(categoryId);
            }
            if (kb.getItemId() != -1) {
                FileItem thisFile = new FileItem(db, kb.getItemId(), kb.getId(), 104051616);
                context.getRequest().setAttribute("fileItem", (Object)thisFile);
            }
            TicketCategory category = new TicketCategory(db, kb.getCategoryId());
            context.getRequest().setAttribute("thisCategory", (Object)category);
            context.getRequest().setAttribute("kb", (Object)kb);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return KnowledgeBaseManager.getReturn(context, "Modify");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String executeCommandSave(ActionContext context) {
        if (!this.hasPermission(context, "tickets-knowledge-base-view")) {
            return "PermissionError";
        }
        boolean isValid = false;
        boolean recordInserted = false;
        boolean fileInserted = false;
        int resultCount = -1;
        KnowledgeBase kb = new KnowledgeBase();
        FileItem thisItem = null;
        Connection db = null;
        try {
            String filePath = this.getPath(context, "knowledgebase");
            HttpMultiPartParser multiPart = new HttpMultiPartParser();
            multiPart.setUsePathParam(false);
            multiPart.setUseUniqueName(true);
            multiPart.setUseDateForFolder(true);
            multiPart.setExtensionId(this.getUserId(context));
            HashMap parts = multiPart.parseData(context.getRequest(), filePath);
            String kbId = (String)parts.get("id");
            kb.setId(kbId);
            db = this.getConnection(context);
            if (kb.getId() != -1) {
                kb.setBuildResources(true);
                kb.queryRecord(db, kb.getId());
            }
            String fileText = (String)parts.get("fileText");
            String title = (String)parts.get("title");
            kb.setTitle(title);
            String description = (String)parts.get("description");
            kb.setDescription(description);
            String categoryId = (String)parts.get("categoryId");
            kb.setCategoryId(categoryId);
            String itemId = (String)parts.get("fid");
            kb.setItemId(itemId);
            String versionId = (String)parts.get("versionId");
            kb.setModifiedBy(this.getUserId(context));
            kb.printKb();
            isValid = this.validateObject(context, db, (Object)kb);
            if (!(parts.get("itemId1") instanceof FileInfo) && fileText != null && !"".equals(fileText.trim())) {
                isValid = false;
            }
            if (isValid) {
                if (kb.getId() == -1) {
                    recordInserted = kb.insert(db);
                } else {
                    resultCount = kb.update(db);
                }
                if (parts.get("itemId1") instanceof FileInfo) {
                    FileInfo newFileInfo = (FileInfo)parts.get("itemId1");
                    thisItem = new FileItem();
                    thisItem.setLinkModuleId(104051616);
                    thisItem.setLinkItemId(kb.getId());
                    thisItem.setEnteredBy(this.getUserId(context));
                    thisItem.setModifiedBy(this.getUserId(context));
                    thisItem.setFolderId(-1);
                    thisItem.setId(kb.getItemId());
                    thisItem.setSubject(title);
                    thisItem.setClientFilename(newFileInfo.getClientFileName());
                    thisItem.setFilename(newFileInfo.getRealFilename());
                    thisItem.setVersion(Double.parseDouble(versionId));
                    thisItem.setSize(newFileInfo.getSize());
                    isValid = this.validateObject(context, db, thisItem);
                    if (isValid && (recordInserted || resultCount > -1)) {
                        if (thisItem.getId() != -1) {
                            recordInserted = thisItem.insertVersion(db);
                        } else {
                            fileInserted = thisItem.insert(db);
                        }
                        if (fileInserted) {
                            kb = new KnowledgeBase(db, kb.getId());
                            kb.setItemId(thisItem.getId());
                            resultCount = kb.update(db);
                            kb.printKb();
                        }
                    }
                }
            }
            HashMap<String, String> errors = new HashMap<String, String>();
            SystemStatus systemStatus = this.getSystemStatus(context);
            if (parts.get("itemId1") instanceof FileInfo) {
                if (!fileInserted) {
                    errors.put("actionError", systemStatus.getLabel("object.validation.incorrectFileName"));
                    this.processErrors(context, errors);
                }
            } else if (fileText != null && !"".equals(fileText.trim())) {
                errors.put("actionError", systemStatus.getLabel("object.validation.incorrectFileName"));
                this.processErrors(context, errors);
            }
            context.getRequest().setAttribute("kbId", (Object)String.valueOf(kb.getId()));
            if (!isValid || !recordInserted && resultCount == -1) {
                context.getRequest().setAttribute("kb", (Object)kb);
                if (kb.getId() == -1) {
                    context.getRequest().setAttribute("categoryId", (Object)String.valueOf(kb.getCategoryId()));
                    if (kb.getTitle() != null) {
                        context.getRequest().setAttribute("title", (Object)kb.getTitle());
                    }
                    if (kb.getDescription() != null) {
                        context.getRequest().setAttribute("description", (Object)kb.getDescription());
                    }
                    String string = this.executeCommandAdd(context);
                    this.freeConnection(context, db);
                    return string;
                }
                String string = this.executeCommandModify(context);
                this.freeConnection(context, db);
                return string;
            }
            this.freeConnection(context, db);
            return KnowledgeBaseManager.getReturn(context, "Save");
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "tickets-knowledge-base-view")) {
            return "PermissionError";
        }
        String kbId = context.getRequest().getParameter("kbId");
        if (kbId == null || "".equals(kbId)) {
            kbId = (String)context.getRequest().getAttribute("kbId");
        }
        KnowledgeBase kb = new KnowledgeBase();
        Connection db = null;
        try {
            db = this.getConnection(context);
            kb.setBuildResources(true);
            kb.queryRecord(db, Integer.parseInt(kbId));
            TicketCategory category = new TicketCategory(db, kb.getCategoryId());
            context.getRequest().setAttribute("thisCategory", (Object)category);
            context.getRequest().setAttribute("kb", (Object)kb);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return KnowledgeBaseManager.getReturn(context, "Details");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDownload(ActionContext context) {
        block25: {
            Object errorMessage = null;
            String itemId = context.getRequest().getParameter("fid");
            String version = context.getRequest().getParameter("ver");
            String kbId = context.getRequest().getParameter("kbId");
            String view = context.getRequest().getParameter("view");
            FileItem thisItem = null;
            Connection db = null;
            KnowledgeBase thisKb = null;
            try {
                db = this.getConnection(context);
                thisKb = new KnowledgeBase(db, Integer.parseInt(kbId));
                thisItem = new FileItem(db, Integer.parseInt(itemId), Integer.parseInt(kbId), 104051616);
                if (version != null) {
                    thisItem.buildVersionList(db);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            finally {
                this.freeConnection(context, db);
            }
            try {
                if (version == null) {
                    FileItem itemToDownload = thisItem;
                    itemToDownload.setEnteredBy(this.getUserId(context));
                    String filePath = this.getPath(context, "knowledgebase") + KnowledgeBaseManager.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                    FileDownload fileDownload = new FileDownload();
                    fileDownload.setFullPath(filePath);
                    fileDownload.setDisplayName(itemToDownload.getClientFilename());
                    if (fileDownload.fileExists()) {
                        if (view != null && "true".equals(view)) {
                            fileDownload.setFileTimestamp(thisItem.getModificationDate().getTime());
                            fileDownload.streamContent(context);
                        } else {
                            fileDownload.sendFile(context);
                        }
                    } else {
                        db = null;
                        System.err.println("KnowledgeBaseManager -> Trying to send a file that does not exist");
                        context.getRequest().setAttribute("actionError", (Object)"The requested download no longer exists on the system");
                        String string = this.executeCommandSearch(context);
                        return string;
                    }
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                    break block25;
                }
                FileItemVersion itemToDownload = thisItem.getVersion(Double.parseDouble(version));
                itemToDownload.setEnteredBy(this.getUserId(context));
                String filePath = this.getPath(context, "knowledgebase") + KnowledgeBaseManager.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                FileDownload fileDownload = new FileDownload();
                fileDownload.setFullPath(filePath);
                fileDownload.setDisplayName(itemToDownload.getClientFilename());
                if (fileDownload.fileExists()) {
                    if (view != null && "true".equals(view)) {
                        fileDownload.setFileTimestamp(itemToDownload.getModificationDate().getTime());
                        fileDownload.streamContent(context);
                    } else {
                        fileDownload.sendFile(context);
                    }
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                    break block25;
                }
                db = null;
                System.err.println("KnowledgeBaseManager -> Trying to send a file that does not exist");
                context.getRequest().setAttribute("actionError", (Object)"The requested download no longer exists on the system");
                String string = this.executeCommandSearch(context);
                return string;
            }
            catch (SocketException se) {
                if (System.getProperty("DEBUG") != null) {
                    se.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                context.getRequest().setAttribute("Error", (Object)e);
                String string = "SystemError";
                return string;
            }
            finally {
                if (db != null) {
                    this.freeConnection(context, db);
                }
            }
        }
        return "-none-";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) throws SQLException {
        if (!this.hasPermission(context, "tickets-knowledge-base-delete")) {
            return "PermissionError";
        }
        String isSourcePopup = context.getRequest().getParameter("isSourcePopup");
        String kbId = context.getRequest().getParameter("kbId");
        if (kbId == null || "".equals(kbId)) {
            kbId = (String)context.getRequest().getAttribute("kbId");
        }
        Connection db = null;
        KnowledgeBase kb = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            kb = new KnowledgeBase();
            kb.setBuildResources(true);
            kb.queryRecord(db, Integer.parseInt(kbId));
            DependencyList dependencies = kb.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            if (dependencies.canDelete()) {
                htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
                htmlDialog.setHeader(systemStatus.getLabel("knowledgebase.dependencies"));
                htmlDialog.addButton(systemStatus.getLabel("global.button.delete"), "javascript:window.location.href='KnowledgeBaseManager.do?command=Delete&kbId=" + kb.getId() + (isSourcePopup != null ? "&isSourcePopup=" + isSourcePopup : "") + "';");
                htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close();");
            } else {
                htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.unableHeader"));
                htmlDialog.addButton("OK", "javascript:parent.window.close();");
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        return "ConfirmDeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) throws SQLException {
        if (!this.hasPermission(context, "tickets-knowledge-base-delete")) {
            return "PermissionError";
        }
        String isSourcePopup = context.getRequest().getParameter("isSourcePopup");
        String kbId = context.getRequest().getParameter("kbId");
        if (kbId != null && !"".equals(kbId)) {
            context.getRequest().setAttribute("kbId", (Object)kbId);
        }
        KnowledgeBase kb = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            kb = new KnowledgeBase();
            kb.setBuildResources(true);
            kb.queryRecord(db, Integer.parseInt(kbId));
            kb.delete(db, KnowledgeBaseManager.getDbNamePath(context));
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("refreshUrl", (Object)("KnowledgeBaseManager.do?command=Search" + (isSourcePopup != null ? "&popup=" + isSourcePopup : "")));
        return "DeleteOK";
    }
}

