/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.troubletickets.base.TicketDefect;
import org.aspcfs.modules.troubletickets.base.TicketDefectList;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;

public final class TroubleTicketDefects
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        if (!this.hasPermission(context, "tickets-defects-view")) {
            return "DefaultError";
        }
        return this.executeCommandView(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        if (!this.hasPermission(context, "tickets-defects-view")) {
            return "PermissionError";
        }
        PagedListInfo defectListInfo = this.getPagedListInfo(context, "defectListInfo");
        defectListInfo.setLink("TroubleTicketDefects.do?command=View");
        TicketDefectList defects = new TicketDefectList();
        User user = this.getUser(context, this.getUserId(context));
        Connection db = null;
        try {
            db = this.getConnection(context);
            defects.setBuildTickets(true);
            defects.setPagedListInfo(defectListInfo);
            defectListInfo.setSearchCriteria(defects, context);
            defects.setSiteId(this.getUserSiteId(context));
            if (user.getSiteId() == -1) {
                defects.setIncludeAllSites(true);
            }
            defects.buildList(db);
            context.getRequest().setAttribute("defects", (Object)defects);
            this.buildFormElements(context, db);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        if (!this.hasPermission(context, "tickets-defects-add")) {
            return "PermissionError";
        }
        TicketDefect defect = (TicketDefect)((Object)context.getFormBean());
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (context.getRequest().getParameter("title") == null) {
                defect.setStartDate(new Timestamp(Calendar.getInstance().getTimeInMillis()));
                defect.setEnabled(true);
                if (this.getUserSiteId(context) == -1) {
                    defect.setSiteId(-2);
                } else {
                    defect.setSiteId(this.getUserSiteId(context));
                }
            }
            context.getRequest().setAttribute("defect", (Object)defect);
            this.buildFormElements(context, db);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "AddOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "tickets-defects-edit")) {
            return "PermissionError";
        }
        String defectId = context.getRequest().getParameter("defectId");
        if (defectId == null || "".equals(defectId)) {
            defectId = (String)context.getRequest().getAttribute("defectId");
        }
        TicketDefect defect = (TicketDefect)((Object)context.getFormBean());
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (defect.getId() == -1) {
                defect = new TicketDefect(db, Integer.parseInt(defectId));
            }
            if (!TroubleTicketDefects.isRecordAccessPermitted(context, (Object)defect)) {
                String string = "PermissionError";
                return string;
            }
            defect.printDefect();
            context.getRequest().setAttribute("defect", (Object)defect);
            this.buildFormElements(context, db);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ModifyOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        if (!this.hasPermission(context, "tickets-defects-add")) {
            return "PermissionError";
        }
        boolean isValid = false;
        boolean recordInserted = false;
        int resultCount = -1;
        TicketDefect defect = (TicketDefect)((Object)context.getFormBean());
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (!TroubleTicketDefects.isRecordAccessPermitted(context, (Object)defect)) {
                String string = "PermissionError";
                return string;
            }
            isValid = this.validateObject(context, db, (Object)defect);
            if (isValid) {
                if (defect.getId() > -1) {
                    resultCount = defect.update(db);
                } else {
                    recordInserted = defect.insert(db);
                }
            }
            context.getRequest().setAttribute("defectId", (Object)String.valueOf(defect.getId()));
            if (!isValid || !recordInserted && resultCount == -1) {
                context.getRequest().setAttribute("defect", (Object)defect);
                if (defect.getId() != -1) {
                    String string = this.executeCommandModify(context);
                    return string;
                }
                String string = this.executeCommandAdd(context);
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "SaveOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "tickets-defects-view")) {
            return "PermissionError";
        }
        String defectId = context.getRequest().getParameter("defectId");
        if (defectId == null || "".equals(defectId)) {
            defectId = (String)context.getRequest().getAttribute("defectId");
        }
        TicketDefect defect = new TicketDefect();
        Connection db = null;
        try {
            db = this.getConnection(context);
            defect.queryRecord(db, Integer.parseInt(defectId));
            if (defect.getSiteId() != -1 && !TroubleTicketDefects.isRecordAccessPermitted(context, (Object)defect)) {
                String string = "PermissionError";
                return string;
            }
            defect.buildTickets(db, this.getUserSiteId(context));
            context.getRequest().setAttribute("defect", (Object)defect);
            this.buildFormElements(context, db);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "DetailsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        if (!this.hasPermission(context, "tickets-defects-delete")) {
            return "PermissionError";
        }
        String defectId = context.getRequest().getParameter("defectId");
        if (defectId == null || "".equals(defectId)) {
            defectId = (String)context.getRequest().getAttribute("defectId");
        }
        TicketDefect defect = new TicketDefect();
        Connection db = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            defect.setBuildTickets(true);
            defect.queryRecord(db, Integer.parseInt(defectId));
            context.getRequest().setAttribute("defect", (Object)defect);
            if (!TroubleTicketDefects.isRecordAccessPermitted(context, (Object)defect)) {
                String string = "PermissionError";
                return string;
            }
            DependencyList dependencies = defect.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            if (dependencies.canDelete()) {
                htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
                htmlDialog.setHeader(systemStatus.getLabel("ticketDefect.dependencies"));
                htmlDialog.addButton(systemStatus.getLabel("global.button.delete"), "javascript:window.location.href='TroubleTicketDefects.do?command=Trash&defectId=" + defect.getId() + "';");
                htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
            } else {
                htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.unableHeader"));
                htmlDialog.addButton("OK", "javascript:parent.window.close()");
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        return "ConfirmDeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandTrash(ActionContext context) {
        if (!this.hasPermission(context, "tickets-defects-delete")) {
            return "PermissionError";
        }
        boolean recordUpdated = false;
        TicketDefect defect = null;
        Connection db = null;
        String passedId = context.getRequest().getParameter("defectId");
        try {
            db = this.getConnection(context);
            defect = new TicketDefect(db, Integer.parseInt(passedId));
            if (!TroubleTicketDefects.isRecordAccessPermitted(context, (Object)defect)) {
                String string = "PermissionError";
                return string;
            }
            recordUpdated = defect.updateStatus(db, true, this.getUserId(context));
            if (recordUpdated) {
                String returnType = context.getRequest().getParameter("return");
                context.getRequest().setAttribute("refreshUrl", (Object)"TroubleTicketDefects.do?command=View");
                String string = "DeleteOK";
                return string;
            }
            String returnType = this.executeCommandView(context);
            return returnType;
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "tickets-defects-delete")) {
            return "PermissionError";
        }
        String defectId = context.getRequest().getParameter("defectId");
        if (defectId == null || "".equals(defectId)) {
            defectId = (String)context.getRequest().getAttribute("defectId");
        }
        TicketDefect defect = new TicketDefect();
        Connection db = null;
        try {
            db = this.getConnection(context);
            defect.setBuildTickets(true);
            defect.queryRecord(db, Integer.parseInt(defectId));
            if (!TroubleTicketDefects.isRecordAccessPermitted(context, (Object)defect)) {
                String string = "PermissionError";
                return string;
            }
            defect.delete(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("refreshUrl", (Object)"TroubleTicketDefects.do?command=View");
        return "DeleteOK";
    }

    protected void buildFormElements(ActionContext context, Connection db) throws SQLException {
        SystemStatus systemStatus = this.getSystemStatus(context);
        LookupList siteList = new LookupList(db, "lookup_site_id");
        siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("SiteList", (Object)siteList);
    }
}

