/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.tasks.base.Task;
import org.aspcfs.modules.tasks.base.TaskList;
import org.aspcfs.modules.troubletickets.base.Ticket;
import org.aspcfs.modules.troubletickets.base.TicketTask;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;

public final class TroubleTicketTasks
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandList(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-tasks-view")) {
            return "PermissionError";
        }
        String ticketId = context.getRequest().getParameter("ticketId");
        Connection db = null;
        TaskList taskList = new TaskList();
        PagedListInfo ticTaskListInfo = this.getPagedListInfo(context, "TicketTaskListInfo");
        ticTaskListInfo.setItemsPerPage(0);
        try {
            db = this.getConnection(context);
            taskList.setTicketId(Integer.parseInt(ticketId));
            taskList.setPagedListInfo(ticTaskListInfo);
            taskList.buildList(db);
            context.getRequest().setAttribute("TaskList", (Object)taskList);
            Ticket thisTicket = new Ticket(db, Integer.parseInt(ticketId));
            if (!TroubleTicketTasks.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("TicketDetails", (Object)thisTicket);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "ViewTickets", "List Tasks");
        return TroubleTicketTasks.getReturn(context, "ListTasks");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-tasks-view")) {
            return "PermissionError";
        }
        Connection db = null;
        Task thisTask = null;
        String id = context.getRequest().getParameter("id");
        if (id == null || "".equals(id.trim())) {
            id = (String)context.getRequest().getAttribute("id");
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            thisTask = new Task(db, Integer.parseInt(id));
            if (!TroubleTicketTasks.isRecordAccessPermitted(context, db, thisTask.getTicket().getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("Task", (Object)thisTask);
            LookupList list = systemStatus.getLookupList(db, "lookup_ticket_task_category");
            context.getRequest().setAttribute("ticketTaskCategoryList", (Object)list);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Tickets", "View Tickets");
        return TroubleTicketTasks.getReturn(context, "TaskDetails");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        String action;
        String forward;
        String permission = "tickets-tickets-tasks-edit";
        Connection db = null;
        int resultCount = -1;
        boolean recordInserted = false;
        boolean isValid = false;
        String addAnother = context.getRequest().getParameter("addAnother");
        if (addAnother != null && !"".equals(addAnother.trim())) {
            context.getRequest().setAttribute("addAnother", (Object)addAnother);
        }
        if ((forward = context.getRequest().getParameter("forward")) != null && !"".equals(forward.trim())) {
            context.getRequest().setAttribute("forward", (Object)forward);
        }
        String ticketId = context.getRequest().getParameter("ticketId");
        TicketTask thisTask = (TicketTask)((Object)context.getFormBean());
        SystemStatus systemStatus = this.getSystemStatus(context);
        String string = action = thisTask.getId() > 0 ? "modify" : "insert";
        if ("insert".equals(action)) {
            permission = "tickets-tickets-tasks-add";
        }
        if (!this.hasPermission(context, permission)) {
            return "PermissionError";
        }
        thisTask.setModifiedBy(this.getUserId(context));
        try {
            db = this.getConnection(context);
            if ("insert".equals(action)) {
                Ticket thisTicket = new Ticket(db, Integer.parseInt(ticketId));
                if (!TroubleTicketTasks.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) {
                    String string2 = "PermissionError";
                    return string2;
                }
                if (forward != null || addAnother != null) {
                    LookupList list = systemStatus.getLookupList(db, "lookup_ticket_task_category");
                    list.addItem(-1, systemStatus.getLabel("calendar.none.4dashes", "-- None --"));
                    context.getRequest().setAttribute("ticketTaskCategoryList", (Object)list);
                }
                thisTask.setEnteredBy(this.getUserId(context));
                thisTask.setTicketId(Integer.parseInt(ticketId));
                isValid = this.validateObject(context, db, (Object)thisTask);
                if (isValid) {
                    recordInserted = thisTask.insert(db);
                }
                if (recordInserted) {
                    this.processInsertHook(context, (Object)thisTask);
                }
            } else {
                Task oldTask = new Task(db, thisTask.getId());
                if (!this.hasAuthority(context, oldTask.getOwner())) {
                    String string3 = "PermissionError";
                    return string3;
                }
                isValid = this.validateObject(context, db, (Object)thisTask);
                if (isValid) {
                    resultCount = thisTask.update(db);
                }
                if (resultCount == 1) {
                    this.processUpdateHook(context, (Object)oldTask, (Object)thisTask);
                }
            }
            if ((!isValid || !recordInserted && resultCount != 1) && thisTask.getContactId() > -1) {
                thisTask.checkEnabledLinkAccount(db);
                Contact contact = new Contact(db, thisTask.getContactId());
                thisTask.setContactName(contact.getNameFull());
                context.getRequest().setAttribute("Task", (Object)thisTask);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string4 = "SystemError";
            return string4;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted || resultCount == 1) {
            if ((resultCount == 1 || recordInserted) && forward != null && "details".equals(forward.trim())) {
                context.getRequest().setAttribute("id", (Object)String.valueOf(thisTask.getId()));
                context.getRequest().setAttribute("forward", (Object)forward);
                return this.executeCommandDetails(context);
            }
            if (recordInserted && addAnother != null && "true".equals(addAnother.trim())) {
                Task task = new Task();
                task.setTicketId(ticketId);
                context.getRequest().setAttribute("Task", (Object)task);
                return "AddTaskOK";
            }
            this.addModuleBean(context, "View Tickets", "Ticket Save OK");
            return "SaveOK";
        }
        if ("insert".equals(action)) {
            return this.executeCommandAdd(context);
        }
        return this.executeCommandModify(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-tasks-add")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            Ticket thisTicket = new Ticket(db, Integer.parseInt(context.getRequest().getParameter("ticketId")));
            if (!TroubleTicketTasks.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            TicketTask thisTicketTask = (TicketTask)((Object)context.getFormBean());
            if (thisTicketTask.getEnteredBy() == -1) {
                thisTicketTask = new TicketTask();
                thisTicketTask.setTicketId(thisTicket.getId());
            }
            TicketTask thisTask = thisTicketTask;
            context.getRequest().setAttribute("Task", (Object)thisTask);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_ticket_task_category");
            list.addItem(-1, systemStatus.getLabel("calendar.none.4dashes", "-- None --"));
            context.getRequest().setAttribute("ticketTaskCategoryList", (Object)list);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Tickets", "Add Ticket");
        return "AddTaskOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-tasks-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        Task thisTask = null;
        String forward = context.getRequest().getParameter("forward");
        if (forward != null && !"".equals(forward.trim())) {
            context.getRequest().setAttribute("forward", (Object)forward);
        }
        String id = context.getRequest().getParameter("id");
        this.addModuleBean(context, "View Tickets", "Add Ticket");
        SystemStatus systemStatus = this.getSystemStatus(context);
        String ticketId = context.getRequest().getParameter("ticketId");
        Ticket thisTicket = null;
        try {
            db = this.getConnection(context);
            thisTask = (Task)((Object)context.getFormBean());
            if (thisTask.getId() == -1) {
                thisTask = new Task(db, Integer.parseInt(id));
            }
            if (!TroubleTicketTasks.isRecordAccessPermitted(context, db, (thisTicket = ticketId != null && !"".equals(ticketId) ? new Ticket(db, Integer.parseInt(ticketId)) : new Ticket(db, thisTask.getTicketId())).getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            thisTask.checkEnabledOwnerAccount(db);
            if (thisTask.getContactId() > -1) {
                thisTask.checkEnabledLinkAccount(db);
                Contact contact = new Contact(db, thisTask.getContactId());
                thisTask.setContactName(contact.getNameFull());
            }
            LookupList list = systemStatus.getLookupList(db, "lookup_ticket_task_category");
            list.addItem(-1, systemStatus.getLabel("calendar.none.4dashes", "-- None --"));
            context.getRequest().setAttribute("ticketTaskCategoryList", (Object)list);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("Task", (Object)thisTask);
        if (!this.hasAuthority(context, thisTask.getOwner()) || !this.hasPermission(context, "tickets-tickets-tasks-edit")) {
            if (this.hasPermission(context, "tickets-tickets-tasks-view")) {
                return "TaskDetailsOK";
            }
            return "PermissionError";
        }
        return "AddTaskOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-tasks-delete")) {
            return "PermissionError";
        }
        Connection db = null;
        Task thisTask = null;
        String sourcePopup = context.getRequest().getParameter("sourcePopup");
        String id = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            thisTask = new Task(db, Integer.parseInt(id));
            thisTask.buildLinkDetails(db);
            if (!this.hasAuthority(context, thisTask.getOwner())) {
                String string = "PermissionError";
                return string;
            }
            thisTask.delete(db);
            this.deleteRecentItem(context, (Object)thisTask);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("Task", (Object)thisTask);
        if (sourcePopup != null && "true".equals(sourcePopup.trim())) {
            return "DeletePopupOK";
        }
        context.getRequest().setAttribute("refreshUrl", (Object)("TroubleTicketTasks.do?command=List&ticketId=" + thisTask.getLinkDetails().getLinkItemId()));
        return "DeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-tasks-delete")) {
            return "PermissionError";
        }
        Connection db = null;
        Task thisTask = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        String id = context.getRequest().getParameter("id");
        String sourcePopup = context.getRequest().getParameter("sourcePopup");
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            thisTask = new Task(db, Integer.parseInt(id));
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            if (!this.hasAuthority(context, thisTask.getOwner())) {
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.taskNotOwnerHeader"));
                htmlDialog.addButton(systemStatus.getLabel("button.ok"), "javascript:parent.window.close()");
            } else {
                DependencyList dependencies = thisTask.processDependencies(db);
                htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
                if (dependencies.size() == 0) {
                    htmlDialog.setShowAndConfirm(false);
                    htmlDialog.setDeleteUrl("javascript:window.location.href='TroubleTicketTasks.do?command=Delete&id=" + id + "&sourcePopup=" + sourcePopup + "'");
                } else {
                    htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.header"));
                    htmlDialog.addButton(systemStatus.getLabel("button.delete"), "javascript:window.location.href='TroubleTicketTasks.do?command=Delete&id=" + id + "&sourcePopup=" + sourcePopup + "'");
                    htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
                }
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        return "ConfirmDeleteOK";
    }
}

