/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemList;
import com.zeroio.webutils.FileDownload;
import java.io.File;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperRunManager;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.accounts.base.OrganizationList;
import org.aspcfs.modules.actionplans.base.ActionPlan;
import org.aspcfs.modules.actionplans.base.ActionPlanList;
import org.aspcfs.modules.actionplans.base.ActionPlanWorkList;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.CategoryEditor;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.UserGroup;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.communications.base.CampaignList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.modules.login.beans.UserBean;
import org.aspcfs.modules.products.base.CustomerProduct;
import org.aspcfs.modules.products.base.ProductCatalog;
import org.aspcfs.modules.quotes.base.QuoteList;
import org.aspcfs.modules.troubletickets.base.Ticket;
import org.aspcfs.modules.troubletickets.base.TicketCategory;
import org.aspcfs.modules.troubletickets.base.TicketCategoryAssignment;
import org.aspcfs.modules.troubletickets.base.TicketCategoryList;
import org.aspcfs.modules.troubletickets.base.TicketDefect;
import org.aspcfs.modules.troubletickets.base.TicketDefectList;
import org.aspcfs.modules.troubletickets.base.TicketList;
import org.aspcfs.modules.troubletickets.base.TicketReport;
import org.aspcfs.utils.JasperReportUtils;
import org.aspcfs.utils.UserUtils;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;
import org.aspcfs.utils.web.RequestUtils;

public final class TroubleTickets
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-view")) {
            return "DefaultError";
        }
        return this.executeCommandHome(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-add")) {
            return "PermissionError";
        }
        Connection db = null;
        Ticket newTic = null;
        try {
            db = this.getConnection(context);
            if (context.getRequest().getParameter("refresh") != null || context.getRequest().getParameter("contact") != null && context.getRequest().getParameter("contact").equals("on")) {
                newTic = (Ticket)((Object)context.getFormBean());
                newTic.getHistory().setTicketId(newTic.getId());
                newTic.getHistory().buildList(db);
            } else {
                newTic = new Ticket();
            }
            this.buildFormElements(context, db, newTic);
            String currentDate = TroubleTickets.getCurrentDateAsString(context);
            context.getRequest().setAttribute("currentDate", (Object)currentDate);
            context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            context.getRequest().setAttribute("ThisContact", (Object)newTic.getThisContact());
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "AddTicket", "Ticket Add");
        if (context.getRequest().getParameter("actionSource") != null) {
            context.getRequest().setAttribute("actionSource", (Object)context.getRequest().getParameter("actionSource"));
            return "AddTicketOK";
        }
        context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
        return "AddOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandGenerateForm(ActionContext context) {
        if (!this.hasPermission(context, "tickets-reports-add")) {
            return "PermissionError";
        }
        User user = this.getUser(context, this.getUserId(context));
        int siteId = user.getSiteId();
        PagedListInfo exportListInfo = this.getPagedListInfo(context, "TicExportListInfo");
        Connection db = null;
        try {
            db = this.getConnection(context);
            LookupList siteIdList = new LookupList(db, "lookup_site_id");
            siteIdList.setJsEvent("id=\"searchcodeSiteId\" onChange=\"updateCategoryList();\"");
            siteIdList.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteIdList);
            String siteIdString = exportListInfo.getSearchOptionValue("searchcodeSiteId");
            if (user.getSiteId() == -1 && siteIdString != null && !"".equals(siteIdString.trim())) {
                siteId = Integer.parseInt(siteIdString);
            }
            TicketCategoryList categoryList = new TicketCategoryList();
            categoryList.setCatLevel(0);
            categoryList.setParentCode(0);
            categoryList.setSiteId(siteId);
            categoryList.setExclusiveToSite(true);
            categoryList.setHtmlJsEvent("onChange=\"javascript:updateSubList1();\"");
            categoryList.buildList(db);
            categoryList.getCatListSelect().addItem(0, "Undetermined");
            context.getRequest().setAttribute("CategoryList", (Object)categoryList);
            String catCode = exportListInfo.getSearchOptionValue("searchcodeCatCode");
            TicketCategoryList subList1 = new TicketCategoryList();
            subList1.setCatLevel(1);
            subList1.setHtmlJsEvent("onChange=\"javascript:updateSubList2();\"");
            subList1.setSiteId(siteId);
            subList1.setExclusiveToSite(true);
            if (catCode != null && !"".equals(catCode.trim())) {
                subList1.setParentCode(catCode);
                subList1.buildList(db);
            }
            subList1.getCatListSelect().addItem(0, "Undetermined");
            context.getRequest().setAttribute("SubList1", (Object)subList1);
            String subList1String = exportListInfo.getSearchOptionValue("searchcodeSubList1");
            TicketCategoryList subList2 = new TicketCategoryList();
            subList2.setCatLevel(2);
            subList2.setHtmlJsEvent("onChange=\"javascript:updateSubList3();\"");
            subList2.setSiteId(siteId);
            subList2.setExclusiveToSite(true);
            if (subList1String != null && !"".equals(subList1String.trim())) {
                subList2.setParentCode(subList1String);
                subList2.getCatListSelect().setDefaultKey(subList1String);
                subList2.buildList(db);
            }
            subList2.getCatListSelect().addItem(0, "Undetermined");
            context.getRequest().setAttribute("SubList2", (Object)subList2);
            String subList2String = exportListInfo.getSearchOptionValue("searchcodeSubList2");
            TicketCategoryList subList3 = new TicketCategoryList();
            subList3.setCatLevel(3);
            subList3.setHtmlJsEvent("onChange=\"javascript:updateSubList4();\"");
            subList3.setSiteId(siteId);
            subList3.setExclusiveToSite(true);
            if (subList2String != null && !"".equals(subList2String.trim())) {
                subList3.setParentCode(subList2String);
                subList3.getCatListSelect().setDefaultKey(subList2String);
                subList3.buildList(db);
            }
            subList3.getCatListSelect().addItem(0, "Undetermined");
            context.getRequest().setAttribute("SubList3", (Object)subList3);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Reports", "Generate new");
        return "GenerateFormOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandExportReport(ActionContext context) {
        block20: {
            if (!this.hasPermission(context, "tickets-reports-add")) {
                return "PermissionError";
            }
            boolean isValid = false;
            Connection db = null;
            String subject = context.getRequest().getParameter("subject");
            context.getRequest().setAttribute("subject", (Object)subject);
            String ownerCriteria = context.getRequest().getParameter("criteria1");
            PagedListInfo exportListInfo = this.getPagedListInfo(context, "TicExportListInfo");
            exportListInfo.setIsValid(true);
            User user = this.getUser(context, this.getUserId(context));
            int siteId = user.getSiteId();
            if (!TroubleTickets.isSiteAccessPermitted(context, String.valueOf(siteId))) {
                return "PermissionError";
            }
            UserBean thisUser = (UserBean)((Object)context.getSession().getAttribute("User"));
            String filePath = this.getPath(context, "ticket-reports");
            SimpleDateFormat formatter1 = new SimpleDateFormat("yyyy");
            String datePathToUse1 = formatter1.format(new Date());
            SimpleDateFormat formatter2 = new SimpleDateFormat("MMdd");
            String datePathToUse2 = formatter2.format(new Date());
            filePath = filePath + datePathToUse1 + fs + datePathToUse2 + fs;
            TicketReport ticketReport = new TicketReport();
            ticketReport.setCriteria(context.getRequest().getParameterValues("selectedList"));
            ticketReport.setFilePath(filePath);
            ticketReport.setSubject(subject);
            exportListInfo.setLink("TroubleTickets.do?command=ExportReport");
            exportListInfo.setColumnToSortBy(context.getRequest().getParameter("sort"));
            exportListInfo.setItemsPerPage(0);
            ticketReport.setPagedListInfo(exportListInfo);
            exportListInfo.setSearchCriteria(ticketReport, context);
            ticketReport.setExclusiveToSite(true);
            ticketReport.setIncludeAllSites(false);
            if (ownerCriteria.equals("assignedToMe")) {
                ticketReport.setAssignedTo(this.getUserId(context));
                ticketReport.setIncludeAllSites(true);
            } else if (ownerCriteria.equals("unassigned")) {
                ticketReport.setOnlyUnassigned(true);
                ticketReport.setSiteId(siteId);
            } else if (ownerCriteria.equals("createdByMe")) {
                ticketReport.setTicketEnteredBy(this.getUserId(context));
                ticketReport.setSiteId(siteId);
            } else if (ownerCriteria.equals("allTickets")) {
                ticketReport.setSiteId(siteId);
            }
            if (siteId == -1) {
                ticketReport.setSiteId(context.getRequest().getParameter("searchcodeSiteId"));
            }
            try {
                db = this.getConnection(context);
                isValid = exportListInfo.getIsValid();
                if (isValid) {
                    if (ticketReport.getSubCat3() == 0) {
                        ticketReport.setSubCat3(-1);
                    }
                    if (ticketReport.getSubCat2() == 0) {
                        ticketReport.setSubCat2(-1);
                    }
                    if (ticketReport.getSubCat1() == 0) {
                        ticketReport.setSubCat1(-1);
                    }
                    if (ticketReport.getCatCode() == 0) {
                        ticketReport.setCatCode(-1);
                    }
                    ticketReport.buildReportFull(db, context);
                    ticketReport.setEnteredBy(this.getUserId(context));
                    ticketReport.setModifiedBy(this.getUserId(context));
                    ticketReport.saveAndInsert(db);
                    break block20;
                }
                this.processErrors(context, ticketReport.getErrors());
                String string = this.executeCommandGenerateForm(context);
                return string;
            }
            catch (Exception e) {
                context.getRequest().setAttribute("Error", (Object)e);
                String string = "SystemError";
                return string;
            }
            finally {
                this.freeConnection(context, db);
            }
        }
        return this.executeCommandReports(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandShowReportHtml(ActionContext context) {
        if (!this.hasPermission(context, "tickets-reports-view")) {
            return "PermissionError";
        }
        String itemId = context.getRequest().getParameter("fid");
        Connection db = null;
        try {
            db = this.getConnection(context);
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId));
            String filePath = this.getPath(context, "ticket-reports") + TroubleTickets.getDatePath(thisItem.getEntered()) + thisItem.getFilename() + ".html";
            String textToShow = TroubleTickets.includeFile(filePath);
            context.getRequest().setAttribute("ReportText", (Object)textToShow);
        }
        catch (Exception e) {
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ReportHtmlOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandReports(ActionContext context) {
        if (!this.hasPermission(context, "tickets-reports-view")) {
            return "PermissionError";
        }
        Connection db = null;
        FileItemList files = new FileItemList();
        files.setLinkModuleId(13);
        files.setLinkItemId(-1);
        PagedListInfo rptListInfo = this.getPagedListInfo(context, "TicketRptListInfo");
        rptListInfo.setLink("TroubleTickets.do?command=Reports");
        try {
            db = this.getConnection(context);
            files.setPagedListInfo(rptListInfo);
            if ("all".equals(rptListInfo.getListView())) {
                files.setOwnerIdRange(this.getUserRange(context));
            } else {
                files.setOwner(this.getUserId(context));
            }
            files.buildList(db);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Reports", "TicketReports");
        context.getRequest().setAttribute("FileList", (Object)files);
        return "ReportsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteReport(ActionContext context) {
        if (!this.hasPermission(context, "tickets-reports-delete")) {
            return "PermissionError";
        }
        boolean recordDeleted = false;
        String itemId = context.getRequest().getParameter("fid");
        Connection db = null;
        try {
            db = this.getConnection(context);
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId));
            if (thisItem.getEnteredBy() == this.getUserId(context)) {
                String filePath2;
                File fileToDelete2;
                recordDeleted = thisItem.delete(db, this.getPath(context, "ticket-reports"));
                String filePath1 = this.getPath(context, "ticket-reports") + TroubleTickets.getDatePath(thisItem.getEntered()) + thisItem.getFilename() + ".csv";
                File fileToDelete1 = new File(filePath1);
                if (!fileToDelete1.delete()) {
                    System.err.println("FileItem-> Tried to delete file: " + filePath1);
                }
                if (!(fileToDelete2 = new File(filePath2 = this.getPath(context, "ticket-reports") + TroubleTickets.getDatePath(thisItem.getEntered()) + thisItem.getFilename() + ".html")).delete()) {
                    System.err.println("FileItem-> Tried to delete file: " + filePath2);
                }
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Reports", "Reports delete");
        if (recordDeleted) {
            return "DeleteReportOK";
        }
        return "DeleteReportERROR";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDownloadCSVReport(ActionContext context) {
        if (!this.hasPermission(context, "tickets-reports-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        String itemId = context.getRequest().getParameter("fid");
        FileItem thisItem = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisItem = new FileItem(db, Integer.parseInt(itemId), -1, 13);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        try {
            FileItem itemToDownload = null;
            itemToDownload = thisItem;
            String filePath = this.getPath(context, "ticket-reports") + TroubleTickets.getDatePath(itemToDownload.getEntered()) + itemToDownload.getFilename() + ".csv";
            FileDownload fileDownload = new FileDownload();
            fileDownload.setFullPath(filePath);
            fileDownload.setDisplayName(itemToDownload.getClientFilename());
            if (fileDownload.fileExists()) {
                fileDownload.sendFile(context);
                db = this.getConnection(context);
                itemToDownload.updateCounter(db);
            } else {
                System.err.println("Accounts-> Trying to send a file that does not exist");
            }
        }
        catch (SocketException se) {
        }
        catch (Exception e) {
            errorMessage = e;
            System.out.println(e.toString());
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "-none-";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        Ticket newTic = null;
        String ticketId = context.getRequest().getParameter("id");
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            User user = this.getUser(context, this.getUserId(context));
            if (context.getRequest().getParameter("companyName") == null) {
                newTic = new Ticket();
                newTic.setBuildOrgHierarchy(true);
                newTic.queryRecord(db, Integer.parseInt(ticketId));
            } else {
                newTic = (Ticket)((Object)context.getFormBean());
                if (newTic.getOrgId() != -1) {
                    newTic.setCompanyName(OrganizationList.buildParentNameHierarchy(db, newTic.getOrgId(), true, new HashMap()));
                }
                newTic.buildRelatedInformation(db);
            }
            if (!TroubleTickets.isRecordAccessPermitted(context, db, newTic.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            String fromDefectDetails = context.getRequest().getParameter("defectCheck");
            if (fromDefectDetails == null || "".equals(fromDefectDetails.trim())) {
                fromDefectDetails = (String)context.getRequest().getAttribute("defectCheck");
            }
            if (fromDefectDetails != null && !"".equals(fromDefectDetails.trim())) {
                context.getRequest().setAttribute("defectCheck", (Object)fromDefectDetails);
            }
            LookupList departmentList = new LookupList(db, "lookup_department");
            departmentList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
            departmentList.setJsEvent("onChange=\"javascript:updateUserList();javascript:resetAssignedDate();\"");
            context.getRequest().setAttribute("DepartmentList", (Object)departmentList);
            LookupList resolvedByDeptList = new LookupList(db, "lookup_department");
            resolvedByDeptList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
            resolvedByDeptList.setJsEvent("onChange=\"javascript:updateResolvedByUserList();\"");
            context.getRequest().setAttribute("resolvedByDeptList", (Object)resolvedByDeptList);
            LookupList severityList = new LookupList(db, "ticket_severity");
            context.getRequest().setAttribute("SeverityList", (Object)severityList);
            LookupList ticketStateList = new LookupList(db, "lookup_ticket_state");
            ticketStateList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("ticketStateList", (Object)ticketStateList);
            LookupList priorityList = new LookupList(db, "ticket_priority");
            context.getRequest().setAttribute("PriorityList", (Object)priorityList);
            LookupList sourceList = new LookupList(db, "lookup_ticketsource");
            sourceList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SourceList", (Object)sourceList);
            LookupList causeList = new LookupList(db, "lookup_ticket_cause");
            causeList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("causeList", (Object)causeList);
            LookupList resolutionList = new LookupList(db, "lookup_ticket_resolution");
            resolutionList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("resolutionList", (Object)resolutionList);
            TicketDefectList list = new TicketDefectList();
            list.setSiteId(newTic.getOrgSiteId());
            list.buildList(db);
            HtmlSelect defectSelect = list.getHtmlSelectObj(newTic.getDefectId());
            defectSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes", "None"), 0);
            context.getRequest().setAttribute("defectSelect", (Object)defectSelect);
            LookupList escalationList = new LookupList(db, "lookup_ticket_escalation");
            escalationList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("EscalationList", (Object)escalationList);
            if (TroubleTickets.getDbName(context).equals("cdb_voice") || TroubleTickets.getDbName(context).equals("cdb_ds21")) {
                CampaignList campaignList = new CampaignList();
                campaignList.setEnabled(1);
                campaignList.setCompleteOnly(true);
                campaignList.buildList(db);
                context.getRequest().setAttribute("CampaignList", (Object)campaignList);
            }
            Organization orgDetails = new Organization(db, newTic.getOrgId());
            context.getRequest().setAttribute("OrgDetails", (Object)orgDetails);
            TicketCategoryList categoryList = new TicketCategoryList();
            categoryList.setCatLevel(0);
            categoryList.setParentCode(0);
            categoryList.setSiteId(orgDetails.getSiteId());
            categoryList.setExclusiveToSite(true);
            categoryList.setHtmlJsEvent("onChange=\"javascript:updateSubList1();\"");
            categoryList.buildList(db);
            categoryList.getCatListSelect().addItem(0, "Undetermined");
            context.getRequest().setAttribute("CategoryList", (Object)categoryList);
            UserList userList = new UserList();
            userList.setEmptyHtmlSelectRecord(systemStatus.getLabel("calendar.none.4dashes"));
            userList.setHidden(0);
            userList.setBuildContact(true);
            userList.setBuildContactDetails(false);
            userList.setDepartment(newTic.getDepartmentCode() != -1 ? newTic.getDepartmentCode() : 0);
            userList.setExcludeDisabledIfUnselected(true);
            userList.setExcludeExpiredIfUnselected(true);
            userList.setRoleType(0);
            userList.setHidden(0);
            userList.setSiteId(newTic.getOrgSiteId());
            userList.setIncludeUsersWithAccessToAllSites(true);
            userList.buildList(db);
            context.getRequest().setAttribute("UserList", (Object)userList);
            UserList resolvedUserList = new UserList();
            resolvedUserList.setHidden(0);
            resolvedUserList.setEmptyHtmlSelectRecord(systemStatus.getLabel("calendar.none.4dashes"));
            resolvedUserList.setBuildContact(true);
            resolvedUserList.setBuildContactDetails(false);
            resolvedUserList.setExcludeDisabledIfUnselected(true);
            resolvedUserList.setExcludeExpiredIfUnselected(true);
            resolvedUserList.setRoleType(0);
            resolvedUserList.setDepartment(newTic.getResolvedByDeptCode() != -1 ? newTic.getResolvedByDeptCode() : 0);
            resolvedUserList.setSiteId(newTic.getOrgSiteId());
            resolvedUserList.setIncludeUsersWithAccessToAllSites(true);
            resolvedUserList.buildList(db);
            context.getRequest().setAttribute("resolvedUserList", (Object)resolvedUserList);
            TicketCategoryList subList1 = new TicketCategoryList();
            subList1.setCatLevel(1);
            subList1.setParentCode(newTic.getCatCode());
            subList1.setSiteId(orgDetails.getSiteId());
            subList1.setExclusiveToSite(true);
            subList1.setHtmlJsEvent("onChange=\"javascript:updateSubList2();\"");
            subList1.buildList(db);
            subList1.getCatListSelect().addItem(0, "Undetermined");
            context.getRequest().setAttribute("SubList1", (Object)subList1);
            ContactList contactList = new ContactList();
            contactList.setEmptyHtmlSelectRecord(systemStatus.getLabel("calendar.none.4dashes"));
            contactList.setBuildDetails(false);
            contactList.setBuildTypes(false);
            contactList.setOrgId(newTic.getOrgId());
            contactList.setDefaultContactId(newTic.getContactId());
            contactList.buildList(db);
            context.getRequest().setAttribute("ContactList", (Object)contactList);
            TicketCategoryList subList2 = new TicketCategoryList();
            subList2.setCatLevel(2);
            if (context.getRequest().getParameter("refresh") != null && Integer.parseInt(context.getRequest().getParameter("refresh")) == 1) {
                subList2.setParentCode(0);
                newTic.setSubCat1(0);
                newTic.setSubCat2(0);
                newTic.setSubCat3(0);
            } else if (context.getRequest().getParameter("refresh") != null && Integer.parseInt(context.getRequest().getParameter("refresh")) == -1) {
                subList2.setParentCode(newTic.getSubCat1());
                subList2.getCatListSelect().setDefaultKey(newTic.getSubCat2());
            } else {
                subList2.setParentCode(newTic.getSubCat1());
            }
            subList2.setHtmlJsEvent("onChange=\"javascript:updateSubList3();\"");
            subList2.setSiteId(orgDetails.getSiteId());
            subList2.setExclusiveToSite(true);
            subList2.buildList(db);
            subList2.getCatListSelect().addItem(0, "Undetermined");
            context.getRequest().setAttribute("SubList2", (Object)subList2);
            TicketCategoryList subList3 = new TicketCategoryList();
            subList3.setCatLevel(3);
            if (context.getRequest().getParameter("refresh") != null && (Integer.parseInt(context.getRequest().getParameter("refresh")) == 1 || Integer.parseInt(context.getRequest().getParameter("refresh")) == 2)) {
                subList3.setParentCode(0);
                newTic.setSubCat2(0);
                newTic.setSubCat3(0);
            } else if (context.getRequest().getParameter("refresh") != null && Integer.parseInt(context.getRequest().getParameter("refresh")) == -1) {
                subList3.setParentCode(newTic.getSubCat2());
                subList3.getCatListSelect().setDefaultKey(newTic.getSubCat3());
            } else {
                subList3.setParentCode(newTic.getSubCat2());
            }
            subList3.setHtmlJsEvent("onChange=\"javascript:updateSubList4();\"");
            subList3.setSiteId(orgDetails.getSiteId());
            subList3.setExclusiveToSite(true);
            subList3.buildList(db);
            subList3.getCatListSelect().addItem(0, "Undetermined");
            context.getRequest().setAttribute("SubList3", (Object)subList3);
            if (context.getRequest().getParameter("refresh") != null && (Integer.parseInt(context.getRequest().getParameter("refresh")) == 1 || Integer.parseInt(context.getRequest().getParameter("refresh")) == 3)) {
                newTic.setSubCat3(0);
            }
            ActionPlanList actionPlans = new ActionPlanList();
            actionPlans.setLinkObjectId(ActionPlan.getMapIdGivenConstantId(db, 912051329));
            if (newTic.getCatCode() > 0) {
                actionPlans.setLinkCatCode(newTic.getCatCode());
            }
            if (newTic.getSubCat1() > 0) {
                actionPlans.setLinkSubCat1(newTic.getSubCat1());
            }
            if (newTic.getSubCat2() > 0) {
                actionPlans.setLinkSubCat2(newTic.getSubCat2());
            }
            if (newTic.getSubCat3() > 0) {
                actionPlans.setLinkSubCat3(newTic.getSubCat3());
            }
            CategoryEditor thisEditor = systemStatus.getCategoryEditor(db, 202041401);
            actionPlans.setNameTable(thisEditor.getTableName());
            actionPlans.setJsEvent("id=\"actionPlanId\"");
            actionPlans.setEnabled(1);
            actionPlans.setIncludeOnlyApproved(1);
            if (actionPlans.getLinkCatCode() <= 0 && actionPlans.getLinkSubCat1() <= 0 && actionPlans.getLinkSubCat2() <= 0 && actionPlans.getLinkSubCat3() <= 0) {
                actionPlans.setDisplayNone(true);
            }
            actionPlans.setSiteId(orgDetails.getSiteId());
            if (user.getSiteId() == -1) {
                actionPlans.setIncludeAllSites(true);
            }
            actionPlans.buildList(db);
            ActionPlanWorkList workList = new ActionPlanWorkList();
            workList.setSiteId(newTic.getSiteId());
            if (user.getSiteId() == -1) {
                workList.setIncludeAllSites(true);
            }
            workList.setLinkModuleId(ActionPlan.getMapIdGivenConstantId(db, 912051329));
            workList.setLinkItemId(newTic.getId());
            workList.buildList(db);
            if (workList.size() > 0) {
                context.getRequest().setAttribute("insertActionPlan", (Object)String.valueOf(true));
            }
            actionPlans.addAtleastOne(db, workList);
            context.getRequest().setAttribute("actionPlans", (Object)actionPlans);
            context.getRequest().setAttribute("TicketDetails", (Object)newTic);
            this.addRecentItem(context, (Object)newTic);
            String currentDate = TroubleTickets.getCurrentDateAsString(context);
            context.getRequest().setAttribute("currentDate", (Object)currentDate);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("TicketDetails", (Object)newTic);
        this.addModuleBean(context, "ViewTickets", "View Tickets");
        return TroubleTickets.getReturn(context, "Modify");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-view")) {
            return "PermissionError";
        }
        Connection db = null;
        Ticket newTic = null;
        String ticketId = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            String fromDefectDetails = context.getRequest().getParameter("defectCheck");
            if (fromDefectDetails == null || "".equals(fromDefectDetails.trim())) {
                fromDefectDetails = (String)context.getRequest().getAttribute("defectCheck");
            }
            ticketId = context.getRequest().getParameter("id");
            this.deletePagedListInfo(context, "TicketDocumentListInfo");
            this.deletePagedListInfo(context, "SunListInfo");
            this.deletePagedListInfo(context, "TMListInfo");
            this.deletePagedListInfo(context, "CSSListInfo");
            this.deletePagedListInfo(context, "TicketsFolderInfo");
            this.deletePagedListInfo(context, "TicketTaskListInfo");
            this.deletePagedListInfo(context, "ticketPlanWorkListInfo");
            db = this.getConnection(context);
            newTic = new Ticket();
            newTic.setBuildOrgHierarchy(true);
            newTic.queryRecord(db, Integer.parseInt(ticketId));
            if (!TroubleTickets.isRecordAccessPermitted(context, db, newTic.getOrgId())) {
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            Organization orgDetails = new Organization(db, newTic.getOrgId());
            if (newTic.getProductId() != -1) {
                ProductCatalog product = new ProductCatalog(db, newTic.getProductId());
                context.getRequest().setAttribute("product", (Object)product);
                QuoteList quoteList = new QuoteList();
                quoteList.setTicketId(newTic.getId());
                quoteList.buildList(db);
                context.getRequest().setAttribute("quoteList", (Object)quoteList);
            }
            if (newTic.getCustomerProductId() != -1) {
                CustomerProduct customerProduct = new CustomerProduct(db, newTic.getCustomerProductId());
                customerProduct.buildFileList(db);
                context.getRequest().setAttribute("customerProduct", (Object)customerProduct);
            }
            if (newTic.getDefectId() != -1) {
                TicketDefect defect = new TicketDefect(db, newTic.getDefectId());
                context.getRequest().setAttribute("defect", (Object)defect);
                if (fromDefectDetails != null && !"".equals(fromDefectDetails) && !fromDefectDetails.equals(String.valueOf(defect.getId()))) {
                    fromDefectDetails = String.valueOf(defect.getId());
                }
            }
            if (newTic.getAssignedTo() > -1) {
                newTic.checkEnabledOwnerAccount(db);
            }
            LookupList causeList = new LookupList(db, "lookup_ticket_cause");
            causeList.addItem(-1, "");
            context.getRequest().setAttribute("causeList", (Object)causeList);
            LookupList ticketStateList = new LookupList(db, "lookup_ticket_state");
            ticketStateList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("ticketStateList", (Object)ticketStateList);
            LookupList resolutionList = new LookupList(db, "lookup_ticket_resolution");
            resolutionList.addItem(-1, "");
            context.getRequest().setAttribute("resolutionList", (Object)resolutionList);
            if (fromDefectDetails != null && !"".equals(fromDefectDetails.trim())) {
                context.getRequest().setAttribute("defectCheck", (Object)fromDefectDetails);
            }
            TicketCategoryList ticketCategoryList = new TicketCategoryList();
            ticketCategoryList.setSiteId(orgDetails.getSiteId());
            ticketCategoryList.setIncludeDisabled(true);
            ticketCategoryList.setExclusiveToSite(true);
            ticketCategoryList.buildList(db);
            context.getRequest().setAttribute("ticketCategoryList", (Object)ticketCategoryList);
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("TicketDetails", (Object)newTic);
        this.addRecentItem(context, (Object)newTic);
        this.addModuleBean(context, "ViewTickets", "View Tickets");
        return "DetailsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewHistory(ActionContext context) {
        Ticket thisTic;
        Connection db;
        block7: {
            if (!this.hasPermission(context, "tickets-tickets-view")) {
                return "PermissionError";
            }
            db = null;
            thisTic = null;
            String ticketId = null;
            ticketId = context.getRequest().getParameter("id");
            db = this.getConnection(context);
            thisTic = new Ticket();
            thisTic.setBuildHistory(true);
            SystemStatus systemStatus = this.getSystemStatus(context);
            thisTic.setSystemStatus(systemStatus);
            thisTic.queryRecord(db, Integer.parseInt(ticketId));
            if (TroubleTickets.isRecordAccessPermitted(context, db, thisTic.getOrgId())) break block7;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            if (thisTic.getAssignedTo() > -1) {
                thisTic.checkEnabledOwnerAccount(db);
            }
        }
        catch (Exception errorMessage) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)errorMessage);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "View Tickets", "Ticket Details");
        context.getRequest().setAttribute("TicketDetails", (Object)thisTic);
        this.addModuleBean(context, "ViewTickets", "View Tickets");
        this.addRecentItem(context, (Object)thisTic);
        return "ViewHistoryOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandHome(ActionContext context) {
        int MINIMIZED_ITEMS_PER_PAGE = 5;
        if (!this.hasPermission(context, "tickets-tickets-view")) {
            return "PermissionError";
        }
        context.getSession().removeAttribute("searchTickets");
        Connection db = null;
        TicketList assignedToMeList = new TicketList();
        TicketList openList = new TicketList();
        TicketList createdByMeList = new TicketList();
        TicketList allTicketsList = new TicketList();
        TicketList userGroupTicketList = new TicketList();
        User user = this.getUser(context, this.getUserId(context));
        String sectionId = null;
        if (context.getRequest().getParameter("pagedListSectionId") != null) {
            sectionId = context.getRequest().getParameter("pagedListSectionId");
        }
        if (context.getRequest().getParameter("resetList") != null && context.getRequest().getParameter("resetList").equals("true")) {
            context.getSession().removeAttribute("AssignedToMeInfo");
            context.getSession().removeAttribute("OpenInfo");
            context.getSession().removeAttribute("CreatedByMeInfo");
            context.getSession().removeAttribute("AllTicketsInfo");
            context.getSession().removeAttribute("UserGroupTicketInfo");
        }
        UserBean thisUser = (UserBean)((Object)context.getSession().getAttribute("User"));
        PagedListInfo assignedToMeInfo = this.getPagedListInfo(context, "AssignedToMeInfo", "t.entered", "desc");
        assignedToMeInfo.setLink("TroubleTickets.do?command=Home");
        if (sectionId == null) {
            if (!assignedToMeInfo.getExpandedSelection()) {
                if (assignedToMeInfo.getItemsPerPage() != MINIMIZED_ITEMS_PER_PAGE) {
                    assignedToMeInfo.setItemsPerPage(MINIMIZED_ITEMS_PER_PAGE);
                }
            } else if (assignedToMeInfo.getItemsPerPage() == MINIMIZED_ITEMS_PER_PAGE) {
                assignedToMeInfo.setItemsPerPage(10);
            }
        } else if (sectionId.equals(assignedToMeInfo.getId())) {
            assignedToMeInfo.setExpandedSelection(true);
        }
        if (sectionId == null || assignedToMeInfo.getExpandedSelection()) {
            assignedToMeList.setPagedListInfo(assignedToMeInfo);
            assignedToMeList.setAssignedTo(user.getId());
            assignedToMeList.setIncludeAllSites(true);
            assignedToMeList.setOnlyOpen(true);
            if ("assignedToMe".equals(assignedToMeInfo.getListView())) {
                assignedToMeList.setAssignedTo(user.getId());
            }
        }
        PagedListInfo openInfo = this.getPagedListInfo(context, "OpenInfo", "t.entered", "desc");
        openInfo.setLink("TroubleTickets.do?command=Home");
        if (sectionId == null) {
            if (!openInfo.getExpandedSelection()) {
                if (openInfo.getItemsPerPage() != MINIMIZED_ITEMS_PER_PAGE) {
                    openInfo.setItemsPerPage(MINIMIZED_ITEMS_PER_PAGE);
                }
            } else if (openInfo.getItemsPerPage() == MINIMIZED_ITEMS_PER_PAGE) {
                openInfo.setItemsPerPage(10);
            }
        } else if (sectionId.equals(openInfo.getId())) {
            openInfo.setExpandedSelection(true);
        }
        if (sectionId == null || openInfo.getExpandedSelection()) {
            openList.setPagedListInfo(openInfo);
            openList.setUnassignedToo(true);
            openList.setBuildDepartmentTickets(true);
            openList.setDepartment(thisUser.getUserRecord().getContact().getDepartment());
            openList.setExcludeAssignedTo(user.getId());
            if (UserUtils.getUserSiteId(context.getRequest()) != -1) {
                openList.setIncludeAllSites(false);
            }
            openList.setExclusiveToSite(true);
            openList.setSiteId(UserUtils.getUserSiteId(context.getRequest()));
            openList.setOnlyOpen(true);
        }
        PagedListInfo createdByMeInfo = this.getPagedListInfo(context, "CreatedByMeInfo", "t.entered", "desc");
        createdByMeInfo.setLink("TroubleTickets.do?command=Home");
        if (sectionId == null) {
            if (!createdByMeInfo.getExpandedSelection()) {
                if (createdByMeInfo.getItemsPerPage() != MINIMIZED_ITEMS_PER_PAGE) {
                    createdByMeInfo.setItemsPerPage(MINIMIZED_ITEMS_PER_PAGE);
                }
            } else if (createdByMeInfo.getItemsPerPage() == MINIMIZED_ITEMS_PER_PAGE) {
                createdByMeInfo.setItemsPerPage(10);
            }
        } else if (sectionId.equals(createdByMeInfo.getId())) {
            createdByMeInfo.setExpandedSelection(true);
        }
        if (sectionId == null || createdByMeInfo.getExpandedSelection()) {
            createdByMeList.setPagedListInfo(createdByMeInfo);
            createdByMeList.setEnteredBy(user.getId());
            createdByMeList.setSiteId(user.getSiteId());
            if (user.getSiteId() != -1) {
                createdByMeList.setExclusiveToSite(true);
                createdByMeList.setIncludeAllSites(false);
            }
            createdByMeList.setOnlyOpen(true);
        }
        PagedListInfo userGroupTicketInfo = this.getPagedListInfo(context, "UserGroupTicketInfo", "t.entered", "desc");
        userGroupTicketInfo.setLink("TroubleTickets.do?command=Home");
        if (sectionId == null) {
            if (!userGroupTicketInfo.getExpandedSelection()) {
                if (userGroupTicketInfo.getItemsPerPage() != MINIMIZED_ITEMS_PER_PAGE) {
                    userGroupTicketInfo.setItemsPerPage(MINIMIZED_ITEMS_PER_PAGE);
                }
            } else if (userGroupTicketInfo.getItemsPerPage() == MINIMIZED_ITEMS_PER_PAGE) {
                userGroupTicketInfo.setItemsPerPage(10);
            }
        } else if (sectionId.equals(userGroupTicketInfo.getId())) {
            userGroupTicketInfo.setExpandedSelection(true);
        }
        if (sectionId == null || userGroupTicketInfo.getExpandedSelection()) {
            userGroupTicketList.setPagedListInfo(userGroupTicketInfo);
            userGroupTicketList.setInMyUserGroups(user.getId());
            userGroupTicketList.setIncludeAllSites(true);
            userGroupTicketList.setOnlyOpen(true);
        }
        PagedListInfo allTicketsInfo = this.getPagedListInfo(context, "AllTicketsInfo", "t.entered", "desc");
        allTicketsInfo.setLink("TroubleTickets.do?command=Home");
        if (sectionId == null) {
            if (!allTicketsInfo.getExpandedSelection()) {
                if (allTicketsInfo.getItemsPerPage() != MINIMIZED_ITEMS_PER_PAGE) {
                    allTicketsInfo.setItemsPerPage(MINIMIZED_ITEMS_PER_PAGE);
                }
            } else if (allTicketsInfo.getItemsPerPage() == MINIMIZED_ITEMS_PER_PAGE) {
                allTicketsInfo.setItemsPerPage(10);
            }
        } else if (sectionId.equals(allTicketsInfo.getId())) {
            allTicketsInfo.setExpandedSelection(true);
        }
        if (sectionId == null || allTicketsInfo.getExpandedSelection()) {
            allTicketsList.setPagedListInfo(allTicketsInfo);
            allTicketsList.setSiteId(user.getSiteId());
            if (user.getSiteId() > -1) {
                allTicketsList.setExclusiveToSite(true);
                allTicketsList.setIncludeAllSites(false);
            }
            allTicketsList.setUnassignedToo(true);
            allTicketsList.setOnlyOpen(true);
        }
        try {
            db = this.getConnection(context);
            if (sectionId == null || assignedToMeInfo.getExpandedSelection()) {
                assignedToMeList.buildList(db);
            }
            if (sectionId == null || openInfo.getExpandedSelection()) {
                openList.buildList(db);
            }
            if (sectionId == null || createdByMeInfo.getExpandedSelection()) {
                createdByMeList.buildList(db);
            }
            if (sectionId == null || allTicketsInfo.getExpandedSelection()) {
                allTicketsList.buildList(db);
            }
            if (sectionId == null || userGroupTicketInfo.getExpandedSelection()) {
                userGroupTicketList.buildList(db);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "ViewTickets", "View Tickets");
        context.getRequest().setAttribute("CreatedByMeList", (Object)createdByMeList);
        context.getRequest().setAttribute("AssignedToMeList", (Object)assignedToMeList);
        context.getRequest().setAttribute("OpenList", (Object)openList);
        context.getRequest().setAttribute("AllTicketsList", (Object)allTicketsList);
        context.getRequest().setAttribute("UserGroupTicketList", (Object)userGroupTicketList);
        this.addModuleBean(context, "ViewTickets", "View Tickets");
        return "HomeOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSearchTickets(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-view")) {
            return "PermissionError";
        }
        PagedListInfo ticListInfo = this.getPagedListInfo(context, "TicListInfo");
        Connection db = null;
        User user = this.getUser(context, this.getUserId(context));
        TicketList ticList = new TicketList();
        UserBean thisUser = (UserBean)((Object)context.getSession().getAttribute("User"));
        ticListInfo.setLink("TroubleTickets.do?command=SearchTickets");
        ticList.setPagedListInfo(ticListInfo);
        ticListInfo.setSearchCriteria(ticList, context);
        try {
            db = this.getConnection(context);
            if (ticList.getSiteId() == -2) {
                ticList.setSiteId(user.getSiteId());
                ticList.setIncludeAllSites(true);
            } else if (ticList.getSiteId() == -1) {
                ticList.setExclusiveToSite(true);
                ticList.setIncludeAllSites(false);
            } else {
                ticList.setExclusiveToSite(true);
                ticList.setIncludeAllSites(false);
            }
            if ("unassigned".equals(ticListInfo.getListView())) {
                ticList.setUnassignedToo(true);
                ticList.setBuildDepartmentTickets(true);
                ticList.setDepartment(thisUser.getUserRecord().getContact().getDepartment());
            } else if ("assignedToMe".equals(ticListInfo.getListView())) {
                ticList.setAssignedTo(this.getUserId(context));
            } else {
                ticList.setUnassignedToo(true);
                if ("createdByMe".equals(ticListInfo.getListView())) {
                    ticList.setEnteredBy(this.getUserId(context));
                }
            }
            if (ticListInfo.getFilterKey("listFilter1") == 1) {
                ticList.setOnlyOpen(true);
            } else if (ticListInfo.getFilterKey("listFilter1") == 2) {
                ticList.setOnlyClosed(true);
            }
            ticList.buildList(db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "SearchTickets", "Search Tickets");
        context.getRequest().setAttribute("TicList", (Object)ticList);
        context.getSession().setAttribute("searchTickets", (Object)"yes");
        this.addModuleBean(context, "SearchTickets", "Search Tickets");
        return "ResultsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandReopen(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-edit")) {
            return "PermissionError";
        }
        int resultCount = -1;
        Connection db = null;
        Ticket thisTicket = null;
        try {
            db = this.getConnection(context);
            thisTicket = new Ticket(db, Integer.parseInt(context.getRequest().getParameter("id")));
            Ticket oldTicket = new Ticket(db, thisTicket.getId());
            if (!TroubleTickets.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            thisTicket.setModifiedBy(this.getUserId(context));
            resultCount = thisTicket.reopen(db);
            if (resultCount == -1) {
                String string = this.executeCommandDetails(context);
                return string;
            }
            if (resultCount == 1) {
                thisTicket.queryRecord(db, thisTicket.getId());
                this.processUpdateHook(context, (Object)oldTicket, (Object)thisTicket);
                String string = this.executeCommandDetails(context);
                return string;
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsert(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-add")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean recordInserted = false;
        boolean contactRecordInserted = false;
        boolean isValid = true;
        Contact nc = null;
        Ticket newTicket = null;
        String newContact = context.getRequest().getParameter("contact");
        Ticket newTic = (Ticket)((Object)context.getFormBean());
        newTic.setEnteredBy(this.getUserId(context));
        newTic.setModifiedBy(this.getUserId(context));
        if (newContact != null && newContact.equals("on")) {
            nc = new Contact();
            nc.setNameFirst(context.getRequest().getParameter("thisContact_nameFirst"));
            nc.setNameLast(context.getRequest().getParameter("thisContact_nameLast"));
            nc.setTitle(context.getRequest().getParameter("thisContact_title"));
            nc.setRequestItems(context);
            nc.setOrgId(newTic.getOrgId());
            nc.setEnteredBy(this.getUserId(context));
            nc.setModifiedBy(this.getUserId(context));
            nc.setOwner(this.getUserId(context));
            if (newTic.getOrgId() == 0) {
                nc.setEmployee(true);
            }
        }
        try {
            db = this.getConnection(context);
            if (nc != null) {
                isValid = this.validateObject(context, db, (Object)nc);
                if (isValid) {
                    if (!TroubleTickets.isRecordAccessPermitted(context, db, nc.getOrgId())) {
                        String string = "PermissionError";
                        return string;
                    }
                    contactRecordInserted = nc.insert(db);
                    if (contactRecordInserted) {
                        newTic.setContactId(nc.getId());
                    }
                    if (contactRecordInserted) {
                        if (newTic.getOrgId() > 0) {
                            newTic.setSiteId(Organization.getOrganizationSiteId(db, newTic.getOrgId()));
                        }
                        boolean bl = isValid = this.validateObject(context, db, (Object)newTic) && isValid;
                        if (!TroubleTickets.isRecordAccessPermitted(context, db, newTic.getOrgId())) {
                            String string = "PermissionError";
                            return string;
                        }
                        if (isValid) {
                            recordInserted = newTic.insert(db);
                        }
                    }
                }
            } else {
                if (newTic.getOrgId() > 0) {
                    newTic.setSiteId(Organization.getOrganizationSiteId(db, newTic.getOrgId()));
                }
                boolean bl = isValid = this.validateObject(context, db, (Object)newTic) && isValid;
                if (isValid) {
                    recordInserted = newTic.insert(db);
                }
            }
            if (recordInserted) {
                newTicket = new Ticket(db, newTic.getId());
                context.getRequest().setAttribute("TicketDetails", (Object)newTicket);
                TicketCategoryList ticketCategoryList = new TicketCategoryList();
                ticketCategoryList.setSiteId(newTicket.getSiteId());
                ticketCategoryList.setExclusiveToSite(true);
                ticketCategoryList.setEnabledState(1);
                ticketCategoryList.buildList(db);
                context.getRequest().setAttribute("ticketCategoryList", (Object)ticketCategoryList);
                if (newTicket.getDefectId() != -1) {
                    TicketDefect defect = new TicketDefect(db, newTicket.getDefectId());
                    context.getRequest().setAttribute("defect", (Object)defect);
                }
                if (newTicket.getProductId() != -1) {
                    ProductCatalog product = new ProductCatalog(db, newTicket.getProductId());
                    context.getRequest().setAttribute("product", (Object)product);
                }
                if (newTicket.getCustomerProductId() != -1) {
                    CustomerProduct customerProduct = new CustomerProduct(db, newTicket.getCustomerProductId());
                    customerProduct.buildFileList(db);
                    context.getRequest().setAttribute("customerProduct", (Object)customerProduct);
                }
                this.addRecentItem(context, (Object)newTicket);
                this.processInsertHook(context, (Object)newTicket);
            } else if (newTic.getOrgId() != -1) {
                Organization thisOrg = new Organization(db, newTic.getOrgId());
                newTic.setCompanyName(thisOrg.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "ViewTickets", "Ticket Insert ok");
        if (recordInserted && isValid) {
            if (context.getRequest().getParameter("actionSource") != null) {
                context.getRequest().setAttribute("actionSource", (Object)context.getRequest().getParameter("actionSource"));
                return "InsertTicketOK";
            }
            return "InsertOK";
        }
        return this.executeCommandAdd(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSearchTicketsForm(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-view")) {
            return "PermissionError";
        }
        Connection db = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        HtmlSelect ticketTypeSelect = new HtmlSelect();
        ticketTypeSelect.addItem("0", systemStatus.getLabel("calendar.any.4dashes", "-- Any --"));
        ticketTypeSelect.addItem("1", systemStatus.getLabel("filter.openOnly", "Open Only"));
        ticketTypeSelect.addItem("2", systemStatus.getLabel("filter.closedOnly", "Closed Only"));
        ticketTypeSelect.build();
        context.getRequest().setAttribute("TicketTypeSelect", (Object)ticketTypeSelect);
        PagedListInfo ticListInfo = this.getPagedListInfo(context, "TicListInfo");
        try {
            db = this.getConnection(context);
            LookupList severityList = new LookupList(db, "ticket_severity");
            severityList.addItem(0, systemStatus.getLabel("calendar.any.4dashes", "-- Any --"));
            context.getRequest().setAttribute("SeverityList", (Object)severityList);
            LookupList priorityList = new LookupList(db, "ticket_priority");
            priorityList.addItem(0, systemStatus.getLabel("calendar.any.4dashes", "-- Any --"));
            context.getRequest().setAttribute("PriorityList", (Object)priorityList);
            LookupList escalationList = new LookupList(db, "lookup_ticket_escalation");
            escalationList.addItem(0, systemStatus.getLabel("calendar.any.4dashes", "-- Any --"));
            context.getRequest().setAttribute("EscalationList", (Object)escalationList);
            this.addModuleBean(context, "SearchTickets", "Tickets Search");
            if (!"".equals(ticListInfo.getSearchOptionValue("searchcodeOrgId")) && !"-1".equals(ticListInfo.getSearchOptionValue("searchcodeOrgId"))) {
                String orgId = ticListInfo.getSearchOptionValue("searchcodeOrgId");
                Organization thisOrg = new Organization(db, Integer.parseInt(orgId));
                context.getRequest().setAttribute("OrgDetails", (Object)thisOrg);
            }
            if (!"".equals(ticListInfo.getSearchOptionValue("searchcodeUserGroupId")) && !"-1".equals(ticListInfo.getSearchOptionValue("searchcodeUserGroupId"))) {
                String groupId = ticListInfo.getSearchOptionValue("searchcodeUserGroupId");
                UserGroup group = new UserGroup(db, Integer.parseInt(groupId));
                context.getRequest().setAttribute("userGroup", (Object)group);
            }
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            siteList.addItem(-2, systemStatus.getLabel("accounts.allSites"));
            context.getRequest().setAttribute("SiteList", (Object)siteList);
            String string = "SearchTicketsFormOK";
            return string;
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdate(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-edit")) {
            return "PermissionError";
        }
        int resultCount = 0;
        int catCount = 0;
        TicketCategory thisCat = null;
        boolean catInserted = false;
        boolean isValid = true;
        Ticket newTic = (Ticket)((Object)context.getFormBean());
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (!TroubleTickets.isRecordAccessPermitted(context, db, newTic.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            Organization orgDetails = new Organization(db, newTic.getOrgId());
            for (catCount = 0; catCount < 4; ++catCount) {
                if (context.getRequest().getParameter("newCat" + catCount + "chk") == null || !context.getRequest().getParameter("newCat" + catCount + "chk").equals("on") || context.getRequest().getParameter("newCat" + catCount) == null || context.getRequest().getParameter("newCat" + catCount).equals("")) continue;
                thisCat = new TicketCategory();
                if (catCount == 0) {
                    thisCat.setParentCode(0);
                } else if (catCount == 1) {
                    thisCat.setParentCode(newTic.getCatCode());
                } else if (catCount == 2) {
                    thisCat.setParentCode(newTic.getSubCat1());
                } else {
                    thisCat.setParentCode(newTic.getSubCat2());
                }
                thisCat.setDescription(context.getRequest().getParameter("newCat" + catCount));
                thisCat.setCategoryLevel(catCount);
                thisCat.setSiteId(orgDetails.getSiteId());
                thisCat.setLevel(catCount);
                boolean bl = isValid = this.validateObject(context, db, (Object)thisCat) && isValid;
                if (!isValid || !(catInserted = thisCat.insert(db))) continue;
                if (catCount == 0) {
                    newTic.setCatCode(thisCat.getId());
                    continue;
                }
                if (catCount == 1) {
                    newTic.setSubCat1(thisCat.getId());
                    continue;
                }
                if (catCount == 2) {
                    newTic.setSubCat2(thisCat.getId());
                    continue;
                }
                newTic.setSubCat3(thisCat.getId());
            }
            newTic.setModifiedBy(this.getUserId(context));
            Ticket previousTicket = new Ticket(db, newTic.getId());
            if (previousTicket.getProductId() > -1) {
                // empty if block
            }
            newTic.setSiteId(Organization.getOrganizationSiteId(db, newTic.getOrgId()));
            boolean bl = isValid = this.validateObject(context, db, (Object)newTic) && isValid;
            if (isValid && (resultCount = newTic.update(db)) == 1) {
                newTic.queryRecord(db, newTic.getId());
                this.processUpdateHook(context, (Object)previousTicket, (Object)newTic);
            }
            TicketCategoryList ticketCategoryList = new TicketCategoryList();
            ticketCategoryList.setSiteId(newTic.getSiteId());
            ticketCategoryList.setExclusiveToSite(true);
            ticketCategoryList.setEnabledState(1);
            ticketCategoryList.buildList(db);
            context.getRequest().setAttribute("ticketCategoryList", (Object)ticketCategoryList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (resultCount == 1) {
            if (context.getRequest().getParameter("return") != null && context.getRequest().getParameter("return").equals("list")) {
                return this.executeCommandHome(context);
            }
            return TroubleTickets.getReturn(context, "Update");
        }
        return this.executeCommandModify(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-delete")) {
            return "PermissionError";
        }
        HtmlDialog htmlDialog = new HtmlDialog();
        Ticket ticket = null;
        String id = context.getRequest().getParameter("id");
        Connection db = null;
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            ticket = new Ticket(db, Integer.parseInt(id));
            if (!TroubleTickets.isRecordAccessPermitted(context, db, ticket.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            String returnType = context.getRequest().getParameter("return");
            DependencyList dependencies = ticket.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.header"));
            if ("searchResults".equals(returnType)) {
                htmlDialog.addButton(systemStatus.getLabel("global.button.delete"), "javascript:window.location.href='TroubleTickets.do?command=Trash&id=" + id + "&return=searchResults" + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType|actionId") + "'");
            } else {
                htmlDialog.addButton(systemStatus.getLabel("global.button.delete"), "javascript:window.location.href='TroubleTickets.do?command=Trash&id=" + id + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType|actionId") + "'");
            }
            htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        return "ConfirmDeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-delete")) {
            return "PermissionError";
        }
        boolean recordDeleted = false;
        Ticket thisTic = null;
        Connection db = null;
        String passedId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            thisTic = new Ticket(db, Integer.parseInt(passedId));
            if (!TroubleTickets.isRecordAccessPermitted(context, db, thisTic.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            recordDeleted = thisTic.delete(db, TroubleTickets.getDbNamePath(context));
            if (recordDeleted) {
                this.processDeleteHook(context, (Object)thisTic);
                this.deleteRecentItem(context, (Object)thisTic);
                String returnType = context.getRequest().getParameter("return");
                if ("searchResults".equals(returnType)) {
                    context.getRequest().setAttribute("refreshUrl", (Object)("TroubleTickets.do?command=SearchTickets" + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType|actionId")));
                } else {
                    context.getRequest().setAttribute("refreshUrl", (Object)("TroubleTickets.do?command=Home" + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType|actionId")));
                }
                String string = "DeleteOK";
                return string;
            }
            String returnType = this.executeCommandHome(context);
            return returnType;
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandTrash(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-delete")) {
            return "PermissionError";
        }
        boolean recordUpdated = false;
        Ticket thisTic = null;
        Connection db = null;
        String passedId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            thisTic = new Ticket(db, Integer.parseInt(passedId));
            if (!TroubleTickets.isRecordAccessPermitted(context, db, thisTic.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            recordUpdated = thisTic.updateStatus(db, true, this.getUserId(context));
            if (recordUpdated) {
                this.processDeleteHook(context, (Object)thisTic);
                this.deleteRecentItem(context, (Object)thisTic);
                String returnType = context.getRequest().getParameter("return");
                if ("searchResults".equals(returnType)) {
                    context.getRequest().setAttribute("refreshUrl", (Object)("TroubleTickets.do?command=SearchTickets" + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType|actionId")));
                } else {
                    context.getRequest().setAttribute("refreshUrl", (Object)("TroubleTickets.do?command=Home" + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType|actionId")));
                }
                String string = "DeleteOK";
                return string;
            }
            String returnType = this.executeCommandHome(context);
            return returnType;
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandRestore(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-edit")) {
            return "PermissionError";
        }
        boolean recordUpdated = false;
        Connection db = null;
        Ticket thisTicket = null;
        try {
            db = this.getConnection(context);
            thisTicket = new Ticket(db, Integer.parseInt(context.getRequest().getParameter("id")));
            if (!TroubleTickets.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            thisTicket.setModifiedBy(this.getUserId(context));
            recordUpdated = thisTicket.updateStatus(db, false, this.getUserId(context));
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordUpdated) {
            return this.executeCommandDetails(context);
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    protected void buildFormElements(ActionContext context, Connection db, Ticket newTic) throws SQLException {
        SystemStatus systemStatus = this.getSystemStatus(context);
        LookupList departmentList = new LookupList(db, "lookup_department");
        departmentList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
        departmentList.setJsEvent("onChange=\"javascript:updateUserList();javascript:resetAssignedDate();\"");
        context.getRequest().setAttribute("DepartmentList", (Object)departmentList);
        User user = this.getUser(context, this.getUserId(context));
        int siteId = user.getSiteId();
        if (newTic.getOrgId() > -1) {
            Organization org = new Organization(db, newTic.getOrgId());
            siteId = org.getSiteId();
            newTic.setOrgSiteId(siteId);
        }
        LookupList resolvedByDeptList = new LookupList(db, "lookup_department");
        resolvedByDeptList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
        resolvedByDeptList.setJsEvent("onChange=\"javascript:updateResolvedByUserList();\"");
        context.getRequest().setAttribute("resolvedByDeptList", (Object)resolvedByDeptList);
        LookupList severityList = new LookupList(db, "ticket_severity");
        context.getRequest().setAttribute("SeverityList", (Object)severityList);
        LookupList priorityList = new LookupList(db, "ticket_priority");
        context.getRequest().setAttribute("PriorityList", (Object)priorityList);
        LookupList sourceList = new LookupList(db, "lookup_ticketsource");
        sourceList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("SourceList", (Object)sourceList);
        LookupList causeList = new LookupList(db, "lookup_ticket_cause");
        causeList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("causeList", (Object)causeList);
        LookupList resolutionList = new LookupList(db, "lookup_ticket_resolution");
        resolutionList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("resolutionList", (Object)resolutionList);
        LookupList escalationList = new LookupList(db, "lookup_ticket_escalation");
        escalationList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("EscalationList", (Object)escalationList);
        LookupList ticketStateList = new LookupList(db, "lookup_ticket_state");
        ticketStateList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("ticketStateList", (Object)ticketStateList);
        TicketCategoryList categoryList = new TicketCategoryList();
        categoryList.setCatLevel(0);
        categoryList.setParentCode(0);
        categoryList.setSiteId(siteId);
        categoryList.setExclusiveToSite(true);
        categoryList.setHtmlJsEvent("onChange=\"javascript:updateSubList1();\"");
        categoryList.buildList(db);
        categoryList.getCatListSelect().addItem(0, "Undetermined");
        context.getRequest().setAttribute("CategoryList", (Object)categoryList);
        UserList userList = new UserList();
        userList.setHidden(0);
        userList.setEmptyHtmlSelectRecord(systemStatus.getLabel("calendar.none.4dashes"));
        userList.setBuildContact(true);
        userList.setBuildContactDetails(false);
        userList.setExcludeDisabledIfUnselected(true);
        userList.setExcludeExpiredIfUnselected(true);
        userList.setRoleType(0);
        userList.setDepartment(newTic.getDepartmentCode() != -1 ? newTic.getDepartmentCode() : 0);
        userList.setSiteId(siteId);
        userList.setIncludeUsersWithAccessToAllSites(true);
        userList.buildList(db);
        context.getRequest().setAttribute("UserList", (Object)userList);
        UserList resolvedUserList = new UserList();
        resolvedUserList.setHidden(0);
        resolvedUserList.setEmptyHtmlSelectRecord(systemStatus.getLabel("calendar.none.4dashes"));
        resolvedUserList.setBuildContact(true);
        resolvedUserList.setBuildContactDetails(false);
        resolvedUserList.setExcludeDisabledIfUnselected(true);
        resolvedUserList.setExcludeExpiredIfUnselected(true);
        resolvedUserList.setRoleType(0);
        resolvedUserList.setDepartment(newTic.getResolvedByDeptCode() != -1 ? newTic.getResolvedByDeptCode() : 0);
        resolvedUserList.setSiteId(UserUtils.getUserSiteId(context.getRequest()));
        resolvedUserList.setIncludeUsersWithAccessToAllSites(true);
        resolvedUserList.buildList(db);
        context.getRequest().setAttribute("resolvedUserList", (Object)resolvedUserList);
        ContactList contactList = new ContactList();
        if (newTic != null && newTic.getOrgId() != -1) {
            contactList.setBuildDetails(false);
            contactList.setBuildTypes(false);
            contactList.setOrgId(newTic.getOrgId());
            contactList.setDefaultContactId(newTic.getContactId());
            contactList.buildList(db);
        }
        context.getRequest().setAttribute("ContactList", (Object)contactList);
        TicketDefectList list = new TicketDefectList();
        list.setSiteId(this.getUserSiteId(context));
        list.buildList(db);
        HtmlSelect defectSelect = list.getHtmlSelectObj(newTic.getDefectId());
        defectSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes", "None"), 0);
        context.getRequest().setAttribute("defectSelect", (Object)defectSelect);
        TicketCategoryList subList1 = new TicketCategoryList();
        subList1.setCatLevel(1);
        subList1.setParentCode(newTic.getCatCode());
        subList1.setHtmlJsEvent("onChange=\"javascript:updateSubList2();\"");
        subList1.setSiteId(siteId);
        subList1.setExclusiveToSite(true);
        subList1.buildList(db);
        subList1.getCatListSelect().addItem(0, "Undetermined");
        context.getRequest().setAttribute("SubList1", (Object)subList1);
        TicketCategoryList subList2 = new TicketCategoryList();
        subList2.setCatLevel(2);
        if (context.getRequest().getParameter("refresh") != null && Integer.parseInt(context.getRequest().getParameter("refresh")) == 1) {
            subList2.setParentCode(0);
            newTic.setSubCat1(0);
            newTic.setSubCat2(0);
            newTic.setSubCat3(0);
        } else if (context.getRequest().getParameter("refresh") != null && Integer.parseInt(context.getRequest().getParameter("refresh")) == -1) {
            subList2.setParentCode(newTic.getSubCat1());
            subList2.getCatListSelect().setDefaultKey(newTic.getSubCat2());
        } else {
            subList2.setParentCode(newTic.getSubCat1());
        }
        subList2.setHtmlJsEvent("onChange=\"javascript:updateSubList3();\"");
        subList2.setSiteId(siteId);
        subList2.setExclusiveToSite(true);
        subList2.buildList(db);
        subList2.getCatListSelect().addItem(0, "Undetermined");
        context.getRequest().setAttribute("SubList2", (Object)subList2);
        TicketCategoryList subList3 = new TicketCategoryList();
        subList3.setCatLevel(3);
        if (context.getRequest().getParameter("refresh") != null && (Integer.parseInt(context.getRequest().getParameter("refresh")) == 1 || Integer.parseInt(context.getRequest().getParameter("refresh")) == 2)) {
            subList3.setParentCode(0);
            newTic.setSubCat2(0);
            newTic.setSubCat3(0);
        } else if (context.getRequest().getParameter("refresh") != null && Integer.parseInt(context.getRequest().getParameter("refresh")) == -1) {
            subList3.setParentCode(newTic.getSubCat2());
            subList3.getCatListSelect().setDefaultKey(newTic.getSubCat3());
        } else {
            subList3.setParentCode(newTic.getSubCat2());
        }
        subList3.setHtmlJsEvent("onChange=\"javascript:updateSubList4();\"");
        subList3.setSiteId(siteId);
        subList3.setExclusiveToSite(true);
        subList3.buildList(db);
        subList3.getCatListSelect().addItem(0, "Undetermined");
        context.getRequest().setAttribute("SubList3", (Object)subList3);
        ActionPlanList actionPlans = new ActionPlanList();
        actionPlans.setLinkObjectId(ActionPlan.getMapIdGivenConstantId(db, 912051329));
        if (newTic.getCatCode() > 0) {
            actionPlans.setLinkCatCode(newTic.getCatCode());
        }
        if (newTic.getSubCat1() > 0) {
            actionPlans.setLinkSubCat1(newTic.getSubCat1());
        }
        if (newTic.getSubCat2() > 0) {
            actionPlans.setLinkSubCat2(newTic.getSubCat2());
        }
        if (newTic.getSubCat3() > 0) {
            actionPlans.setLinkSubCat3(newTic.getSubCat3());
        }
        if (actionPlans.getLinkCatCode() <= 0 && actionPlans.getLinkSubCat1() <= 0 && actionPlans.getLinkSubCat2() <= 0 && actionPlans.getLinkSubCat3() <= 0) {
            actionPlans.setDisplayNone(true);
        }
        CategoryEditor thisEditor = systemStatus.getCategoryEditor(db, 202041401);
        actionPlans.setNameTable(thisEditor.getTableName());
        actionPlans.setJsEvent("id=\"actionPlanId\"");
        actionPlans.setEnabled(1);
        actionPlans.setIncludeOnlyApproved(1);
        actionPlans.setSiteId(siteId);
        actionPlans.buildList(db);
        context.getRequest().setAttribute("actionPlans", (Object)actionPlans);
        if (context.getRequest().getParameter("insertActionPlan") != null && !"".equals(context.getRequest().getParameter("insertActionPlan"))) {
            context.getRequest().setAttribute("insertActionPlan", (Object)String.valueOf(true));
        }
        if (context.getRequest().getParameter("refresh") != null && (Integer.parseInt(context.getRequest().getParameter("refresh")) == 1 || Integer.parseInt(context.getRequest().getParameter("refresh")) == 3)) {
            newTic.setSubCat3(0);
        }
        context.getRequest().setAttribute("TicketDetails", (Object)newTic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String executeCommandCategoryJSList(ActionContext context) {
        Connection db = null;
        try {
            ActionPlanList plans = null;
            TicketCategoryAssignment assignment = null;
            Organization orgDetails = null;
            String reset = context.getRequest().getParameter("reset");
            String orgId = context.getRequest().getParameter("orgId");
            String catCode = context.getRequest().getParameter("catCode");
            String subCat1 = context.getRequest().getParameter("subCat1");
            String subCat2 = context.getRequest().getParameter("subCat2");
            String subCat3 = context.getRequest().getParameter("subCat3");
            db = this.getConnection(context);
            orgDetails = new Organization(db, Integer.parseInt(orgId));
            plans = new ActionPlanList();
            plans.setSiteId(orgDetails.getSiteId());
            plans.setLinkObjectId(ActionPlan.getMapIdGivenConstantId(db, 912051329));
            if (reset != null && "true".equals(reset.trim())) {
                TicketCategoryList catList = new TicketCategoryList();
                catList.setSiteId(orgDetails.getSiteId());
                catList.setExclusiveToSite(true);
                catList.setCatLevel(0);
                catList.setParentCode(0);
                catList.buildList(db);
                context.getRequest().setAttribute("CategoryList", (Object)catList);
            } else if (catCode != null) {
                plans.setLinkCatCode(catCode);
                TicketCategoryList subList1 = new TicketCategoryList();
                subList1.setSiteId(orgDetails.getSiteId());
                subList1.setExclusiveToSite(true);
                subList1.setCatLevel(1);
                subList1.setParentCode(Integer.parseInt(catCode));
                subList1.buildList(db);
                assignment = new TicketCategoryAssignment(db, Integer.parseInt(catCode), null);
                context.getRequest().setAttribute("SubList1", (Object)subList1);
            } else if (subCat1 != null) {
                plans.setLinkSubCat1(subCat1);
                TicketCategoryList subList2 = new TicketCategoryList();
                subList2.setSiteId(orgDetails.getSiteId());
                subList2.setExclusiveToSite(true);
                subList2.setCatLevel(2);
                subList2.setParentCode(Integer.parseInt(subCat1));
                subList2.buildList(db);
                assignment = new TicketCategoryAssignment(db, Integer.parseInt(subCat1), null);
                context.getRequest().setAttribute("SubList2", (Object)subList2);
            } else if (subCat2 != null) {
                plans.setLinkSubCat2(subCat2);
                TicketCategoryList subList3 = new TicketCategoryList();
                subList3.setSiteId(orgDetails.getSiteId());
                subList3.setExclusiveToSite(true);
                subList3.setCatLevel(3);
                subList3.setParentCode(Integer.parseInt(subCat2));
                subList3.buildList(db);
                assignment = new TicketCategoryAssignment(db, Integer.parseInt(subCat2), null);
                context.getRequest().setAttribute("SubList3", (Object)subList3);
            } else if (subCat3 != null) {
                plans.setLinkSubCat3(subCat3);
                assignment = new TicketCategoryAssignment(db, Integer.parseInt(subCat3), null);
            }
            if (plans.getLinkCatCode() <= 0 && plans.getLinkSubCat1() <= 0 && plans.getLinkSubCat2() <= 0 && plans.getLinkSubCat3() <= 0) {
                plans.setDisplayNone(true);
            }
            if (assignment != null && assignment.getId() > -1) {
                assignment.setSiteId(orgDetails.getSiteId());
                assignment.buildDepartmentUsers(db);
                context.getRequest().setAttribute("assignment", (Object)assignment);
            } else if (assignment != null) {
                assignment.setSiteId(orgDetails.getSiteId());
                assignment.setDepartmentId(0);
                assignment.buildDepartmentUsers(db);
                context.getRequest().setAttribute("assignment", (Object)assignment);
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            CategoryEditor thisEditor = systemStatus.getCategoryEditor(db, 202041401);
            plans.setNameTable(thisEditor.getTableName());
            plans.setJsEvent("id=\"actionPlanId\"");
            plans.setEnabled(1);
            plans.setSiteId(orgDetails.getSiteId());
            plans.setIncludeOnlyApproved(1);
            if (reset == null || !"true".equals(reset.trim())) {
                plans.buildList(db);
            }
            context.getRequest().setAttribute("actionPlans", (Object)plans);
        }
        catch (Exception exception) {
            this.freeConnection(context, db);
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
        }
        this.freeConnection(context, db);
        return "CategoryJSListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDepartmentJSList(ActionContext context) {
        Connection db = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            String siteIdString = context.getRequest().getParameter("orgSiteId");
            if (siteIdString == null || "".equals(siteIdString)) {
                siteIdString = (String)context.getRequest().getAttribute("orgSiteId");
            }
            int siteId = UserUtils.getUserSiteId(context.getRequest());
            if (siteIdString != null && !"".equals(siteIdString)) {
                siteId = Integer.parseInt(siteIdString);
            }
            String populateResourceAssigned = context.getRequest().getParameter("populateResourceAssigned");
            String populateResolvedBy = context.getRequest().getParameter("populateResolvedBy");
            if ("true".equals(populateResourceAssigned)) {
                String resourceAssignedDepartmentCode = context.getRequest().getParameter("resourceAssignedDepartmentCode");
                UserList resourceAssignedList = new UserList();
                resourceAssignedList.setHidden(0);
                resourceAssignedList.setEmptyHtmlSelectRecord(systemStatus.getLabel("calendar.none.4dashes"));
                resourceAssignedList.setSiteId(siteId);
                resourceAssignedList.setIncludeUsersWithAccessToAllSites(true);
                resourceAssignedList.setBuildContact(true);
                resourceAssignedList.setBuildContactDetails(false);
                resourceAssignedList.setExcludeDisabledIfUnselected(true);
                resourceAssignedList.setExcludeExpiredIfUnselected(true);
                if (resourceAssignedDepartmentCode != null && !"".equals(resourceAssignedDepartmentCode) && !"-1".equals(resourceAssignedDepartmentCode)) {
                    resourceAssignedList.setDepartment(Integer.parseInt(resourceAssignedDepartmentCode));
                }
                resourceAssignedList.setRoleType(0);
                resourceAssignedList.buildList(db);
                HtmlSelect resourceAssignedSelect = resourceAssignedList.getHtmlSelectObj(systemStatus.getLabel("calendar.none.4dashes"), -1);
                context.getRequest().setAttribute("resourceAssignedList", (Object)resourceAssignedList);
                context.getRequest().setAttribute("resourceAssignedSelect", (Object)resourceAssignedSelect);
            }
            if ("true".equals(populateResolvedBy)) {
                String resolvedByDepartmentCode = context.getRequest().getParameter("resolvedByDepartmentCode");
                UserList resolvedByList = new UserList();
                resolvedByList.setHidden(0);
                resolvedByList.setEmptyHtmlSelectRecord(systemStatus.getLabel("calendar.none.4dashes"));
                resolvedByList.setSiteId(siteId);
                resolvedByList.setIncludeUsersWithAccessToAllSites(true);
                resolvedByList.setBuildContact(true);
                resolvedByList.setBuildContactDetails(false);
                resolvedByList.setExcludeDisabledIfUnselected(true);
                resolvedByList.setExcludeExpiredIfUnselected(true);
                if (resolvedByDepartmentCode != null && !"".equals(resolvedByDepartmentCode) && !"-1".equals(resolvedByDepartmentCode)) {
                    resolvedByList.setDepartment(Integer.parseInt(resolvedByDepartmentCode));
                }
                resolvedByList.setRoleType(0);
                resolvedByList.buildList(db);
                HtmlSelect resolvedBySelect = resolvedByList.getHtmlSelectObj(systemStatus.getLabel("calendar.none.4dashes"), -1);
                context.getRequest().setAttribute("resolvedByList", (Object)resolvedByList);
                context.getRequest().setAttribute("resolvedBySelect", (Object)resolvedBySelect);
            }
        }
        catch (Exception errorMessage) {
        }
        finally {
            this.freeConnection(context, db);
        }
        return "DepartmentJSListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandOrganizationJSList(ActionContext context) {
        Connection db;
        block6: {
            db = null;
            try {
                String orgId = context.getRequest().getParameter("orgId");
                db = this.getConnection(context);
                ContactList contactList = new ContactList();
                if (orgId != null && !"-1".equals(orgId)) {
                    contactList.setBuildDetails(false);
                    contactList.setBuildTypes(false);
                    contactList.setOrgId(Integer.parseInt(orgId));
                    contactList.buildList(db);
                }
                context.getRequest().setAttribute("ContactList", (Object)contactList);
                Organization orgDetails = new Organization(db, Integer.parseInt(orgId));
                context.getRequest().setAttribute("OrgDetails", (Object)orgDetails);
                String populateResourceAssigned = context.getRequest().getParameter("populateResourceAssigned");
                String populateResolvedBy = context.getRequest().getParameter("populateResolvedBy");
                if ("true".equals(populateResourceAssigned) || "true".equals(populateResolvedBy)) {
                    this.executeCommandDepartmentJSList(context);
                }
                context.getRequest().setAttribute("orgSiteId", (Object)String.valueOf(orgDetails.getSiteId()));
                String populateDefects = context.getRequest().getParameter("populateDefects");
                if (!"true".equals(populateDefects)) break block6;
                TicketDefectList defectList = new TicketDefectList();
                defectList.setSiteId(orgDetails.getSiteId());
                defectList.buildList(db);
                context.getRequest().setAttribute("defectList", (Object)defectList);
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    this.freeConnection(context, db);
                    throw throwable;
                }
                this.freeConnection(context, db);
            }
        }
        this.freeConnection(context, db);
        return "OrganizationJSListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPrintReport(ActionContext context) {
        block7: {
            if (!this.hasPermission(context, "tickets-tickets-view") && !this.hasPermission(context, "accounts-accounts-tickets-view")) {
                return "PermissionError";
            }
            Connection db = null;
            try {
                db = this.getConnection(context);
                String id = context.getRequest().getParameter("id");
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("ticketid", new Integer(id));
                map.put("path", this.getWebInfPath(context, "reports"));
                map.put("CENTRIC_DICTIONARY", this.getSystemStatus(context).getLocalizationPrefs());
                String filename = "ticket.xml";
                Connection scriptdb = this.getConnection(context);
                map.put("SCRIPT_DB_CONNECTION", scriptdb);
                String fontPath = this.getWebInfPath(context, "fonts");
                String reportDir = this.getWebInfPath(context, "reports");
                JasperReport jasperReport = JasperReportUtils.getReport(reportDir + filename);
                String language = TroubleTickets.getPref(context, "SYSTEM.LANGUAGE");
                JasperReportUtils.modifyFontProperties(jasperReport, reportDir, fontPath, language);
                byte[] bytes = JasperRunManager.runReportToPdf((JasperReport)jasperReport, map, (Connection)db);
                if (bytes != null) {
                    FileDownload fileDownload = new FileDownload();
                    fileDownload.setDisplayName("Ticket_Details_" + id + ".pdf");
                    fileDownload.sendFile(context, bytes, "application/pdf");
                    break block7;
                }
                String string = "SystemError";
                return string;
            }
            catch (Exception errorMessage) {
                context.getRequest().setAttribute("Error", (Object)errorMessage);
                String string = "SystemError";
                return string;
            }
            finally {
                this.freeConnection(context, db);
            }
        }
        return "-none-";
    }
}

