/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.isavvix.tools.FileInfo;
import com.isavvix.tools.HttpMultiPartParser;
import com.zeroio.iteam.actions.ProjectManagementFileFolders;
import com.zeroio.iteam.base.FileFolderHierarchy;
import com.zeroio.iteam.base.FileFolderList;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemList;
import com.zeroio.iteam.base.FileItemVersion;
import com.zeroio.webutils.FileDownload;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.troubletickets.base.Ticket;

public final class TroubleTicketsDocuments
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-view")) {
            return "PermissionError";
        }
        String folderId = context.getRequest().getParameter("folderId");
        if (folderId == null) {
            folderId = (String)context.getRequest().getAttribute("folderId");
        }
        Exception errorMessage = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            Ticket thisTicket = this.addTicket(context, db);
            int ticketId = thisTicket.getId();
            if (!TroubleTicketsDocuments.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            FileFolderList folders = new FileFolderList();
            if (folderId == null || "-1".equals(folderId) || "0".equals(folderId) || "".equals(folderId)) {
                folders.setTopLevelOnly(true);
            } else {
                folders.setParentId(Integer.parseInt(folderId));
                ProjectManagementFileFolders.buildHierarchy((Connection)db, (ActionContext)context);
            }
            folders.setLinkModuleId(6);
            folders.setLinkItemId(ticketId);
            folders.setBuildItemCount(true);
            folders.buildList(db);
            FileItemList documents = new FileItemList();
            if (folderId == null || "-1".equals(folderId) || "0".equals(folderId) || "".equals(folderId)) {
                documents.setTopLevelOnly(true);
            } else {
                documents.setFolderId(Integer.parseInt(folderId));
            }
            documents.setLinkModuleId(6);
            documents.setLinkItemId(ticketId);
            documents.buildList(db);
            context.getRequest().setAttribute("fileItemList", (Object)documents);
            context.getRequest().setAttribute("fileFolderList", (Object)folders);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "ViewTickets", "View Documents");
        if (errorMessage == null) {
            return "ViewOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-edit")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            Ticket thisTicket = this.addTicket(context, db);
            int ticketId = thisTicket.getId();
            if (!TroubleTicketsDocuments.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            String folderId = context.getRequest().getParameter("folderId");
            if (folderId != null) {
                context.getRequest().setAttribute("folderId", (Object)folderId);
            }
            ProjectManagementFileFolders.buildHierarchy((Connection)db, (ActionContext)context);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "ViewTickets", "Upload Document");
        if (errorMessage == null) {
            return "AddOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpload(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean recordInserted = false;
        boolean isValid = false;
        try {
            String filePath = this.getPath(context, "tickets");
            HttpMultiPartParser multiPart = new HttpMultiPartParser();
            multiPart.setUsePathParam(false);
            multiPart.setUseUniqueName(true);
            multiPart.setUseDateForFolder(true);
            multiPart.setExtensionId(this.getUserId(context));
            HashMap parts = multiPart.parseData(context.getRequest(), filePath);
            db = this.getConnection(context);
            String id = (String)parts.get("id");
            String subject = (String)parts.get("subject");
            String folderId = (String)parts.get("folderId");
            if (folderId != null) {
                context.getRequest().setAttribute("folderId", (Object)folderId);
            }
            if (subject != null) {
                context.getRequest().setAttribute("subject", (Object)subject);
            }
            Ticket thisTicket = this.addTicket(context, db, id);
            int ticketId = thisTicket.getId();
            if (!TroubleTicketsDocuments.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) {
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            if (parts.get("id" + (String)parts.get("id")) instanceof FileInfo) {
                FileInfo newFileInfo = (FileInfo)parts.get("id" + id);
                FileItem thisItem = new FileItem();
                thisItem.setLinkModuleId(6);
                thisItem.setLinkItemId(ticketId);
                thisItem.setEnteredBy(this.getUserId(context));
                thisItem.setModifiedBy(this.getUserId(context));
                thisItem.setFolderId(Integer.parseInt(folderId));
                thisItem.setSubject(subject);
                thisItem.setClientFilename(newFileInfo.getClientFileName());
                thisItem.setFilename(newFileInfo.getRealFilename());
                thisItem.setVersion(1.0);
                thisItem.setSize(newFileInfo.getSize());
                isValid = this.validateObject(context, db, thisItem);
                if (isValid) {
                    recordInserted = thisItem.insert(db);
                }
            } else {
                recordInserted = false;
                HashMap<String, String> errors = new HashMap<String, String>();
                SystemStatus systemStatus = this.getSystemStatus(context);
                errors.put("actionError", systemStatus.getLabel("object.validation.incorrectFileName"));
                if (subject != null && "".equals(subject.trim())) {
                    errors.put("subjectError", systemStatus.getLabel("object.validation.required"));
                }
                this.processErrors(context, errors);
            }
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted) {
            return "UploadOK";
        }
        return this.executeCommandAdd(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddVersion(ActionContext context) {
        String folderId;
        if (!this.hasPermission(context, "tickets-tickets-edit")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        String itemId = context.getRequest().getParameter("fid");
        if (itemId == null) {
            itemId = (String)context.getRequest().getAttribute("fid");
        }
        if ((folderId = context.getRequest().getParameter("folderId")) == null) {
            folderId = (String)context.getRequest().getAttribute("folderId");
        }
        if (folderId != null) {
            context.getRequest().setAttribute("folderId", (Object)folderId);
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            Ticket thisTicket = this.addTicket(context, db);
            int ticketId = thisTicket.getId();
            if (!TroubleTicketsDocuments.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            FileItem thisFile = new FileItem(db, Integer.parseInt(itemId), ticketId, 6);
            context.getRequest().setAttribute("FileItem", (Object)thisFile);
            ProjectManagementFileFolders.buildHierarchy((Connection)db, (ActionContext)context);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "ViewTickets", "Upload New Document Version");
        if (errorMessage == null) {
            return "AddVersionOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUploadVersion(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean recordInserted = false;
        boolean isValid = false;
        try {
            String filePath = this.getPath(context, "tickets");
            HttpMultiPartParser multiPart = new HttpMultiPartParser();
            multiPart.setUsePathParam(false);
            multiPart.setUseUniqueName(true);
            multiPart.setUseDateForFolder(true);
            multiPart.setExtensionId(this.getUserId(context));
            HashMap parts = multiPart.parseData(context.getRequest(), filePath);
            String id = (String)parts.get("id");
            String itemId = (String)parts.get("fid");
            String subject = (String)parts.get("subject");
            String versionId = (String)parts.get("versionId");
            String folderId = (String)parts.get("folderId");
            if (folderId != null) {
                context.getRequest().setAttribute("folderId", (Object)folderId);
            }
            if (subject != null) {
                context.getRequest().setAttribute("subject", (Object)subject);
            }
            db = this.getConnection(context);
            Ticket thisTicket = this.addTicket(context, db, id);
            int ticketId = thisTicket.getId();
            if (!TroubleTicketsDocuments.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) {
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            if (parts.get("id" + (String)parts.get("id")) instanceof FileInfo) {
                FileInfo newFileInfo = (FileInfo)parts.get("id" + id);
                FileItem thisItem = new FileItem();
                thisItem.setLinkModuleId(6);
                thisItem.setLinkItemId(ticketId);
                thisItem.setId(Integer.parseInt(itemId));
                thisItem.setEnteredBy(this.getUserId(context));
                thisItem.setModifiedBy(this.getUserId(context));
                thisItem.setSubject(subject);
                thisItem.setClientFilename(newFileInfo.getClientFileName());
                thisItem.setFilename(newFileInfo.getRealFilename());
                thisItem.setVersion(Double.parseDouble(versionId));
                thisItem.setSize(newFileInfo.getSize());
                isValid = this.validateObject(context, db, thisItem);
                if (isValid) {
                    recordInserted = thisItem.insertVersion(db);
                }
            } else {
                recordInserted = false;
                HashMap<String, String> errors = new HashMap<String, String>();
                SystemStatus systemStatus = this.getSystemStatus(context);
                errors.put("actionError", systemStatus.getLabel("object.validation.incorrectFileName"));
                if (subject != null && "".equals(subject.trim())) {
                    errors.put("subjectError", systemStatus.getLabel("object.validation.required"));
                }
                this.processErrors(context, errors);
            }
            context.getRequest().setAttribute("fid", (Object)itemId);
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted) {
            return "UploadOK";
        }
        return this.executeCommandAddVersion(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        String itemId = context.getRequest().getParameter("fid");
        String folderId = context.getRequest().getParameter("folderId");
        if (folderId != null) {
            context.getRequest().setAttribute("folderId", (Object)folderId);
        }
        try {
            db = this.getConnection(context);
            Ticket thisTicket = this.addTicket(context, db);
            int ticketId = thisTicket.getId();
            if (!TroubleTicketsDocuments.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), ticketId, 6);
            thisItem.buildVersionList(db);
            if (!(folderId == null || "-1".equals(folderId) || "0".equals(folderId) || "".equals(folderId) || " ".equals(folderId))) {
                ProjectManagementFileFolders.buildHierarchy((Connection)db, (ActionContext)context);
            }
            context.getRequest().setAttribute("FileItem", (Object)thisItem);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "ViewTickets", "Document Details");
        if (errorMessage == null) {
            return "DetailsOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDownload(ActionContext context) {
        Exception errorMessage;
        block28: {
            errorMessage = null;
            String itemId = context.getRequest().getParameter("fid");
            String version = context.getRequest().getParameter("ver");
            FileItemVersion thisItem = null;
            String stream = context.getRequest().getParameter("stream");
            SystemStatus systemStatus = this.getSystemStatus(context);
            Connection db = null;
            try {
                db = this.getConnection(context);
                Ticket thisTicket = this.addTicket(context, db);
                int ticketId = thisTicket.getId();
                if (!TroubleTicketsDocuments.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) {
                    String string = "PermissionError";
                    return string;
                }
                thisItem = new FileItem(db, Integer.parseInt(itemId), ticketId, 6);
                if (version != null) {
                    thisItem.buildVersionList(db);
                }
            }
            catch (Exception e) {
                errorMessage = e;
            }
            finally {
                this.freeConnection(context, db);
            }
            try {
                FileItemVersion itemToDownload;
                if (version == null) {
                    itemToDownload = thisItem;
                    itemToDownload.setEnteredBy(this.getUserId(context));
                    String filePath = this.getPath(context, "tickets") + TroubleTicketsDocuments.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                    FileDownload fileDownload = new FileDownload();
                    fileDownload.setFullPath(filePath);
                    fileDownload.setDisplayName(itemToDownload.getClientFilename());
                    if (fileDownload.fileExists()) {
                        if (stream != null && "true".equals(stream)) {
                            fileDownload.setFileTimestamp(thisItem.getModificationDate().getTime());
                            fileDownload.streamContent(context);
                        } else {
                            fileDownload.sendFile(context);
                        }
                    } else {
                        db = null;
                        System.err.println("TroubleTicketsDocuments-> Trying to send a file that does not exist");
                        context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.downloadDoesNotExist"));
                        String string = this.executeCommandView(context);
                        return string;
                    }
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                    break block28;
                }
                itemToDownload = thisItem.getVersion(Double.parseDouble(version));
                itemToDownload.setEnteredBy(this.getUserId(context));
                String filePath = this.getPath(context, "tickets") + TroubleTicketsDocuments.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                FileDownload fileDownload = new FileDownload();
                fileDownload.setFullPath(filePath);
                fileDownload.setDisplayName(itemToDownload.getClientFilename());
                if (fileDownload.fileExists()) {
                    if (stream != null && "true".equals(stream)) {
                        fileDownload.setFileTimestamp(itemToDownload.getModificationDate().getTime());
                        fileDownload.streamContent(context);
                    } else {
                        fileDownload.sendFile(context);
                    }
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                    break block28;
                }
                db = null;
                System.err.println("TroubleTicketsDocuments-> Trying to send a file that does not exist");
                context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.downloadDoesNotExist"));
                String string = this.executeCommandView(context);
                return string;
            }
            catch (SocketException se) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println(se.toString());
                }
            }
            catch (Exception e) {
                errorMessage = e;
                System.out.println(e.toString());
            }
            finally {
                if (db != null) {
                    this.freeConnection(context, db);
                }
            }
        }
        if (errorMessage == null) {
            return "-none-";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        this.addModuleBean(context, "ViewTickets", "");
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-edit")) {
            return "PermissionError";
        }
        String folderId = context.getRequest().getParameter("folderId");
        if (folderId != null) {
            context.getRequest().setAttribute("folderId", (Object)folderId);
        }
        Exception errorMessage = null;
        String itemId = context.getRequest().getParameter("fid");
        Connection db = null;
        try {
            db = this.getConnection(context);
            Ticket thisTicket = this.addTicket(context, db);
            int ticketId = thisTicket.getId();
            if (!TroubleTicketsDocuments.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), ticketId, 6);
            thisItem.buildVersionList(db);
            context.getRequest().setAttribute("FileItem", (Object)thisItem);
            ProjectManagementFileFolders.buildHierarchy((Connection)db, (ActionContext)context);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "ViewTickets", "Modify Document Information");
        if (errorMessage == null) {
            return "ModifyOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdate(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-edit")) {
            return "PermissionError";
        }
        Object errorMessage = null;
        boolean recordInserted = false;
        boolean isValid = false;
        String folderId = context.getRequest().getParameter("folderId");
        if (folderId != null) {
            context.getRequest().setAttribute("folderId", (Object)folderId);
        }
        String itemId = context.getRequest().getParameter("fid");
        String subject = context.getRequest().getParameter("subject");
        String filename = context.getRequest().getParameter("clientFilename");
        Connection db = null;
        try {
            db = this.getConnection(context);
            Ticket thisTicket = this.addTicket(context, db);
            int ticketId = thisTicket.getId();
            if (!TroubleTicketsDocuments.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), ticketId, 6);
            thisItem.setClientFilename(filename);
            thisItem.setSubject(subject);
            isValid = this.validateObject(context, db, thisItem);
            if (isValid) {
                recordInserted = thisItem.update(db);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "ViewTickets", "");
        if (recordInserted && isValid) {
            return "UpdateOK";
        }
        context.getRequest().setAttribute("fid", (Object)itemId);
        return this.executeCommandModify(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-edit")) {
            return "PermissionError";
        }
        String folderId = context.getRequest().getParameter("folderId");
        if (folderId != null) {
            context.getRequest().setAttribute("folderId", (Object)folderId);
        }
        Exception errorMessage = null;
        boolean recordDeleted = false;
        String itemId = context.getRequest().getParameter("fid");
        Connection db = null;
        try {
            db = this.getConnection(context);
            Ticket thisTicket = this.addTicket(context, db);
            int ticketId = thisTicket.getId();
            if (!TroubleTicketsDocuments.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), ticketId, 6);
            recordDeleted = thisItem.delete(db, this.getPath(context, "tickets"));
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "ViewTickets", "Delete Document");
        if (errorMessage == null) {
            if (recordDeleted) {
                return "DeleteOK";
            }
            return "DeleteERROR";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    private Ticket addTicket(ActionContext context, Connection db) throws SQLException {
        String ticketId = context.getRequest().getParameter("tId");
        if (ticketId == null) {
            ticketId = (String)context.getRequest().getAttribute("tId");
        }
        return this.addTicket(context, db, ticketId);
    }

    private Ticket addTicket(ActionContext context, Connection db, String ticketId) throws SQLException {
        context.getRequest().setAttribute("tId", (Object)ticketId);
        Ticket thisTicket = new Ticket(db, Integer.parseInt(ticketId));
        context.getRequest().setAttribute("TicketDetails", (Object)thisTicket);
        return thisTicket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMove(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        String itemId = context.getRequest().getParameter("fid");
        try {
            db = this.getConnection(context);
            Ticket thisTicket = this.addTicket(context, db);
            int ticketId = thisTicket.getId();
            if (!TroubleTicketsDocuments.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), ticketId, 6);
            thisItem.buildVersionList(db);
            context.getRequest().setAttribute("FileItem", (Object)thisItem);
            FileFolderHierarchy hierarchy = new FileFolderHierarchy();
            hierarchy.setLinkModuleId(6);
            hierarchy.setLinkItemId(ticketId);
            hierarchy.build(db);
            context.getRequest().setAttribute("folderHierarchy", (Object)hierarchy);
            String string = "MoveOK";
            return string;
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveMove(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        String newFolderId = context.getRequest().getParameter("folderId");
        String itemId = context.getRequest().getParameter("fid");
        try {
            db = this.getConnection(context);
            Ticket thisTicket = this.addTicket(context, db);
            int ticketId = thisTicket.getId();
            if (!TroubleTicketsDocuments.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), ticketId, 6);
            thisItem.buildVersionList(db);
            thisItem.updateFolderId(db, Integer.parseInt(newFolderId));
            String string = "PopupCloseOK";
            return string;
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }
}

