/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.base;

import com.darkhorseventures.framework.beans.GenericBean;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.utils.DatabaseUtils;

public class KnowledgeBase
extends GenericBean {
    private int id = -1;
    protected int categoryId = -1;
    protected String title = null;
    protected String description = null;
    protected int itemId = -1;
    protected Timestamp entered = null;
    protected int enteredBy = -1;
    protected Timestamp modified = null;
    protected int modifiedBy = -1;
    FileItem item = null;
    boolean buildResources = false;

    public KnowledgeBase() {
    }

    public KnowledgeBase(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public KnowledgeBase(Connection db, int id) throws SQLException {
        if (id <= -1) {
            throw new SQLException("Knowledge Base ID not specified");
        }
        this.queryRecord(db, id);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id <= -1) {
            throw new SQLException("Defect ID not specified");
        }
        PreparedStatement pst = db.prepareStatement("SELECT kb.* FROM knowledge_base kb LEFT JOIN ticket_category tc ON (kb.category_id = tc.id) WHERE kb.kb_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("NOT_FOUND_ERROR");
        }
        if (this.buildResources) {
            this.buildResources(db);
        }
    }

    public void buildResources(Connection db) throws SQLException {
        if (this.getItemId() != -1) {
            this.item = new FileItem(db, this.itemId, this.getId(), 104051616);
        }
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("kb_id"));
        this.categoryId = DatabaseUtils.getInt(rs, "category_id");
        this.title = rs.getString("title");
        this.description = rs.getString("description");
        this.itemId = DatabaseUtils.getInt(rs, "item_id");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
    }

    public void printKb() {
        System.out.println("KnowledgeBase::printDefect id is " + this.getId());
        System.out.println("KnowledgeBase::printDefect categoryId is " + this.categoryId);
        System.out.println("KnowledgeBase::printDefect title is " + this.getTitle());
        System.out.println("KnowledgeBase::printDefect description is " + this.getDescription());
        System.out.println("KnowledgeBase::printDefect itemId is " + this.itemId);
        System.out.println("KnowledgeBase::printDefect entered is " + (this.entered != null ? this.entered.toString() : "null"));
        System.out.println("KnowledgeBase::printDefect enteredBy is " + this.enteredBy);
        System.out.println("KnowledgeBase::printDefect modified is " + (this.modified != null ? this.modified.toString() : "null"));
        System.out.println("KnowledgeBase::printDefect modifiedBy is " + this.modifiedBy);
    }

    public boolean insert(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            this.id = DatabaseUtils.getNextSeq(db, "knowledge_base_kb_id_seq");
            sql.append("INSERT INTO knowledge_base (" + (this.id > -1 ? "kb_id," : "") + " category_id, title, description, ");
            if (this.itemId != -1) {
                sql.append("item_id, ");
            }
            if (this.entered != null) {
                sql.append("entered, ");
            }
            sql.append("enteredby, ");
            if (this.modified != null) {
                sql.append("modified, ");
            }
            sql.append("modifiedby )");
            sql.append("VALUES (" + (this.id > -1 ? "?," : "") + " ?, ?, ?, ");
            if (this.itemId != -1) {
                sql.append("?, ");
            }
            if (this.entered != null) {
                sql.append("?, ");
            }
            sql.append("?, ");
            if (this.modified != null) {
                sql.append("?, ");
            }
            sql.append("? )");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            DatabaseUtils.setInt(pst, ++i, this.getCategoryId());
            pst.setString(++i, this.getTitle());
            pst.setString(++i, this.getDescription());
            if (this.itemId != -1) {
                DatabaseUtils.setInt(pst, ++i, this.getItemId());
            }
            if (this.entered != null) {
                pst.setTimestamp(++i, this.getEntered());
            }
            pst.setInt(++i, this.getModifiedBy());
            if (this.modified != null) {
                pst.setTimestamp(++i, this.getModified());
            }
            pst.setInt(++i, this.getModifiedBy());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "knowledge_base_kb_id_seq", this.id);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public int update(Connection db, boolean override) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            return -1;
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE knowledge_base  SET category_id = ?, title = ?, description = ?, ");
        if (this.getItemId() != -1) {
            sql.append(" item_id = ?, ");
        }
        sql.append(" modified = " + DatabaseUtils.getCurrentTimestamp(db) + ", " + " modifiedby = ? " + " WHERE kb_id = ? ");
        if (!override) {
            sql.append("AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        }
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        DatabaseUtils.setInt(pst, ++i, this.getCategoryId());
        pst.setString(++i, this.getTitle());
        pst.setString(++i, this.getDescription());
        if (this.itemId != -1) {
            pst.setInt(++i, this.getItemId());
        }
        pst.setInt(++i, this.getModifiedBy());
        pst.setInt(++i, this.getId());
        if (!override && this.getModified() != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public int update(Connection db) throws SQLException {
        return this.update(db, false);
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Knowledge Base ID not specified");
        }
        DependencyList dependencyList = new DependencyList();
        Dependency docDependency = new Dependency();
        docDependency.setName("documents");
        docDependency.setCount(FileItemList.retrieveRecordCount((Connection)db, (int)104051616, (int)this.getId()));
        docDependency.setCanDelete(true);
        dependencyList.add(docDependency);
        return dependencyList;
    }

    public boolean delete(Connection db, String baseFilePath) throws SQLException {
        PreparedStatement pst = null;
        pst = db.prepareStatement("DELETE FROM knowledge_base WHERE kb_id = ? ");
        pst.setInt(1, this.getId());
        pst.execute();
        pst.close();
        FileItemList fileList = new FileItemList();
        fileList.setLinkModuleId(104051616);
        fileList.setLinkItemId(this.getId());
        fileList.buildList(db);
        fileList.delete(db, this.getFileLibraryPath(baseFilePath, "knowledgebase"));
        fileList = null;
        return true;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public void setCategoryId(String tmp) {
        this.categoryId = Integer.parseInt(tmp);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String tmp) {
        this.title = tmp;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public int getItemId() {
        return this.itemId;
    }

    public void setItemId(int tmp) {
        this.itemId = tmp;
    }

    public void setItemId(String tmp) {
        this.itemId = Integer.parseInt(tmp);
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public FileItem getItem() {
        return this.item;
    }

    public void setItem(FileItem tmp) {
        this.item = tmp;
    }

    public boolean getBuildResources() {
        return this.buildResources;
    }

    public void setBuildResources(boolean tmp) {
        this.buildResources = tmp;
    }

    public void setBuildResources(String tmp) {
        this.buildResources = DatabaseUtils.parseBoolean(tmp);
    }
}

