/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.troubletickets.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.modules.troubletickets.base.KnowledgeBase;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.PagedListInfo;

public class KnowledgeBaseList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    protected int id = -1;
    protected int categoryId = -1;
    protected String title = null;
    protected String description = null;
    protected int itemId = -1;
    protected int siteId = -1;
    protected boolean exclusiveToSite = false;
    public static final String tableName = "knowledge_base";
    public static final String uniqueField = "kb_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    protected boolean buildResources = false;
    private int catCode = 0;
    private int subCat1 = 0;
    private int subCat2 = 0;
    private int subCat3 = 0;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append(" SELECT COUNT(*) AS recordcount  FROM knowledge_base kb  LEFT JOIN ticket_category tc ON (kb.category_id = tc.id)  WHERE kb.kb_id > -1 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(kb.title) < ?  ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("kb.title", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY kb.entered ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append(" kb.*  FROM knowledge_base kb  LEFT JOIN ticket_category tc ON (kb.category_id = tc.id)  WHERE kb.kb_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            KnowledgeBase thisKb = new KnowledgeBase(rs);
            this.add(thisKb);
        }
        rs.close();
        pst.close();
        if (this.buildResources) {
            for (KnowledgeBase kb : this) {
                kb.setBuildResources(true);
                kb.buildResources(db);
            }
        }
    }

    protected void createFilter(StringBuffer sqlFilter, Connection db) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.subCat3 > 0) {
            this.categoryId = this.subCat3;
        } else if (this.subCat2 > 0) {
            this.categoryId = this.subCat2;
        } else if (this.subCat1 > 0) {
            this.categoryId = this.subCat1;
        } else if (this.catCode > 0) {
            this.categoryId = this.catCode;
        }
        if (this.id > -1) {
            sqlFilter.append("AND kb.kb_id = ? ");
        }
        if (this.categoryId > -1) {
            sqlFilter.append("AND kb.category_id = ? ");
        }
        if (this.title != null) {
            sqlFilter.append("AND kb.title LIKE ? ");
        }
        if (this.description != null) {
            sqlFilter.append("AND kb.desctiption LIKE ? ");
        }
        if (this.itemId != -1) {
            sqlFilter.append("AND kb.item_id = ? ");
        }
        if (this.siteId > -1) {
            sqlFilter.append("AND (tc.site_id = ? ");
            if (!this.exclusiveToSite) {
                sqlFilter.append("OR tc.site_id IS NULL ");
            }
            sqlFilter.append(") ");
        } else {
            sqlFilter.append("AND tc.site_id IS NULL ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.categoryId > -1) {
            pst.setInt(++i, this.categoryId);
        }
        if (this.title != null) {
            pst.setString(++i, this.title);
        }
        if (this.description != null) {
            pst.setString(++i, this.description);
        }
        if (this.itemId != -1) {
            pst.setInt(++i, this.itemId);
        }
        if (this.siteId > -1) {
            pst.setInt(++i, this.siteId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public HashMap getHashMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (KnowledgeBase kb : this) {
            map.put(String.valueOf(kb.getId()), new Integer(kb.getCategoryId()));
        }
        return map;
    }

    public HtmlSelect getHtmlSelectObj(int selectedKey) {
        HtmlSelect kbListSelect = new HtmlSelect();
        for (KnowledgeBase thisKb : this) {
            kbListSelect.addItem(thisKb.getId(), thisKb.getTitle());
        }
        return kbListSelect;
    }

    public boolean delete(Connection db, String baseFilePath) throws SQLException {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            KnowledgeBase thisKb = (KnowledgeBase)((Object)iter.next());
            thisKb.delete(db, baseFilePath);
            iter.remove();
        }
        return true;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public void setCategoryId(String tmp) {
        this.categoryId = Integer.parseInt(tmp);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String tmp) {
        this.title = tmp;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public int getItemId() {
        return this.itemId;
    }

    public void setItemId(int tmp) {
        this.itemId = tmp;
    }

    public void setItemId(String tmp) {
        this.itemId = Integer.parseInt(tmp);
    }

    public boolean getBuildResources() {
        return this.buildResources;
    }

    public void setBuildResources(boolean tmp) {
        this.buildResources = tmp;
    }

    public void setBuildResources(String tmp) {
        this.buildResources = DatabaseUtils.parseBoolean(tmp);
    }

    public int getCatCode() {
        return this.catCode;
    }

    public void setCatCode(int tmp) {
        this.catCode = tmp;
    }

    public void setCatCode(String tmp) {
        this.catCode = Integer.parseInt(tmp);
    }

    public int getSubCat1() {
        return this.subCat1;
    }

    public void setSubCat1(int tmp) {
        this.subCat1 = tmp;
    }

    public void setSubCat1(String tmp) {
        this.subCat1 = Integer.parseInt(tmp);
    }

    public int getSubCat2() {
        return this.subCat2;
    }

    public void setSubCat2(int tmp) {
        this.subCat2 = tmp;
    }

    public void setSubCat2(String tmp) {
        this.subCat2 = Integer.parseInt(tmp);
    }

    public int getSubCat3() {
        return this.subCat3;
    }

    public void setSubCat3(int tmp) {
        this.subCat3 = tmp;
    }

    public void setSubCat3(String tmp) {
        this.subCat3 = Integer.parseInt(tmp);
    }

    public int getSiteId() {
        return this.siteId;
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public boolean getExclusiveToSite() {
        return this.exclusiveToSite;
    }

    public void setExclusiveToSite(boolean tmp) {
        this.exclusiveToSite = tmp;
    }

    public void setExclusiveToSite(String tmp) {
        this.exclusiveToSite = DatabaseUtils.parseBoolean(tmp);
    }
}

